/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.services.R01MBaseAPI;
import com.ejie.r01m.services.bzd.R01MContentModelManagerBzd;
import java.util.List;
import java.util.logging.Level;

public class R01MUserActivityAPI
extends R01MBaseAPI {
    private R01MUserContext _userCtx = null;
    private static final String LOG_TYPE_ID = "r01m.userActivityAPI";
    private static final String LOG_SEP_INI = "\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.userActivityAPI").intValue() != Level.OFF.intValue();

    R01MUserActivityAPI() {
        super("contentModel");
    }

    R01MUserActivityAPI(R01MUserContext userCtx) {
        this();
        this._userCtx = userCtx;
    }

    public List loadUserContentLastActions(int numActions, String lang) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init)");
            }
            return ((R01MContentModelManagerBzd)this.getBzd()).doLoadUserContentLastActions(this._userCtx, numActions, lang);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public List frequentlyModifyUserActivity(int numActions) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init)");
            }
            return ((R01MContentModelManagerBzd)this.getBzd()).doFrequentlyModifyUserActivity(this._userCtx, numActions);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public List frequentlyCreatedUserActivity(int numActions) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init)");
            }
            return ((R01MContentModelManagerBzd)this.getBzd()).doFrequentlyCreatedUserActivity(this._userCtx, numActions);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    private boolean _validateContext(R01MUserContext userCtx) {
        return userCtx != null;
    }
}

