/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.config.objects.typologymanagement.R01MContentTypeManagementConfig;
import com.ejie.r01m.config.objects.typologymanagement.R01MContentTypeTemplateConfig;
import com.ejie.r01m.config.objects.typologymanagement.R01MTypologyManagementConfig;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.contentmodel.R01MContentTypologyInfo;
import com.ejie.r01m.services.R01MBaseConfigAPI;
import com.ejie.r01m.services.bzd.R01MTypologyManagementConfigLoaderBzd;
import java.util.Map;
import java.util.Properties;

public class R01MTypologyManagementConfigAPI
extends R01MBaseConfigAPI {
    public static final String TEMPLATE_EDITURL = "editUrl";
    public static final String TEMPLATE_PREVIEWURL = "previewUrl";
    public static final String TEMPLATE_GENERATEURL = "generateUrl";

    R01MTypologyManagementConfigAPI() {
        super("typologyManagementConfig");
    }

    public R01MTypologyManagementConfig getTypologyManagementConfig(String serverOid, String dataStoreOid) throws R01MConfigLoadException {
        String indx = serverOid + "." + dataStoreOid;
        R01MTypologyManagementConfig typologyManagementConfig = (R01MTypologyManagementConfig)this.getObjectConfig(indx);
        if (typologyManagementConfig == null) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: No se habia cargado la configuracion de gestion de tipos de contenido para el dataStore " + dataStoreOid + " en el servidor " + serverOid + "... se carga ahora");
            typologyManagementConfig = ((R01MTypologyManagementConfigLoaderBzd)this.getBzd("typologyManagementConfig")).loadTypologyManagementConfig(serverOid, dataStoreOid);
            if (typologyManagementConfig != null) {
                this.cacheObjectConfig(indx, typologyManagementConfig);
                return typologyManagementConfig;
            }
            throw new R01MConfigLoadException("No se han podido cargar los datos de configuracion de gestion de tipos de contenido para el dataStore " + dataStoreOid + " en el servidor " + serverOid);
        }
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La configuracion del server " + serverOid + " esta en la cache... NO SE CARGA");
        return typologyManagementConfig;
    }

    public Map getAvailableTemplates(R01MContentLocation storageInfo, String contentTypeOid) throws R01MConfigLoadException {
        if (contentTypeOid == null) {
            throw new R01MConfigLoadException("No se pueden obtener las plantillas disponibles ya que el oid del tipo de contenido es nulo");
        }
        R01MTypologyManagementConfig typoMngmntCfg = this.getTypologyManagementConfig(storageInfo.getServerOid(), storageInfo.getDataRepositoryOid());
        R01MContentTypeManagementConfig typo = (R01MContentTypeManagementConfig)typoMngmntCfg.getTypes().get(contentTypeOid);
        if (typo == null) {
            R01FLog.to((String)"r01m.configAPI").warning("NO existe el tipo " + contentTypeOid + " en la configuracion de gesti\u00f3n de tipos de contenido. Revisa el fichero typologyManagementConfig.xml");
            return null;
        }
        return typo.getTemplates();
    }

    public R01MContentTypeTemplateConfig getTemplateConfig(R01MContentLocation storageInfo, R01MContentTypologyInfo typoInfo, String templateOid) throws R01MConfigLoadException {
        if (templateOid == null) {
            R01FLog.to((String)"r01m.configAPI").severe("CONFIG CLIENT API: No se pueden obtener las propiedades de la plantilla ya que no se ha pasado su oid");
            return null;
        }
        if (storageInfo == null || storageInfo != null && (storageInfo.getServerOid() == null || storageInfo.getDataRepositoryOid() == null)) {
            throw new R01MConfigLoadException("No se puede obtener la configuracion de gesti\u00f3n del tipo de contenido ya que no se ha pasado el servidor o el repositorio de datos");
        }
        if (typoInfo == null || typoInfo != null && typoInfo.getTypeOid() == null) {
            throw new R01MConfigLoadException("No se puede obtener la configuracion de la plantilla para del tipo de contenido " + (typoInfo != null ? typoInfo.getTypeOid() : "null") + " en el dataStore " + storageInfo.getServerOid() + ":" + storageInfo.getDataRepositoryOid() + " ya que no se ha pasado la plantilla!!!");
        }
        Map templates = this.getAvailableTemplates(storageInfo, typoInfo.getTypeOid());
        return (R01MContentTypeTemplateConfig)templates.get(templateOid);
    }

    public Properties getTemplateResources(String templateOid, String lang) throws R01MConfigLoadException {
        if (templateOid == null) {
            R01FLog.to((String)"r01m.configAPI").severe("CONFIG CLIENT API: No se pueden obtener los recursos de la plantilla ya que no se ha pasado su oid o el idioma.");
            return null;
        }
        String indx = templateOid + "." + lang;
        Properties templateResources = (Properties)this.getObjectConfig(indx);
        if (templateResources == null) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: No se habia cargado el fichero de recursos para la plantilla " + templateOid + " en el idioma " + lang + "... se carga ahora");
            templateResources = ((R01MTypologyManagementConfigLoaderBzd)this.getBzd("typologyManagementConfig")).loadTemplateResources(templateOid, lang);
            if (templateResources != null) {
                this.cacheObjectConfig(indx, templateResources);
                return templateResources;
            }
            throw new R01MConfigLoadException("No se ha podido cargar el fichero de recursos para la plantilla " + templateOid + " en el idioma " + lang);
        }
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: El fichero de recursos para la plantilla " + templateOid + " en el idioma " + lang + " esta en la cache... NO SE CARGA");
        return templateResources;
    }

    public Properties getTemplateProperties(R01MContentLocation storageInfo, R01MContentTypologyInfo typoInfo, String templateOid) throws R01MConfigLoadException {
        R01MContentTypeTemplateConfig templateCfg = this.getTemplateConfig(storageInfo, typoInfo, templateOid);
        Properties p = new Properties();
        if (templateCfg != null) {
            Map templateProperties = templateCfg.getProperties();
            if (templateProperties != null) {
                p.putAll((Map<?, ?>)templateProperties);
            } else {
                R01FLog.to((String)"r01m.configAPI").warning("No se han encontrado propiedades en la plantilla " + templateOid);
            }
        } else {
            throw new R01MConfigLoadException("No existe la plantilla " + templateOid + " en el tipo de contenido " + typoInfo.getTypeOid() + " del dataStore " + storageInfo.getServerOid() + ":" + storageInfo.getDataRepositoryOid());
        }
        return p;
    }

    public String getTemplateProperty(R01MContentLocation storageInfo, R01MContentTypologyInfo typoInfo, String templateOid, String propertyName) throws R01MConfigLoadException {
        Properties templateProperties = this.getTemplateProperties(storageInfo, typoInfo, templateOid);
        if (templateProperties == null) {
            return null;
        }
        String propValue = templateProperties.getProperty(TEMPLATE_PREVIEWURL);
        if (propValue == null) {
            R01FLog.to((String)"r01m.configAPI").severe("CONFIG CLIENT API: En el tipo " + typoInfo.getTypeOid() + " NO se ha configurado la propiedad " + propertyName + "para la plantilla " + templateOid + " en el XML de configuracion para el servidor.repositorio=" + storageInfo.getServerOid() + "." + storageInfo.getDataRepositoryOid() + ">>> Revisa el XML de configuracion!");
            return null;
        }
        return propValue;
    }

    public Map getTemplatePresentationTemplates(R01MContentLocation storageInfo, R01MContentTypologyInfo typoInfo, String templateOid) throws R01MConfigLoadException {
        R01MContentTypeTemplateConfig templateCfg = this.getTemplateConfig(storageInfo, typoInfo, templateOid);
        if (templateCfg != null) {
            return templateCfg.getPresentationTemplates();
        }
        throw new R01MConfigLoadException("No existe la plantilla " + templateOid + " en el tipo de contenido " + typoInfo.getTypeOid() + " del dataStore " + storageInfo.getServerOid() + ":" + storageInfo.getDataRepositoryOid());
    }

    @Override
    public void reset() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (cliente + servidor) de configuraci\u00f3n completa de la gesti\u00f3n de cada tipo de contenido.");
        this.resetClient();
        this.resetServer();
    }

    @Override
    public void resetClient() {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (cliente) de configuraci\u00f3n completa de la gesti\u00f3n de cada tipo de contenido.");
        super.resetCacheObjectConfig();
    }

    @Override
    public void resetServer() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (servidor) de configuraci\u00f3n completa de la gesti\u00f3n de cada tipo de contenido.");
        ((R01MTypologyManagementConfigLoaderBzd)this.getBzd("typologyManagementConfig")).reset();
    }
}

