/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.CollectionUtils;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.config.objects.typology.R01MBaseTypologyObject;
import com.ejie.r01m.config.objects.typology.R01MContentCluster;
import com.ejie.r01m.config.objects.typology.R01MContentFamily;
import com.ejie.r01m.config.objects.typology.R01MContentType;
import com.ejie.r01m.config.objects.typology.R01MContentTypeMetaData;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.services.R01MBaseConfigAPI;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.bzd.R01MTypologyConfigLoaderBzd;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class R01MTypologyConfigAPI
extends R01MBaseConfigAPI {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.configAPI").intValue() != Level.OFF.intValue();
    private static long _lastCheckTS = 0L;
    private static Map<String, R01MContentFamily> _allFamiliesConfigsCache = null;
    private static Map<String, R01MContentType> _allTypesConfigsCache = null;
    private static long _loadTS = DateUtils.getDateFromMillis((long)0L).getTime();

    R01MTypologyConfigAPI() {
        super("typologyConfig");
    }

    public String[] loadClustersOid() throws R01MConfigLoadException {
        return this.loadClustersOids();
    }

    public String[] loadClustersOids() throws R01MConfigLoadException {
        String[] clusterOids;
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Listando todas las configuraciones de clusters de tipos (solo devuelve oids... NO CACHEA!");
        }
        String[] stringArray = clusterOids = this.getConfigs() != null ? this.getConfigs().keySet().toArray(new String[this.getConfigs().keySet().size()]) : null;
        if (clusterOids == null && (clusterOids = ((R01MTypologyConfigLoaderBzd)this.getBzd("typologyConfig")).loadClustersOids()) != null) {
            for (int i = 0; i < clusterOids.length; ++i) {
                this.cacheObjectConfig(clusterOids[i], "NOT LOADED");
            }
        }
        return clusterOids;
    }

    public R01MContentCluster getClusterConfig(String clusterOid) throws R01MConfigLoadException {
        if (StringUtils.isEmptyString((String)clusterOid)) {
            return null;
        }
        Object clusterConfig = this.getObjectConfig(clusterOid);
        if (this.getConfigs() == null) {
            this.getAllClusterConfig();
            clusterConfig = this.getObjectConfig(clusterOid);
        }
        if (clusterConfig == null || clusterConfig instanceof String) {
            if (DEBUG) {
                R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: No se habia cargado la configuracion del cluster " + clusterOid + "... se carga ahora");
            }
            if ((clusterConfig = ((R01MTypologyConfigLoaderBzd)this.getBzd("typologyConfig")).loadClusterConfig(clusterOid)) != null) {
                this.cacheObjectConfig(clusterOid, clusterConfig);
                return (R01MContentCluster)clusterConfig;
            }
            throw new R01MConfigLoadException("No se han podido cargar los datos de configuracion del cluster " + clusterOid);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La configuracion del cluster " + clusterOid + " esta en la cache... NO SE CARGA");
        }
        return (R01MContentCluster)clusterConfig;
    }

    public Map<String, R01MContentCluster> getAllClusterConfig() throws R01MConfigLoadException {
        String[] clustersOids = this.loadClustersOids();
        HashMap<String, R01MContentCluster> outClustersCfgs = null;
        if (clustersOids != null) {
            outClustersCfgs = new HashMap<String, R01MContentCluster>(clustersOids.length);
            R01MContentCluster currClusterCfg = null;
            for (int i = 0; i < clustersOids.length; ++i) {
                currClusterCfg = this.getClusterConfig(clustersOids[i]);
                outClustersCfgs.put(currClusterCfg.getOid(), currClusterCfg);
            }
        }
        return outClustersCfgs;
    }

    public R01MContentCluster getClusterConfigFromNumericId(int clusterNumericId) throws R01MConfigLoadException {
        Map<String, R01MContentCluster> clusters = this.getAllClusterConfig();
        if (clusters != null) {
            for (R01MContentCluster currCluster : clusters.values()) {
                if (currCluster.getNumericId() != clusterNumericId) continue;
                return currCluster;
            }
        }
        return null;
    }

    public R01MContentFamily getFamilyConfig(String clusterOid, String familyOid) throws R01MConfigLoadException {
        if (clusterOid != null) {
            R01MContentCluster clusterConfig = this.getClusterConfig(clusterOid);
            if (clusterConfig == null || familyOid == null) {
                return null;
            }
            R01MContentFamily familyConfig = clusterConfig.getFamilies().get(familyOid);
            if (familyConfig != null) {
                return familyConfig;
            }
        } else if (familyOid != null) {
            return this.getFamilyConfig(familyOid);
        }
        throw new R01MConfigLoadException("No se han podido cargar los datos de configuracion de la famila " + familyOid + " en el cluster " + clusterOid);
    }

    public R01MContentFamily getFamilyConfig(String familyOid) throws R01MConfigLoadException {
        this._reloadClientCache();
        Map<String, R01MContentFamily> families = _allFamiliesConfigsCache != null ? _allFamiliesConfigsCache : this.getAllFamiliesConfigIgnoringCluster();
        return families != null && families.containsKey(familyOid) ? families.get(familyOid) : null;
    }

    public R01MContentFamily getFamilyConfigFromNumericId(int familyNumericId) throws R01MConfigLoadException {
        Map<String, R01MContentFamily> families;
        this._reloadClientCache();
        Map<String, R01MContentFamily> map = families = _allFamiliesConfigsCache != null ? _allFamiliesConfigsCache : this.getAllFamiliesConfigIgnoringCluster();
        if (families != null && !families.isEmpty()) {
            for (R01MContentFamily currFamily : families.values()) {
                if (currFamily.getNumericId() != familyNumericId) continue;
                return currFamily;
            }
        }
        return null;
    }

    public Map<String, R01MContentFamily> getAllFamiliesConfigIgnoringCluster() throws R01MConfigLoadException {
        this._reloadClientCache();
        if (_allFamiliesConfigsCache != null) {
            return _allFamiliesConfigsCache;
        }
        HashMap<String, R01MContentFamily> outFamilies = new HashMap<String, R01MContentFamily>();
        Map<String, R01MContentCluster> clusterCfgs = this.getAllClusterConfig();
        if (clusterCfgs != null) {
            for (R01MContentCluster currCluster : clusterCfgs.values()) {
                if (currCluster.getFamilies() == null) continue;
                for (R01MContentFamily currFamily : currCluster.getFamilies().values()) {
                    if (outFamilies.containsKey(currFamily.getOid())) continue;
                    outFamilies.put(currFamily.getOid(), currFamily);
                }
            }
        }
        if (!outFamilies.isEmpty()) {
            _allFamiliesConfigsCache = outFamilies;
            return outFamilies;
        }
        return null;
    }

    public R01MContentType getTypeConfig(String clusterOid, String familyOid, String typeOid) throws R01MConfigLoadException {
        R01MContentFamily familyConfig = familyOid != null ? this.getFamilyConfig(clusterOid, familyOid) : null;
        R01MContentType type = null;
        if (familyConfig != null && (type = familyConfig.getTypes().get(typeOid)) != null) {
            return type;
        }
        if (!StringUtils.isEmptyString((String)typeOid) && (type = this.getTypeConfig(typeOid)) != null) {
            return type;
        }
        throw new R01MConfigLoadException("No se han podido cargar los datos de configuracion del tipo " + typeOid + " en la familia " + familyOid + " en el cluster " + clusterOid);
    }

    public R01MContentType getTypeConfig(String familyOid, String typeOid) throws R01MConfigLoadException {
        return this.getTypeConfig(null, familyOid, typeOid);
    }

    public R01MContentType getTypeConfig(String typeOid) throws R01MConfigLoadException {
        this._reloadClientCache();
        Map<String, R01MContentType> types = _allTypesConfigsCache != null ? _allTypesConfigsCache : this.getAllTypesConfigIgnoringFamilyAndCluster();
        return types != null ? types.get(typeOid) : null;
    }

    public R01MContentType getTypeConfigFromNumericId(int typeNumericId) throws R01MConfigLoadException {
        Map<String, R01MContentType> types;
        this._reloadClientCache();
        Map<String, R01MContentType> map = types = _allTypesConfigsCache != null ? _allTypesConfigsCache : this.getAllTypesConfigIgnoringFamilyAndCluster();
        if (types != null) {
            for (R01MContentType currType : types.values()) {
                if (currType.getNumericId() != typeNumericId) continue;
                return currType;
            }
        }
        return null;
    }

    public Map<String, R01MContentType> getAllTypesConfigIgnoringFamilyAndCluster() throws R01MConfigLoadException {
        this._reloadClientCache();
        if (_allTypesConfigsCache != null) {
            return _allTypesConfigsCache;
        }
        HashMap<String, R01MContentType> outTypes = new HashMap<String, R01MContentType>();
        Map<String, R01MContentFamily> families = this.getAllFamiliesConfigIgnoringCluster();
        if (families != null) {
            for (R01MContentFamily currFamily : families.values()) {
                if (currFamily.getTypes() == null) continue;
                for (R01MContentType currType : currFamily.getTypes().values()) {
                    if (outTypes.containsKey(currType.getOid())) continue;
                    outTypes.put(currType.getOid(), currType);
                }
            }
        }
        if (!outTypes.isEmpty()) {
            _allTypesConfigsCache = outTypes;
            return outTypes;
        }
        return null;
    }

    public R01MContentTypeMetaData getContentTypeMetaData(String clusterOid, String familyOid, String typeOid, String metaDataOid) throws R01MConfigLoadException {
        R01MBaseTypologyObject typoObj = null;
        if (clusterOid != null && familyOid != null && typeOid != null) {
            typoObj = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(clusterOid, familyOid, typeOid);
        } else if (familyOid != null && typeOid != null) {
            typoObj = R01MClientFactory.getTypologyConfigAPI().getFamilyConfig(familyOid, typeOid);
        } else if (familyOid != null && typeOid == null) {
            typoObj = R01MClientFactory.getTypologyConfigAPI().getFamilyConfig(familyOid);
        } else if (typeOid != null) {
            typoObj = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(typeOid);
        } else {
            Map<String, R01MContentCluster> clusters = R01MClientFactory.getTypologyConfigAPI().getAllClusterConfig();
            if (!clusters.values().isEmpty()) {
                typoObj = (R01MBaseTypologyObject)clusters.values().toArray()[0];
            }
        }
        Map<String, R01MContentTypeMetaData> metaDataList = null;
        R01MContentTypeMetaData outMd = null;
        if (typoObj != null) {
            metaDataList = typoObj.getMetaDataList();
        }
        if (metaDataList != null) {
            outMd = metaDataList.get(metaDataOid);
        }
        if (outMd == null) {
            R01FLog.to((String)"r01m.search").severe("NO se ha encontrado la configuraci\u00f3n del metaDato " + metaDataOid + " en el cluster:familia:tipo=" + clusterOid + ":" + familyOid + ":" + typeOid);
        }
        return outMd;
    }

    public String[] getClustersContainingFamily(String familyOid) throws R01MConfigLoadException {
        Map<String, R01MContentCluster> clusters = R01MClientFactory.getTypologyConfigAPI().getAllClusterConfig();
        ArrayList<String> outClustersOids = new ArrayList<String>();
        if (clusters != null) {
            for (R01MContentCluster currCluster : clusters.values()) {
                if (currCluster.getFamily(familyOid) == null) continue;
                outClustersOids.add(currCluster.getOid());
            }
        }
        return outClustersOids.toArray(new String[outClustersOids.size()]);
    }

    public String[] getFamiliesContainingType(String typeOid) throws R01MConfigLoadException {
        Map<String, R01MContentCluster> clusters = R01MClientFactory.getTypologyConfigAPI().getAllClusterConfig();
        ArrayList<String> outFamiliesOids = new ArrayList<String>();
        if (clusters != null) {
            for (R01MContentCluster currCluster : clusters.values()) {
                if (currCluster.getFamilies() == null) continue;
                for (R01MContentFamily currFamily : currCluster.getFamilies().values()) {
                    if (currFamily.getType(typeOid) == null || outFamiliesOids.contains(currFamily.getOid())) continue;
                    outFamiliesOids.add(currFamily.getOid());
                }
            }
        }
        return outFamiliesOids.toArray(new String[outFamiliesOids.size()]);
    }

    @Override
    public void reset() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (cliente + servidor) de configuraci\u00f3n de tipos de contenido.");
        this.resetServer();
        this.resetClient();
    }

    @Override
    public void resetClient() {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (cliente) de configuraci\u00f3n de tipos de contenido.");
        _allFamiliesConfigsCache = null;
        _allTypesConfigsCache = null;
        super.resetCacheObjectConfig();
    }

    @Override
    public void resetServer() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (cliente + servidor) de configuraci\u00f3n de tipos de contenido.");
        ((R01MTypologyConfigLoaderBzd)this.getBzd("typologyConfig")).reset();
    }

    public Object[] getCommonElements(Object[] parentObjectsArray, String childMemberName) {
        if (parentObjectsArray != null) {
            Object[] childObjects = new Object[parentObjectsArray.length];
            for (int i = 0; i < parentObjectsArray.length; ++i) {
                if (parentObjectsArray[i] == null) continue;
                try {
                    Map childMap = (Map)ReflectionUtils.getMemberValue((Object)parentObjectsArray[i], (String)childMemberName, (boolean)true);
                    if (childMap == null) continue;
                    childObjects[i] = childMap.values().toArray();
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.out);
                }
            }
            return this._obtainCommonElements(childObjects);
        }
        return null;
    }

    public Object[] getDistinctElements(Object[] parentObjectsArray, String childMemberName) {
        if (parentObjectsArray != null) {
            Object[] childObjects = new Object[parentObjectsArray.length];
            for (int i = 0; i < parentObjectsArray.length; ++i) {
                if (parentObjectsArray[i] == null) continue;
                try {
                    Map childMap = (Map)ReflectionUtils.getMemberValue((Object)parentObjectsArray[i], (String)childMemberName, (boolean)true);
                    if (childMap == null) continue;
                    childObjects[i] = childMap.values().toArray();
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.out);
                }
            }
            List<Object> elements = Arrays.asList(childObjects);
            ArrayList<Object> nonRepeatedElements = new ArrayList<Object>();
            for (int i = 0; i < elements.size(); ++i) {
                Object[] element = (Object[])elements.get(i);
                for (int j = 0; j < element.length; ++j) {
                    if (nonRepeatedElements.contains(element[j])) continue;
                    nonRepeatedElements.add(element[j]);
                }
            }
            return nonRepeatedElements.toArray(new Object[nonRepeatedElements.size()]);
        }
        return null;
    }

    private synchronized void _reloadClientCache() {
        if (_lastCheckTS == 0L || _lastCheckTS + TIMESTAMP_CHECKED_PERIOD < System.currentTimeMillis()) {
            long loadTS = R01MClientFactory.getConfigLoadersTimingAPI().getLoadTimeStamp();
            _lastCheckTS = System.currentTimeMillis();
            if (loadTS > 0L && loadTS > _loadTS) {
                R01FLog.to((String)"r01m.loadConfigOnStartup").info("\r\n\r\n");
                R01FLog.to((String)"r01m.loadConfigOnStartup").info("//////////////////////////////////////////////////////////////////////////////////////////////////////\r\n");
                R01FLog.to((String)"r01m.loadConfigOnStartup").info("Se han actualizado los objetos de configuraci\u00f3n en el servidor y la cache del cliente ya NO es valida\r\n");
                R01FLog.to((String)"r01m.loadConfigOnStartup").info("//////////////////////////////////////////////////////////////////////////////////////////////////////\r\n");
                _allFamiliesConfigsCache = null;
                _allTypesConfigsCache = null;
                _loadTS = loadTS;
            }
        }
    }

    private Object[] _obtainCommonElements(Object[] arrays) {
        return CollectionUtils.obtainArraysCommonElements((Object[])arrays, (Comparator)new Comparator(){

            public int compare(Object obj1, Object obj2) {
                try {
                    String oid1 = (String)ReflectionUtils.getMemberValue((Object)obj1, (String)"oid", (boolean)true);
                    String oid2 = (String)ReflectionUtils.getMemberValue((Object)obj2, (String)"oid", (boolean)true);
                    if (oid1 != null && oid2 != null && oid1.equals(oid2)) {
                        return 0;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.out);
                }
                return 1;
            }
        });
    }
}

