/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MTaskDef;
import com.ejie.r01m.objects.R01MTaskExecResult;
import com.ejie.r01m.objects.R01MTaskParam;
import java.util.LinkedList;
import java.util.logging.Level;

public class R01MTaskManagerAPI {
    private static final String LOG_TYPE_ID = "r01m.taskManagerAPI";
    private static final String LOG_SEP_INI = "\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n";
    private static final String LOG_SEP_END = "\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\n";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.taskManagerAPI").intValue() != Level.OFF.intValue();
    private R01MUserContext _userCtx = null;

    public R01MTaskManagerAPI() {
    }

    public R01MTaskManagerAPI(R01MUserContext userCtx) {
        this._userCtx = userCtx;
    }

    public R01MTaskExecResult executeTasks(LinkedList tasks) throws R01MSecurityException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Ejecuci\u00f3n m\u00faltiple de Tareas";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
        }
        R01MTaskExecResult result = new R01MTaskExecResult();
        if (tasks != null && !tasks.isEmpty()) {
            for (R01MTaskDef currTask : tasks) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("Ejecutar la tarea \n" + currTask.debugInfo(""));
                }
                result = this.processTask(currTask);
            }
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT API (end): " + opDesc);
        }
        return result;
    }

    private boolean _validateContext(R01MUserContext userCtx) {
        return userCtx != null;
    }

    private R01MTaskExecResult processTask(R01MTaskDef task) {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Inicio de la ejecuci\u00f3n de la tarea " + task.getClass() + "." + task.getMethod());
        }
        R01MTaskExecResult taskResult = new R01MTaskExecResult();
        String api = task.getApi();
        if (!StringUtils.isEmptyString((String)api)) {
            Object apiCall;
            block17: {
                Class[] argsConsTypes = null;
                Object[] argsConsValues = null;
                if (task.getParamsConstructorApi() != null && !task.getParamsConstructorApi().isEmpty()) {
                    argsConsTypes = new Class[task.getParamsConstructorApi().size()];
                    argsConsValues = new Object[task.getParamsConstructorApi().size()];
                    int pos = 0;
                    for (R01MTaskParam currParam : task.getParamsConstructorApi()) {
                        argsConsTypes[pos] = currParam.getParamType();
                        argsConsValues[pos] = currParam.getParamValue();
                        ++pos;
                    }
                }
                try {
                    if (api.equals("com.ejie.r01m.services.R01MContentModelAPI")) {
                        apiCall = task.getParamsConstructorApi() != null && !task.getParamsConstructorApi().isEmpty() ? ReflectionUtils.getObjectInstance((String)"com.ejie.r01m.services.R01MContentModelAPI", (Class[])argsConsTypes, (Object[])argsConsValues, (boolean)false) : ReflectionUtils.getObjectInstance((String)"com.ejie.r01m.services.R01MContentModelAPI");
                        break block17;
                    }
                    if (api.equals("com.ejie.r01m.services.R01MContentDataAPI")) {
                        apiCall = task.getParamsConstructorApi() != null && !task.getParamsConstructorApi().isEmpty() ? ReflectionUtils.getObjectInstance((String)"com.ejie.r01m.services.R01MContentDataAPI", (Class[])argsConsTypes, (Object[])argsConsValues, (boolean)false) : ReflectionUtils.getObjectInstance((String)"com.ejie.r01m.services.R01MContentDataAPI");
                        break block17;
                    }
                    if (api.equals("com.ejie.r01m.services.R01MRawDataAPI")) {
                        apiCall = task.getParamsConstructorApi() != null && !task.getParamsConstructorApi().isEmpty() ? ReflectionUtils.getObjectInstance((String)"com.ejie.r01m.services.R01MRawDataAPI", (Class[])argsConsTypes, (Object[])argsConsValues, (boolean)false) : ReflectionUtils.getObjectInstance((String)"com.ejie.r01m.services.R01MRawDataAPI");
                        break block17;
                    }
                    taskResult.setStateOK(false);
                    taskResult.setMsg("Error en la definici\u00f3n de la tarea, el api de ejecuci\u00f3n especificado no es v\u00e1lido.");
                    return taskResult;
                }
                catch (ReflectionException refExc) {
                    taskResult.setStateOK(false);
                    taskResult.setMsg("No se ha podido crear una instancia del API '" + api + "'." + refExc.getMessage());
                    taskResult.setCauseExc((Exception)((Object)refExc));
                    return taskResult;
                }
            }
            if (task.getParams() != null && !task.getParams().isEmpty()) {
                Class[] argsTypes = new Class[task.getParams().size()];
                Object[] argsValues = new Object[task.getParams().size()];
                int pos = 0;
                for (R01MTaskParam currParam : task.getParams()) {
                    argsTypes[pos] = currParam.getParamType();
                    argsValues[pos] = currParam.getParamValue();
                    ++pos;
                }
                try {
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info(task.getClass() + "....invocar al m\u00e9todo " + task.getMethod() + " del API '" + api + "'.");
                    }
                    ReflectionUtils.invokeMethod((Object)apiCall, (String)task.getMethod(), (Class[])argsTypes, (Object[])argsValues);
                    taskResult.setStateOK(true);
                    taskResult.setMsg("OK");
                }
                catch (ReflectionException refExc) {
                    taskResult.setStateOK(false);
                    taskResult.setMsg("No se ha podido invocar al m\u00e9todo " + task.getMethod() + " del API '" + api + "'." + refExc.getMessage());
                    taskResult.setCauseExc((Exception)((Object)refExc));
                }
                catch (Throwable thEx) {
                    taskResult.setStateOK(false);
                    taskResult.setMsg("Error al invocar al m\u00e9todo " + task.getMethod() + " del API '" + api + "'." + thEx.getCause().getMessage());
                    taskResult.setCauseExc(new Exception("Error al invocar al m\u00e9todo " + task.getMethod() + " del API '" + api + "'." + thEx.getCause().getMessage(), thEx.getCause()));
                }
            }
        } else {
            taskResult.setStateOK(false);
            taskResult.setMsg("Error en la definici\u00f3n de la tarea, no se ha especificado un api de ejecuci\u00f3n.");
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Fin de la ejecuci\u00f3n de la tarea " + task.getClass() + "." + task.getMethod());
        }
        return taskResult;
    }
}

