/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.clone.CloneUtils;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.config.objects.storage.R01MArea;
import com.ejie.r01m.config.objects.storage.R01MDataRepository;
import com.ejie.r01m.config.objects.storage.R01MServer;
import com.ejie.r01m.config.objects.storage.R01MWorkArea;
import com.ejie.r01m.config.objects.storage.R01MWorkAreaExtendedInfo;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.services.R01MBaseConfigAPI;
import com.ejie.r01m.services.bzd.R01MStorageConfigLoaderBzd;
import com.ejie.r01m.services.bzd.R01MWorkAreaExtendedInfoLoaderBzd;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class R01MStorageConfigAPI
extends R01MBaseConfigAPI {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.configAPI").intValue() != Level.OFF.intValue();

    R01MStorageConfigAPI() {
        super("storageConfig");
    }

    public Map<String, R01MServer> getAllServerConfig() throws R01MConfigLoadException {
        Map<Object, Object> allServerConfig;
        Map<Object, Object> map = allServerConfig = this.getAllObjectConfig() != null ? this.getAllObjectConfig().get("storageConfig") : null;
        if (allServerConfig != null) {
            if (DEBUG) {
                R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La configuracion de todos los servidores est\u00e1 en la cache... NO SE CARGA");
            }
            return allServerConfig;
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La cach\u00e9 se ha reseteado,se vuelve a cargar la configuracion de todos los servidores... RECARGA");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: No se habia cargado la configuracion de todos los servidores, se cargan ahora");
        }
        if ((allServerConfig = ((R01MStorageConfigLoaderBzd)this.getBzd("storageConfig")).loadAllServerConfig()) != null) {
            for (Map.Entry<Object, Object> me : allServerConfig.entrySet()) {
                R01MServer server = (R01MServer)me.getValue();
                this.cacheObjectConfig(server.getOid(), server);
            }
        }
        return allServerConfig;
    }

    public R01MServer getServerConfigLazy(String serverOid, String lang) throws R01MConfigLoadException {
        if (StringUtils.isEmptyString((String)serverOid)) {
            return null;
        }
        R01MServer currServer = null;
        try {
            currServer = this.getServerConfig(serverOid);
        }
        catch (R01MConfigLoadException cfgExc) {
            throw new R01MConfigLoadException("El servidor de identificador " + serverOid + " no ha podido cargarse.Error:" + cfgExc.getMessage(), (Exception)((Object)cfgExc));
        }
        R01MServer serverClone = null;
        if (currServer != null) {
            try {
                serverClone = (R01MServer)CloneUtils.cloneByReflection((Object)currServer);
            }
            catch (Exception ex) {
                throw new R01MConfigLoadException("Error al crear un clone del objeto servidor, de identificador " + serverOid + ".Error:" + ex.getMessage(), ex);
            }
            if (serverClone != null && serverClone.getDataRepositories() != null && !serverClone.getDataRepositories().isEmpty()) {
                HashMap<String, R01MDataRepository> dataRepositoriesLazy = new HashMap<String, R01MDataRepository>();
                for (R01MDataRepository currDataRepository : serverClone.getDataRepositories().values()) {
                    dataRepositoriesLazy.put(currDataRepository.getOid(), (R01MDataRepository)((Object)(!StringUtils.isEmptyString((String)lang) && currDataRepository.getName().containsKey(lang) ? currDataRepository.getName(lang) : "")));
                }
                serverClone.setDataRepositories(dataRepositoriesLazy);
            }
        }
        return serverClone;
    }

    public R01MServer getServerConfig(String serverOid) throws R01MConfigLoadException {
        if (StringUtils.isEmptyString((String)serverOid)) {
            return null;
        }
        R01MServer serverConfig = (R01MServer)this.getObjectConfig(serverOid);
        if (this.getConfigs() == null) {
            this.getAllServerConfig();
            serverConfig = (R01MServer)this.getObjectConfig(serverOid);
        }
        if (serverConfig == null) {
            if (DEBUG) {
                R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: No se habia cargado la configuracion del servidor " + serverOid + "... se carga ahora");
            }
            if ((serverConfig = ((R01MStorageConfigLoaderBzd)this.getBzd("storageConfig")).loadServerConfig(serverOid)) != null) {
                this.cacheObjectConfig(serverOid, serverConfig);
                return serverConfig;
            }
            throw new R01MConfigLoadException("No se han podido cargar los datos de configuracion del servidor " + serverOid);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La configuracion del server " + serverOid + " esta en la cache... NO SE CARGA");
        }
        return serverConfig;
    }

    public R01MDataRepository getDataRepositoryConfig(String serverOid, String dataRepositoryOid) throws R01MConfigLoadException {
        if (StringUtils.isEmptyString((String)serverOid) || StringUtils.isEmptyString((String)dataRepositoryOid)) {
            return null;
        }
        R01MServer serverConfig = this.getServerConfig(serverOid);
        R01MDataRepository dataRepositoryConfig = serverConfig.getDataRepositories().get(dataRepositoryOid);
        if (dataRepositoryConfig != null) {
            return dataRepositoryConfig;
        }
        throw new R01MConfigLoadException("No se han podido cargar los datos de configuracion del repositorio " + dataRepositoryOid + " en el servidor " + serverOid);
    }

    public R01MDataRepository getDataRepositoryConfigLazy(String serverOid, String dataRepositoryOid, String lang) throws R01MConfigLoadException {
        if (StringUtils.isEmptyString((String)serverOid) || StringUtils.isEmptyString((String)dataRepositoryOid)) {
            return null;
        }
        R01MDataRepository currDataRepository = null;
        try {
            currDataRepository = this.getDataRepositoryConfig(serverOid, dataRepositoryOid);
        }
        catch (R01MConfigLoadException cfgExc) {
            throw new R01MConfigLoadException("El repositorio de identificador " + dataRepositoryOid + " no ha podido cargarse.Error:" + cfgExc.getMessage(), (Exception)((Object)cfgExc));
        }
        R01MDataRepository dataRepositoryClone = null;
        if (currDataRepository != null) {
            try {
                dataRepositoryClone = (R01MDataRepository)CloneUtils.cloneByReflection((Object)currDataRepository);
            }
            catch (Exception ex) {
                throw new R01MConfigLoadException("Error al crear un clone del objeto repositorio, de identificador " + dataRepositoryOid + ".Error:" + ex.getMessage(), ex);
            }
            if (dataRepositoryClone != null && dataRepositoryClone.getAreas() != null && !dataRepositoryClone.getAreas().isEmpty()) {
                HashMap<String, R01MArea> areasLazy = new HashMap<String, R01MArea>();
                for (R01MArea currArea : dataRepositoryClone.getAreas().values()) {
                    areasLazy.put(currArea.getOid(), (R01MArea)((Object)(!StringUtils.isEmptyString((String)lang) && currArea.getName().containsKey(lang) ? currArea.getName(lang) : "")));
                }
                dataRepositoryClone.setAreas(areasLazy);
            }
        }
        return dataRepositoryClone;
    }

    public R01MArea getAreaConfig(String serverOid, String dataRepositoryOid, String areaOid) throws R01MConfigLoadException {
        if (StringUtils.isEmptyString((String)serverOid) || StringUtils.isEmptyString((String)dataRepositoryOid) || StringUtils.isEmptyString((String)areaOid)) {
            return null;
        }
        this.getServerConfig(serverOid);
        R01MDataRepository dataRepositoryConfig = this.getDataRepositoryConfig(serverOid, dataRepositoryOid);
        if (dataRepositoryConfig.getAreas() == null) {
            throw new R01MConfigLoadException("No se han podido cargar los datos de configuracion del area " + areaOid + " en el repositorio " + dataRepositoryOid + " en el servidor " + serverOid + " . El \"dataRepositoryConfig\" tiene el mapa de areas vacio ");
        }
        R01MArea area = dataRepositoryConfig.getAreas().get(areaOid);
        if (area != null) {
            return area;
        }
        throw new R01MConfigLoadException("No se han podido cargar los datos de configuracion del area " + areaOid + " en el repositorio " + dataRepositoryOid + " en el servidor " + serverOid);
    }

    public R01MArea getAreaConfig(String areaOid) throws R01MConfigLoadException {
        ArrayList<R01MArea> outAreas = new ArrayList<R01MArea>();
        Map<String, R01MServer> servers = this.getAllServerConfig();
        if (servers != null) {
            for (R01MServer currServer : servers.values()) {
                Map<String, R01MDataRepository> ds = currServer.getDataRepositories();
                if (ds == null) continue;
                for (R01MDataRepository currDs : ds.values()) {
                    Map<String, R01MArea> areas = currDs.getAreas();
                    if (areas == null) continue;
                    for (R01MArea currArea : areas.values()) {
                        if (!currArea.getOid().equals(areaOid)) continue;
                        outAreas.add(currArea);
                    }
                }
            }
        }
        if (outAreas.size() > 1) {
            throw new R01MConfigLoadException("Hay mas de una area con el oid " + areaOid + ". NO se puede obtener su configuracion utilizando el metodo getAreaConfig(areaOid), utiliza getAreaConfig(server,store,area)!");
        }
        return outAreas.size() == 1 ? (R01MArea)outAreas.get(0) : null;
    }

    public R01MArea getAreaConfigLazy(String serverOid, String dataRepositoryOid, String areaOid, String lang) throws R01MConfigLoadException {
        if (StringUtils.isEmptyString((String)serverOid) || StringUtils.isEmptyString((String)dataRepositoryOid) || StringUtils.isEmptyString((String)areaOid)) {
            return null;
        }
        R01MArea currArea = null;
        try {
            currArea = this.getAreaConfig(serverOid, dataRepositoryOid, areaOid);
        }
        catch (R01MConfigLoadException cfgExc) {
            throw new R01MConfigLoadException("El area de identificador " + areaOid + " no ha podido cargarse.Error:" + cfgExc.getMessage(), (Exception)((Object)cfgExc));
        }
        R01MArea areaClone = null;
        if (currArea != null) {
            try {
                areaClone = (R01MArea)CloneUtils.cloneByReflection((Object)currArea);
            }
            catch (Exception ex) {
                throw new R01MConfigLoadException("Error al crear un clone del objeto area, de identificador " + areaOid + ".Error:" + ex.getMessage(), ex);
            }
            if (areaClone != null && areaClone.getWorkAreas() != null && !areaClone.getWorkAreas().isEmpty()) {
                HashMap<String, R01MWorkArea> workAreasLazy = new HashMap<String, R01MWorkArea>();
                for (R01MWorkArea currWorkArea : areaClone.getWorkAreas().values()) {
                    workAreasLazy.put(currWorkArea.getOid(), (R01MWorkArea)((Object)(!StringUtils.isEmptyString((String)lang) && currWorkArea.getName().containsKey(lang) ? currWorkArea.getName(lang) : "")));
                }
                areaClone.setWorkAreas(workAreasLazy);
            }
        }
        return areaClone;
    }

    public R01MWorkArea getWorkAreaConfig(String serverOid, String dataRepositoryOid, String areaOid, String workAreaOid) throws R01MConfigLoadException {
        if (StringUtils.isEmptyString((String)serverOid) || StringUtils.isEmptyString((String)dataRepositoryOid) || StringUtils.isEmptyString((String)areaOid) || StringUtils.isEmptyString((String)workAreaOid)) {
            return null;
        }
        this.getServerConfig(serverOid);
        this.getDataRepositoryConfig(serverOid, dataRepositoryOid);
        R01MArea area = this.getAreaConfig(serverOid, dataRepositoryOid, areaOid);
        R01MWorkArea workArea = area.getWorkAreas().get(workAreaOid);
        if (workArea != null) {
            return workArea;
        }
        throw new R01MConfigLoadException("No se han podido cargar los datos de configuracion del workArea " + workAreaOid + " en el area " + areaOid + " en el repositorio " + dataRepositoryOid + " en el servidor " + serverOid);
    }

    public R01MWorkArea getWorkAreaConfig(String workAreaOid) throws R01MConfigLoadException {
        ArrayList<R01MWorkArea> workAreas = new ArrayList<R01MWorkArea>();
        Map<String, R01MServer> servers = this.getAllServerConfig();
        if (servers != null) {
            for (R01MServer currServer : servers.values()) {
                Map<String, R01MDataRepository> ds = currServer.getDataRepositories();
                if (ds == null) continue;
                for (R01MDataRepository currDs : ds.values()) {
                    Map<String, R01MArea> areas = currDs.getAreas();
                    if (areas == null) continue;
                    for (R01MArea currArea : areas.values()) {
                        Map<String, R01MWorkArea> was = currArea.getWorkAreas();
                        if (was == null) continue;
                        for (R01MWorkArea currWa : was.values()) {
                            if (!currWa.getOid().equals(workAreaOid)) continue;
                            workAreas.add(currWa);
                        }
                    }
                }
            }
        }
        if (workAreas.size() > 1) {
            throw new R01MConfigLoadException("Hay mas de una workArea con el oid " + workAreaOid + ". NO se puede obtener su configuracion utilizando el metodo getWorkAreaConfig(waOid), utiliza getWorkAreaConfig(server,store,area,workArea)!");
        }
        return workAreas.size() == 1 ? (R01MWorkArea)workAreas.get(0) : null;
    }

    public R01MWorkAreaExtendedInfo getWorkAreaExtendedInfo() throws R01MConfigLoadException {
        R01MWorkAreaExtendedInfo waExtendedInfo;
        Map<Object, Object> waExtendedInfoCache;
        Map<Object, Object> map = waExtendedInfoCache = this.getAllObjectConfig() != null ? this.getAllObjectConfig().get("waExtendedInfo") : null;
        if (waExtendedInfoCache != null) {
            if (DEBUG) {
                R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La informaci\u00f3n extendida para las WAs est\u00e1 en la cache... NO SE CARGA");
            }
            if ((waExtendedInfo = (R01MWorkAreaExtendedInfo)waExtendedInfoCache.get("waExtendedInfo")) != null) {
                return waExtendedInfo;
            }
        } else if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La cach\u00e9 se ha reseteado,se vuelve a cargar la informaci\u00f3n extendida para las WAs... RECARGA");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: No se hab\u00eda cargado la informaci\u00f3n extendida para las WAs, se cargan ahora");
        }
        if ((waExtendedInfo = ((R01MWorkAreaExtendedInfoLoaderBzd)this.getBzd("storageConfig")).loadWorkAreaExtendedInfo()) != null) {
            this.cacheObjectConfig("waExtendedInfo", waExtendedInfo);
        }
        return waExtendedInfo;
    }

    public void reloadDataStoreConfig(String serverOid, String dataStoreOid) throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Recarga de la configuracion de " + serverOid + ":" + dataStoreOid);
        ((R01MStorageConfigLoaderBzd)this.getBzd("storageConfig")).reloadDataStoreConfig(serverOid, dataStoreOid);
        this.resetClient();
    }

    public void reloadAreaConfig(String serverOid, String dataStoreOid, String areaOid) throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Recarga de la configuracion de " + serverOid + ":" + dataStoreOid + ":" + areaOid);
        ((R01MStorageConfigLoaderBzd)this.getBzd("storageConfig")).reloadAreaConfig(serverOid, dataStoreOid, areaOid);
        this.resetClient();
    }

    public void reloadWorkAreaConfig(String serverOid, String dataStoreOid, String areaOid, String workAreaOid) throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Recarga de la configuracion de " + serverOid + ":" + dataStoreOid + ":" + areaOid + ":" + workAreaOid);
        ((R01MStorageConfigLoaderBzd)this.getBzd("storageConfig")).reloadWorkAreaConfig(serverOid, dataStoreOid, areaOid, workAreaOid);
        this.resetClient();
    }

    public void reloadWorkAreaExtendedInfo() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Recarga de la configuraci\u00f3n de la informaci\u00f3n extendida para las WAs.");
        ((R01MWorkAreaExtendedInfoLoaderBzd)this.getBzd("storageConfig")).reloadWorkAreaExtendedInfo();
        this.resetCacheObjectConfig();
        this.resetClient();
    }

    @Override
    public void reset() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (cliente + servidor) de configuraci\u00f3n completa de todos los servidores.");
        this.resetClient();
        this.resetServer();
    }

    @Override
    public void resetClient() {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (solo cliente) de configuraci\u00f3n completa de todos los servidores.");
        super.resetCacheObjectConfig();
    }

    @Override
    public void resetServer() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (servidor) de configuraci\u00f3n completa de todos los servidores.");
        ((R01MStorageConfigLoaderBzd)this.getBzd("storageConfig")).reset();
    }
}

