/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.services.R01MBaseAPI;
import com.ejie.r01m.services.bzd.R01MSecurityManagerBzd;
import java.util.logging.Level;
import javax.servlet.ServletRequest;

public class R01MSecurityManagerAPI
extends R01MBaseAPI {
    private static final String LOG_SEP_INI = "\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n";
    private static final String LOG_SEP_END = "\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\n";
    private static final String LOGGER_ID = "r01m.security";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.security").intValue() != Level.OFF.intValue();
    private static R01MUserContext _userCtx = null;
    private static R01MUserContext _appCtx = null;

    public R01MSecurityManagerAPI() {
        super("security");
    }

    public R01MUserContext createAppUserContext(String appCode) throws R01MSecurityException {
        try {
            String opDesc = "createUserContext > appCode=" + appCode;
            if (DEBUG) {
                R01FLog.to((String)LOGGER_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            if (_appCtx == null) {
                _appCtx = ((R01MSecurityManagerBzd)this.getBzd()).doCreateAppUserContext(appCode);
            }
            if (DEBUG) {
                R01FLog.to((String)LOGGER_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
            return _appCtx;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MSecurityException("Error en la configuracion del businessDelegate del api de seguridad. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MUserContext createCachedUserContext(ServletRequest request) throws R01MSecurityException {
        String opDesc = "createUserContext > Crear el contexto del usuario.";
        if (DEBUG) {
            R01FLog.to((String)LOGGER_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
        }
        if (_userCtx == null) {
            _userCtx = R01MAuthManager.createUserContext(request);
        }
        if (DEBUG) {
            R01FLog.to((String)LOGGER_ID).info("Creado un contexto para el usuario " + _userCtx.getUserName());
            R01FLog.to((String)LOGGER_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
        }
        return _userCtx;
    }
}

