/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MFamilyStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MSearchMetaDataStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MTypeStorageConfig;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.services.R01MBaseConfigAPI;
import com.ejie.r01m.services.bzd.R01MSearchMetaDataStorageConfigLoaderBzd;

public class R01MSearchMetaDataStorageConfigAPI
extends R01MBaseConfigAPI {
    R01MSearchMetaDataStorageConfigAPI() {
        super("searchMetaDataStorageConfig");
    }

    public R01MSearchMetaDataStorageConfig getSearchMetaDataStorageConfig(String serverOid, String dataStoreOid) throws R01MConfigLoadException {
        return this._obtainSearchMetaDataStorageConfig(serverOid, dataStoreOid);
    }

    public R01MTypeStorageConfig getTypeStorageConfig(String serverOid, String dataStoreOid, String clusterOid, String familyOid, String typeOid) throws R01MConfigLoadException {
        return ((R01MSearchMetaDataStorageConfigLoaderBzd)this.getBzd("searchMetaDataStorageConfig")).getTypeStorageConfig(serverOid, dataStoreOid, clusterOid, familyOid, typeOid);
    }

    public R01MFamilyStorageConfig getFamilyStorageConfig(String serverOid, String dataStoreOid, String clusterOid, String familyOid) throws R01MConfigLoadException {
        return ((R01MSearchMetaDataStorageConfigLoaderBzd)this.getBzd("searchMetaDataStorageConfig")).getFamilyStorageConfig(serverOid, dataStoreOid, clusterOid, familyOid);
    }

    @Override
    public void reset() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (cliente + servidor) de configuraci\u00f3n completa de almacenamiento de metadatos.");
        this.resetClient();
        ((R01MSearchMetaDataStorageConfigLoaderBzd)this.getBzd("searchMetaDataStorageConfig")).reset();
    }

    @Override
    public void resetClient() {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (solo cliente) de configuraci\u00f3n completa de almacenamiento de metadatos.");
        super.resetCacheObjectConfig();
    }

    @Override
    public void resetServer() throws R01MConfigLoadException {
    }

    private R01MSearchMetaDataStorageConfig _obtainSearchMetaDataStorageConfig(String serverOid, String dataStoreOid) throws R01MConfigLoadException {
        String indx = "default";
        indx = serverOid != null && dataStoreOid != null ? serverOid + "." + dataStoreOid : (serverOid != null && dataStoreOid == null ? serverOid : "default");
        R01MSearchMetaDataStorageConfig metaDataStorageConfig = (R01MSearchMetaDataStorageConfig)this.getObjectConfig(indx);
        if (metaDataStorageConfig != null) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La configuracion " + indx + " esta en la cache... NO SE CARGA");
            return metaDataStorageConfig;
        }
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: No se habia cargado la configuracion de almacenamiento de metadatos de busqueda para server.dataStore=" + indx + "... se carga ahora");
        metaDataStorageConfig = ((R01MSearchMetaDataStorageConfigLoaderBzd)this.getBzd("searchMetaDataStorageConfig")).loadSearchMetaDataStorageConfig(serverOid, dataStoreOid);
        if (metaDataStorageConfig == null) {
            throw new R01MConfigLoadException("No se han podido cargar los datos de configuracion de almacenamiento de metadatos de busqueda para server.dataStore=" + indx);
        }
        this.cacheObjectConfig(indx, metaDataStorageConfig);
        return metaDataStorageConfig;
    }
}

