/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01m.exceptions.R01MSearchInitializeException;
import com.ejie.r01m.exceptions.R01MSearchPerformerException;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuide;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchSessionResults;
import com.ejie.r01m.objects.searchengine.results.R01MSearchSourceResults;
import com.ejie.r01m.objects.searchengine.session.R01MSearchSession;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences;
import com.ejie.r01m.services.R01MBaseAPI;
import com.ejie.r01m.services.bzd.R01MSearchOrchestatorBzd;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class R01MSearchEngineSessionAPI
extends R01MBaseAPI
implements Serializable {
    private static final long serialVersionUID = -4243903837553284884L;

    public R01MSearchEngineSessionAPI() {
        super("searchEngine");
    }

    public R01MQueryObject getQueryObjectFromXML(String queryXML) throws XOMarshallerException {
        if (queryXML == null) {
            return null;
        }
        return (R01MQueryObject)XOManager.getObject((String)R01MConstants.QUERY_RESULTS_MAPFILE, (String)queryXML);
    }

    public String getXMLFromQueryObject(R01MQueryObject qry) throws XOMarshallerException {
        if (qry == null) {
            return null;
        }
        return XOManager.getXML((String)R01MConstants.QUERY_RESULTS_MAPFILE, (Object)qry);
    }

    public String getQueryURLEncoded(R01MQueryObject qry) {
        return R01MSearchEngineUtils.encodeQueryObjectInURL(qry);
    }

    public R01MQueryObject getQueryFromURL(String url) {
        return R01MSearchEngineUtils.decodeURLInQueryObject(url);
    }

    public String getXMLFromSearchSessionResults(R01MSearchSessionResults results) throws XOMarshallerException {
        if (results == null) {
            return null;
        }
        return XOManager.getXML((String)R01MConstants.QUERY_RESULTS_MAPFILE, (Object)results);
    }

    public String getXMLFromSearchSourceResults(R01MSearchSourceResults srcResults) throws XOMarshallerException {
        if (srcResults == null) {
            return null;
        }
        return XOManager.getXML((String)R01MConstants.QUERY_RESULTS_MAPFILE, (Object)srcResults);
    }

    public R01MQueryObject obtainQueryObjectFromXML(String qryXML) throws R01MSearchInitializeException {
        R01MQueryObject newQry;
        try {
            newQry = (R01MQueryObject)XOManager.getObject((String)R01MConstants.QUERY_RESULTS_MAPFILE, (String)qryXML);
        }
        catch (XOMarshallerException xoEx) {
            throw new R01MSearchInitializeException("Error al convertir el XML de b\u00fasqueda a objetos: " + xoEx.getDetailedMessage(), (Exception)((Object)xoEx));
        }
        return newQry;
    }

    public R01MSearchSession createSession(String sessionLang, R01MQueryObject qry) throws R01MSearchInitializeException {
        return this.createSession(sessionLang, qry, false, true);
    }

    public R01MSearchSession createSession(String sessionLang, R01MQueryObject qry, boolean lazyInit, boolean cacheResults) throws R01MSearchInitializeException {
        return new R01MSearchSession(sessionLang, qry, lazyInit, cacheResults);
    }

    public R01MSearchSession createSession(String sessionLang, String qryXML, boolean lazyInit, boolean cacheResults) throws R01MSearchInitializeException {
        R01MQueryObject newQry = this.obtainQueryObjectFromXML(qryXML);
        return this.createSession(sessionLang, newQry, lazyInit, cacheResults);
    }

    public R01MSearchSession createSession(String sessionLang, R01MQueryObject qry, R01MSearchGuide guide, boolean lazyInit, boolean lazyGuide, boolean cacheResults) throws R01MSearchInitializeException {
        return new R01MSearchSession(sessionLang, qry, guide, lazyInit, lazyGuide, cacheResults);
    }

    public R01MSearchSession createSession(String context, String searchEngineId, String sessionOid, String sessionLang, R01MQueryObject qry, R01MSearchGuide guide, boolean lazyInit, boolean lazyGuide, boolean cacheResults) throws R01MSearchInitializeException {
        return new R01MSearchSession(context, searchEngineId, sessionOid, sessionLang, qry, guide, lazyInit, lazyGuide, cacheResults);
    }

    public Map searchComposedContentsHTML(String[] documentOids, String lang) throws R01MSearchInitializeException {
        return this.searchComposedContentsHTML(documentOids, R01MSearchEngineUtils.composeDataGridFormatterPreferences(), lang);
    }

    public Map searchComposedContentsHTML(String[] documentOids, R01MSearchSessionFormatterPreferences prefs, String lang) throws R01MSearchInitializeException {
        Map contentsFormatted = new HashMap();
        if (documentOids != null && documentOids.length > 0) {
            R01MSearchResultItem[] result;
            R01MQueryObject qry = new R01MQueryObject();
            qry.setModified(true);
            qry.setPublishedItemsOnly(false);
            StringBuffer composeINValue = new StringBuffer();
            composeINValue.append('(');
            for (int i = 0; i < documentOids.length; ++i) {
                composeINValue.append(documentOids[i]);
                composeINValue.append(',');
            }
            composeINValue.deleteCharAt(composeINValue.length() - 1);
            composeINValue.append(')');
            qry.setAllResultsInAPage(true);
            qry.addMetaData("documentOid", "IN", composeINValue.toString());
            R01MSearchSession session = this.createSession(lang, qry);
            try {
                result = session.getAllSourcesSearchResultItems();
            }
            catch (IllegalStateException illegalExc) {
                throw new R01MSearchInitializeException("Error en la inicializaci\u00f3n de la b\u00fasqueda de los documentos especificados.", (Exception)illegalExc);
            }
            catch (R01MSearchPerformerException srchExc) {
                throw new R01MSearchInitializeException("Error en la b\u00fasqueda de los documentos especificados.", (Exception)((Object)srchExc));
            }
            if (result.length > 0) {
                contentsFormatted = R01MSearchEngineUtils.formatAndDecorateSearchResult(lang, prefs, result);
            }
        }
        return contentsFormatted;
    }

    public List execSearchFullText(String text) throws R01MSearchPerformerException {
        List result;
        try {
            result = ((R01MSearchOrchestatorBzd)this.getBzd()).execSearchFullText(text);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MSearchPerformerException("Error en la configuracion del businessDelegate del modelo de b\u00fasquedas. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return result;
    }
}

