/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01m.config.objects.searchengine.guide.R01MSearchGuideDef;
import com.ejie.r01m.config.objects.searchengine.guide.R01MSearchGuideDefBranch;
import com.ejie.r01m.exceptions.R01MSearchGuideManagerException;
import com.ejie.r01m.exceptions.R01MSearchStorageException;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuide;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.searchengine.guides.R01MSearchGuideManager;
import com.ejie.r01m.services.R01MBaseAPI;
import com.ejie.r01m.services.bzd.R01MSearchOrchestatorPersistenceManagerBzd;
import com.ejie.r01m.utils.R01MConstants;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class R01MSearchEnginePersistenceAPI
extends R01MBaseAPI
implements Serializable {
    private static final long serialVersionUID = -4243903837553284884L;
    private static Map _guideDefsCache;
    private static Map _storedQueryCache;
    private static String DEFAULT_GUIDEDEF;

    public R01MSearchEnginePersistenceAPI() {
        super("searchEnginePersistence");
    }

    public boolean existsQuery(String queryOid) throws R01MSearchStorageException {
        try {
            return ((R01MSearchOrchestatorPersistenceManagerBzd)super.getBzd()).existsQuery(queryOid);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MSearchStorageException("Error en la configuracion del BZD del buscador!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public R01MQueryObject loadQuery(String queryOid) throws R01MSearchStorageException {
        if (queryOid == null) {
            throw new R01MSearchStorageException("No se puede cargar la query ya que el oid es nulo");
        }
        R01FLog.to((String)"r01m.searchAPI").info("SEARCHENGINE CLIENT API: Cargar una query: " + queryOid);
        try {
            R01MQueryObject outQry;
            R01MQueryObject r01MQueryObject = outQry = _storedQueryCache == null ? null : (R01MQueryObject)_storedQueryCache.get(queryOid);
            if (outQry == null) {
                String queryXML = ((R01MSearchOrchestatorPersistenceManagerBzd)super.getBzd()).execLoadQuery(queryOid);
                if (queryXML == null || queryXML.length() == 0) {
                    throw new R01MSearchStorageException("Error al cargar la query " + queryOid + " el xml devuelto es null");
                }
                outQry = (R01MQueryObject)XOManager.getObject((String)R01MConstants.QUERY_RESULTS_MAPFILE, (String)queryXML);
                if (_storedQueryCache == null) {
                    _storedQueryCache = new HashMap();
                }
                _storedQueryCache.put(queryOid, outQry);
            }
            return outQry;
        }
        catch (XOMarshallerException xoEx) {
            throw new R01MSearchStorageException("Error al pasar la query almacenada con oid=" + queryOid + " de XML a objetos: " + xoEx.getMessage(), (Exception)((Object)xoEx));
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MSearchStorageException("Error en la configuracion del BZD del buscador!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public void saveQuery(R01MQueryObject qry) throws R01MSearchStorageException {
        if (qry == null || qry.getQueryOid() == null) {
            throw new R01MSearchStorageException("No se puede guardar la query ya que esta o su oid son nulos");
        }
        R01FLog.to((String)"r01m.searchAPI").info("SEARCHENGINE CLIENT API: Guardar una query: " + qry.getQueryOid());
        try {
            if (_storedQueryCache != null) {
                _storedQueryCache.remove(qry.getQueryOid());
            }
            String queryXML = XOManager.getXML((String)R01MConstants.QUERY_RESULTS_MAPFILE, (Object)qry);
            ((R01MSearchOrchestatorPersistenceManagerBzd)super.getBzd()).execSaveQuery(qry.getQueryOid(), queryXML);
        }
        catch (XOMarshallerException xoEx) {
            throw new R01MSearchStorageException("Error al pasar la guia almacenada con oid=" + qry.getQueryOid() + " de XML a objetos: " + xoEx.getMessage(), (Exception)((Object)xoEx));
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MSearchStorageException("Error en la configuracion del BZD del buscador!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public R01MSearchGuide getGuide(String guideOid, R01MQueryObject qry) throws R01MSearchGuideManagerException {
        return R01MSearchGuideManager.getGuide(guideOid, qry);
    }

    public R01MSearchGuide getGuideFromXMLDefinition(String guideXML, R01MQueryObject qry) throws R01MSearchGuideManagerException {
        if (guideXML == null) {
            throw new R01MSearchGuideManagerException("No se puede crear la guia de navegacion ya que el xml es nulo");
        }
        R01FLog.to((String)"r01m.searchAPI").info("SEARCHENGINE CLIENT API: Crear una guia de navegacion a partir de su definicion en xml: " + guideXML);
        try {
            if (guideXML == null || guideXML.length() == 0) {
                throw new R01MSearchGuideManagerException("Error al cargar la query a partir del XML");
            }
            R01MSearchGuideDef guideDef = (R01MSearchGuideDef)XOManager.getObject((String)R01MConstants.CONFIGCONTENTMODEL_MAPFILE, (String)guideXML);
            guideDef.computeBranchPaths();
            return R01MSearchGuideManager.getGuide(guideDef, qry);
        }
        catch (XOMarshallerException xoEx) {
            throw new R01MSearchGuideManagerException("Error al pasar la guia de XML a objetos: " + xoEx.getMessage(), (Exception)((Object)xoEx));
        }
    }

    public R01MSearchGuideDef loadGuideDef(String guideOid) throws R01MSearchStorageException {
        if (guideOid == null) {
            throw new R01MSearchStorageException("No se puede cargar la guia de navegacion ya que el oid es nulo");
        }
        R01FLog.to((String)"r01m.searchAPI").info("SEARCHENGINE CLIENT API: Cargar una guia de navegacion: " + guideOid);
        try {
            R01MSearchGuideDef outGuide;
            R01MSearchGuideDef r01MSearchGuideDef = outGuide = _guideDefsCache == null ? null : (R01MSearchGuideDef)_guideDefsCache.get(guideOid);
            if (outGuide == null) {
                String guideXML = null;
                guideXML = guideOid.equals("r01TestGuide") && DEFAULT_GUIDEDEF != null ? "<?xml version='1.0' encoding='ISO-8859-1'?>" + DEFAULT_GUIDEDEF : ((R01MSearchOrchestatorPersistenceManagerBzd)super.getBzd()).execLoadGuide(guideOid);
                if (guideXML == null || guideXML.length() == 0) {
                    throw new R01MSearchStorageException("Error al cargar la query " + guideOid + " el xml devuelto es null");
                }
                outGuide = (R01MSearchGuideDef)XOManager.getObject((String)R01MConstants.CONFIGCONTENTMODEL_MAPFILE, (String)guideXML);
                outGuide.computeBranchPaths();
                if (_guideDefsCache == null) {
                    _guideDefsCache = new HashMap();
                }
                _guideDefsCache.put(guideOid, outGuide);
            }
            return outGuide;
        }
        catch (XOMarshallerException xoEx) {
            throw new R01MSearchStorageException("Error al pasar la query almacenada con oid=" + guideOid + " de XML a objetos: " + xoEx.getMessage(), (Exception)((Object)xoEx));
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MSearchStorageException("Error en la configuracion del BZD del buscador!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public void reloadGuidesInCache() throws R01MSearchStorageException {
        block8: {
            R01FLog.to((String)"r01m.searchAPI").info("SEARCHENGINE CLIENT API: Recargar las guias de navegacion en cache");
            try {
                _guideDefsCache = null;
                R01MSearchGuideManager.resetGuide();
                ((R01MSearchOrchestatorPersistenceManagerBzd)super.getBzd()).execReloadGuidesInCache();
                List guides = ((R01MSearchOrchestatorPersistenceManagerBzd)super.getBzd()).execLoadGuideList();
                String guideXML = null;
                R01MSearchGuideDef outGuide = null;
                if (guides == null || guides.isEmpty()) break block8;
                for (String[] guide : guides) {
                    guideXML = ((R01MSearchOrchestatorPersistenceManagerBzd)super.getBzd()).execLoadGuide(guide[0]);
                    if (StringUtils.isEmptyString((String)guideXML)) {
                        throw new R01MSearchStorageException("Error al cargar el xml devuelto es null: " + guide[0]);
                    }
                    outGuide = (R01MSearchGuideDef)XOManager.getObject((String)R01MConstants.CONFIGCONTENTMODEL_MAPFILE, (String)guideXML);
                    try {
                        R01MSearchGuideManager.reloadGuide(outGuide);
                    }
                    catch (R01MSearchGuideManagerException ex) {
                        throw new R01MSearchStorageException("Error al recargar la guias en R01MSearhGuideManager: " + ex.getMessage(), (Exception)((Object)ex));
                    }
                    outGuide.computeBranchPaths();
                    if (_guideDefsCache == null) {
                        _guideDefsCache = new HashMap();
                    }
                    _guideDefsCache.put(guide[0], outGuide);
                }
            }
            catch (XOMarshallerException xoEx) {
                throw new R01MSearchStorageException("Error al pasar de XML a objetos: " + xoEx.getMessage(), (Exception)((Object)xoEx));
            }
            catch (BzdConfigException bzdConfigEx) {
                throw new R01MSearchStorageException("Error en la configuracion del BZD del buscador!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
            }
        }
    }

    public List loadGuideList() throws R01MSearchStorageException {
        R01FLog.to((String)"r01m.searchAPI").info("SEARCHENGINE CLIENT API: Cargar la lista de guias de navegacion");
        List outGuideList = null;
        try {
            outGuideList = ((R01MSearchOrchestatorPersistenceManagerBzd)super.getBzd()).execLoadGuideList();
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MSearchStorageException("Error en la configuracion del BZD del buscador!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
        return outGuideList;
    }

    public String loadXMLGuide(String guideOid) throws R01MSearchStorageException {
        if (guideOid == null || guideOid.equals("")) {
            throw new R01MSearchStorageException("No se puede cargar la guia de navegacion ya que el oid es nulo");
        }
        R01FLog.to((String)"r01m.searchAPI").info("SEARCHENGINE CLIENT API: Cargar el XML de la guia de navegacion " + guideOid);
        String xmlGuide = "";
        try {
            xmlGuide = ((R01MSearchOrchestatorPersistenceManagerBzd)super.getBzd()).execLoadXMLGuide(guideOid);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MSearchStorageException("Error en la configuracion del BZD del buscador!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
        return xmlGuide;
    }

    public void deleteGuideDef(String guideOid) throws R01MSearchStorageException {
        R01FLog.to((String)"r01m.searchAPI").info("SEARCHENGINE CLIENT API: Borrar la guia de navegacion " + guideOid);
        try {
            ((R01MSearchOrchestatorPersistenceManagerBzd)super.getBzd()).execDeleteGuide(guideOid);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MSearchStorageException("Error en la configuracion del BZD del buscador!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public void saveGuideDef(String guideOid, String guideDesc, R01MSearchGuideDef guideDef) throws R01MSearchStorageException {
        if (guideOid == null || guideOid.length() == 0) {
            throw new R01MSearchStorageException(1L, "NO se puede guardar la guia ya que el oid es nulo!!");
        }
        if (guideDef == null || guideDef.getOid() == null) {
            throw new R01MSearchStorageException(2L, "No se puede guardar la guia ya que esta o su oid son nulos");
        }
        R01FLog.to((String)"r01m.searchAPI").info("SEARCHENGINE CLIENT API: Guardar una guia de navegaci\u00f3n: " + guideDef.getOid());
        try {
            if (!guideOid.equals(guideDef.getOid())) {
                throw new R01MSearchStorageException(3L, "NO se puede guardar la guia ya que el identificador suministrado NO coincide con el especificado en el XML");
            }
            String guideXML = XOManager.getXML((String)R01MConstants.QUERY_RESULTS_MAPFILE, (Object)guideDef);
            ((R01MSearchOrchestatorPersistenceManagerBzd)super.getBzd()).execSaveGuide(guideDef.getOid(), guideDesc, guideXML);
        }
        catch (XOMarshallerException xoEx) {
            throw new R01MSearchStorageException(4L, "Error al pasar la guia de navegacion con oid=" + guideDef.getOid() + " de XML a objetos: " + xoEx.getMessage(), (Exception)((Object)xoEx));
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MSearchStorageException("Error en la configuracion del BZD del buscador!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public void saveGuideDef(String guideOid, String guideDesc, String guideDefXML) throws R01MSearchStorageException {
        if (guideOid == null || guideOid.length() == 0) {
            throw new R01MSearchStorageException(1L, "NO se puede guardar la guia ya que el oid de la misma es nulo");
        }
        if (guideDefXML == null || guideDefXML.length() == 0) {
            throw new R01MSearchStorageException(2L, "No se puede guardar la guia ya que el XML es nulo");
        }
        String theGuideOid = this.getGuideDefOid(guideDefXML);
        if (theGuideOid != null && !theGuideOid.equals(guideOid)) {
            throw new R01MSearchStorageException(3L, "NO se puede guardar la guia ya que el identificador suministrado NO coincide con el especificado en el XML");
        }
        R01FLog.to((String)"r01m.searchAPI").info("SEARCHENGINE CLIENT API: Guardar una guia de navegaci\u00f3n desde su definicion en XML: " + guideDefXML);
        try {
            ((R01MSearchOrchestatorPersistenceManagerBzd)super.getBzd()).execSaveGuide(guideOid, guideDesc, guideDefXML);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MSearchStorageException("Error en la configuracion del BZD del buscador!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public String getGuideDefOid(String guideDefXML) {
        String patternStr = "^.*<searchGuideDef\\s+oid=['\"]([^'\" ]+)['\"]>.*</searchGuideDef>\\s*$";
        Pattern p = Pattern.compile(patternStr);
        Matcher m = p.matcher(guideDefXML);
        String guideDefOid = "unknown";
        if (m.find()) {
            try {
                guideDefOid = m.group(1);
            }
            catch (Exception ex) {
                guideDefOid = "unknown";
            }
        }
        return guideDefOid;
    }

    public R01MSearchGuideDefBranch getGuideBranchDef(String branchDefPath) throws R01MSearchStorageException {
        R01MSearchGuideDefBranch outBranch = null;
        String[] branchSplited = branchDefPath.split("/");
        if (branchSplited.length < 2) {
            throw new R01MSearchStorageException("NO se ha encontrado el identificador de la guia en el path del branch (formato guideOid/branch_name1/branch_name2...");
        }
        R01MSearchGuideDef guideDef = this.loadGuideDef(branchSplited[0]);
        outBranch = guideDef.getBranchDef(branchDefPath);
        return outBranch;
    }

    public void reset() {
        _guideDefsCache = null;
        _storedQueryCache = null;
    }

    static {
        DEFAULT_GUIDEDEF = "<searchGuideDef oid='r01TestGuide'><name><es>Test Guide</es><eu>eu_Test Guide</eu></name><description><es>Test Guide</es><eu>eu_Test Guide</eu></description><searchGuideDefBranch name='branchTypos' branchType='typo' startingPath='euskadi' maxLevels='3'/></searchGuideDef>";
    }
}

