/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.config.objects.searchengine.R01MSearchEngineConfig;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.services.R01MBaseConfigAPI;
import com.ejie.r01m.services.bzd.R01MSearchEngineConfigLoaderBzd;
import java.util.logging.Level;

public class R01MSearchEngineConfigAPI
extends R01MBaseConfigAPI {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.configAPI").intValue() != Level.OFF.intValue();

    R01MSearchEngineConfigAPI() {
        super("searchEngineConfig");
    }

    public R01MSearchEngineConfig getSearchEngineConfig() throws R01MConfigLoadException {
        R01MSearchEngineConfig searchEngineConfig = (R01MSearchEngineConfig)this.getObjectConfig("searchEngineConfig");
        if (searchEngineConfig == null) {
            if (DEBUG) {
                R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: No se habia cargado la configuracion del motor de b\u00fasqueda... se carga ahora");
            }
            if ((searchEngineConfig = ((R01MSearchEngineConfigLoaderBzd)this.getBzd("searchEngineConfig")).loadSearchEngineConfig()) != null) {
                this.cacheObjectConfig("searchEngineConfig", searchEngineConfig);
                return searchEngineConfig;
            }
            throw new R01MConfigLoadException("No se han podido cargar los datos de configuracion del motor de b\u00fasqueda");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La configuracion del motor de b\u00fasqueda esta en la cache... NO SE CARGA");
        }
        return searchEngineConfig;
    }

    @Override
    public void reset() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (cliente + servidor) de configuraci\u00f3n completa de un motor de b\u00fasqueda.");
        this.resetClient();
        this.resetServer();
    }

    @Override
    public void resetClient() {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (cliente) de configuraci\u00f3n completa de un motor de b\u00fasqueda.");
        super.resetCacheObjectConfig();
    }

    @Override
    public void resetServer() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (cliente + servidor) de configuraci\u00f3n completa de un motor de b\u00fasqueda.");
        ((R01MSearchEngineConfigLoaderBzd)this.getBzd("searchEngineConfig")).reset();
    }
}

