/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MJMSException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.datastore.R01MDataStoreItem;
import com.ejie.r01m.services.R01MBaseAPI;
import com.ejie.r01m.services.bzd.R01MRawDataManagerBzd;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.jms.R01MJMSUtils;
import com.ejie.r01m.utils.jms.R01MJmsQueueParam;
import com.ejie.r01m.utils.jms.R01MMessageCallBackBean;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class R01MRawDataAPI
extends R01MBaseAPI {
    private static final String LOG_SEP_INI = "\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n";
    private static final String LOG_SEP_END = "\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\n";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.dataAPI").intValue() != Level.OFF.intValue();
    private R01MUserContext _userCtx = new R01MUserContext();

    R01MRawDataAPI() {
        super("rawData");
    }

    public R01MRawDataAPI(R01MUserContext userCtx) {
        super("rawData");
        this._userCtx = userCtx;
    }

    public String getPathSeparator() throws R01MDataStoreException {
        try {
            String opDesc = "getPathSeparator";
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            String pathSep = ((R01MRawDataManagerBzd)this.getBzd()).doGetPathSeparator(this._userCtx);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
            return pathSep;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public boolean checkFolder(String workAreaPath, String folderWARelPath) throws R01MSecurityException, R01MDataStoreException {
        try {
            String opDesc = "checkFolder > workAreaPath=" + workAreaPath + " fileWARelPath=" + folderWARelPath;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            boolean checkResult = ((R01MRawDataManagerBzd)this.getBzd()).doCheckFolder(this._userCtx, workAreaPath, folderWARelPath);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
            return checkResult;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MDataStoreItem[] getFolderContents(String workAreaPath, String folderWARelPath, boolean recurse) throws R01MSecurityException, R01MDataStoreException {
        try {
            String opDesc = "getFolderContents > workAreaPath=" + workAreaPath + " folderWARelPath=" + folderWARelPath + " recurse=" + recurse;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            R01MDataStoreItem[] conts = ((R01MRawDataManagerBzd)this.getBzd()).doGetFolderContents(this._userCtx, workAreaPath, folderWARelPath, recurse);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
            return conts;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void createFolder(String waPath, String folderWARelativePath) throws R01MSecurityException, R01MDataStoreException {
        try {
            String opDesc = "createFolder > workAreaPath=" + waPath + " folderWARelPath=" + folderWARelativePath;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MRawDataManagerBzd)this.getBzd()).doCreateFolder(this._userCtx, waPath, folderWARelativePath);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void deleteFolder(String waPath, String folderWARelativePath, boolean consolidate) throws R01MSecurityException, R01MDataStoreException {
        try {
            String opDesc = "deleteFolder > waPath=" + waPath + " folderWARelativePath=" + folderWARelativePath + " consolidate=" + consolidate;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MRawDataManagerBzd)this.getBzd()).doDeleteFolder(this._userCtx, waPath, folderWARelativePath, consolidate);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void renameFolder(String waPath, String folderWARelativePath, String newFolderName) throws R01MSecurityException, R01MDataStoreException {
        try {
            String opDesc = "renameFolder > waPath=" + waPath + " folderWARelativePath=" + folderWARelativePath + " newFolderName=" + newFolderName;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MRawDataManagerBzd)this.getBzd()).doRenameFolder(this._userCtx, waPath, folderWARelativePath, newFolderName);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void moveFolderInWorkArea(R01MUserContext userCtx, String waPath, String folderWARelativePath, String newFolderWARelativePath) throws R01MSecurityException, R01MDataStoreException {
        try {
            String opDesc = "moveFolderInWorkArea > waPath=" + waPath + " folderWARelativePath=" + folderWARelativePath + " newFolderWARelativePath=" + newFolderWARelativePath;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MRawDataManagerBzd)this.getBzd()).doMoveFolderInWorkArea(this._userCtx, waPath, folderWARelativePath, newFolderWARelativePath);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void moveFolderToAnotherWorkArea(String waPathSrc, String waPathDst, String[] foldersWARelativePaths) throws R01MSecurityException, R01MDataStoreException {
        try {
            String opDesc = "moveFolderToAnotherWorkArea > waPathSrc=" + waPathSrc + " waPathDest=" + waPathDst;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MRawDataManagerBzd)this.getBzd()).doMoveFolderToAnotherWorkArea(this._userCtx, waPathSrc, waPathDst, foldersWARelativePaths);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void copyFolderToAnotherWorkArea(String srcWAPath, String srcFolderWARelativePath, String dstWAPath, String dstFolderWARelativePath, String[] folderWARelativePaths) throws R01MSecurityException, R01MDataStoreException {
        try {
            String opDesc = "copyFolderToAnotherWorkArea > srcWAPath=" + srcWAPath + " srcFolderWARelativePath=" + srcFolderWARelativePath + " dstWAPath=" + dstWAPath + " dstFolderWARelativePath=" + dstFolderWARelativePath;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MRawDataManagerBzd)this.getBzd()).doCopyFolderToAnotherWorkArea(this._userCtx, srcWAPath, srcFolderWARelativePath, dstWAPath, dstFolderWARelativePath, folderWARelativePaths);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void submmitFolder(String waPath, String folderWARelativePath) throws R01MSecurityException, R01MDataStoreException {
        try {
            String opDesc = "submmitFolder > waPath=" + waPath + " folderWARelativePath=" + folderWARelativePath;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MRawDataManagerBzd)this.getBzd()).doSubmmitFolder(this._userCtx, waPath, folderWARelativePath);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public Properties getFolderAttributes(String waPath, String folderWARelativePath) throws R01MSecurityException, R01MDataStoreException {
        try {
            String opDesc = "getFolderAttributes > waPath=" + waPath + " folderWARelativePath=" + folderWARelativePath;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            Properties outProps = ((R01MRawDataManagerBzd)this.getBzd()).doGetFolderAttributes(this._userCtx, waPath, folderWARelativePath);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
            return outProps;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void setFolderAttributes(String waPath, String folderWARelativePath, Properties attrs) throws R01MSecurityException, R01MDataStoreException {
        try {
            String opDesc = "setFolderAttributes > waPath=" + waPath + " folderWARelativePath=" + folderWARelativePath;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MRawDataManagerBzd)this.getBzd()).doSetFolderAttributes(this._userCtx, waPath, folderWARelativePath, attrs);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public boolean checkFile(String workAreaPath, String fileWARelPath) throws R01MSecurityException, R01MDataStoreException {
        try {
            String opDesc = "rawCheckFile > workAreaPath=" + workAreaPath + " fileWARelPath=" + fileWARelPath;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            boolean checkResult = ((R01MRawDataManagerBzd)this.getBzd()).doCheckFile(this._userCtx, workAreaPath, fileWARelPath);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
            return checkResult;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void copyFiles(String srcWAPath, String srcFolderWARelativePath, String dstWAPath, String dstFolderWARelativePath, String[] filesWARelativePaths) throws R01MSecurityException, R01MDataStoreException {
        try {
            String opDesc = "copyFiles > srcWAPath=" + srcWAPath + " srcFolderWARelativePath=" + srcFolderWARelativePath + " to dstWAPath=" + dstWAPath + " dstFolderWARelativePath=" + dstFolderWARelativePath;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MRawDataManagerBzd)this.getBzd()).doCopyFiles(this._userCtx, srcWAPath, srcFolderWARelativePath, dstWAPath, dstFolderWARelativePath, filesWARelativePaths);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void moveFileInWorkArea(String waPath, String fileWARelativePath, String newFileWorkAreaRelativePath) throws R01MSecurityException, R01MDataStoreException {
        try {
            String opDesc = "moveFileInWorkArea > waPath=" + waPath + " fileWARelativePath=" + fileWARelativePath + " to newFileWorkAreaRelativePath=" + newFileWorkAreaRelativePath;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MRawDataManagerBzd)this.getBzd()).doMoveFileInWorkArea(this._userCtx, waPath, fileWARelativePath, newFileWorkAreaRelativePath);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void updateFile(String waPath, String fileWARelativePath, InputStream fileData, Properties properties) throws R01MSecurityException, R01MDataStoreException {
        this.updateFile(waPath, fileWARelativePath, fileData, properties, false);
    }

    public void createUpdateFile(String waPath, String fileWARelativePath, byte[] fileData, Properties properties, boolean appendToFile) throws R01MSecurityException, R01MDataStoreException {
        try {
            String opDesc = "createUpdateFile > workAreaPath=" + waPath + " fileWARelPath=" + fileWARelativePath;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MRawDataManagerBzd)this.getBzd()).doCreateUpdateFile(this._userCtx, waPath, fileWARelativePath, fileData, properties, appendToFile);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void updateFile(String workAreaPath, String fileWARelPath, InputStream fileData, Properties props, boolean createFilePath) throws R01MSecurityException, R01MDataStoreException {
        try {
            String wayUpload;
            String opDesc = "updateFile > workAreaPath=" + workAreaPath + " fileWARelPath=" + fileWARelPath;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            if ("chunked".equals(wayUpload = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"wayUploadFile", (String)"atOnce"))) {
                try {
                    long offset = 0L;
                    int totalLength = fileData.available();
                    int block = R01MConstants.BUFFER_SIZE_CHUNK_MAX;
                    if (totalLength < block) {
                        block = totalLength;
                    }
                    do {
                        byte[] data = new byte[block];
                        fileData.read(data);
                        ((R01MRawDataManagerBzd)this.getBzd()).doUpdateFileChunk(this._userCtx, workAreaPath, fileWARelPath, data, offset, props);
                        if ((offset += (long)block) + (long)block <= (long)totalLength) continue;
                        block = totalLength - (int)offset;
                    } while (offset < (long)totalLength);
                }
                catch (IOException ioExc) {
                    throw new R01MDataStoreException("Error al subir el archivo " + fileWARelPath, (Exception)ioExc);
                }
                finally {
                    if (fileData != null) {
                        try {
                            fileData.close();
                        }
                        catch (IOException ex) {}
                    }
                }
            }
            ((R01MRawDataManagerBzd)this.getBzd()).doUpdateFile(this._userCtx, workAreaPath, fileWARelPath, fileData, props, createFilePath);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void updateFileChunk(String waPath, String fileWARelativePath, byte[] fileDataChunk, long offset, Properties properties) throws R01MSecurityException, R01MDataStoreException {
        try {
            String opDesc = "updateFileChunk > workAreaPath=" + waPath + " fileWARelPath=" + fileWARelativePath;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MRawDataManagerBzd)this.getBzd()).doUpdateFileChunk(this._userCtx, waPath, fileWARelativePath, fileDataChunk, offset, properties);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public InputStream readFile(String workAreaPath, String fileWARelPath) throws R01MSecurityException, R01MDataStoreException {
        InputStream is = null;
        try {
            String opDesc;
            block10: {
                String wayUpload;
                opDesc = "rawReadFile > workAreaPath=" + workAreaPath + " fileWARelPath=" + fileWARelPath;
                if (DEBUG) {
                    R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
                }
                if ("chunked".equals(wayUpload = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"wayUploadFile", (String)"atOnce"))) {
                    int block = R01MConstants.BUFFER_SIZE_CHUNK_MAX;
                    long offset = 0L;
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    try {
                        byte[] readed;
                        do {
                            if ((readed = ((R01MRawDataManagerBzd)this.getBzd()).doReadFileChunk(this._userCtx, workAreaPath, fileWARelPath, offset, block)) == null || readed.length <= 0) continue;
                            offset += (long)block;
                            os.write(readed);
                        } while (readed != null && readed.length == R01MConstants.BUFFER_SIZE_CHUNK_MAX);
                        is = new ByteArrayInputStream(os.toString().getBytes());
                        break block10;
                    }
                    catch (IOException ioExc) {
                        throw new R01MDataStoreException("Error al subir el archivo " + fileWARelPath, (Exception)ioExc);
                    }
                }
                is = ((R01MRawDataManagerBzd)this.getBzd()).doReadFile(this._userCtx, workAreaPath, fileWARelPath);
            }
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return is;
    }

    public byte[] readFileChunk(String waPath, String fileWARelativePath, long offset, int length) throws R01MSecurityException, R01MDataStoreException {
        try {
            String opDesc = "readFileChunk > waPath=" + waPath + " fileWARelativePath=" + fileWARelativePath + " offset=" + offset + " length=" + length;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            byte[] bytes = ((R01MRawDataManagerBzd)this.getBzd()).doReadFileChunk(this._userCtx, waPath, fileWARelativePath, offset, length);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
            return bytes;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void deleteFile(String waPath, String fileWARelativePath, boolean consolidate) throws R01MSecurityException, R01MDataStoreException {
        try {
            String opDesc = "deleteFile > waPath=" + waPath + " fileWARelativePath=" + fileWARelativePath;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MRawDataManagerBzd)this.getBzd()).doDeleteFile(this._userCtx, waPath, fileWARelativePath, consolidate);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void renameFile(String waPath, String fileWARelativePath, String newFileName) throws R01MSecurityException, R01MDataStoreException {
        try {
            String opDesc = "renameFile > waPath=" + waPath + " fileWARelativePath=" + fileWARelativePath + " newFileName=" + newFileName;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MRawDataManagerBzd)this.getBzd()).doRenameFile(this._userCtx, waPath, fileWARelativePath, newFileName);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void submmitFile(String waPath, String fileWARelativePath) throws R01MSecurityException, R01MDataStoreException {
        try {
            String opDesc = "submmitFile > waPath=" + waPath + " fileWARelativePath=" + fileWARelativePath;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MRawDataManagerBzd)this.getBzd()).doSubmmitFile(this._userCtx, waPath, fileWARelativePath);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public Properties getFileAttributes(String waPath, String fileWARelativePath) throws R01MSecurityException, R01MDataStoreException {
        try {
            String opDesc = "getFileAttributes > waPath=" + waPath + " fileWARelativePath=" + fileWARelativePath;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            Properties outProps = ((R01MRawDataManagerBzd)this.getBzd()).doGetFileAttributes(this._userCtx, waPath, fileWARelativePath);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
            return outProps;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void setFileAttributes(String waPath, String fileWARelativePath, Properties attrs) throws R01MSecurityException, R01MDataStoreException {
        try {
            String opDesc = "setFileAttributes > waPath=" + waPath + " fileWARelativePath=" + fileWARelativePath;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MRawDataManagerBzd)this.getBzd()).doSetFileAttributes(this._userCtx, waPath, fileWARelativePath, attrs);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void generateFileUsingPresentationTemplate(String waPath, String dataFileWARelativePath, Map generatedFilesWARelativePaths, String generateURL, String templateOid, String templateInstanceId, Properties templateProperties) throws R01MSecurityException, R01MDataStoreException {
        try {
            String opDesc = "generateFileUsingPresentationTemplate > waPath=" + waPath + " dataFileWARelativePath=" + dataFileWARelativePath + " generateURL=" + generateURL + " template=" + templateOid;
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MRawDataManagerBzd)this.getBzd()).doGenerateFileUsingPresentationTemplate(this._userCtx, waPath, dataFileWARelativePath, generatedFilesWARelativePaths, generateURL, templateOid, templateInstanceId, templateProperties);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void downloadFileAsync(String waPath, String fileWARelativePath, String targetFileAbsolutePath, R01MMessageCallBackBean msgDataCallBack) throws R01MDataStoreException {
        String msgDataCallBackXML;
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("Notificaci\u00f3n de descarga del fichero '" + waPath + fileWARelativePath + "' a " + targetFileAbsolutePath + ", respuesta en " + msgDataCallBack.composeMemoCode());
        }
        ArrayList<R01MJmsQueueParam> params = new ArrayList<R01MJmsQueueParam>();
        params.add(new R01MJmsQueueParam(1, "waPath", waPath));
        params.add(new R01MJmsQueueParam(1, "fileWARelativePath", fileWARelativePath));
        params.add(new R01MJmsQueueParam(1, "targetFileAbsolutePath", targetFileAbsolutePath));
        try {
            msgDataCallBackXML = XOManager.getXML((String)R01MConstants.CONTENTMODEL_MAPFILE, (Object)msgDataCallBack);
        }
        catch (XOMarshallerException xoExc) {
            R01FLog.to((String)"r01m.dataAPI").severe("Error en la notificaci\u00f3n de descarga del fichero '" + waPath + fileWARelativePath + "' a " + targetFileAbsolutePath + "', el objeto de respuesta es incorrecto.Error:" + xoExc.getMessage());
            throw new R01MDataStoreException("Error en la notificaci\u00f3n de descarga del fichero '" + waPath + fileWARelativePath + "' a " + targetFileAbsolutePath + "', el objeto de respuesta es incorrecto.", (Exception)((Object)xoExc));
        }
        params.add(new R01MJmsQueueParam(1, "messageCallBackOid", msgDataCallBack.getProcessOid()));
        params.add(new R01MJmsQueueParam(1, "msgCallBack", msgDataCallBackXML));
        try {
            R01MJMSUtils.sendJMSMessage("r01DownloadFileAsync", params);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("Notificaci\u00f3n de descarga del fichero '" + waPath + fileWARelativePath + "' a " + targetFileAbsolutePath + ", respuesta en " + msgDataCallBack.composeMemoCode());
            }
        }
        catch (R01MJMSException jmsExc) {
            R01FLog.to((String)"r01m.dataAPI").severe("Error en la notificaci\u00f3n de descarga del fichero '" + waPath + fileWARelativePath + "' a '" + targetFileAbsolutePath + "', respuesta en " + msgDataCallBack.composeMemoCode() + ".Error:" + jmsExc.getMessage());
            throw new R01MDataStoreException("Error en la notificaci\u00f3n de descarga del fichero '" + waPath + fileWARelativePath + "' a '" + targetFileAbsolutePath + "', respuesta en " + msgDataCallBack.composeMemoCode() + ".", (Exception)((Object)jmsExc));
        }
    }

    public void uploadFileAsync(String sourceFileAbsolutePath, String targetWAPath, String targetFileWARelativePath, R01MMessageCallBackBean msgDataCallBack) throws R01MDataStoreException {
        if (msgDataCallBack == null || msgDataCallBack != null && msgDataCallBack.getResponseType() == 0 && (StringUtils.isEmptyString((String)msgDataCallBack.getJmsConnectionFactory()) || StringUtils.isEmptyString((String)msgDataCallBack.getJmsJNDIName()))) {
            R01FLog.to((String)"r01m.dataAPI").severe("Los par\u00e1metros de respuesta son incorrectos." + (msgDataCallBack != null ? "factory:" + msgDataCallBack.getJmsConnectionFactory() + ",jndi:" + StringUtils.isEmptyString((String)msgDataCallBack.getJmsJNDIName()) : "Se debe definir un objeto R01MMessageCallBackBean."));
            throw new R01MDataStoreException("Los par\u00e1metros de conexion JMS son incorrectos." + (msgDataCallBack != null ? "factory:" + msgDataCallBack.getJmsConnectionFactory() + ",jndi:" + StringUtils.isEmptyString((String)msgDataCallBack.getJmsJNDIName()) : "Se debe definir un objeto R01MMessageCallBackBean."));
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("Notificaci\u00f3n de subir el fichero '" + sourceFileAbsolutePath + "' a " + targetWAPath + targetFileWARelativePath + ", respuesta en " + msgDataCallBack.composeMemoCode());
        }
        if (!this.validateFileName(targetFileWARelativePath)) {
            throw new R01MDataStoreException("El nombre destino del archivo '" + targetFileWARelativePath + "' no est\u00e1 permitido o no es v\u00e1lido.");
        }
        try {
            ((R01MRawDataManagerBzd)this.getBzd()).doUploadFileAsync(this._userCtx, sourceFileAbsolutePath, targetWAPath, targetFileWARelativePath, msgDataCallBack);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MDataStoreException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        catch (R01MSecurityException e) {
            throw new R01MDataStoreException("No se tienen permisos para realizar la operacion solicitada.");
        }
    }

    private boolean validateFileName(String targetFileWARelativePath) {
        return true;
    }

    public boolean rawCheckFile(String workAreaPath, String fileWARelPath) throws R01MSecurityException, R01MContentModelException {
        try {
            return this.checkFile(workAreaPath, fileWARelPath);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException((Exception)((Object)dsEx));
        }
    }

    public boolean rawCheckFolder(String workAreaPath, String folderWARelPath) throws R01MSecurityException, R01MContentModelException {
        try {
            return this.checkFolder(workAreaPath, folderWARelPath);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException((Exception)((Object)dsEx));
        }
    }

    public R01MDataStoreItem[] rawGetFolderContents(String workAreaPath, String folderWARelPath, boolean recurse) throws R01MSecurityException, R01MContentModelException {
        try {
            return this.getFolderContents(workAreaPath, folderWARelPath, recurse);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException((Exception)((Object)dsEx));
        }
    }

    public InputStream rawReadFile(String workAreaPath, String fileWARelPath) throws R01MSecurityException, R01MContentModelException {
        try {
            return this.readFile(workAreaPath, fileWARelPath);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException((Exception)((Object)dsEx));
        }
    }
}

