/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.clone.CloneUtils;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.config.objects.publisher.R01MLogicalPublicationInfo;
import com.ejie.r01m.config.objects.publisher.R01MPublisherDestinationSystem;
import com.ejie.r01m.config.objects.publisher.R01MPublisherSourceSystem;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.services.R01MBaseConfigAPI;
import com.ejie.r01m.services.bzd.R01MPublisherConfigLoaderBzd;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class R01MPublisherConfigAPI
extends R01MBaseConfigAPI {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.configAPI").intValue() != Level.OFF.intValue();
    public static final int SYSTEM_SOURCE = 0;
    public static final int SYSTEM_DESTINATION = 1;
    public static final int LOGICAL_PUBCONFIGS = 2;
    public static final String CACHEPREFIX_SOURCE = "source";
    public static final String CACHEPREFIX_DESTINATION = "destination";
    public static final String CACHEPREFIX_LOGICALPUBS = "logicalPublicationConfigs";

    R01MPublisherConfigAPI() {
        super("publisherConfig");
    }

    public R01MPublisherSourceSystem getSourceSystemConfig(String systemOid) throws R01MConfigLoadException {
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Obtener la configuraci\u00f3n del sistema origen de publicaci\u00f3n " + systemOid);
        }
        return (R01MPublisherSourceSystem)this._obtainSystemConfig(0, systemOid);
    }

    public R01MPublisherDestinationSystem getDestinationSystemConfig(String systemOid) throws R01MConfigLoadException {
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Obtener la configuraci\u00f3n del sistema destino de publicaci\u00f3n " + systemOid);
        }
        return (R01MPublisherDestinationSystem)this._obtainSystemConfig(1, systemOid);
    }

    public R01MLogicalPublicationInfo getLogicalPublicationConfig(String logicalPubCfgOid) throws R01MConfigLoadException {
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Obtener la configuraci\u00f3n de todos las configuraciones l\u00f3gicas de publicaci\u00f3n");
        }
        return (R01MLogicalPublicationInfo)this._obtainSystemConfig(2, logicalPubCfgOid);
    }

    public Map getSourcesConfigs() throws R01MConfigLoadException {
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Obtener la configuraci\u00f3n de todos los sistemas origen de publicaci\u00f3n");
        }
        return ((R01MPublisherConfigLoaderBzd)this.getBzd("publisherConfig")).loadSystemsConfigs(0);
    }

    public Map getDestinationsConfigs() throws R01MConfigLoadException {
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Obtener la configuraci\u00f3n de todos los sistemas destino de publicaci\u00f3n");
        }
        return ((R01MPublisherConfigLoaderBzd)this.getBzd("publisherConfig")).loadSystemsConfigs(1);
    }

    public Map<String, R01MLogicalPublicationInfo> getLogicalPublicationsConfigs() throws R01MConfigLoadException {
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Obtener la configuraci\u00f3n de todos las configuraciones l\u00f3gicas de publicaci\u00f3n");
        }
        return ((R01MPublisherConfigLoaderBzd)this.getBzd("publisherConfig")).loadSystemsConfigs(2);
    }

    public List getLogicalPublicationsAlias() throws R01MConfigLoadException {
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Obtener los alias de repositorios de publicacion.");
        }
        ArrayList<String> contentAlias = new ArrayList<String>();
        Map<String, R01MLogicalPublicationInfo> logicalPublications = ((R01MPublisherConfigLoaderBzd)this.getBzd("publisherConfig")).loadSystemsConfigs(2);
        if (logicalPublications != null && !logicalPublications.isEmpty()) {
            Iterator<R01MLogicalPublicationInfo> itLogicalPublications = logicalPublications.values().iterator();
            while (itLogicalPublications.hasNext()) {
                contentAlias.add(itLogicalPublications.next().getContentAlias());
            }
        }
        return contentAlias;
    }

    public String getLogicalPublicationsAliasRegExp() throws R01MConfigLoadException {
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Obtener los alias de repositorios de publicacion.");
        }
        StringBuffer contentAliasRegExp = new StringBuffer("contenidos");
        List logicalPublicationsAlias = this.getLogicalPublicationsAlias();
        if (logicalPublicationsAlias != null && !logicalPublicationsAlias.isEmpty()) {
            contentAliasRegExp = new StringBuffer();
            contentAliasRegExp.append('(');
            Iterator itLogicalPublicationsAlias = logicalPublicationsAlias.iterator();
            while (itLogicalPublicationsAlias.hasNext()) {
                contentAliasRegExp.append(itLogicalPublicationsAlias.next());
                contentAliasRegExp.append('|');
            }
            contentAliasRegExp.deleteCharAt(contentAliasRegExp.length() - 1);
            contentAliasRegExp.append(')');
        }
        return contentAliasRegExp.toString();
    }

    @Override
    public void reset() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (cliente + servidor) de configuraci\u00f3n de publicaciones.");
        this.resetClient();
        this.resetServer();
    }

    @Override
    public void resetClient() {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (solo cliente) de configuraci\u00f3n de publicaciones.");
        super.resetCacheObjectConfig();
    }

    @Override
    public void resetServer() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (servidor) de configuraci\u00f3n de publicaciones.");
        ((R01MPublisherConfigLoaderBzd)this.getBzd("publisherConfig")).reset();
    }

    private Object _obtainSystemConfig(int systemType, String systemOid) throws R01MConfigLoadException {
        String cacheIndx = systemOid;
        switch (systemType) {
            case 1: {
                cacheIndx = "destination." + cacheIndx;
                break;
            }
            case 0: {
                cacheIndx = "source." + cacheIndx;
                break;
            }
            case 2: {
                cacheIndx = "logicalPublicationConfigs." + cacheIndx;
                break;
            }
            default: {
                throw new R01MConfigLoadException("Tipo de Sistema de publicaci\u00f3n desconocido!!!: " + systemType);
            }
        }
        Object config = this.getObjectConfig(cacheIndx);
        if (config == null) {
            if (DEBUG) {
                R01FLog.to((String)"r01m.config").info("CLIENT: No se habia cargado la configuraci\u00f3n del sistema del publicador " + cacheIndx + "... se carga ahora");
            }
            if ((config = ((R01MPublisherConfigLoaderBzd)this.getBzd("publisherConfig")).loadSystemConfig(systemType, systemOid)) != null) {
                this.cacheObjectConfig(cacheIndx, config);
                return CloneUtils.cloneByReflection((Object)config);
            }
            throw new R01MConfigLoadException("No se han podido cargar los datos de configuraci\u00f3n del sistema del publicador " + cacheIndx);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.config").info("CLIENT: La configuraci\u00f3n de publicaci\u00f3n " + systemOid + " esta en la cache... NO SE CARGA");
        }
        return CloneUtils.cloneByReflection((Object)config);
    }
}

