/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.exceptions.R01MPublisherException;
import com.ejie.r01m.objects.publisher.R01MPublish;
import com.ejie.r01m.services.R01MBaseAPI;
import com.ejie.r01m.services.bzd.R01MPublisherBzd;
import java.util.Date;
import java.util.List;

public class R01MPublisherAPI
extends R01MBaseAPI {
    private static String LOG_TYPE_ID = "r01m.pubAPI";

    public R01MPublisherAPI() {
        super("publisherapi");
    }

    public R01MPublish obtainPublicationInfoObject(String userName, String objectOid, int objectType, String filePattern, List resourcesRelativePaths, String publisherManagerClassName, String repositoryOid, int publicationType, Date publicationDate) throws R01MPublisherException {
        String opDesc = "obteniendo la informaci\u00f3n de publicaci\u00f3n.";
        R01MPublish pub = null;
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("PUBLISHER CLIENT API (init): " + opDesc);
            pub = ((R01MPublisherBzd)this.getBzd()).execObtainPublicationInfoObject(userName, objectOid, objectType, filePattern, resourcesRelativePaths, publisherManagerClassName, repositoryOid, publicationType, publicationDate);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPublisherException("Error en la configuracion del BZD del publicador!!!:", (Exception)((Object)bzdCfgEx));
        }
        return pub;
    }

    public void removeDeployment(R01MPublish pub) throws R01MPublisherException {
        String opDesc = "Eliminando el deployment de oid " + (pub.getOid() != null ? pub.getOid() : "[null]");
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("PUBLISHER CLIENT API (init): " + opDesc);
            ((R01MPublisherBzd)this.getBzd()).execRemoveDeployment(pub);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPublisherException("Error en la configuracion del BZD del publicador!!!:", (Exception)((Object)bzdCfgEx));
        }
    }
}

