/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.services.R01MBaseConfigAPI;
import com.ejie.r01m.services.bzd.R01MPropertiesConfigLoaderBzd;
import com.ejie.r01m.services.bzd.R01MTypologyConfigLoaderBzd;
import java.util.Properties;
import java.util.logging.Level;

public class R01MPropertiesConfigAPI
extends R01MBaseConfigAPI {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.configAPI").intValue() != Level.OFF.intValue();

    R01MPropertiesConfigAPI() {
        super("propertiesConfig");
    }

    public String getProperty(String propXPath) {
        try {
            return ((R01MPropertiesConfigLoaderBzd)this.getBzd("propertiesConfig")).getProperty(propXPath);
        }
        catch (R01MConfigLoadException clEx) {
            if (DEBUG) {
                R01FLog.to((String)"r01m.configAPI").severe("Error al acceder al BZD de configuraci\u00f3n de los properties: " + clEx.getMessage());
            }
            return null;
        }
    }

    public String getProperty(String propXPath, String defValue) {
        try {
            return ((R01MPropertiesConfigLoaderBzd)this.getBzd("propertiesConfig")).getProperty(propXPath, defValue);
        }
        catch (R01MConfigLoadException clEx) {
            if (DEBUG) {
                R01FLog.to((String)"r01m.configAPI").severe("Error al acceder al BZD de configuraci\u00f3n de los properties: " + clEx.getMessage());
            }
            return null;
        }
    }

    public Properties getProperties(String fileCode, String propXPath) {
        try {
            return ((R01MPropertiesConfigLoaderBzd)this.getBzd("propertiesConfig")).getProperties(fileCode, propXPath);
        }
        catch (R01MConfigLoadException clEx) {
            if (DEBUG) {
                R01FLog.to((String)"r01m.configAPI").severe("Error al acceder al BZD de configuraci\u00f3n de los properties: " + clEx.getMessage());
            }
            return null;
        }
    }

    public Properties getProperties(String propXPath) {
        try {
            return ((R01MPropertiesConfigLoaderBzd)this.getBzd("propertiesConfig")).getProperties(propXPath);
        }
        catch (R01MConfigLoadException clEx) {
            if (DEBUG) {
                R01FLog.to((String)"r01m.configAPI").severe("Error al acceder al BZD de configuraci\u00f3n de los properties: " + clEx.getMessage());
            }
            return null;
        }
    }

    @Override
    public void reset() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (cliente + servidor) de configuraci\u00f3n de tipos de contenido.");
        this.resetServer();
        this.resetClient();
    }

    @Override
    public void resetClient() {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (cliente) de configuraci\u00f3n de tipos de contenido.");
        super.resetCacheObjectConfig();
    }

    @Override
    public void resetServer() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (cliente + servidor) de configuraci\u00f3n de tipos de contenido.");
        ((R01MTypologyConfigLoaderBzd)this.getBzd("typologyConfig")).reset();
    }
}

