/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.clone.CloneUtils;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelsPacket;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MDeletePageException;
import com.ejie.r01m.exceptions.R01MDuplicatePageException;
import com.ejie.r01m.exceptions.R01MDuplicateVisualAreaException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MPortalModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MBasePublicationTarget;
import com.ejie.r01m.objects.R01MURLAlias;
import com.ejie.r01m.objects.cataloguing.picks.R01MGeoPicks;
import com.ejie.r01m.objects.portalmodel.R01MPage;
import com.ejie.r01m.objects.portalmodel.R01MPortal;
import com.ejie.r01m.objects.portalmodel.R01MPortalCategory;
import com.ejie.r01m.objects.portalmodel.R01MPortalHistoryFilter;
import com.ejie.r01m.objects.portalmodel.R01MPortalLocation;
import com.ejie.r01m.objects.portalmodel.R01MSearchedPortalPage;
import com.ejie.r01m.objects.portalmodel.R01MVisualAreaInstance;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexablePortalPage;
import com.ejie.r01m.services.R01MBaseAPI;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.bzd.R01MPortalModelManagerBzd;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MPortalModelObjectsValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;

public class R01MPortalManagerAPI
extends R01MBaseAPI {
    private static Map _portalLocationCache = Collections.synchronizedMap(new WeakHashMap(100));
    private transient R01MUserContext _userCtx = null;
    private transient String _portalOid = null;
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.portalAPI").intValue() != Level.OFF.intValue();
    private static final String LOG_SEP_INI = "\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n";
    private static final String LOG_SEP_END = "\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\n";

    public R01MPortalManagerAPI(R01MUserContext userCtx, String portalOid) {
        super("portalManager");
        this._userCtx = userCtx;
        this._portalOid = portalOid;
    }

    public String getPortalOid() {
        return this._portalOid;
    }

    public void setPortalOid(String thePortalOid) {
        this._portalOid = thePortalOid;
    }

    public R01MUserContext getUserContext() {
        return this._userCtx;
    }

    public void setUserContext(R01MUserContext theUserCtx) {
        this._userCtx = theUserCtx;
    }

    public Map savePortalPage(R01MPage page) throws R01MSecurityException, R01MPortalModelException, R01MPortalModelObjectsValidatorException, R01MDuplicatePageException {
        return this.savePortalPage(page, false);
    }

    public Map savePortalPage(R01MPage page, boolean sassCompile) throws R01MSecurityException, R01MPortalModelException, R01MPortalModelObjectsValidatorException, R01MDuplicatePageException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Salvando la p\u00e1gina " + (page != null && page.getOid() != null ? page.getOid() : "null") + " del portal " + this._portalOid;
        if (page == null) {
            throw new R01MPortalModelObjectsValidatorException("El objeto de p\u00e1gina es NULO.");
        }
        Map vaIncludes = null;
        try {
            R01MPortal portalObj;
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            try {
                portalObj = R01MClientFactory.getPortalConfigAPI().loadPortal(page.getPortalOid());
            }
            catch (R01MConfigLoadException ex) {
                R01FLog.to((String)"r01m.portalAPI").severe("Error en la carga del portal " + this._portalOid + ".Error:" + ex.getMessage());
                throw new R01MPortalModelException("Error en la carga del portal " + this._portalOid + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
            }
            if (!R01MAuthManager.getRoleRights(portalObj.getStoreLocation(), this._userCtx).canModify()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede guardar la p\u00e1gina " + page.getOid() + " en el portal " + this._portalOid);
            }
            R01MPortalModelObjectsValidator.validatePage(this._userCtx, page);
            R01MPortalModelObjectsValidator.validatePageFriendlyUrl(this._userCtx, this._portalOid, page);
            vaIncludes = ((R01MPortalModelManagerBzd)this.getBzd()).doSavePortalPage(this._userCtx, page, sassCompile);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            R01FLog.to((String)"r01m.portalAPI").severe("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.");
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (R01MDuplicatePageException duplExc) {
            throw duplExc;
        }
        catch (R01MPortalModelObjectsValidatorException valExc) {
            throw valExc;
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n. " + ex.getMessage(), ex);
        }
        return vaIncludes;
    }

    public R01MPage copyPortalPage(String pageOidTo, String pageOidFrom) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Copiando la p\u00e1gina " + pageOidFrom + " en la p\u00e1gina " + pageOidTo + " del portal " + this._portalOid;
        if (!StringUtils.isEmptyString((String)pageOidTo) && !StringUtils.isEmptyString((String)pageOidFrom)) {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            try {
                if (R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canModify()) {
                    return ((R01MPortalModelManagerBzd)this.getBzd()).doCopyPortalPage(this._userCtx, pageOidTo, pageOidFrom);
                }
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede copiar p\u00e1ginas en el portal " + this._portalOid);
            }
            catch (BzdConfigException bzdCfgEx) {
                throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
            }
            catch (Exception ex) {
                throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
            }
        }
        R01FLog.to((String)"r01m.portalAPI").warning("Error en la copia de p\u00e1gina, alg\u00fan identificador es nulo, o se trata del mismo...");
        return null;
    }

    public void copyVisualAreasFromPage(String pageOidTo, String pageOidFrom) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Copiando las AVs de la p\u00e1gina " + pageOidFrom + " en la p\u00e1gina " + pageOidTo + " del portal " + this._portalOid;
        if (!StringUtils.isEmptyString((String)pageOidTo) && !StringUtils.isEmptyString((String)pageOidFrom)) {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            try {
                if (R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canModify()) {
                    ((R01MPortalModelManagerBzd)this.getBzd()).doCopyVisualAreasFromPage(this._userCtx, pageOidTo, pageOidFrom);
                    return;
                }
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede copiar AVs de p\u00e1ginas en el portal " + this._portalOid);
            }
            catch (BzdConfigException bzdCfgEx) {
                throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
            }
            catch (Exception ex) {
                throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
            }
        }
        R01FLog.to((String)"r01m.portalAPI").warning("Error en la copia de AVs de p\u00e1gina, alg\u00fan identificador es nulo, o se trata del mismo...");
    }

    public Map changePageTemplate(String pageOid, String templateOid) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Modificando la plantilla de la p\u00e1gina " + pageOid + " del portal " + this._portalOid + " a la nueva plantilla de oid " + templateOid;
        if (!StringUtils.isEmptyString((String)pageOid) && !StringUtils.isEmptyString((String)templateOid)) {
            try {
                R01MPortal portalObj;
                if (DEBUG) {
                    R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
                }
                try {
                    portalObj = R01MClientFactory.getPortalConfigAPI().loadPortal(this._portalOid);
                }
                catch (R01MConfigLoadException ex) {
                    throw new R01MPortalModelException("Error en la carga del portal " + this._portalOid + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
                }
                if (R01MAuthManager.getRoleRights(portalObj.getStoreLocation(), this._userCtx).canModify()) {
                    return ((R01MPortalModelManagerBzd)this.getBzd()).doChangePageTemplate(this._userCtx, pageOid, templateOid);
                }
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede modificar la plantilla de la p\u00e1gina " + pageOid + " en el portal " + this._portalOid);
            }
            catch (BzdConfigException bzdCfgEx) {
                throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
            }
            catch (Exception ex) {
                throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
            }
        }
        R01FLog.to((String)"r01m.portalAPI").warning("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT API (end): Identificador de p\u00e1gina o plantilla incorrecto.");
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void changePageCategory(String pageOid, String categoryOid) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Modificando la categor\u00eda de la p\u00e1gina " + pageOid + " del portal " + this._portalOid + " a la nueva categor\u00eda de oid " + categoryOid;
        if (!StringUtils.isEmptyString((String)pageOid) && !StringUtils.isEmptyString((String)categoryOid)) {
            try {
                R01MPortal portalObj;
                if (DEBUG) {
                    R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
                }
                try {
                    portalObj = R01MClientFactory.getPortalConfigAPI().loadPortal(this._portalOid);
                }
                catch (R01MConfigLoadException ex) {
                    throw new R01MPortalModelException("Error en la carga del portal " + this._portalOid + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
                }
                if (!R01MAuthManager.getRoleRights(portalObj.getStoreLocation(), this._userCtx).canModify()) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede modificar la categor\u00eda de la p\u00e1gina " + pageOid + " en el portal " + this._portalOid);
                }
                ((R01MPortalModelManagerBzd)this.getBzd()).doChangePageCategory(this._userCtx, pageOid, categoryOid);
                if (!DEBUG) return;
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
                return;
            }
            catch (BzdConfigException bzdCfgEx) {
                throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
            }
            catch (Exception ex) {
                throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
            }
        }
        R01FLog.to((String)"r01m.portalAPI").warning("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (end): Identificador de p\u00e1gina o categor\u00eda incorrecto.");
    }

    public void publishPortalResources(String portalOid, String repositoryOid, String[] resourcesRelativePaths) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Publicando los recursos: ";
        for (int i = 0; i < resourcesRelativePaths.length; ++i) {
            opDesc = opDesc + (resourcesRelativePaths[i] != null ? resourcesRelativePaths[i] : "") + (i < resourcesRelativePaths.length - 1 ? ", " : ".");
        }
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canModify()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede publicar los recuros seleccionados.");
            }
            ((R01MPortalModelManagerBzd)this.getBzd()).doPublishPortalResources(this._userCtx, portalOid, repositoryOid, resourcesRelativePaths);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException ex) {
            ex.printStackTrace(System.out);
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public void publishPortalAliases(String portalOid, String repositoryOid) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Publicando los aliases del portal " + portalOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canModify()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede publicar los aliases del portal " + portalOid + ".");
            }
            ((R01MPortalModelManagerBzd)this.getBzd()).doPublishPortalAliases(this._userCtx, portalOid, repositoryOid);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException ex) {
            ex.printStackTrace(System.out);
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public void publishPortalAlias(String portalOid, String aliasOid, String repositoryOid) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Publicando los aliases del portal " + portalOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canModify()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede publicar los aliases del portal " + portalOid + ".");
            }
            ((R01MPortalModelManagerBzd)this.getBzd()).doPublishPortalAlias(this._userCtx, portalOid, aliasOid, repositoryOid);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException ex) {
            ex.printStackTrace(System.out);
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public void publishPortalPage(R01MPage page) throws R01MSecurityException, R01MPortalModelException, R01MPortalModelObjectsValidatorException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Publicando la p\u00e1gina " + page.getOid() + " del portal " + this._portalOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canModify()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede publicar la p\u00e1gina " + page.getOid() + " del portal " + this._portalOid);
            }
            ((R01MPortalModelManagerBzd)this.getBzd()).doPublishPortalPage(this._userCtx, page);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (R01MPortalModelObjectsValidatorException valExc) {
            throw valExc;
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public boolean isPagePublished(String pageOid, String repositoryOid) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Validando si la p\u00e1gina " + pageOid + " est\u00e1 publicada en el repositorio " + repositoryOid;
        if (DEBUG) {
            R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
        }
        boolean isPagePublishedInRepo = false;
        try {
            isPagePublishedInRepo = ((R01MPortalModelManagerBzd)this.getBzd()).isPagePublished(this._userCtx, pageOid, repositoryOid);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.portalAPI").info("\u00bfLa p\u00e1gina de identificador '" + pageOid + "' est\u00e1 publicada en '" + repositoryOid + "?" + isPagePublishedInRepo);
            R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        return isPagePublishedInRepo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void changePageCatalog(String pageOid, List structureCats) throws R01MSecurityException, R01MPortalModelException, R01MPortalModelObjectsValidatorException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Catalogando en ejes la p\u00e1gina " + pageOid + " del portal " + this._portalOid;
        if (!StringUtils.isEmptyString((String)pageOid)) {
            try {
                if (DEBUG) {
                    R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
                }
                if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canModify()) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede catalogar en ejes la p\u00e1gina " + pageOid + " del portal " + this._portalOid);
                }
                ((R01MPortalModelManagerBzd)this.getBzd()).doChangePageCatalog(this._userCtx, pageOid, structureCats);
                if (!DEBUG) return;
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
                return;
            }
            catch (BzdConfigException bzdCfgEx) {
                throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
            }
            catch (R01MPortalModelObjectsValidatorException valExc) {
                throw valExc;
            }
            catch (Exception ex) {
                throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
            }
        } else {
            R01FLog.to((String)"r01m.portalAPI").warning("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (end): Identificador de p\u00e1gina incorrecto.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void changePageGeoCatalog(String pageOid, R01MGeoPicks geoCats) throws R01MSecurityException, R01MPortalModelException, R01MPortalModelObjectsValidatorException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Catalogando geogr\u00e1ficamente la p\u00e1gina " + pageOid + " del portal " + this._portalOid;
        if (!StringUtils.isEmptyString((String)pageOid)) {
            try {
                if (DEBUG) {
                    R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
                }
                if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canModify()) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede catalogar geogr\u00e1ficamente la p\u00e1gina " + pageOid + " del portal " + this._portalOid);
                }
                ((R01MPortalModelManagerBzd)this.getBzd()).doChangePageGeoCatalog(this._userCtx, pageOid, geoCats);
                if (!DEBUG) return;
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
                return;
            }
            catch (BzdConfigException bzdCfgEx) {
                throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
            }
            catch (R01MPortalModelObjectsValidatorException valExc) {
                throw valExc;
            }
            catch (Exception ex) {
                throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
            }
        } else {
            R01FLog.to((String)"r01m.portalAPI").warning("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (end): Identificador de p\u00e1gina incorrecto.");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void saveVisualAreaInstance(String pageOid, String vaIncludeId, R01MVisualAreaInstance vaInstance) throws R01MSecurityException, R01MPortalModelException, R01MDuplicateVisualAreaException, R01MPortalModelObjectsValidatorException {
        opDesc = "Guardando el Area Visual " + (vaInstance != null ? vaInstance.getOid() : "null") + " del portal " + this._portalOid;
        if (R01MPortalManagerAPI.DEBUG) {
            R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
        }
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        if (vaInstance != null) {
            try {
                if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canModify()) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede modificar Areas Visuales en el portal " + this._portalOid);
                }
                ((R01MPortalModelManagerBzd)this.getBzd()).doSaveVisualAreaInstance(this._userCtx, this._portalOid, pageOid, vaIncludeId, vaInstance);
                if (!R01MPortalManagerAPI.DEBUG) ** GOTO lbl23
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + "\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\n");
            }
            catch (BzdConfigException bzdCfgEx) {
                throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)bzdCfgEx);
            }
            catch (R01MDuplicateVisualAreaException duplExc) {
                throw duplExc;
            }
            catch (R01MPortalModelObjectsValidatorException valExc) {
                throw valExc;
            }
            catch (Exception ex) {
                throw new R01MPortalModelException("Error de aplicaci\u00f3n." + ex.getMessage(), ex);
            }
        } else {
            R01FLog.to((String)"r01m.portalAPI").warning("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (end): La instancia de Area Visual es NULA.");
        }
lbl23:
        // 3 sources

        if (R01MPortalManagerAPI.DEBUG) {
            R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (end): " + opDesc);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void referenceVisualAreaInstance(String pageOid, String vaIncludeId, String vaInstanceOid) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        if (!StringUtils.isEmptyString((String)pageOid) && !StringUtils.isEmptyString((String)vaInstanceOid)) {
            String opDesc = "Referenciando el Area Visual " + vaInstanceOid + " con la p\u00e1gina " + pageOid + " en el portal " + this._portalOid;
            try {
                if (DEBUG) {
                    R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
                }
                if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canModify()) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede Referenciar Areas Visuales en el portal " + this._portalOid);
                }
                ((R01MPortalModelManagerBzd)this.getBzd()).doReferenceVisualAreaInstance(this._userCtx, pageOid, vaIncludeId, vaInstanceOid);
                if (!DEBUG) return;
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
                return;
            }
            catch (BzdConfigException bzdCfgEx) {
                throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
            }
            catch (Exception ex) {
                throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
            }
        } else {
            R01FLog.to((String)"r01m.portalAPI").warning("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (end): El identificador de instancia de Area Visual o de p\u00e1gina es NULO.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String cloneVisualAreaInstance(String portalOid, String pageOid, String vaIncludeId, String sourceVAInstanceOid, String newVAInstanceName) throws R01MSecurityException, R01MPortalModelException, R01MPortalModelObjectsValidatorException, R01MDuplicateVisualAreaException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String newVAInstanceOid = null;
        if (!StringUtils.isEmptyString((String)pageOid) && !StringUtils.isEmptyString((String)sourceVAInstanceOid)) {
            String opDesc = "Referenciando el Area Visual " + sourceVAInstanceOid + " con la p\u00e1gina " + pageOid + " en el portal " + this._portalOid;
            try {
                if (DEBUG) {
                    R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
                }
                if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canModify()) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede Referenciar Areas Visuales en el portal " + this._portalOid);
                }
                newVAInstanceOid = ((R01MPortalModelManagerBzd)this.getBzd()).doCloneVisualAreaInstance(this._userCtx, portalOid, pageOid, vaIncludeId, sourceVAInstanceOid, newVAInstanceName);
                if (!DEBUG) return newVAInstanceOid;
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
                return newVAInstanceOid;
            }
            catch (BzdConfigException bzdCfgEx) {
                throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
            }
            catch (R01MPortalModelObjectsValidatorException ex) {
                throw new R01MPortalModelObjectsValidatorException("Error de validaci\u00f3n de AV.", (Exception)((Object)ex));
            }
            catch (R01MDuplicateVisualAreaException ex) {
                throw new R01MDuplicateVisualAreaException("Ya existe en AV con el mismo nombre.", (Exception)((Object)ex));
            }
            catch (Exception ex) {
                throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
            }
        } else {
            R01FLog.to((String)"r01m.portalAPI").warning("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (end): El identificador de instancia de Area Visual o de p\u00e1gina es NULO.");
        }
        return newVAInstanceOid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void referenceMigatedVisualAreaInstance(String pageOid, String vaIncludeId, String vaInstanceOid, String newVAInstanceName) throws R01MSecurityException, R01MPortalModelException, R01MDuplicateVisualAreaException, R01MPortalModelObjectsValidatorException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        if (!StringUtils.isEmptyString((String)pageOid) && !StringUtils.isEmptyString((String)vaInstanceOid)) {
            String opDesc = "Referenciando el Area Visual " + vaInstanceOid + " con la p\u00e1gina " + pageOid + " en el portal " + this._portalOid;
            try {
                if (DEBUG) {
                    R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
                }
                if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canModify()) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede Referenciar Areas Visuales en el portal " + this._portalOid);
                }
                ((R01MPortalModelManagerBzd)this.getBzd()).doReferenceMigratedVisualAreaInstance(this._userCtx, this._portalOid, pageOid, vaIncludeId, vaInstanceOid, newVAInstanceName);
                if (!DEBUG) return;
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
                return;
            }
            catch (BzdConfigException bzdCfgEx) {
                throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
            }
            catch (R01MDuplicateVisualAreaException duplExc) {
                throw duplExc;
            }
            catch (R01MPortalModelObjectsValidatorException valExc) {
                throw valExc;
            }
            catch (Exception ex) {
                throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
            }
        } else {
            R01FLog.to((String)"r01m.portalAPI").warning("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (end): El identificador de instancia de Area Visual o de p\u00e1gina es NULO.");
        }
    }

    public boolean checkAliasExistence(R01MURLAlias alias) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Comprobar existencia del alias " + alias;
        boolean existsAlias = false;
        try {
            R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            existsAlias = ((R01MPortalModelManagerBzd)this.getBzd()).doCheckAliasExistence(alias);
            R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return existsAlias;
    }

    public boolean checkAliasExistence(String portalOid, R01MURLAlias alias) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Comprobar existencia del alias " + alias;
        boolean existsAlias = false;
        try {
            R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            existsAlias = ((R01MPortalModelManagerBzd)this.getBzd()).doCheckAliasExistence(portalOid, alias);
            R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return existsAlias;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveAlias(R01MURLAlias alias) throws R01MSecurityException, R01MPortalModelObjectsValidatorException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        if (alias != null) {
            String opDesc = "Guardando el alias " + alias.getAlias() + " del portal " + this._portalOid;
            try {
                if (DEBUG) {
                    R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
                }
                if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canModify()) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede modificar los aliases en el portal " + this._portalOid);
                }
                ((R01MPortalModelManagerBzd)this.getBzd()).doSaveAlias(this._userCtx, this._portalOid, alias);
                if (!DEBUG) return;
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
                return;
            }
            catch (BzdConfigException bzdCfgEx) {
                throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
            }
        } else {
            R01FLog.to((String)"r01m.portalAPI").warning("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (end): El alias es NULO.");
        }
    }

    public void regeneratePortalAliases() throws R01MSecurityException, R01MPortalModelObjectsValidatorException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Regenerando los alias del portal " + this._portalOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canModify()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede modificar los aliases en el portal " + this._portalOid);
            }
            ((R01MPortalModelManagerBzd)this.getBzd()).doRegeneratePortalAliases(this._userCtx, this._portalOid);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
    }

    public void updatePageAliasesState(String pageOid, int initialState, int finalState) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Actualizando los aliases de la p\u00e1gina " + pageOid + " del estado " + initialState + " al estado " + finalState;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canModify()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede modificar los aliases en el portal " + this._portalOid);
            }
            ((R01MPortalModelManagerBzd)this.getBzd()).doUpdatePageAliasesState(this._userCtx, pageOid, initialState, finalState);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public void updatePageAliasesState(String pageOid, List aliases, int finalState) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Actualizando los aliases de la p\u00e1gina " + pageOid + " al estado " + finalState;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canModify()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede modificar los aliases en el portal " + this._portalOid);
            }
            ((R01MPortalModelManagerBzd)this.getBzd()).doUpdatePageAliasesState(this._userCtx, pageOid, aliases, finalState);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public void updatePortalAliasesState(int initialState, int finalState) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Actualizando los aliases del portal " + this._portalOid + " del estado " + initialState + " al estado " + finalState;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canModify()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede modificar los aliases en el portal " + this._portalOid);
            }
            ((R01MPortalModelManagerBzd)this.getBzd()).doUpdatePortalAliasesState(this._userCtx, this._portalOid, initialState, finalState);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteAlias(R01MURLAlias alias) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        if (alias != null) {
            String opDesc = "Guardando el alias " + alias.getAlias() + " del portal " + this._portalOid;
            try {
                if (DEBUG) {
                    R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
                }
                if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canModify()) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede modificar los aliases en el portal " + this._portalOid);
                }
                ((R01MPortalModelManagerBzd)this.getBzd()).doDeleteAlias(this._userCtx, this._portalOid, alias);
                if (!DEBUG) return;
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
                return;
            }
            catch (BzdConfigException bzdCfgEx) {
                throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
            }
            catch (Exception ex) {
                throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
            }
        } else {
            R01FLog.to((String)"r01m.portalAPI").warning("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (end): El alias es NULO.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveCategory(R01MPortalCategory category) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        if (category != null) {
            String opDesc = "Guardando la categor\u00eda " + category.getOid() + " del portal " + this._portalOid;
            try {
                if (DEBUG) {
                    R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
                }
                if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canModify()) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede modificar las categor\u00edas en el portal " + this._portalOid);
                }
                ((R01MPortalModelManagerBzd)this.getBzd()).doSaveCategory(this._userCtx, this._portalOid, category);
                if (!DEBUG) return;
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
                return;
            }
            catch (BzdConfigException bzdCfgEx) {
                throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
            }
            catch (Exception ex) {
                throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
            }
        } else {
            R01FLog.to((String)"r01m.portalAPI").warning("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (end): La categor\u00eda es NULA.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveTemplate(String templateFileName) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        if (!StringUtils.isEmptyString((String)templateFileName)) {
            String opDesc = "Guardando la plantilla " + templateFileName + " del portal " + this._portalOid;
            try {
                if (DEBUG) {
                    R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
                }
                if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canModify()) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede modificar las plantillas en el portal " + this._portalOid);
                }
                ((R01MPortalModelManagerBzd)this.getBzd()).doSaveTemplate(this._userCtx, this._portalOid, templateFileName);
                if (!DEBUG) return;
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
                return;
            }
            catch (BzdConfigException bzdCfgEx) {
                throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
            }
            catch (Exception ex) {
                throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
            }
        } else {
            R01FLog.to((String)"r01m.portalAPI").warning("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (end): La plantilla es NULA.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void changeInitialPage(String pageOid) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        if (!StringUtils.isEmptyString((String)pageOid)) {
            String opDesc = "Estableciendo la p\u00e1gina " + pageOid + " como la inicial del portal " + this._portalOid;
            try {
                if (DEBUG) {
                    R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
                }
                if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canModify()) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede modificar la p\u00e1gina inicial del portal " + this._portalOid);
                }
                ((R01MPortalModelManagerBzd)this.getBzd()).doChangeInitialPage(this._userCtx, this._portalOid, pageOid);
                if (!DEBUG) return;
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
                return;
            }
            catch (BzdConfigException bzdCfgEx) {
                throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
            }
            catch (Exception ex) {
                throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
            }
        } else {
            R01FLog.to((String)"r01m.portalAPI").warning("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (end): La p\u00e1gina es NULA.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void redirectUrlPage(String pageOid, String redirectUrl) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        if (!StringUtils.isEmptyString((String)pageOid)) {
            String opDesc = "Estableciendo la p\u00e1gina " + pageOid + " como la inicial del portal " + this._portalOid;
            try {
                if (DEBUG) {
                    R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
                }
                if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canModify()) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede modificar la p\u00e1gina inicial del portal " + this._portalOid);
                }
                ((R01MPortalModelManagerBzd)this.getBzd()).doRedirectUrlPage(this._userCtx, this._portalOid, pageOid, redirectUrl);
                if (!DEBUG) return;
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
                return;
            }
            catch (BzdConfigException bzdCfgEx) {
                throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
            }
            catch (Exception ex) {
                throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
            }
        } else {
            R01FLog.to((String)"r01m.portalAPI").warning("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (end): La p\u00e1gina es NULA.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deletePortalPage(String pageOid) throws R01MSecurityException, R01MPortalModelException, R01MDeletePageException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Borrar la p\u00e1gina " + pageOid + " del portal " + this._portalOid;
        if (!StringUtils.isEmptyString((String)pageOid)) {
            try {
                if (DEBUG) {
                    R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
                }
                if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canDelete()) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede borrar la p\u00e1gina " + pageOid + " del portal " + this._portalOid);
                }
                ((R01MPortalModelManagerBzd)this.getBzd()).doDeletePortalPage(this._userCtx, pageOid);
                if (!DEBUG) return;
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
                return;
            }
            catch (BzdConfigException bzdCfgEx) {
                throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
            }
            catch (R01MDeletePageException delExc) {
                throw delExc;
            }
            catch (Exception ex) {
                throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
            }
        } else {
            R01FLog.to((String)"r01m.portalAPI").warning("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (end): Identificador de p\u00e1gina incorrecto.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean deleteCategory(String categoryOid) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Borrar la categor\u00eda " + categoryOid + " del portal " + this._portalOid;
        boolean result = false;
        if (!StringUtils.isEmptyString((String)categoryOid)) {
            try {
                if (DEBUG) {
                    R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
                }
                if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canDelete()) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede borrar la categor\u00eda " + categoryOid + " del portal " + this._portalOid);
                }
                result = ((R01MPortalModelManagerBzd)this.getBzd()).doDeleteCategory(this._userCtx, this._portalOid, categoryOid);
                if (!DEBUG) return result;
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
                return result;
            }
            catch (BzdConfigException bzdCfgEx) {
                throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
            }
            catch (Exception ex) {
                throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
            }
        } else {
            R01FLog.to((String)"r01m.portalAPI").warning("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (end): Identificador de categor\u00eda incorrecto.");
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean deleteTemplate(String templateId) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Borrar la plantilla " + templateId + " del portal " + this._portalOid;
        boolean result = false;
        if (!StringUtils.isEmptyString((String)templateId)) {
            try {
                if (DEBUG) {
                    R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
                }
                if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canDelete()) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede borrar la plantilla " + templateId + " del portal " + this._portalOid);
                }
                result = ((R01MPortalModelManagerBzd)this.getBzd()).doDeleteTemplate(this._userCtx, this._portalOid, templateId);
                if (!DEBUG) return result;
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
                return result;
            }
            catch (BzdConfigException bzdCfgEx) {
                throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
            }
            catch (Exception ex) {
                throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
            }
        } else {
            R01FLog.to((String)"r01m.portalAPI").warning("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (end): Identificador de plantilla incorrecto.");
        }
        return result;
    }

    public R01MPage loadPortalPage(String pageOid) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        if (StringUtils.isEmptyString((String)pageOid)) {
            return null;
        }
        String opDesc = "Carga de la p\u00e1gina " + pageOid + " del portal " + this._portalOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            R01MPage page = null;
            if (!this._userCtx.isMasterSystem() && !R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canSee()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede leer la p\u00e1gina " + pageOid + " del portal " + this._portalOid);
            }
            page = ((R01MPortalModelManagerBzd)this.getBzd()).doLoadPortalPage(this._userCtx, pageOid);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return page;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public String getPageParentPortalOid(String pageOid) throws R01MPortalModelException {
        if (StringUtils.isEmptyString((String)pageOid)) {
            return null;
        }
        String opDesc = "Obtencion del codigo de portal al que pertenece la pagina " + pageOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            String portalOid = ((R01MPortalModelManagerBzd)this.getBzd()).doGetPageParentPortalOid(pageOid);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return portalOid;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public String getVisualAreaParentPortalOid(String vaOid) throws R01MPortalModelException {
        if (StringUtils.isEmptyString((String)vaOid)) {
            return null;
        }
        String opDesc = "Obtencion del codigo de portal al que pertenece el area visual " + vaOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            String portalOid = ((R01MPortalModelManagerBzd)this.getBzd()).doGetVisualAreaParentPortalOid(vaOid);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return portalOid;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public List loadPortalPageHistory(String pageOid, R01MPortalHistoryFilter filter) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        if (StringUtils.isEmptyString((String)pageOid)) {
            return null;
        }
        String opDesc = "Carga del hist\u00f3rico de la p\u00e1gina " + pageOid + " del portal " + this._portalOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            List pageHistory = null;
            if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canSee()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede leer el hist\u00f3rico de la p\u00e1gina " + pageOid + " del portal " + this._portalOid);
            }
            pageHistory = ((R01MPortalModelManagerBzd)this.getBzd()).doLoadPortalPageHistory(this._userCtx, pageOid, filter);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return pageHistory;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public Map<String, R01MBasePublicationTarget> loadRunningPublications() throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Carga de las publicaciones y despublicaciones en estado RUNNING";
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            Map<String, R01MBasePublicationTarget> runningPublications = ((R01MPortalModelManagerBzd)this.getBzd()).doLoadRunningPublications();
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return runningPublications;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public List<R01MURLAlias> loadPortalAliasesByState(int state) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Carga alias del portal " + this._portalOid + " con el estado " + state;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            List<R01MURLAlias> aliasList = ((R01MPortalModelManagerBzd)this.getBzd()).doLoadPortalAliasesInState(this._portalOid, state);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return aliasList;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public Map<String, List<R01MURLAlias>> loadPortalAliasesByState() throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Carga alias del portal " + this._portalOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            Map<String, List<R01MURLAlias>> aliasList = ((R01MPortalModelManagerBzd)this.getBzd()).doLoadPortalAliasesByState(this._portalOid);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return aliasList;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public List<R01MURLAlias> loadPortalAliasesByStateAndGeneratedWithSameName(int state) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Carga alias del portal " + this._portalOid + " con el estado " + state;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            List<R01MURLAlias> aliasList = ((R01MPortalModelManagerBzd)this.getBzd()).doLoadPortalAliasesInStateAndGeneratedWithSameName(this._portalOid, state);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return aliasList;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public List<R01MURLAlias> loadPortalAliasesByAlias(String alias) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Carga alias del portal " + this._portalOid + " con el texto " + alias;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            List<R01MURLAlias> aliasList = ((R01MPortalModelManagerBzd)this.getBzd()).doLoadPortalAliasesByAlias(this._portalOid, alias);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return aliasList;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public List<R01MURLAlias> loadPageAliasesByAlias(String alias) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Carga alias del portal " + this._portalOid + " con el texto " + alias;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            List<R01MURLAlias> aliasList = ((R01MPortalModelManagerBzd)this.getBzd()).doLoadPageAliasesByAlias(this._portalOid, alias);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return aliasList;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public List<R01MURLAlias> loadPageAliasesInState(String pageOid, int state) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Carga alias de la p\u00e1gina " + pageOid + " con el estado " + state;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            List aliasList = ((R01MPortalModelManagerBzd)this.getBzd()).doLoadPageAliasesInState(pageOid, state);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return aliasList;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public List<R01MURLAlias> loadPortalActiveAliases() throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Carga alias activos del portal " + this._portalOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            List<R01MURLAlias> aliasList = ((R01MPortalModelManagerBzd)this.getBzd()).doLoadPortalActiveAliases(this._portalOid);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return aliasList;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public List<R01MURLAlias> loadPageActiveAliasesOfPortal() throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Carga alias activos del portal " + this._portalOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            List<R01MURLAlias> aliasList = ((R01MPortalModelManagerBzd)this.getBzd()).doLoadPageActiveAliasesOfPortal(this._portalOid);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return aliasList;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public List loadPageActiveAliases(String pageOid) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Carga alias activos de la p\u00e1gina " + pageOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            List aliasList = ((R01MPortalModelManagerBzd)this.getBzd()).doLoadPageActiveAliases(pageOid);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return aliasList;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public List loadPageVALinks(String pageOid) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        if (StringUtils.isEmptyString((String)pageOid)) {
            return null;
        }
        String opDesc = "Carga los enlaces de las areas visuales de la p\u00e1gina " + pageOid + " del portal " + this._portalOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            List pageVALinks = null;
            if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canSee()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede cargar los enlaces de las areas visuales de la pagina " + pageOid + " del portal " + this._portalOid);
            }
            pageVALinks = ((R01MPortalModelManagerBzd)this.getBzd()).doLoadPageVALinks(this._userCtx, pageOid);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return pageVALinks;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public Map loadPageVADescriptions(String pageOid) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        if (StringUtils.isEmptyString((String)pageOid)) {
            return null;
        }
        String opDesc = "Carga las descripciones de las areas visuales de la p\u00e1gina " + pageOid + " del portal " + this._portalOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            Map vaDescriptions = null;
            if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canSee()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede cargar las descripciones de las areas visuales de la pagina " + pageOid + " del portal " + this._portalOid);
            }
            vaDescriptions = ((R01MPortalModelManagerBzd)this.getBzd()).doLoadPageVADescriptions(this._userCtx, pageOid);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return vaDescriptions;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public R01MVisualAreaInstance loadVAInstance(String vaInstanceOid) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        if (StringUtils.isEmptyString((String)vaInstanceOid)) {
            return null;
        }
        String opDesc = "Carga de la instancia " + vaInstanceOid + " del portal " + this._portalOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            R01MVisualAreaInstance vaInstance = null;
            if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canSee()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede leer la instancia " + vaInstanceOid + " del portal " + this._portalOid);
            }
            vaInstance = ((R01MPortalModelManagerBzd)this.getBzd()).doLoadVisualAreaInstance(this._userCtx, vaInstanceOid);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return vaInstance;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public List findPortalPages(R01MSearchedPortalPage searchPagePortal) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "B\u00fasqueda de p\u00e1ginas en el portal de Oid " + this._portalOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("/n/tCriterios de b\u00fasqueda: ");
            }
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("/n/t/tNombre Interno de p\u00e1gina " + searchPagePortal.getInternalName());
            }
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("/n/t/tNombre de p\u00e1gina " + searchPagePortal.getName());
            }
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("/n/t/tDescripci\u00f3n de la p\u00e1gina " + searchPagePortal.getDescription());
            }
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("/n/t/tPlantilla de oid " + searchPagePortal.getTemplateId());
            }
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("/n/t/tCategor\u00eda de oid " + searchPagePortal.getCategoryOid());
            }
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("/n/t/tTipo de area visual que esta contenida en la p\u00e1gina " + searchPagePortal.getVisualAreaType());
            }
            ArrayList resultPages = null;
            if (R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canSee()) {
                resultPages = ((R01MPortalModelManagerBzd)this.getBzd()).doFindPortalPages(this._userCtx, this._portalOid, searchPagePortal);
                if (searchPagePortal.getVisualAreaType() != null && searchPagePortal.getVisualAreaType().equals(R01MConstants.VA_CONTAINER_TYPE)) {
                    R01MSearchedPortalPage searchPagePortal2 = (R01MSearchedPortalPage)CloneUtils.cloneByReflection((Object)searchPagePortal);
                    searchPagePortal2.setVisualAreaType(R01MConstants.VA_RESULTS_TYPE);
                    List resultPagesSearch = ((R01MPortalModelManagerBzd)this.getBzd()).doFindPortalPages(this._userCtx, this._portalOid, searchPagePortal2);
                    if (resultPagesSearch != null && !resultPagesSearch.isEmpty()) {
                        if (resultPages == null) {
                            resultPages = new ArrayList();
                        }
                        resultPages.addAll(resultPagesSearch);
                    }
                } else if (searchPagePortal.getVisualAreaType() != null && searchPagePortal.getVisualAreaType().equals(R01MConstants.VA_RESULTS_TYPE)) {
                    R01MSearchedPortalPage searchPagePortal2 = (R01MSearchedPortalPage)CloneUtils.cloneByReflection((Object)searchPagePortal);
                    searchPagePortal2.setVisualAreaType(R01MConstants.VA_CONTAINER_TYPE);
                    List resultPagesContentList = ((R01MPortalModelManagerBzd)this.getBzd()).doFindPortalPages(this._userCtx, this._portalOid, searchPagePortal2);
                    if (resultPagesContentList != null && !resultPagesContentList.isEmpty()) {
                        if (resultPages == null) {
                            resultPages = new ArrayList();
                        }
                        resultPages.addAll(resultPagesContentList);
                    }
                }
            } else {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede buscar p\u00e1ginas en el portal " + this._portalOid);
            }
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return resultPages;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public List findPortalPagesWithVisualArea(String typeVAOid) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        if (StringUtils.isEmptyString((String)typeVAOid)) {
            return null;
        }
        String opDesc = "B\u00fasqueda de p\u00e1ginas en el portal de Oid " + this._portalOid + " con \u00e1reas visuales del tipo " + typeVAOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            List resultPages = null;
            if (R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canSee()) {
                resultPages = ((R01MPortalModelManagerBzd)this.getBzd()).doFindPortalPagesWithVisualArea(this._userCtx, this._portalOid, typeVAOid);
                if (typeVAOid.equals(R01MConstants.VA_CONTAINER_TYPE)) {
                    resultPages.addAll(((R01MPortalModelManagerBzd)this.getBzd()).doFindPortalPagesWithVisualArea(this._userCtx, this._portalOid, R01MConstants.VA_RESULTS_TYPE));
                } else if (typeVAOid.equals(R01MConstants.VA_RESULTS_TYPE)) {
                    resultPages.addAll(((R01MPortalModelManagerBzd)this.getBzd()).doFindPortalPagesWithVisualArea(this._userCtx, this._portalOid, R01MConstants.VA_CONTAINER_TYPE));
                }
            } else {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede buscar p\u00e1ginas en el portal " + this._portalOid);
            }
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return resultPages;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public List findPortalPagesWithVisualAreaInstance(String instanceOid) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        if (StringUtils.isEmptyString((String)instanceOid)) {
            return null;
        }
        String opDesc = "B\u00fasqueda de p\u00e1ginas en el portal de Oid " + this._portalOid + " con \u00e1reas visuales con oid de instancia " + instanceOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            List resultPages = null;
            if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canSee()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede buscar p\u00e1ginas en el portal " + this._portalOid);
            }
            resultPages = ((R01MPortalModelManagerBzd)this.getBzd()).doFindPortalPagesWithVisualAreaInstance(this._userCtx, this._portalOid, instanceOid);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return resultPages;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public List findVisualAreaInstances(String portalOid, String typeVAOid) throws R01MSecurityException, R01MPortalModelException {
        return this.findVisualAreaInstances(portalOid, typeVAOid, null);
    }

    public List findVisualAreaInstances(String portalOid, String typeVAOid, String internalName) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        if (StringUtils.isEmptyString((String)typeVAOid)) {
            return null;
        }
        String opDesc = "B\u00fasqueda de instancias de VA del tipo " + typeVAOid + " en el portal de Oid " + this._portalOid + " con \u00e1reas visuales del tipo " + typeVAOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            List resultPages = null;
            if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canSee()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede buscar VAs en el portal " + this._portalOid);
            }
            resultPages = ((R01MPortalModelManagerBzd)this.getBzd()).doFindVisualAreaInstances(this._userCtx, portalOid, typeVAOid, internalName);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return resultPages;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public Map analyzeTemplatePage(String pageOid, String templateOid) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        if (StringUtils.isEmptyString((String)pageOid) || StringUtils.isEmptyString((String)templateOid)) {
            return null;
        }
        String opDesc = "Analizando el cambio de plantilla de la p\u00e1gina " + pageOid + "  del portal de Oid " + this._portalOid + " a la nueva plantilla " + templateOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            Map analyzeVAs = null;
            if (!R01MAuthManager.getRoleRights(this.getPortalLocation(), this._userCtx).canSee()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede buscar p\u00e1ginas en el portal " + this._portalOid);
            }
            analyzeVAs = ((R01MPortalModelManagerBzd)this.getBzd()).doAnalyzeTemplatePage(this._userCtx, pageOid, templateOid);
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return analyzeVAs;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public R01MPortalLocation getPortalLocation() throws R01MPortalModelException, R01MSecurityException {
        R01MPortalLocation outLocation;
        block6: {
            if (!this._validateContextAndPortal()) {
                throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
            }
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("...obtener la localizacion del portal: " + this._portalOid);
            }
            outLocation = (R01MPortalLocation)_portalLocationCache.get(this._portalOid);
            try {
                if (outLocation != null) break block6;
                try {
                    outLocation = this.loadPortalLocation();
                }
                catch (R01MSecurityException secEx) {
                    // empty catch block
                }
                _portalLocationCache.put(this._portalOid, outLocation);
            }
            catch (Exception ex) {
                throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
            }
        }
        return outLocation;
    }

    public R01MPortalLocation loadPortalLocation() throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Carga de la informaci\u00f3n de localizaci\u00f3n en el almacenamiento del portal " + this._portalOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            return ((R01MPortalModelManagerBzd)this.getBzd()).doLoadPortalLocation(this._userCtx, this._portalOid);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public boolean existsVisualAreaInstance(String visualAreaOid) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Valida si el Area Visual de identificador " + visualAreaOid + " ya existe.";
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            return ((R01MPortalModelManagerBzd)this.getBzd()).existsVisualAreaInstance(this._userCtx, visualAreaOid);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public R01MIndexablePortalPage preparePageToBeIndexed(String pageOid) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Prepara una pagina para su indexacion (pageOid=" + pageOid + ")";
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            return ((R01MPortalModelManagerBzd)this.getBzd()).doPreparePageToBeIndexed(this._userCtx, pageOid);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public R01MIndexablePortalPage getIndexablePage(String pageOid) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContextAndPortal()) {
            throw new R01MSecurityException("El contexto de usuario o el c\u00f3digo de portal NO es valido!");
        }
        String opDesc = "Cargando la versi\u00f3n indexable de la pagina " + pageOid;
        R01MIndexablePortalPage idxPage = null;
        try {
            R01FLog.to((String)"r01m.contentAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            idxPage = ((R01MPortalModelManagerBzd)this.getBzd()).doGetIndexablePortalPage(this._userCtx, pageOid);
            R01FLog.to((String)"r01m.contentAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return idxPage;
    }

    public Map getOperationsGroupByPages(R01MChangesLabelsPacket changesPacket) throws R01MPortalModelException, R01MSecurityException {
        if (!this._validateAdminContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Obtener las p\u00e1ginas para el paquete de operaciones " + changesPacket.getPacketOid();
        try {
            Map outGroups = null;
            R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            outGroups = ((R01MPortalModelManagerBzd)this.getBzd()).doGetOperationsGroupByPages(this._userCtx, changesPacket);
            R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            return outGroups;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuraci\u00f3n del businessDelegate del modelo de portales. Revisa la configuraci\u00f3n.", (Exception)((Object)bzdCfgEx));
        }
    }

    private boolean _validateAdminContext(R01MUserContext userCtx) {
        if (userCtx == null) {
            return false;
        }
        return userCtx.getUserProfile().equals("masterSystem");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean _validateContextAndPortal() throws R01MSecurityException {
        if (this._userCtx == null) {
            return false;
        }
        boolean isAccesible = false;
        if (this._userCtx.isMasterSystem()) return true;
        if (StringUtils.isEmptyString((String)this._portalOid)) {
            isAccesible = false;
        } else {
            if ("all".equals(this._portalOid)) {
                return true;
            }
            Map accessiblePortals = this._userCtx.getUserPortals();
            if (accessiblePortals == null) throw new R01MSecurityException("No existen portales accesibles para el usuario.");
            if (accessiblePortals.isEmpty()) throw new R01MSecurityException("No existen portales accesibles para el usuario.");
            for (Map.Entry mePortal : accessiblePortals.entrySet()) {
                R01MPortal portal = (R01MPortal)mePortal.getValue();
                if (!portal.getOid().equals(this._portalOid)) continue;
                isAccesible = true;
            }
        }
        if (isAccesible) return true;
        throw new R01MSecurityException("El usuario no tiene acceso al portal.");
    }
}

