/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.datastore.R01MDataStoreItem;
import com.ejie.r01m.objects.portalmodel.R01MPortal;
import com.ejie.r01m.services.R01MBaseAPI;
import com.ejie.r01m.services.bzd.R01MPortalDataManagerBzd;
import com.ejie.r01m.utils.R01MConstants;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class R01MPortalDataAPI
extends R01MBaseAPI {
    private static final String LOG_SEP_INI = "\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n";
    private static final String LOG_SEP_END = "\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\n";
    private transient R01MUserContext _userCtx = new R01MUserContext();
    private transient String _portalOid = null;

    private R01MPortalDataAPI() {
        super("portalModelData");
    }

    public R01MPortalDataAPI(R01MUserContext newUserCtx, String newPortalOid) {
        this();
        this._userCtx = newUserCtx;
        this._portalOid = newPortalOid;
    }

    public R01MPortalDataAPI(R01MUserContext newUserCtx, R01MPortal newPortal) {
        this();
        this._userCtx = newUserCtx;
        if (newPortal != null) {
            this._portalOid = newPortal.getOid();
        } else {
            R01FLog.to((String)"r01m.dataAPI").warning("ERROR al instanciar el API de Datos para portales... el portal suministrado es nulo!!!");
        }
    }

    public InputStream downloadAdminPage(String pageInternalName) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "downloadAdminPage > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            InputStream is = ((R01MPortalDataManagerBzd)this.getBzd()).doDownloadAdminPage(this._userCtx, this._portalOid, pageInternalName);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            return is;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public byte[] downloadAdminPageChunk(String pageInternalName, long offset, int length) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "downloadAdminPageChunk > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            byte[] bytes = ((R01MPortalDataManagerBzd)this.getBzd()).doDownloadAdminPageChunk(this._userCtx, this._portalOid, pageInternalName, offset, length);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            return bytes;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public InputStream downloadPage(String pageInternalName) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "downloadPage > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            InputStream is = ((R01MPortalDataManagerBzd)this.getBzd()).doDownloadPage(this._userCtx, this._portalOid, pageInternalName);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            return is;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public byte[] downloadPageChunk(String portalOid, String pageInternalName, long offset, int length) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "downloadPageChunk > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            byte[] bytes = ((R01MPortalDataManagerBzd)this.getBzd()).doDownloadPageChunk(this._userCtx, this._portalOid, pageInternalName, offset, length);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            return bytes;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public InputStream downloadTemplate(String templateInternalName) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "downloadTemplate > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            InputStream is = ((R01MPortalDataManagerBzd)this.getBzd()).doDownloadTemplate(this._userCtx, this._portalOid, templateInternalName);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            return is;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public byte[] downloadTemplateChunk(String templateInternalName, long offset, int length) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "downloadTemplateChunk > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            byte[] bytes = ((R01MPortalDataManagerBzd)this.getBzd()).doDownloadTemplateChunk(this._userCtx, this._portalOid, templateInternalName, offset, length);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            return bytes;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public InputStream downloadAV(String avType, String avLang, String avOid) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "downloadAV > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            InputStream is = ((R01MPortalDataManagerBzd)this.getBzd()).doDownloadAV(this._userCtx, this._portalOid, avType, avLang, avOid);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            return is;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public byte[] downloadAVChunk(String avType, String avLang, String avOid, long offset, int length) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "downloadAVChunk > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            byte[] bytes = ((R01MPortalDataManagerBzd)this.getBzd()).doDownloadAVChunk(this._userCtx, this._portalOid, avType, avLang, avOid, offset, length);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            return bytes;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public InputStream downloadPortalResource(int resourceType, String resourceName) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "downloadPortalResource > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            InputStream is = ((R01MPortalDataManagerBzd)this.getBzd()).doDownloadPortalResource(this._userCtx, this._portalOid, resourceType, resourceName);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            return is;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public byte[] downloadPortalResourceChunk(int resourceType, String resourceName, long offset, int length) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "downloadPortalResourceChunk > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            byte[] bytes = ((R01MPortalDataManagerBzd)this.getBzd()).doDownloadPortalResourceChunk(this._userCtx, this._portalOid, resourceType, resourceName, offset, length);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            return bytes;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public InputStream downloadPortalFile(String resourceWARelPath) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "downloadPortalFile > portalOid=" + this._portalOid + " resourceWARelPath=" + resourceWARelPath;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            InputStream is = ((R01MPortalDataManagerBzd)this.getBzd()).doDownloadPortalFile(this._userCtx, this._portalOid, resourceWARelPath);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            return is;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public byte[] downloadPortalFileChunk(String resourceWARelPath, long offset, int length) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "downloadPortalFileChunk > portalOid=" + this._portalOid + " resourceWARelPath=" + resourceWARelPath + " offset=" + offset + ":" + length;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            byte[] bytes = ((R01MPortalDataManagerBzd)this.getBzd()).doDownloadPortalFileChunk(this._userCtx, this._portalOid, resourceWARelPath, offset, length);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            return bytes;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public InputStream downloadAVResource(String avType, String resourceType, String resourceName) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "downloadAVResource > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            InputStream is = ((R01MPortalDataManagerBzd)this.getBzd()).doDownloadAVResource(this._userCtx, this._portalOid, avType, resourceType, resourceName);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            return is;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public byte[] downloadAVResourceChunk(String avType, String resourceType, String resourceName, long offset, int length) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "downloadAVResourceChunk > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            byte[] bytes = ((R01MPortalDataManagerBzd)this.getBzd()).doDownloadAVResourceChunk(this._userCtx, this._portalOid, avType, resourceType, resourceName, offset, length);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            return bytes;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadAdminPage(String pageInternalName, InputStream pageHtml) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "uploadAdminPage > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            ((R01MPortalDataManagerBzd)this.getBzd()).doUploadAdminPage(this._userCtx, this._portalOid, pageInternalName, pageHtml);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadAdminPageChunk(String pageInternalName, byte[] pageHtmlChunk, long offset) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "uploadAdminPageChunk > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            ((R01MPortalDataManagerBzd)this.getBzd()).doUploadAdminPageChunk(this._userCtx, this._portalOid, pageInternalName, pageHtmlChunk, offset);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadPage(String pageInternalName, InputStream pageHtml) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "uploadPage > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            ((R01MPortalDataManagerBzd)this.getBzd()).doUploadPage(this._userCtx, this._portalOid, pageInternalName, pageHtml);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadPageChunk(String pageInternalName, byte[] pageHtmlChunk, long offset) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "uploadPageChunk > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            ((R01MPortalDataManagerBzd)this.getBzd()).doUploadPageChunk(this._userCtx, this._portalOid, pageInternalName, pageHtmlChunk, offset);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadInitialPage(String pageInternalName, InputStream pageHtml) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "uploadInitialPage > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            ((R01MPortalDataManagerBzd)this.getBzd()).doUploadInitialPage(this._userCtx, this._portalOid, pageInternalName, pageHtml);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadTemplate(String templateInternalName, InputStream templateHtml) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "uploadTemplate > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            ((R01MPortalDataManagerBzd)this.getBzd()).doUploadTemplate(this._userCtx, this._portalOid, templateInternalName, templateHtml);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadTemplateChunk(String templateInternalName, byte[] templateHtmlChunk, long offset) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "uploadTemplateChunk > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            ((R01MPortalDataManagerBzd)this.getBzd()).doUploadTemplateChunk(this._userCtx, this._portalOid, templateInternalName, templateHtmlChunk, offset);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadPublishFile(String fileListPublishName, InputStream pubFileList) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "uploadPublishFile > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            ((R01MPortalDataManagerBzd)this.getBzd()).doUploadPublishFile(this._userCtx, this._portalOid, fileListPublishName, pubFileList);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadAV(String avType, String avInternalName, String avLang, InputStream avHtml) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "uploadAV > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            ((R01MPortalDataManagerBzd)this.getBzd()).doUploadAV(this._userCtx, this._portalOid, avType, avInternalName, avLang, avHtml);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadAVChunk(String avType, String avLang, String avInternalName, byte[] avHtmlChunk, long offset) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "uploadAVChunk > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            ((R01MPortalDataManagerBzd)this.getBzd()).doUploadAVChunk(this._userCtx, this._portalOid, avType, avInternalName, avLang, avHtmlChunk, offset);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadPortalResource(int resourceType, String resourceName, InputStream resource) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "uploadPortalResource > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            String wayUpload = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"wayUploadFile", (String)"atOnce");
            if ("chunked".equals(wayUpload)) {
                try {
                    long offset = 0L;
                    int totalLength = resource.available();
                    int block = R01MConstants.BUFFER_SIZE_CHUNK_MAX;
                    if (totalLength < block) {
                        block = totalLength;
                    }
                    do {
                        byte[] data = new byte[block];
                        resource.read(data);
                        ((R01MPortalDataManagerBzd)this.getBzd()).doUploadPortalResourceChunk(this._userCtx, this._portalOid, resourceType, resourceName, data, offset);
                        if ((offset += (long)block) + (long)block <= (long)totalLength) continue;
                        block = totalLength - (int)offset;
                    } while (offset < (long)totalLength);
                }
                catch (IOException ioExc) {
                    throw new R01MPortalModelException("Error al subir el archivo " + resourceName, (Exception)ioExc);
                }
                finally {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (IOException ex) {}
                    }
                }
            }
            ((R01MPortalDataManagerBzd)this.getBzd()).doUploadPortalResource(this._userCtx, this._portalOid, resourceType, resourceName, resource);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadPortalResource(int resourceType, String pageInternalName, String resourceName, InputStream resource) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "uploadPortalResource > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            ((R01MPortalDataManagerBzd)this.getBzd()).doUploadPortalResource(this._userCtx, this._portalOid, resourceType, pageInternalName, resourceName, resource);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadPortalResource(int resourceType, String pageInternalName, String language, String resourceName, InputStream resource) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "uploadPortalResource > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            ((R01MPortalDataManagerBzd)this.getBzd()).doUploadPortalResource(this._userCtx, this._portalOid, resourceType, pageInternalName, language, resourceName, resource);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadPortalResourceChunk(int resourceType, String resourceName, byte[] resChunk, long offset) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "uploadPortalResourceChunk > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            ((R01MPortalDataManagerBzd)this.getBzd()).doUploadPortalResourceChunk(this._userCtx, this._portalOid, resourceType, resourceName, resChunk, offset);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadAVResource(String avType, int resourceType, String resourceName, InputStream resource) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "uploadAVResource > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            ((R01MPortalDataManagerBzd)this.getBzd()).doUploadAVResource(this._userCtx, this._portalOid, avType, resourceType, resourceName, resource);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadAVResourceChunk(String avType, String resourceType, String resourceName, byte[] resChunk, long offset) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "uploadAVResourceChunk > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            ((R01MPortalDataManagerBzd)this.getBzd()).doUploadAVResourceChunk(this._userCtx, this._portalOid, avType, resourceType, resourceName, resChunk, offset);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void deletePage(String pageInternalName) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "deletePage > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            ((R01MPortalDataManagerBzd)this.getBzd()).doDeletePage(this._userCtx, this._portalOid, pageInternalName);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void deleteResource(String resourceWorkAreaRelativePath) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "deleteResource > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            ((R01MPortalDataManagerBzd)this.getBzd()).doDeleteResource(this._userCtx, this._portalOid, resourceWorkAreaRelativePath);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void deleteTemplate(String templateInternalName) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "deleteTemplate > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            ((R01MPortalDataManagerBzd)this.getBzd()).doDeleteTemplate(this._userCtx, this._portalOid, templateInternalName);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void createPublishDir() throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "createPublishDir > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            ((R01MPortalDataManagerBzd)this.getBzd()).doCreatePublishDir(this._userCtx, this._portalOid);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public StringBuffer consolidatePage(List resourcesToConsolidate) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "consolidatePage > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            StringBuffer sb = ((R01MPortalDataManagerBzd)this.getBzd()).doConsolidatePage(this._userCtx, this._portalOid, resourcesToConsolidate);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            return sb;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public StringBuffer consolidatePortalResources(List resourcesToConsolidate) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "consolidatePortalResources > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            StringBuffer sb = ((R01MPortalDataManagerBzd)this.getBzd()).doConsolidatePortalResources(this._userCtx, this._portalOid, resourcesToConsolidate);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            return sb;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public StringBuffer consolidatePortalResource(int resourceType) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "consolidatePortalResouce > portalOid=" + this._portalOid + " resource=" + resourceType;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            StringBuffer sb = ((R01MPortalDataManagerBzd)this.getBzd()).doConsolidatePortalResource(this._userCtx, this._portalOid, resourceType);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            return sb;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public StringBuffer consolidatePortalResourceFile(int resourceType, String resourceFileName) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "consolidatePortalResouceFile > portalOid=" + this._portalOid + " resource=" + resourceType + " fileName=" + resourceFileName;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            StringBuffer sb = ((R01MPortalDataManagerBzd)this.getBzd()).doConsolidatePortalResourceFile(this._userCtx, this._portalOid, resourceType, resourceFileName);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            return sb;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public StringBuffer consolidatePortalResourceFile(int resourceType, String pageInternalName, String resourceFileName) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "consolidatePortalResouceFile > portalOid=" + this._portalOid + " resource=" + resourceType + " fileName=" + resourceFileName;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            StringBuffer sb = ((R01MPortalDataManagerBzd)this.getBzd()).doConsolidatePortalResourceFile(this._userCtx, this._portalOid, resourceType, pageInternalName, resourceFileName);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            return sb;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public StringBuffer consolidatePortalResourceFile(int resourceType, String pageInternalName, String language, String resourceFileName) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "consolidatePortalResouceFile > portalOid=" + this._portalOid + " resource=" + resourceType + " fileName=" + resourceFileName;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            StringBuffer sb = ((R01MPortalDataManagerBzd)this.getBzd()).doConsolidatePortalResourceFile(this._userCtx, this._portalOid, resourceType, pageInternalName, language, resourceFileName);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            return sb;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public boolean checkResourceFileExistence(String filePath) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "checkResourceFileExistence > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            boolean exists = ((R01MPortalDataManagerBzd)this.getBzd()).doCheckResourceFileExistence(this._userCtx, this._portalOid, filePath);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            return exists;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MDataStoreItem[] getImageResourcesFileList() throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "getImageResourcesFileList > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            R01MDataStoreItem[] items = ((R01MPortalDataManagerBzd)this.getBzd()).doGetImageResourcesFileList(this._userCtx, this._portalOid);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            return items;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MDataStoreItem[] getResourcesFileList(String dirWARelativePath) throws R01MSecurityException, R01MPortalModelException {
        return this.getResourcesFileList(dirWARelativePath, false);
    }

    public R01MDataStoreItem[] getResourcesFileList(String dirWARelativePath, boolean isRecursive) throws R01MSecurityException, R01MPortalModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "getResourcesFileList > portalOid=" + this._portalOid;
            R01FLog.to((String)"r01m.dataAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            R01MDataStoreItem[] items = ((R01MPortalDataManagerBzd)this.getBzd()).doGetResourcesFileList(this._userCtx, this._portalOid, dirWARelativePath, isRecursive);
            R01FLog.to((String)"r01m.dataAPI").info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            return items;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del datos de portal. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }
}

