/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.objects.portalmodel.R01MPortal;
import com.ejie.r01m.objects.portalmodel.R01MPortalCategory;
import com.ejie.r01m.objects.portalmodel.R01MPortalTemplate;
import com.ejie.r01m.services.R01MBaseConfigAPI;
import com.ejie.r01m.services.bzd.R01MPortalConfigLoaderBzd;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class R01MPortalConfigAPI
extends R01MBaseConfigAPI {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.configAPI").intValue() != Level.OFF.intValue();

    R01MPortalConfigAPI() {
        super("portalConfig");
    }

    public synchronized Map<String, R01MPortal> getAllPortalConfig() throws R01MConfigLoadException {
        List<String> allPortalOids;
        Map<Object, Object> portalsConfig = this.getConfigs();
        if (portalsConfig != null) {
            if (DEBUG) {
                R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La configuraci\u00f3n de todos los portales est\u00e1 en la cach\u00e9... NO SE CARGA");
            }
            return portalsConfig;
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La cach\u00e9 se ha reseteado,se vuelve a cargar la configuraci\u00f3n de todos los portales... RECARGA");
        }
        if ((allPortalOids = this.loadPortalOids()) != null && !allPortalOids.isEmpty()) {
            if (DEBUG) {
                R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Cargando la configuracion de TODOS los portales.");
            }
            portalsConfig = new HashMap<Object, Object>(allPortalOids.size());
            for (String portalOid : allPortalOids) {
                try {
                    R01MPortal portal = ((R01MPortalConfigLoaderBzd)this.getBzd("portalConfig")).loadPortal(portalOid);
                    portalsConfig.put(portalOid, portal);
                    this.cacheObjectConfig(portalOid, portal);
                }
                catch (R01MConfigLoadException cfgExc) {
                    cfgExc.printStackTrace(System.out);
                    R01FLog.to((String)"r01m.configAPI").severe("CONFIG CLIENT API: Error en la carga del portal " + portalOid + ".Error:" + cfgExc.getMessage());
                    if (!DEBUG) continue;
                    R01FLog.to((String)"r01m.configAPI").info("Error en la carga del portal " + portalOid + " se continua con el siguiente ....");
                }
            }
            return portalsConfig;
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Cargando la configuracion de TODOS los portales.");
        }
        return portalsConfig;
    }

    public Map<String, R01MPortal> getAllPortalConfig(boolean reload) throws R01MConfigLoadException {
        if (reload) {
            return ((R01MPortalConfigLoaderBzd)this.getBzd("portalConfig")).loadAllPortalConfig();
        }
        return this.getAllPortalConfig();
    }

    public Map<String, R01MPortal> getAllPortalConfig(List xlnetWorkareasOids) throws R01MConfigLoadException {
        return this._filterUserAccess(this.getAllPortalConfig(), xlnetWorkareasOids);
    }

    public List loadPortalAlias(String portalOid) throws R01MConfigLoadException {
        return ((R01MPortalConfigLoaderBzd)this.getBzd("portalConfig")).loadPortalAlias(portalOid);
    }

    public R01MPortalCategory loadPortalCategory(String portalOid, String categoryOid) throws R01MConfigLoadException {
        return ((R01MPortalConfigLoaderBzd)this.getBzd("portalConfig")).loadPortalCategory(portalOid, categoryOid);
    }

    public List loadPortalCategories(String portalOid, boolean ordered, String lang) throws R01MConfigLoadException {
        return ((R01MPortalConfigLoaderBzd)this.getBzd("portalConfig")).loadPortalCategories(portalOid, ordered, lang);
    }

    public List loadPortalTemplates(String portalOid, boolean ordered, String lang) throws R01MConfigLoadException {
        return ((R01MPortalConfigLoaderBzd)this.getBzd("portalConfig")).loadPortalTemplates(portalOid, ordered, lang);
    }

    public R01MPortalTemplate loadPortalTemplate(String portalOid, String templateOid) throws R01MConfigLoadException {
        return ((R01MPortalConfigLoaderBzd)this.getBzd("portalConfig")).loadPortalTemplate(portalOid, templateOid);
    }

    public R01MPortal loadPortal(String portalOid) throws R01MConfigLoadException {
        R01MPortal portalConfig = (R01MPortal)this.getObjectConfig(portalOid);
        if (this.getConfigs() == null) {
            this.getAllPortalConfig();
            portalConfig = (R01MPortal)this.getObjectConfig(portalOid);
        }
        if (portalConfig == null) {
            if (DEBUG) {
                R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: No se habia cargado la configuracion del portal " + portalOid + "... se carga ahora");
            }
            if ((portalConfig = ((R01MPortalConfigLoaderBzd)this.getBzd("portalConfig")).loadPortal(portalOid)) != null) {
                this.cacheObjectConfig(portalOid, portalConfig);
                return portalConfig;
            }
            throw new R01MConfigLoadException("No se han podido cargar los datos de configuracion del portal " + portalOid);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La configuracion del portal " + portalOid + " esta en la cache... NO SE CARGA");
        }
        return portalConfig;
    }

    public R01MPortal loadPortal(String portalOid, boolean reload) throws R01MConfigLoadException {
        if (reload) {
            return ((R01MPortalConfigLoaderBzd)this.getBzd("portalConfig")).loadPortal(portalOid);
        }
        return this.loadPortal(portalOid);
    }

    public List<String> loadPortalOids() throws R01MConfigLoadException {
        return ((R01MPortalConfigLoaderBzd)this.getBzd("portalConfig")).loadPortals();
    }

    @Override
    public void reset() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (cliente + servidor) de configuraci\u00f3n completa de todos los portales.");
        this.resetClient();
        this.resetServer();
    }

    @Override
    public void resetClient() {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (cliente) de configuraci\u00f3n completa de todos los portales.");
        super.resetCacheObjectConfig();
    }

    @Override
    public void resetServer() throws R01MConfigLoadException {
    }

    private Map<String, R01MPortal> _filterUserAccess(Map<String, R01MPortal> portals, List<String> oidsWorkareasXlnets) {
        HashMap<String, R01MPortal> securityPortals = null;
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("Filtro de portales");
        }
        if (portals != null && !portals.isEmpty()) {
            if (oidsWorkareasXlnets != null && !oidsWorkareasXlnets.isEmpty()) {
                StringBuffer sbErr = new StringBuffer("");
                for (Map.Entry<String, R01MPortal> me : portals.entrySet()) {
                    R01MPortal portal = me.getValue();
                    if (oidsWorkareasXlnets.contains(portal.getStoreLocation().getWorkAreaOid())) {
                        if (DEBUG) {
                            R01FLog.to((String)"r01m.configAPI").info("Agregando el portal " + portal.getOid());
                        }
                        if (securityPortals == null) {
                            securityPortals = new HashMap<String, R01MPortal>();
                        }
                        securityPortals.put(portal.getOid(), portal);
                        continue;
                    }
                    sbErr.append("\tEl portal con la WA ");
                    sbErr.append(portal.getStoreLocation().getWorkAreaOid());
                    sbErr.append(" no est\u00e1 entre los permitidos.\r\n");
                }
                if (securityPortals == null || securityPortals.size() != portals.size()) {
                    R01FLog.to((String)"r01m.configAPI").warning("El usuario tiene acceso a un portal pero no se ha encontrado su configuraci\u00f3n:\r\n" + sbErr.toString());
                }
            }
        } else {
            R01FLog.to((String)"r01m.configAPI").warning("CONFIG CLIENT API (filterUserAccess): No existen portales configurados, revisar la configuraci\u00f3n.....");
        }
        return securityPortals;
    }
}

