/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MPortalModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.misc.R01MOperationInModelObjectResult;
import com.ejie.r01m.objects.portalmodel.R01MPortalLocation;
import com.ejie.r01m.objects.portalmodel.R01MVisualAreaInstance;
import com.ejie.r01m.services.R01MBaseAPI;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.bzd.R01MPortalAdminBzd;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class R01MPortalAdminAPI
extends R01MBaseAPI {
    private R01MUserContext _userCtx = null;
    private static final String LOG_SEP_INI = "\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n";
    private static final String LOG_SEP_END = "\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\n";

    R01MPortalAdminAPI() {
        super("portalAdmin");
    }

    R01MPortalAdminAPI(R01MUserContext userCtx) {
        this();
        this._userCtx = userCtx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doSavePortal(String portalOid, String portalXML) throws R01MPortalModelObjectsValidatorException, R01MSecurityException, R01MPortalModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Creando/Actualizando el portal " + portalOid;
        try {
            R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            List<String> portalOids = R01MClientFactory.getPortalConfigAPI().loadPortalOids();
            if (portalOids.contains(portalOid)) {
                R01MPortalLocation loc = R01MClientFactory.getPortalModelAPI(this._userCtx, portalOid).getPortalLocation();
                if (loc == null || !R01MAuthManager.getRoleRights(loc, this._userCtx).canModify()) throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede crear/actualizar el portal " + portalXML);
                ((R01MPortalAdminBzd)this.getBzd()).doSavePortal(this._userCtx, portalXML);
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
                return;
            } else {
                ((R01MPortalAdminBzd)this.getBzd()).doSavePortal(this._userCtx, portalXML);
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuracion.", (Exception)((Object)bzdCfgEx));
        }
        catch (R01MPortalModelObjectsValidatorException valExc) {
            throw valExc;
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public String doLoadXMLPortal(String portalOid) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        if (portalOid == null || StringUtils.isEmptyString((String)portalOid)) {
            throw new R01MPortalModelException("El c\u00f3digo de portal no es v\u00e1lido.");
        }
        String opDesc = "Cargando el descriptor del portal " + portalOid;
        try {
            R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            R01MPortalLocation loc = R01MClientFactory.getPortalModelAPI(this._userCtx, portalOid).getPortalLocation();
            if (loc != null && R01MAuthManager.getRoleRights(loc, this._userCtx).canModify()) {
                String xmlPortal = ((R01MPortalAdminBzd)this.getBzd()).doLoadXMLPortal(this._userCtx, portalOid);
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
                return xmlPortal;
            }
            throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede cargar el portal " + portalOid);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuracion.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public List[] regeneratePortalDynamicVAs(String portalOid) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        if (portalOid == null || StringUtils.isEmptyString((String)portalOid)) {
            throw new R01MPortalModelException("El c\u00f3digo de portal no es v\u00e1lido.");
        }
        String opDesc = "Regenerando las Areas Visuales del portal " + portalOid;
        try {
            R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            R01MPortalLocation loc = R01MClientFactory.getPortalModelAPI(this._userCtx, portalOid).getPortalLocation();
            if (loc != null && R01MAuthManager.getRoleRights(loc, this._userCtx).canModify()) {
                List[] result = ((R01MPortalAdminBzd)this.getBzd()).doRegeneratePortalDynamicVAs(this._userCtx, portalOid);
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
                return result;
            }
            throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede regenerar las VAs del portal " + portalOid);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuracion.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public R01MOperationInModelObjectResult regenerateVA(String portalOid, String visualAreaOid, boolean bExecuteInmediateRegeneration, boolean bRegenerateOnlyDynamicVAs, String lang) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        if (portalOid == null || StringUtils.isEmptyString((String)portalOid) || visualAreaOid == null || StringUtils.isEmptyString((String)visualAreaOid)) {
            throw new R01MPortalModelException("El c\u00f3digo de portal, o del Area Visual no es v\u00e1lido.");
        }
        String opDesc = "Regenerando el Area Visual de oid " + visualAreaOid;
        try {
            R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            R01MPortalLocation loc = R01MClientFactory.getPortalModelAPI(this._userCtx, portalOid).getPortalLocation();
            if (loc != null && R01MAuthManager.getRoleRights(loc, this._userCtx).canModify()) {
                R01MOperationInModelObjectResult result = ((R01MPortalAdminBzd)this.getBzd()).doRegenerateVA(this._userCtx, portalOid, visualAreaOid, bExecuteInmediateRegeneration, bRegenerateOnlyDynamicVAs, lang);
                R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
                return result;
            }
            throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede regenerar el VA de oid " + visualAreaOid);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuracion.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    public Map regenerateAllPortalsDynamicVAs() throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Regenerando el Area Visual de TODOS LOS PORTALES";
        R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
        HashMap<String, List[]> result = null;
        List<String> allPortals = null;
        try {
            allPortals = R01MClientFactory.getPortalConfigAPI().loadPortalOids();
        }
        catch (R01MConfigLoadException cfgEx) {
            R01FLog.to((String)"r01m.portalAPI").severe("CLIENT API : Error en la carga de la lista de portales. Error:" + cfgEx.getMessage());
            throw new R01MPortalModelException("Error en la carga de la lista de portales. Error:" + cfgEx.getMessage(), (Exception)((Object)cfgEx));
        }
        if (allPortals != null && !allPortals.isEmpty()) {
            R01FLog.to((String)"r01m.portalAPI").info("CLIENT API : Los portales a regenerar son:" + allPortals);
            result = new HashMap<String, List[]>();
            for (String portalOid : allPortals) {
                try {
                    List[] resultPortal = this.regeneratePortalDynamicVAs(portalOid);
                    result.put(portalOid, resultPortal);
                }
                catch (Exception e) {
                    result.put(portalOid, null);
                    R01FLog.to((String)"r01m.portalAPI").severe("CLIENT API : Error en la regeneraci\u00f3n del portal " + portalOid + ". Error:" + e.getMessage());
                    R01FLog.to((String)"r01m.portalAPI").severe("CLIENT API : Se continua con el siguiente.");
                }
            }
        } else {
            R01FLog.to((String)"r01m.portalAPI").warning("CLIENT API : \u00a1\u00a1 No existen PORTALES para regenerar. !!");
        }
        R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        return result;
    }

    public List[] regeneratePortalDynamicVAsJMS(String portalOid) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Regenerando las Areas Visuales  ";
        List[] result = null;
        try {
            R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            result = ((R01MPortalAdminBzd)this.getBzd()).doRegeneratePortalDynamicVAsJMS(this._userCtx, portalOid);
            R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (Exception e) {
            R01FLog.to((String)"r01m.portalAPI").severe("CLIENT API : Error en la regeneraci\u00f3n del portal . Error:" + e.getMessage());
            R01FLog.to((String)"r01m.portalAPI").severe("CLIENT API : Se continua con el siguiente.");
        }
        return result;
    }

    public void migrateVisualArea(String portalOid, R01MVisualAreaInstance vaInstance) throws R01MSecurityException, R01MPortalModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        if (portalOid == null || StringUtils.isEmptyString((String)portalOid) || vaInstance == null) {
            throw new R01MPortalModelException("El c\u00f3digo de portal no es v\u00e1lido.");
        }
        String opDesc = "Migrando el Area Visual de oid " + vaInstance.getOid();
        try {
            R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            R01MPortalLocation loc = R01MClientFactory.getPortalModelAPI(this._userCtx, portalOid).getPortalLocation();
            if (loc == null || !R01MAuthManager.getRoleRights(loc, this._userCtx).canModify()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede migrar el VA de oid " + vaInstance.getOid());
            }
            ((R01MPortalAdminBzd)this.getBzd()).doMigrateVisualArea(this._userCtx, portalOid, vaInstance);
            R01FLog.to((String)"r01m.portalAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MPortalModelException("Error en la configuracion del businessDelegate del modelo de portales. Revisa la configuracion.", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MPortalModelException("Error de aplicaci\u00f3n.", ex);
        }
    }

    private boolean _validateContext(R01MUserContext userCtx) {
        return userCtx != null;
    }
}

