/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.exceptions.R01MMiscDataLoadException;
import com.ejie.r01m.objects.portalmodel.R01MMetaTag;
import com.ejie.r01m.services.R01MBaseAPI;
import com.ejie.r01m.services.bzd.R01MMiscellaneousPortalDataLoaderBzd;
import com.ejie.r01m.utils.R01MConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class R01MMiscellaneousPortalDataAPI
extends R01MBaseAPI {
    public R01MMiscellaneousPortalDataAPI() {
        super("miscellaneousPortalData");
    }

    public Map getLanguages(String lang) throws R01MMiscDataLoadException {
        try {
            R01FLog.to((String)"r01m.miscAPI").info("MISC CLIENT API: Obtener los lenguajes en el idioma " + lang);
            return ((R01MMiscellaneousPortalDataLoaderBzd)this.getBzd()).loadLanguages(lang);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MMiscDataLoadException("Revisa el fichero de propiedades de R01M: Error en la configuracion del businessDelegate del API de datos miscellaneousPortalData.", (Exception)((Object)bzdCfgEx));
        }
    }

    public Map getEvents(String lang) throws R01MMiscDataLoadException {
        try {
            R01FLog.to((String)"r01m.miscAPI").info("MISC CLIENT API: Obtener los eventos en el idioma " + lang);
            return ((R01MMiscellaneousPortalDataLoaderBzd)this.getBzd()).loadEvents(lang);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MMiscDataLoadException("Revisa el fichero de propiedades de R01M: Error en la configuracion del businessDelegate del API de datos miscellaneousPortalData.", (Exception)((Object)bzdCfgEx));
        }
    }

    public List getDefaultMetaTags() throws R01MMiscDataLoadException {
        R01FLog.to((String)"r01m.miscAPI").info("MISC CLIENT API: Obtener los metaTags.");
        ArrayList<R01MMetaTag> metaTags = new ArrayList<R01MMetaTag>();
        NodeIterator itMetas = XMLProperties.getPropertyNodeIterator((String)R01MConstants.PORTALMANAGER_APPCODE, (String)"portal/metas/meta");
        Node node = itMetas.nextNode();
        while (node != null) {
            R01MMetaTag tag = new R01MMetaTag();
            tag.setName(node.getAttributes().getNamedItem("oid").getNodeValue());
            if (node.getAttributes().getNamedItem("type").getNodeValue().equals("name")) {
                tag.setTypeName();
            } else {
                tag.setTypeHttpEquip();
            }
            tag.setLanguageDependant(node.getAttributes().getNamedItem("languageDependant").getNodeValue().equalsIgnoreCase("true"));
            String defaultValue = XMLProperties.getProperty((String)R01MConstants.PORTALMANAGER_APPCODE, (String)("portal/metas/meta[@oid='" + tag.getName() + "']/defaultValue"));
            if (defaultValue != null) {
                tag.setDefaultValue(defaultValue);
            }
            metaTags.add(tag);
            node = itMetas.nextNode();
        }
        return metaTags;
    }

    public void reset() throws R01MMiscDataLoadException {
        R01FLog.to((String)"r01m.miscAPI").info("CONFIG CLIENT API: Reset de informaci\u00f3n auxiliar.");
        try {
            ((R01MMiscellaneousPortalDataLoaderBzd)this.getBzd()).reset();
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MMiscDataLoadException("Revisa el fichero de propiedades de R01M: Error en la configuracion del businessDelegate del API de datos miscellaneousPortalData.", (Exception)((Object)bzdCfgEx));
        }
    }
}

