/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.exceptions.R01MMiscDataLoadException;
import com.ejie.r01m.services.R01MBaseAPI;
import com.ejie.r01m.services.bzd.R01MMiscellaneousDataLoaderBzd;
import java.util.Map;

public class R01MMiscellaneousDataAPI
extends R01MBaseAPI {
    public R01MMiscellaneousDataAPI() {
        super("miscellaneousData");
    }

    public Map<String, String> getLanguages(String lang) throws R01MMiscDataLoadException {
        try {
            R01FLog.to((String)"r01m.miscAPI").info("MISC CLIENT API: Obtener los lenguajes en el idioma " + lang);
            return ((R01MMiscellaneousDataLoaderBzd)this.getBzd()).loadLanguages(lang);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MMiscDataLoadException("Revisa el fichero de propiedades de R01M: Error en la configuracion del businessDelegate del API de datos miscelaneos.", (Exception)((Object)bzdCfgEx));
        }
    }

    public Map getDeepthLevels(String lang) throws R01MMiscDataLoadException {
        try {
            R01FLog.to((String)"r01m.miscAPI").info("MISC CLIENT API: Obtener los niveles de profundidad en el idioma " + lang);
            return ((R01MMiscellaneousDataLoaderBzd)this.getBzd()).loadDeepthLevels(lang);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MMiscDataLoadException("Revisa el fichero de propiedades de R01M: Error en la configuracion del businessDelegate del API de datos miscelaneos.", (Exception)((Object)bzdCfgEx));
        }
    }

    public Map getEvents(String lang) throws R01MMiscDataLoadException {
        try {
            R01FLog.to((String)"r01m.miscAPI").info("MISC CLIENT API: Obtener los eventos en el idioma " + lang);
            return ((R01MMiscellaneousDataLoaderBzd)this.getBzd()).loadEvents(lang);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MMiscDataLoadException("Revisa el fichero de propiedades de R01M: Error en la configuracion del businessDelegate del API de datos miscelaneos.", (Exception)((Object)bzdCfgEx));
        }
    }

    public Map getStatus(String lang) throws R01MMiscDataLoadException {
        try {
            R01FLog.to((String)"r01m.miscAPI").info("MISC CLIENT API: Obtener los estados en el idioma " + lang);
            return ((R01MMiscellaneousDataLoaderBzd)this.getBzd()).loadStatus(lang);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MMiscDataLoadException("Revisa el fichero de propiedades de R01M: Error en la configuracion del businessDelegate del API de datos miscelaneos.", (Exception)((Object)bzdCfgEx));
        }
    }

    public Map getUpdatePeriods(String lang) throws R01MMiscDataLoadException {
        try {
            R01FLog.to((String)"r01m.miscAPI").info("MISC CLIENT API: Obtener los periodos de actualizacion en el idioma " + lang);
            return ((R01MMiscellaneousDataLoaderBzd)this.getBzd()).loadUpdatePeriods(lang);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MMiscDataLoadException("Revisa el fichero de propiedades de R01M: Error en la configuracion del businessDelegate del API de datos miscelaneos.", (Exception)((Object)bzdCfgEx));
        }
    }

    public Map loadProvinces(String lang) throws R01MMiscDataLoadException {
        try {
            R01FLog.to((String)"r01m.miscAPI").info("MISC CLIENT API: Obtener las provincias en el idioma " + lang);
            return ((R01MMiscellaneousDataLoaderBzd)this.getBzd()).loadProvinces(lang);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MMiscDataLoadException("Revisa el fichero de propiedades de R01M: Error en la configuracion del businessDelegate del API de datos miscelaneos.", (Exception)((Object)bzdCfgEx));
        }
    }

    public Map loadMunicipalities(String lang, String oidProvince) throws R01MMiscDataLoadException {
        try {
            R01FLog.to((String)"r01m.miscAPI").info("MISC CLIENT API: Obtener los municipios en el idioma " + lang);
            return ((R01MMiscellaneousDataLoaderBzd)this.getBzd()).loadMunicipalities(lang, oidProvince);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MMiscDataLoadException("Revisa el fichero de propiedades de R01M: Error en la configuracion del businessDelegate del API de datos miscelaneos.", (Exception)((Object)bzdCfgEx));
        }
    }

    public void reset() throws R01MMiscDataLoadException {
        R01FLog.to((String)"r01m.miscAPI").info("CONFIG CLIENT API: Reset de informaci\u00f3n auxiliar.");
        try {
            ((R01MMiscellaneousDataLoaderBzd)this.getBzd()).reset();
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MMiscDataLoadException("Revisa el fichero de propiedades de R01M: Error en la configuracion del businessDelegate del API de datos miscelaneos.", (Exception)((Object)bzdCfgEx));
        }
    }
}

