/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.config.objects.typology.R01MContentTypeMetaData;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MMetaDataManagerException;
import com.ejie.r01m.services.R01MBaseAPI;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.bzd.R01MMetaDataManagerBzd;

public class R01MMetaDataManagerAPI
extends R01MBaseAPI {
    R01MMetaDataManagerAPI() {
        super("metaDataManager");
    }

    public String[][] loadMetaDataValuesAndDescriptions(String lang, R01MContentTypeMetaData metaDataConfig) throws R01MMetaDataManagerException {
        try {
            R01FLog.to((String)"r01m.metaDataAPI").info("METADATA CLIENT API: Cargando los valores del metaDato " + metaDataConfig.getOid() + " en el lenguage " + lang);
            return ((R01MMetaDataManagerBzd)this.getBzd()).doLoadMetaDataValuesAndDescriptions(lang, metaDataConfig);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MMetaDataManagerException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public String loadMetaDataValueDescription(String lang, R01MContentTypeMetaData metaDataConfig, String metaDataValue) throws R01MMetaDataManagerException {
        try {
            if (metaDataValue == null) {
                throw new R01MMetaDataManagerException("NO se puede cargar la descripcion de un valor del metaDato " + metaDataConfig.getOid() + " si se pasa un valor null");
            }
            R01FLog.to((String)"r01m.metaDataAPI").info("METADATA CLIENT API: Cargando la descripcion del metaDato " + metaDataConfig.getOid() + " con valor " + metaDataValue + " en el lenguaje " + lang);
            return ((R01MMetaDataManagerBzd)this.getBzd()).doLoadMetaDataValueDescription(lang, metaDataConfig, metaDataValue);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MMetaDataManagerException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public String[][] loadMetaDataValuesAndDescriptionsByRelatedMetaData(String lang, R01MContentTypeMetaData metaDataConfig, String metaDataValue, String relatedMetaDataOid, String relatedMetaDataValue) throws R01MMetaDataManagerException {
        try {
            if (relatedMetaDataOid == null || relatedMetaDataValue == null) {
                throw new R01MMetaDataManagerException("NO se pueden cargar los valores de metaDato " + metaDataConfig.getOid() + " filtrados por otro metaDato relacionado si se pasa el oid del metaDato relacionado null o el valor del metaDatoRelacionado null > " + relatedMetaDataOid + ":" + relatedMetaDataValue);
            }
            R01FLog.to((String)"r01m.metaDataAPI").info("METADATA CLIENT API: Cargando los valores del metaDato " + metaDataConfig.getOid() + " en el lenguaje " + lang + " y filtrando por el valor " + relatedMetaDataValue + " del metaDato relaciondao " + relatedMetaDataOid);
            return ((R01MMetaDataManagerBzd)this.getBzd()).doLoadMetaDataValuesAndDescriptionsByRelatedMetaData(lang, metaDataConfig, null, relatedMetaDataOid, relatedMetaDataValue);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MMetaDataManagerException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public String[][] loadMetaDataValuesAndDescriptions(String lang, String clusterOid, String familyOid, String typoOid, String mdOid) throws R01MMetaDataManagerException {
        try {
            R01MContentTypeMetaData metaDataConfig = R01MClientFactory.getTypologyConfigAPI().getContentTypeMetaData(clusterOid, familyOid, typoOid, mdOid);
            return this.loadMetaDataValuesAndDescriptions(lang, metaDataConfig);
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            throw new R01MMetaDataManagerException("NO se ha podido cargar la configuraci\u00f3n del metaDato " + mdOid + " a partir del cluster:familia:tipo=" + clusterOid + ":" + familyOid + ":" + typoOid + " > " + cfgLoadEx.getMessage(), (Exception)((Object)cfgLoadEx));
        }
    }

    public String loadMetaDataValueDescription(String lang, String clusterOid, String familyOid, String typoOid, String mdOid, String metaDataValue) throws R01MMetaDataManagerException {
        try {
            R01MContentTypeMetaData metaDataConfig = R01MClientFactory.getTypologyConfigAPI().getContentTypeMetaData(clusterOid, familyOid, typoOid, mdOid);
            return this.loadMetaDataValueDescription(lang, metaDataConfig, metaDataValue);
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            throw new R01MMetaDataManagerException("NO se ha podido cargar la configuraci\u00f3n del metaDato " + mdOid + " a partir del cluster:familia:tipo=" + clusterOid + ":" + familyOid + ":" + typoOid + " > " + cfgLoadEx.getMessage(), (Exception)((Object)cfgLoadEx));
        }
    }

    public String[][] loadMetaDataValuesAndDescriptionsByRelatedMetaData(String lang, String clusterOid, String familyOid, String typoOid, String mdOid, String metaDataValue, String relatedMetaDataOid, String relatedMetaDataValue) throws R01MMetaDataManagerException {
        try {
            R01MContentTypeMetaData metaDataConfig = R01MClientFactory.getTypologyConfigAPI().getContentTypeMetaData(clusterOid, familyOid, typoOid, mdOid);
            return this.loadMetaDataValuesAndDescriptionsByRelatedMetaData(lang, metaDataConfig, metaDataValue, relatedMetaDataOid, relatedMetaDataValue);
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            throw new R01MMetaDataManagerException("NO se ha podido cargar la configuraci\u00f3n del metaDato " + mdOid + " a partir del cluster:familia:tipo=" + clusterOid + ":" + familyOid + ":" + typoOid + " > " + cfgLoadEx.getMessage(), (Exception)((Object)cfgLoadEx));
        }
    }
}

