/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.config.objects.tags.links.R01MAppTagLinks;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.services.R01MBaseConfigAPI;
import com.ejie.r01m.services.bzd.R01MLinkedTagsConfigLoaderBzd;
import java.util.logging.Level;

public class R01MLinkedTagsConfigAPI
extends R01MBaseConfigAPI {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.configAPI").intValue() != Level.OFF.intValue();

    R01MLinkedTagsConfigAPI() {
        super("linkedTags");
    }

    public R01MAppTagLinks getTagLinks(String codApp) throws R01MConfigLoadException {
        R01MAppTagLinks appTagLinksConfig = null;
        try {
            if (this.getConfigs() != null && this.getConfigs().get("appTagLinks." + codApp) != null) {
                if (DEBUG) {
                    R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La configuraci\u00f3n de tag de vinculaciones para la aplicaci\u00f3n " + codApp + " est\u00e1 en la cache... NO SE CARGA");
                }
                if ((appTagLinksConfig = (R01MAppTagLinks)this.getConfigs().get("appTagLinks." + codApp)) != null) {
                    return appTagLinksConfig;
                }
            } else if (DEBUG) {
                R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La cach\u00e9 se ha reseteado,se vuelve a cargar la configuracion de tags de vinculaciones para la aplicaci\u00f3n " + codApp + "... RECARGA");
            }
            if (DEBUG) {
                R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: No se hab\u00eda cargado la configuraci\u00f3n de tags de vinculaciones para la aplicaci\u00f3n " + codApp + ", se cargan ahora");
            }
            if ((appTagLinksConfig = ((R01MLinkedTagsConfigLoaderBzd)this.getBzd("linkedTags")).loadConfigTagLinks(codApp)) != null) {
                this.cacheObjectConfig("appTagLinks." + codApp, appTagLinksConfig);
            }
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            R01FLog.to((String)"r01m.configAPI").severe("CONFIG CLIENT API: NO se ha podido cargar el tag de la vinculaci\u00f3n " + codApp);
            cfgLoadEx.printStackTrace(System.out);
        }
        return appTagLinksConfig;
    }

    @Override
    public void reset() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (cliente + servidor) de configuraci\u00f3n completa ");
        this.resetClient();
        this.resetServer();
    }

    @Override
    public void resetClient() {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (solo cliente) de configuraci\u00f3n completa.");
    }

    @Override
    public void resetServer() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (servidor) de configuraci\u00f3n completa.");
        ((R01MLinkedTagsConfigLoaderBzd)this.getBzd("linkedTags")).reset();
    }
}

