/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.clone.CloneUtils;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.objects.contentmodel.R01MContentTypologyInfo;
import com.ejie.r01m.objects.contentmodel.R01MLinkedRelation;
import com.ejie.r01m.objects.contentmodel.R01MLinkedRelationsGroup;
import com.ejie.r01m.services.R01MBaseConfigAPI;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.bzd.R01MLinkedRelationsConfigLoaderBzd;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class R01MLinkedRelationsConfigAPI
extends R01MBaseConfigAPI {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.configAPI").intValue() != Level.OFF.intValue();

    R01MLinkedRelationsConfigAPI() {
        super("linkedRelationsConfig");
    }

    public R01MLinkedRelationsGroup getLinkedRelationsConfig() throws R01MConfigLoadException {
        R01MLinkedRelationsGroup linkedRelationsConfig;
        Map<Object, Object> linkedRelationsCache;
        Map<Object, Object> map = linkedRelationsCache = this.getAllObjectConfig() != null ? this.getAllObjectConfig().get("linkedRelationsConfig") : null;
        if (linkedRelationsCache != null) {
            if (DEBUG) {
                R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La configuraci\u00f3n de relaciones est\u00e1 en la cache... NO SE CARGA");
            }
            if ((linkedRelationsConfig = (R01MLinkedRelationsGroup)linkedRelationsCache.get("linkedRelationsConfig")) != null) {
                return linkedRelationsConfig;
            }
        } else if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La cach\u00e9 se ha reseteado,se vuelve a cargar la configuracion de todas las relaciones... RECARGA");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: No se hab\u00eda cargado la configuraci\u00f3n de relaciones, se cargan ahora");
        }
        if ((linkedRelationsConfig = ((R01MLinkedRelationsConfigLoaderBzd)this.getBzd("linkedRelationsConfig")).loadLinkedRelationsConfig()) != null) {
            this.cacheObjectConfig("linkedRelationsConfig", linkedRelationsConfig);
        }
        return linkedRelationsConfig;
    }

    public R01MLinkedRelationsGroup getLinkedRelationsConfigByTypo(R01MContentTypologyInfo typo) throws R01MConfigLoadException {
        R01MLinkedRelationsGroup allLinkedRelations = (R01MLinkedRelationsGroup)CloneUtils.cloneByReflection((Object)this.getLinkedRelationsConfig());
        List<String> relationsIds = R01MClientFactory.getTypologyConfigAPI().getFamilyConfig(typo.getFamilyOid()).getAllowedRelations();
        if (relationsIds != null && !relationsIds.isEmpty()) {
            Map newLinkedRelations = (Map)CloneUtils.cloneByReflection(allLinkedRelations.getRelations());
            for (String currRelationId : allLinkedRelations.getRelations().keySet()) {
                if (relationsIds.contains(currRelationId)) continue;
                newLinkedRelations.remove(currRelationId);
            }
            allLinkedRelations.setRelations(newLinkedRelations);
        } else {
            allLinkedRelations.setRelations(new HashMap<String, R01MLinkedRelation>());
        }
        return allLinkedRelations;
    }

    public void reloadAllLinkedRelationsConfig() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Recarga de la configuraci\u00f3n de relaciones.");
        ((R01MLinkedRelationsConfigLoaderBzd)this.getBzd("linkedRelationsConfig")).reloadLinkedRelationsConfig();
        this.resetCacheObjectConfig();
        this.resetClient();
    }

    @Override
    public final void reset() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (cliente + servidor) de configuraci\u00f3n completa de todas las relaciones.");
        this.resetClient();
        this.resetServer();
    }

    @Override
    public void resetClient() {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (solo cliente) de configuraci\u00f3n completa de todas las relaciones.");
        super.resetCacheObjectConfig();
        this.resetCacheObjectConfig();
    }

    @Override
    public final void resetServer() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (servidor) de configuraci\u00f3n completa de todas las relaciones.");
        ((R01MLinkedRelationsConfigLoaderBzd)this.getBzd("linkedRelationsConfig")).reset();
        this.resetCacheObjectConfig();
    }
}

