/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.objects.entities.R01MEntity;
import com.ejie.r01m.objects.entities.R01MEntityGroup;
import com.ejie.r01m.objects.entities.R01MEntityLabel;
import com.ejie.r01m.services.R01MBaseConfigAPI;
import com.ejie.r01m.services.bzd.R01MEntitiesConfigLoaderBzd;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class R01MEntitiesConfigAPI
extends R01MBaseConfigAPI {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.configAPI").intValue() != Level.OFF.intValue();
    private static Map<String, R01MEntity> _entitiesCache = null;

    R01MEntitiesConfigAPI() {
        super("entitiesConfig");
    }

    public Map<String, R01MEntityGroup> getAllGroupConfig() throws R01MConfigLoadException {
        Map<Object, Object> allGroupConfig;
        Map<Object, Object> map = allGroupConfig = this.getAllObjectConfig() != null ? this.getAllObjectConfig().get("entitiesConfig") : null;
        if (allGroupConfig != null) {
            if (DEBUG) {
                R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La configuraci\u00f3n de todos los grupos est\u00e1 en la cache... NO SE CARGA");
            }
            return allGroupConfig;
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La cach\u00e9 se ha reseteado,se vuelve a cargar la configuracion de todos los grupos... RECARGA");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: No se hab\u00eda cargado la configuraci\u00f3n de todos los grupos, se cargan ahora");
        }
        if ((allGroupConfig = ((R01MEntitiesConfigLoaderBzd)this.getBzd("entitiesConfig")).loadAllGroupConfig()) != null) {
            for (Map.Entry<Object, Object> me : allGroupConfig.entrySet()) {
                R01MEntityGroup group = (R01MEntityGroup)me.getValue();
                this.cacheObjectConfig(group.getOid(), group);
            }
        }
        return allGroupConfig;
    }

    public R01MEntityGroup getGroupConfig(String groupOid) throws R01MConfigLoadException {
        R01MEntityGroup groupConfig = (R01MEntityGroup)this.getObjectConfig(groupOid);
        if (this.getConfigs() == null) {
            this.getAllGroupConfig();
            _entitiesCache = null;
            groupConfig = (R01MEntityGroup)this.getObjectConfig(groupOid);
        }
        if (groupConfig == null) {
            if (DEBUG) {
                R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: No se hab\u00eda cargado la configuraci\u00f3n del grupo " + groupOid + "... se carga ahora");
            }
            if ((groupConfig = ((R01MEntitiesConfigLoaderBzd)this.getBzd("entitiesConfig")).loadGroupConfig(groupOid)) != null) {
                this.cacheObjectConfig(groupOid, groupConfig);
                return groupConfig;
            }
            throw new R01MConfigLoadException("No se han podido cargar los datos de configuraci\u00f3n del grupo " + groupOid);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: La configuraci\u00f3n del grupo " + groupOid + " esta en la cache... NO SE CARGA");
        }
        return groupConfig;
    }

    public R01MEntity getEntityConfig(String groupOid, String entityOid) throws R01MConfigLoadException {
        R01MEntityGroup groupConfig = this.getGroupConfig(groupOid);
        R01MEntity entityConfig = groupConfig.getEntities().get(entityOid);
        if (entityConfig != null) {
            return entityConfig;
        }
        throw new R01MConfigLoadException("No se han podido cargar los datos de configuraci\u00f3n de la entidad " + entityOid + " del grupo " + groupOid);
    }

    public R01MEntity getEntityConfigFromCatalogOid(String labelOid) throws R01MConfigLoadException {
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Cargando la ENTIDAD CON LA CATALOGACION " + labelOid);
        }
        if (this.getConfigs() == null) {
            _entitiesCache = null;
        }
        if (_entitiesCache == null) {
            _entitiesCache = new HashMap<String, R01MEntity>();
            Map<String, R01MEntityGroup> groups = this.getAllGroupConfig();
            if (groups != null && !groups.isEmpty()) {
                for (Map.Entry<String, R01MEntityGroup> meGroup : groups.entrySet()) {
                    R01MEntityGroup group = meGroup.getValue();
                    Map<String, R01MEntity> entities = group.getEntities();
                    if (entities == null || entities.isEmpty()) continue;
                    for (Map.Entry<String, R01MEntity> meEntity : entities.entrySet()) {
                        R01MEntity entity = meEntity.getValue();
                        List<R01MEntityLabel> labels = entity.getEntityCatalogation().getEntityLabels();
                        if (labels == null || labels.isEmpty()) continue;
                        for (R01MEntityLabel label : labels) {
                            _entitiesCache.put(label.getLabelOid(), entity);
                        }
                    }
                }
            }
        }
        if (_entitiesCache.containsKey(labelOid)) {
            return _entitiesCache.get(labelOid);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.configAPI").info("No se ha encontrado la entidad con catalogOid: " + labelOid);
        }
        return null;
    }

    public void reloadGroupConfig(String groupOid) throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Recarga de la configuraci\u00f3n de " + groupOid);
        ((R01MEntitiesConfigLoaderBzd)this.getBzd("entitiesConfig")).reloadGroupConfig(groupOid);
        _entitiesCache = null;
        this.resetClient();
    }

    public void reloadEntityConfig(String groupOid, String entityOid) throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Recarga de la configuraci\u00f3n de " + groupOid + ":" + entityOid);
        ((R01MEntitiesConfigLoaderBzd)this.getBzd("entitiesConfig")).reloadEntityConfig(groupOid, entityOid);
        _entitiesCache = null;
        this.resetClient();
    }

    @Override
    public void reset() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (cliente + servidor) de configuraci\u00f3n completa de todos los grupos de entidades.");
        this.resetClient();
        this.resetServer();
    }

    @Override
    public void resetClient() {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (solo cliente) de configuraci\u00f3n completa de todos los grupos de entidades.");
        super.resetCacheObjectConfig();
        _entitiesCache = null;
    }

    @Override
    public void resetServer() throws R01MConfigLoadException {
        R01FLog.to((String)"r01m.configAPI").info("CONFIG CLIENT API: Reset (servidor) de configuraci\u00f3n completa de todos los grupos de entidades.");
        ((R01MEntitiesConfigLoaderBzd)this.getBzd("entitiesConfig")).reset();
        _entitiesCache = null;
    }
}

