/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelsPacket;
import com.ejie.r01m.config.objects.container.R01MResourcesContainer;
import com.ejie.r01m.config.objects.container.R01MResourcesContainerConfig;
import com.ejie.r01m.config.objects.container.R01MResourcesContainerManagementConfig;
import com.ejie.r01m.config.objects.publisher.R01MLogicalPublicationInfo;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MRoleRights;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MDeleteContentException;
import com.ejie.r01m.exceptions.R01MDeleteDataFileException;
import com.ejie.r01m.exceptions.R01MDeleteDocumentException;
import com.ejie.r01m.exceptions.R01MDirtyContentModelException;
import com.ejie.r01m.exceptions.R01MDuplicateContentException;
import com.ejie.r01m.exceptions.R01MDuplicateDataFileException;
import com.ejie.r01m.exceptions.R01MDuplicateDocumentException;
import com.ejie.r01m.exceptions.R01MPublisherException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MBasePublicationTarget;
import com.ejie.r01m.objects.R01MURLAlias;
import com.ejie.r01m.objects.businesserrors.R01MBusinessErrors;
import com.ejie.r01m.objects.cataloguing.R01MStructureCatalog;
import com.ejie.r01m.objects.cataloguing.picks.R01MGeoPicks;
import com.ejie.r01m.objects.contentmodel.R01MBaseResumeModelObject;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MContentHistoryFilter;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.contentmodel.R01MContentPublishResume;
import com.ejie.r01m.objects.contentmodel.R01MContentTypologyInfo;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationTarget;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublishResume;
import com.ejie.r01m.objects.contentmodel.R01MDocumentRevisionState;
import com.ejie.r01m.objects.contentmodel.R01MLinkedRelationsGroup;
import com.ejie.r01m.objects.notice.R01MNotice;
import com.ejie.r01m.objects.publisher.R01MPublishActionObject;
import com.ejie.r01m.objects.resources.R01MGallery;
import com.ejie.r01m.objects.resources.R01MGalleryResourcesGroup;
import com.ejie.r01m.objects.resources.R01MLinkedDocumentToDocumentResume;
import com.ejie.r01m.objects.resources.R01MLinkedResource;
import com.ejie.r01m.objects.resources.R01MLinkedResourcesGroup;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableContent;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableDocument;
import com.ejie.r01m.services.R01MBaseAPI;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.bzd.R01MContentModelManagerBzd;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.contentmanager.R01MContentManagerStorageIterator;
import com.ejie.r01m.utils.contentmanager.R01MContentModelObjectsValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class R01MContentModelAPI
extends R01MBaseAPI {
    private static Map _contentLocationCache = Collections.synchronizedMap(new WeakHashMap(100));
    private R01MUserContext _userCtx = null;
    private static final String LOG_TYPE_ID = "r01m.contentAPI";
    private static final String LOG_SEP_INI = "\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n";
    private static final String LOG_SEP_END = "\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\n";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.contentAPI").intValue() != Level.OFF.intValue();

    R01MContentModelAPI() {
        super("contentModel");
    }

    R01MContentModelAPI(R01MUserContext userCtx) {
        this();
        this._userCtx = userCtx;
    }

    public R01MRoleRights getRoleRightsInContent(String contentOid) throws R01MSecurityException, R01MContentModelException {
        try {
            return ((R01MContentModelManagerBzd)this.getBzd()).doGetRoleRightsInContent(this._userCtx, contentOid);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public String getContentXML(R01MContent content) throws XOMarshallerException {
        return "<?xml version='1.0' encoding='ISO-8859-1'?>" + XOManager.getXML((String)R01MConstants.CONTENTMODEL_MAPFILE, (Object)content);
    }

    public R01MContent getContentFromXML(String xml) throws XOMarshallerException {
        return (R01MContent)XOManager.getObject((String)R01MConstants.CONTENTMODEL_MAPFILE, (String)xml);
    }

    public R01MIndexableContent getIndexableContent(String contentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Cargando la versi\u00f3n indexable del contenido " + contentOid;
        R01MIndexableContent idxCont = null;
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) != null && roleRights.canSee()) {
                idxCont = ((R01MContentModelManagerBzd)this.getBzd()).doGetIndexableContent(this._userCtx, contentOid);
                if (idxCont != null && idxCont.getDocuments() != null && !idxCont.getDocuments().isEmpty()) {
                    Iterator<Map.Entry<String, R01MIndexableDocument>> itDocuments = idxCont.getDocuments().entrySet().iterator();
                    while (itDocuments.hasNext()) {
                        R01MIndexableDocument idxDoc = itDocuments.next().getValue();
                        Map<String, Map<String, String>> docFriendlyUrlByLanguage = idxDoc.getFriendlyUrlsByLanguage();
                        HashMap<String, Map<String, String>> newDocFriendlyUrlByLanguage = new HashMap<String, Map<String, String>>();
                        Pattern elementPattern = Pattern.compile("([^\\ \\{\\}=,]+)=([^\\{\\}=,]+)");
                        if (docFriendlyUrlByLanguage != null) {
                            for (Map.Entry<String, Map<String, String>> entry : docFriendlyUrlByLanguage.entrySet()) {
                                String key = entry.getKey();
                                if (entry.getValue() instanceof String) {
                                    Matcher m = elementPattern.matcher((String)((Object)entry.getValue()));
                                    HashMap<String, String> element = new HashMap<String, String>();
                                    while (m.find()) {
                                        element.put(m.group(1), m.group(2));
                                    }
                                    newDocFriendlyUrlByLanguage.put(key, element);
                                    continue;
                                }
                                if (!(entry.getValue() instanceof Map)) continue;
                                newDocFriendlyUrlByLanguage.put(key, entry.getValue());
                            }
                        }
                        idxDoc.setFriendlyUrlsByLanguage(newDocFriendlyUrlByLanguage);
                        Map<String, Map<String, String>> docUrlByLanguage = idxDoc.getUrlsByLanguage();
                        HashMap<String, Map<String, String>> newDocUrlByLanguage = new HashMap<String, Map<String, String>>();
                        if (docUrlByLanguage != null) {
                            for (Map.Entry<String, Map<String, String>> entry : docUrlByLanguage.entrySet()) {
                                String key = entry.getKey();
                                if (entry.getValue() instanceof String) {
                                    Matcher m = elementPattern.matcher((String)((Object)entry.getValue()));
                                    HashMap<String, String> element = new HashMap<String, String>();
                                    while (m.find()) {
                                        element.put(m.group(1), m.group(2));
                                    }
                                    newDocUrlByLanguage.put(key, element);
                                    continue;
                                }
                                if (!(entry.getValue() instanceof Map)) continue;
                                newDocUrlByLanguage.put(key, entry.getValue());
                            }
                        }
                        idxDoc.setUrlsByLanguage(newDocUrlByLanguage);
                    }
                }
            } else {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede ver el contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return idxCont;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveContent(R01MContent content) throws R01MSecurityException, R01MDuplicateContentException, R01MDuplicateDocumentException, R01MDuplicateDataFileException, R01MDeleteContentException, R01MDeleteDocumentException, R01MDeleteDataFileException, R01MContentModelObjectsValidatorException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Salvando el contenido " + content.getOid();
        try {
            block9: {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
                }
                if (!R01MAuthManager.getRoleRights(content.getStoreLocation(), this._userCtx).canModify()) throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede guardar el contenido " + content.getOid());
                R01MContentModelObjectsValidator.validateContent(this._userCtx, content);
                try {
                    Map<String, Long> lastUpdateTS = ((R01MContentModelManagerBzd)this.getBzd()).doSaveContent(this._userCtx, content);
                    if (lastUpdateTS == null) throw new R01MContentModelException("No se ha podido guardar el contenido la fecha de actualizaci\u00f3n es NULL.");
                    if (lastUpdateTS.containsKey(content.getOid())) {
                        content.setLastUpdateTS(lastUpdateTS.get(content.getOid()));
                    }
                    if (content.getDocuments() == null || content.getDocuments().isEmpty()) break block9;
                    for (String documentOid : content.getDocuments().keySet()) {
                        if (!lastUpdateTS.containsKey(documentOid)) continue;
                        content.getDocuments().get(documentOid).setLastUpdateTS(lastUpdateTS.get(documentOid));
                    }
                }
                catch (R01MDirtyContentModelException cmExc) {
                    R01MContent contentInModel = ((R01MContentModelManagerBzd)this.getBzd()).doLoadContent(this._userCtx, content.getOid());
                    content.setLastUpdateTS(contentInModel.getLastUpdateTS());
                    if (content.getDocuments() == null || content.getDocuments().isEmpty()) break block9;
                    for (String documentOid : content.getDocuments().keySet()) {
                        content.getDocuments().get(documentOid).setLastUpdateTS(contentInModel.getDocument(documentOid).getLastUpdateTS());
                        content.getDocuments().get(documentOid).setPublicationInfo(contentInModel.getDocument(documentOid).getPublicationInfo());
                    }
                }
            }
            if (!DEBUG) return;
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            return;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void createDocument(R01MContent content, R01MDocument document) throws R01MSecurityException, R01MContentModelException, R01MDeleteDocumentException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Creando el documento " + document.getOid() + " en el contenido " + content.getInternalName() + "(" + content.getOid() + ").";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
        }
        content.getDocuments().put(document.getOid(), document);
        try {
            this.saveContent(content);
        }
        catch (Exception delExc) {
            throw new R01MDeleteDocumentException("Error al crear el documento de identificador '" + document.getOid() + "'.", delExc);
        }
    }

    public void deleteDocument(R01MContent content, String documentOid) throws R01MSecurityException, R01MContentModelException, R01MDeleteDocumentException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Borrando el documento " + documentOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
        }
        content.getDocuments().remove(documentOid);
        try {
            this.saveContent(content);
        }
        catch (Exception delExc) {
            throw new R01MDeleteDocumentException("Error al borrar el documento de identificador '" + documentOid + "'.", delExc);
        }
    }

    public void saveDocument(R01MContent content, R01MDocument document) throws R01MSecurityException, R01MDuplicateContentException, R01MDuplicateDocumentException, R01MDuplicateDataFileException, R01MDeleteContentException, R01MDeleteDocumentException, R01MDeleteDataFileException, R01MContentModelObjectsValidatorException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Salvando el documento " + document.getOid();
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            content.getDocuments().put(document.getOid(), document);
            if (R01MAuthManager.getRoleRights(content.getStoreLocation(), this._userCtx).canModify()) {
                R01MContentModelObjectsValidator.validateDocument(this._userCtx, content, document.getOid());
                try {
                    Long lastUpdateTS;
                    boolean existsDocument = ((R01MContentModelManagerBzd)this.getBzd()).doCheckDocumentExistence(document.getOid());
                    if (!existsDocument) {
                        Map<String, Long> allUpdateTS = ((R01MContentModelManagerBzd)this.getBzd()).doSaveContent(this._userCtx, content);
                        lastUpdateTS = allUpdateTS.get(document.getOid());
                        content.setLastUpdateTS(allUpdateTS.get(content.getOid()));
                    } else {
                        lastUpdateTS = ((R01MContentModelManagerBzd)this.getBzd()).doSaveDocument(this._userCtx, content.getOid(), content.getDocument(document.getOid()));
                    }
                    if (lastUpdateTS == null) {
                        throw new R01MContentModelException("No se ha podido guardar el documento la fecha de actualizaci\u00f3n es NULL.");
                    }
                    document.setLastUpdateTS(lastUpdateTS);
                }
                catch (R01MDirtyContentModelException cmExc) {
                    R01MDocument documentInModel = ((R01MContentModelManagerBzd)this.getBzd()).doLoadDocument(this._userCtx, document.getOid());
                    document.setLastUpdateTS(documentInModel.getLastUpdateTS());
                    document.setPublicationInfo(documentInModel.getPublicationInfo());
                }
            } else {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede guardar el documento " + document.getOid());
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void generateRenders(R01MContent content, R01MDocument document, String renderGroup, String renderId) throws R01MContentModelException {
        String opDesc = "Ejecutando los renderizadores ";
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            ((R01MContentModelManagerBzd)this.getBzd()).doGenerateRenders(this._userCtx, content, document, renderGroup, renderId);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void changeContentCluster(String contentOid, String clusterOid) throws R01MSecurityException, R01MContentModelObjectsValidatorException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Cambiando la tipolog\u00eda (Cluster) del contenido de oid " + contentOid + " al cluster de oid " + clusterOid;
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) != null && roleRights.canModify()) {
                R01MContentTypologyInfo typology = this.loadContentTypology(contentOid);
                R01MContentLocation location = this.loadContentLocation(contentOid);
                if (!R01MContentModelObjectsValidator.validateChangeCluster(location, typology, clusterOid)) {
                    throw new R01MContentModelObjectsValidatorException("El cluster del contenido de oid " + contentOid + " no pude ser cambiado de " + typology.getClusterOid() + " a " + clusterOid + ".");
                }
            } else {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede cambiar el cluster del contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            ((R01MContentModelManagerBzd)this.getBzd()).doChangeContentCluster(this._userCtx, contentOid, clusterOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void changeContentLocation(String contentOid, R01MContentLocation locTarget) throws R01MSecurityException, R01MContentModelObjectsValidatorException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Moviendo el contenido de oid " + contentOid + " a la localizaci\u00f3n " + locTarget.getServerOid() + "/" + locTarget.getDataRepositoryOid() + "/" + locTarget.getAreaOid() + "/" + locTarget.getWorkAreaOid();
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) != null && roleRights.canMove()) {
                if (!R01MContentModelObjectsValidator.validateChangeLocation(this._userCtx, contentOid, locTarget)) {
                    String msg = "No se puede mover el contenido a la localizaci\u00f3n " + locTarget.getServerOid() + "/" + locTarget.getDataRepositoryOid() + "/" + locTarget.getAreaOid() + "/" + locTarget.getWorkAreaOid() + ".\r\n" + "Causas:\r\n" + "   - No se puede mover un contenido de un server a otro.\r\n" + "   - No se puede mover un contenido de un repositorio a otro.\r\n" + "   - No se puede mover un contenido dentro de la misma workarea.";
                    throw new R01MContentModelObjectsValidatorException(msg);
                }
            } else {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede cambiar el mover el contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            ((R01MContentModelManagerBzd)this.getBzd()).doChangeContentLocation(this._userCtx, contentOid, locTarget);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public String copyContent(String contentOid, R01MContentLocation locTarget, String newContentName) throws R01MSecurityException, R01MContentModelObjectsValidatorException, R01MDuplicateContentException, R01MContentModelException {
        String newContentOid = "";
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Copiando el contenido de oid " + contentOid + " a la localizaci\u00f3n " + locTarget.getServerOid() + "/" + locTarget.getDataRepositoryOid() + "/" + locTarget.getAreaOid() + "/" + locTarget.getWorkAreaOid() + " con el nuevo nombre " + newContentName;
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) != null && roleRights.canMove()) {
                if (!R01MContentModelObjectsValidator.validateCopyToLocation(contentOid, locTarget, newContentName, this._userCtx)) {
                    String msg = "No se puede copiar el contenido a la localizaci\u00f3n " + locTarget.getServerOid() + "/" + locTarget.getDataRepositoryOid() + "/" + locTarget.getAreaOid() + "/" + locTarget.getWorkAreaOid() + " con el nuevo nombre " + newContentName + ".\r\n" + "Causas:\r\n" + "   - No se puede copiar un contenido de un server a otro.\r\n" + "   - No se puede copiar un contenido de un repositorio a otro.";
                    throw new R01MContentModelObjectsValidatorException(msg);
                }
            } else {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede copiar el contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            newContentOid = ((R01MContentModelManagerBzd)this.getBzd()).doCopyContent(this._userCtx, contentOid, locTarget, newContentName);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return newContentOid;
    }

    public void moveContentToAnotherArea(String contentOid, String newAreaOid, String newWorkAreaOid, boolean publishDocuments, int actionType, String contentNameTarget, String newDataRepositoryOid, String newServerOid) throws R01MSecurityException, R01MContentModelException, R01MContentModelObjectsValidatorException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Moviendo el contenido de oid " + contentOid + " al area " + newAreaOid + " y workarea " + newWorkAreaOid;
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) != null && roleRights.canMove()) {
                R01MContentLocation locTarget = new R01MContentLocation(newServerOid, newDataRepositoryOid, newAreaOid, newWorkAreaOid);
                if (!R01MContentModelObjectsValidator.validateChangeLocation(this._userCtx, contentOid, locTarget)) {
                    String msg = "No se puede mover el contenido a la localizaci\u00f3n " + locTarget.getServerOid() + "/" + locTarget.getDataRepositoryOid() + "/" + locTarget.getAreaOid() + "/" + locTarget.getWorkAreaOid() + ".\r\n" + "Causas:\r\n" + "   - No se puede mover un contenido de un server a otro.\r\n" + "   - No se puede mover un contenido de un repositorio a otro.\r\n" + "   - No se puede mover un contenido dentro de la misma workarea.";
                    throw new R01MContentModelObjectsValidatorException(msg);
                }
            } else {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede mover el contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            ((R01MContentModelManagerBzd)this.getBzd()).doMoveContentToAnotherArea(this._userCtx, contentOid, newAreaOid, newWorkAreaOid, publishDocuments, actionType, contentNameTarget, newDataRepositoryOid, newServerOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void deleteContent(String contentOid) throws R01MSecurityException, R01MDeleteContentException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Borrar el contenido " + contentOid;
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) == null || !roleRights.canDelete()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede borrar el contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            ((R01MContentModelManagerBzd)this.getBzd()).doDeleteContent(this._userCtx, contentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void forceDeleteContent(String contentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Forzar el borrado del contenido " + contentOid;
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) == null || !roleRights.canDelete()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede borrar el contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            ((R01MContentModelManagerBzd)this.getBzd()).doForceDeleteContent(this._userCtx, contentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void forceDeleteDocuments(String contentOid, List documentOids) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Forzar el borrado de documentos del contenido " + contentOid;
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) == null || !roleRights.canDelete()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede borrar los documentos del contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            ((R01MContentModelManagerBzd)this.getBzd()).doForceDeleteDocuments(this._userCtx, contentOid, documentOids, false, false, false);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void deleteDocuments(List documentOids, boolean deleteLinked, boolean forceUnpublish, boolean deleteEmptyContents) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Borrado de documentos";
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            HashMap documentsContentOids = new HashMap();
            if (documentOids != null && !documentOids.isEmpty()) {
                for (String documentOid : documentOids) {
                    try {
                        String contentOid = this.getDocumentParentContent(documentOid);
                        if (contentOid == null) continue;
                        if (!documentsContentOids.containsKey(contentOid)) {
                            documentsContentOids.put(contentOid, new ArrayList());
                        }
                        ((List)documentsContentOids.get(contentOid)).add(documentOid);
                    }
                    catch (Exception ex) {
                        R01FLog.to((String)LOG_TYPE_ID).info("Error al obtener el contenido del documneto" + ex.getMessage());
                    }
                }
                this.deleteDocuments(documentsContentOids, deleteLinked, forceUnpublish, forceUnpublish, deleteEmptyContents);
            }
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (R01MContentModelException cmEx) {
            throw new R01MContentModelException("Error en el borrado de documentos", (Exception)((Object)cmEx));
        }
    }

    public void deleteDocuments(Map documentsContentsOids, boolean deleteLinked, boolean forceUnpublish, boolean forceLinkedUnpublish, boolean deleteEmptyContents) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Forzar el borrado de documentos del contenido ";
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            HashMap<String, List<String>> documentsContentsOidsToDelete = new HashMap<String, List<String>>();
            if (documentsContentsOids != null && !documentsContentsOids.isEmpty()) {
                for (String contentOid : documentsContentsOids.keySet()) {
                    R01MRoleRights roleRights = this.getRoleRightsInContent(contentOid);
                    if (roleRights == null || !roleRights.canDelete()) continue;
                    R01FLog.to((String)LOG_TYPE_ID).info("El usuario " + this._userCtx.getUserName() + " NO puede borrar los documentos del contenido " + contentOid);
                    documentsContentsOidsToDelete.put(contentOid, (List<String>)documentsContentsOids.get(contentOid));
                }
            }
            ((R01MContentModelManagerBzd)this.getBzd()).doDeleteDocuments(this._userCtx, documentsContentsOidsToDelete, deleteLinked, forceUnpublish, forceLinkedUnpublish, deleteEmptyContents);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public boolean checkContentExistence(String contentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Comprobar existencia del contenido " + contentOid;
        boolean existsContent = false;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            existsContent = ((R01MContentModelManagerBzd)this.getBzd()).doCheckContentExistence(contentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return existsContent;
    }

    public boolean checkDocumentExistence(String documentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Comprobar existencia del documento " + documentOid;
        boolean existsDocument = false;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            existsDocument = ((R01MContentModelManagerBzd)this.getBzd()).doCheckDocumentExistence(documentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return existsDocument;
    }

    public boolean checkDataFileExistence(String datafileOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Comprobar existencia del archivo de identificador '" + datafileOid + "'.";
        boolean existsDatafile = false;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            existsDatafile = ((R01MContentModelManagerBzd)this.getBzd()).doCheckContentExistence(datafileOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return existsDatafile;
    }

    public R01MContent loadContent(String contentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Carga del contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            R01MContent content = null;
            R01MRoleRights roleRights = this.getRoleRightsInContent(contentOid);
            if (roleRights == null || !roleRights.canSee()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede leer el contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            content = ((R01MContentModelManagerBzd)this.getBzd()).doLoadContent(this._userCtx, contentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return content;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MDocument loadDocument(String documentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Carga del documento " + documentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            R01MDocument document = null;
            R01MRoleRights roleRights = this.getRoleRightsInContent(((R01MContentModelManagerBzd)this.getBzd()).doGetDocumentParentContent(documentOid));
            if (roleRights == null || !roleRights.canSee()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede leer el contenido del documento " + documentOid);
                }
                throw new R01MContentModelException("El documento de identificador '" + documentOid + "' no existe.");
            }
            document = ((R01MContentModelManagerBzd)this.getBzd()).doLoadDocument(this._userCtx, documentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return document;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MContent loadContentLazy(String contentOid) throws R01MSecurityException, R01MContentModelException {
        return this.loadContent(contentOid);
    }

    public List<R01MStructureCatalog> getDefaultLabels(R01MContentLocation loc, R01MContentTypologyInfo typo) throws R01MContentModelException {
        if (loc == null && typo == null) {
            return null;
        }
        String opDesc = "Obtener las etiquetas por defecto para el almacenamiento: " + (loc != null ? loc.composeMemoCode() : "[null]") + " y la tipolog\u00eda " + (typo != null ? typo.composeMemoCode() : "[null]");
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            List defaultLabels = ((R01MContentModelManagerBzd)this.getBzd()).doGetDefaultLabels(loc, typo);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return defaultLabels;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MContentLocation loadContentLocation(String contentOid) throws R01MContentModelException {
        R01MContentLocation outLocation;
        block7: {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("...obtener la localizacion del contenido: " + contentOid);
            }
            outLocation = null;
            try {
                R01MRoleRights roleRights = this.getRoleRightsInContent(contentOid);
                if (roleRights != null && roleRights.canSee()) {
                    outLocation = (R01MContentLocation)_contentLocationCache.get(contentOid);
                    if (outLocation != null) break block7;
                    try {
                        outLocation = this._loadContentLocation(contentOid);
                    }
                    catch (R01MSecurityException secEx) {
                        // empty catch block
                    }
                    _contentLocationCache.put(contentOid, outLocation);
                    break block7;
                }
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede leer el contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            catch (R01MSecurityException secExc) {
                throw new R01MContentModelException("El usuario " + this._userCtx.getUserName() + " NO puede leer el contenido " + contentOid, (Exception)((Object)secExc));
            }
        }
        return outLocation;
    }

    private R01MContentLocation _loadContentLocation(String contentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Carga de la informaci\u00f3n de localizaci\u00f3n en el almacenamiento del contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            R01MContentLocation loc = null;
            loc = ((R01MContentModelManagerBzd)this.getBzd()).doLoadContentLocation(this._userCtx, contentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return loc;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MContentTypologyInfo loadContentTypology(String contentOid) throws R01MSecurityException, R01MContentModelException {
        return this.loadContentTypology(contentOid, 0);
    }

    public R01MContentTypologyInfo loadContentTypology(String objectOid, int objectType) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Carga de la informaci\u00f3n de tipolog\u00eda del objeto " + objectOid + " de tipo " + objectType;
        try {
            String contentOid;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            switch (objectType) {
                case 0: {
                    contentOid = objectOid;
                    break;
                }
                case 1: {
                    contentOid = ((R01MContentModelManagerBzd)this.getBzd()).doGetDocumentParentContent(objectOid);
                    break;
                }
                case 2: {
                    contentOid = ((R01MContentModelManagerBzd)this.getBzd()).doGetDocumentParentContent(((R01MContentModelManagerBzd)this.getBzd()).doGetDataFileParentDocument(objectOid));
                    break;
                }
                default: {
                    throw new R01MContentModelException("No se ha podido obtener el identificador del contenido al que pertenece el objeto de identificador '" + objectOid + "'");
                }
            }
            R01MRoleRights roleRights = this.getRoleRightsInContent(contentOid);
            if (roleRights == null || !roleRights.canSee()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede leer el contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            R01MContentTypologyInfo typo = ((R01MContentModelManagerBzd)this.getBzd()).doLoadContentTypology(this._userCtx, objectOid, objectType);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return typo;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public List loadContentStructureLabels(String contentOid) throws R01MSecurityException, R01MContentModelException {
        return this.loadContentStructureLabels(contentOid, null);
    }

    public List loadContentStructureLabels(String contentOid, String structureOid) throws R01MSecurityException, R01MContentModelException {
        return this.loadContentStructureLabels(contentOid, structureOid, null);
    }

    public List loadContentStructureLabels(String contentOid, String structureOid, String role) throws R01MSecurityException, R01MContentModelException {
        return this.loadContentStructureLabels(contentOid, structureOid, role, true);
    }

    public List<R01MStructureCatalog> loadContentStructureLabels(String contentOid, String structureOid, String role, boolean strictRole) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Carga de las etiquetas de catalogacion en el eje " + structureOid + " del contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            List<R01MStructureCatalog> outStructureLabels = null;
            R01MRoleRights roleRights = this.getRoleRightsInContent(contentOid);
            if (roleRights == null || !roleRights.canSee()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede leer el contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            outStructureLabels = ((R01MContentModelManagerBzd)this.getBzd()).doLoadContentStructureLabels(this._userCtx, contentOid, structureOid, role, strictRole);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return outStructureLabels;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MGeoPicks loadContentGeoLabels(String contentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Carga de las etiquetas de catalogacion geogr\u00e1fica del contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            R01MGeoPicks outGeoLabels = null;
            R01MRoleRights roleRights = this.getRoleRightsInContent(contentOid);
            if (roleRights == null || !roleRights.canSee()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede leer el contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            outGeoLabels = ((R01MContentModelManagerBzd)this.getBzd()).doLoadContentGeoLabels(this._userCtx, contentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return outGeoLabels;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public boolean checkContentCatalogs(R01MContent content) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            return ((R01MContentModelManagerBzd)this.getBzd()).doCheckContentCatalogs(this._userCtx, content);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public List loadContentHistory(String contentOid, R01MContentHistoryFilter filter) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        StringBuffer opDesc = new StringBuffer(61);
        opDesc.append("Obtener el historico del contenido ");
        opDesc.append(contentOid);
        opDesc.append(" utilizando el filtro:\r\n");
        if (filter == null) {
            opDesc.append("(sin filtro)");
        } else {
            opDesc.append(filter.composeDebugInfo());
        }
        try {
            R01MRoleRights roleRights;
            List recordHistory = null;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) == null || !roleRights.canSee()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede ver el historial del contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            recordHistory = ((R01MContentModelManagerBzd)this.getBzd()).doLoadContentHistory(this._userCtx, contentOid, filter);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end): " + opDesc + LOG_SEP_END);
            }
            return recordHistory;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public boolean isDocumentPublished(String target, String documentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Validaci\u00f3n de la publicaci\u00f3n del documento " + documentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            boolean isPublished = ((R01MContentModelManagerBzd)this.getBzd()).isDocumentPublished(this._userCtx, target, documentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return isPublished;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        catch (Exception ex) {
            throw new R01MContentModelException("Error de aplicaci\u00f3n", ex);
        }
    }

    public List getDocumentRepositoriesPublished(String documentOid) throws R01MSecurityException, R01MConfigLoadException, R01MContentModelException {
        ArrayList<String> publishedRepositories = new ArrayList<String>();
        Map<String, R01MLogicalPublicationInfo> logicalPublicationConfigs = R01MClientFactory.getPublisherConfigAPI().getLogicalPublicationsConfigs();
        ArrayList<String> allRepositories = new ArrayList<String>();
        if (logicalPublicationConfigs != null && !logicalPublicationConfigs.isEmpty()) {
            for (String repositoryOid : logicalPublicationConfigs.keySet()) {
                allRepositories.add(repositoryOid);
            }
        }
        if (!allRepositories.isEmpty()) {
            boolean bPublished = false;
            for (String repositorioTratado : allRepositories) {
                bPublished = R01MClientFactory.getContentModelAPI(this._userCtx).isDocumentPublished(repositorioTratado, documentOid);
                if (!bPublished) continue;
                publishedRepositories.add(repositorioTratado);
            }
        }
        return publishedRepositories;
    }

    public R01MContent loadContentDocumentLazy(R01MContent inContent, String documentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Carga ligera el documento " + documentOid + " en el contenido " + inContent.getOid();
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            R01MContent content = null;
            if (R01MAuthManager.getRoleRights(inContent.getStoreLocation(), this._userCtx).canSee()) {
                if (inContent.getDocuments() == null || inContent.getDocuments().get(documentOid) == null) {
                    throw new R01MContentModelException("No se puede cargar el documento " + documentOid + " en el contenido " + inContent.getOid() + " ya que el contenido NO tiene este documento");
                }
            } else {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + "NO puede leer el documento " + documentOid + " del contenido " + inContent.getOid());
            }
            content = ((R01MContentModelManagerBzd)this.getBzd()).doLoadContentDocumentLazy(this._userCtx, inContent, documentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return content;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public String getContentOidFromContentTypeAndName(String contentType, String contentName) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Obtener el oid del contenido de tipo " + contentType + " y nombre " + contentName;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            String contOid = ((R01MContentModelManagerBzd)this.getBzd()).doGetContentOidFromContentTypeAndName(contentType, contentName);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return contOid;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public String getDocumentParentContent(String documentOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Obtener el contenido padre del documento " + documentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            String contOid = ((R01MContentModelManagerBzd)this.getBzd()).doGetDocumentParentContent(documentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return contOid;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public Map getAvailableLanguagesToTranslateDocument(String documentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Carga de identificadores de idiomas disponibles para el documento " + documentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            Map languages = ((R01MContentModelManagerBzd)this.getBzd()).doGetAvailableLanguagesToTranslateDocument(this._userCtx, documentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return languages;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MDocumentRevisionState requestDocumentRevision(String contentOid, String documentOid) throws R01MSecurityException, R01MContentModelException {
        R01MDocumentRevisionState newState;
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Solicitud de revision del documento " + documentOid + " del contenido " + contentOid;
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) == null || !roleRights.canRequestRevision()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede solicitar la revision del documento " + documentOid + " en el contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            newState = ((R01MContentModelManagerBzd)this.getBzd()).doRequestDocumentRevision(this._userCtx, contentOid, documentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return newState;
    }

    public R01MContent publishAllDocuments(String contentOid, int publicationType, Date publicationDate, boolean onlyPublished) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Solicitud de publicacion/despublicaci\u00f3n de TODOS los documentos del contenido " + contentOid;
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) == null || !roleRights.canAprove()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede solicitar la publicaci\u00f3n de los documentos del contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            R01MContent modifiedContent = ((R01MContentModelManagerBzd)this.getBzd()).doPublishAllDocuments(this._userCtx, contentOid, publicationType, publicationDate, onlyPublished);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return modifiedContent;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MContent publishDocuments(String contentOid, List documentOids, int publicationType, Date publicationDate, boolean onlyPublished) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Solicitud de publicacion/despublicaci\u00f3n de los documentos " + documentOids + " del contenido " + contentOid;
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) == null || !roleRights.canAprove()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede solicitar la publicaci\u00f3n de los documentos " + documentOids + " del contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            R01MContent modifiedContent = ((R01MContentModelManagerBzd)this.getBzd()).doPublishDocuments(this._userCtx, contentOid, documentOids, publicationType, publicationDate, onlyPublished, null);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return modifiedContent;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MDocumentPublicationTarget updatePublicationState(String documentOid, int publicationType, Date publicationDate, String repositoryOid) throws R01MSecurityException, R01MContentModelException, R01MDuplicateContentException, R01MDuplicateDocumentException, R01MDuplicateDataFileException, R01MDeleteContentException, R01MDeleteDocumentException, R01MDeleteDataFileException, R01MDirtyContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Solicitud de actualizaci\u00f3n del estado de publicacion/despublicaci\u00f3n del documento " + documentOid;
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(this.getDocumentParentContent(documentOid))) == null || !roleRights.canAprove()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede solicitar la " + "actualizaci\u00f3n de informaci\u00f3n de publicaci\u00f3n sobre el documento " + documentOid);
                }
                throw new R01MContentModelException("El contenido del documento '" + documentOid + "' no existe.");
            }
            R01MContentModelManagerBzd bzd = (R01MContentModelManagerBzd)this.getBzd();
            R01MContent content = bzd.doLoadContent(this._userCtx, bzd.doGetDocumentParentContent(documentOid));
            R01MDocumentPublicationTarget pubTarget = bzd.doUpdatePublicationState(content, documentOid, publicationType, publicationDate, repositoryOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return pubTarget;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void publishDocuments(List documentOids, int publicationType, Date publicationDate, String pubRepositoryOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Solicitud de publicacion/despublicaci\u00f3n de los documentos " + documentOids;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            ArrayList<String> documentOidsToPublish = new ArrayList<String>();
            ArrayList<String> allowedContentOids = new ArrayList<String>();
            for (String currentDocumentOid : documentOids) {
                String currentContentOid = this.getDocumentParentContent(currentDocumentOid);
                if (allowedContentOids.contains(currentContentOid)) {
                    documentOidsToPublish.add(currentDocumentOid);
                    continue;
                }
                R01MRoleRights roleRights = this.getRoleRightsInContent(currentContentOid);
                if (roleRights != null && roleRights.canAprove()) {
                    documentOidsToPublish.add(currentDocumentOid);
                    allowedContentOids.add(currentContentOid);
                    continue;
                }
                if (roleRights != null && DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("El usuario " + this._userCtx.getUserName() + " NO puede solicitar la publicaci\u00f3n del documento " + currentDocumentOid + " del contenido " + currentContentOid);
                }
                if (!DEBUG) continue;
                R01FLog.to((String)LOG_TYPE_ID).severe("El contenido de identificador '" + currentContentOid + "' no existe.");
            }
            if (!documentOidsToPublish.isEmpty()) {
                ((R01MContentModelManagerBzd)this.getBzd()).doPublishDocuments(this._userCtx, documentOidsToPublish, publicationType, publicationDate, new ArrayList<R01MPublishActionObject>(), pubRepositoryOid);
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void publishDocuments(List documentOids, int publicationType, Date publicationDate) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Solicitud de publicacion/despublicaci\u00f3n de los documentos " + documentOids;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            ArrayList<String> documentOidsToPublish = new ArrayList<String>();
            ArrayList<String> allowedContentOids = new ArrayList<String>();
            for (String currentDocumentOid : documentOids) {
                String currentContentOid = this.getDocumentParentContent(currentDocumentOid);
                if (allowedContentOids.contains(currentContentOid)) {
                    documentOidsToPublish.add(currentDocumentOid);
                    continue;
                }
                R01MRoleRights roleRights = this.getRoleRightsInContent(currentContentOid);
                if (roleRights != null && roleRights.canAprove()) {
                    documentOidsToPublish.add(currentDocumentOid);
                    allowedContentOids.add(currentContentOid);
                    continue;
                }
                if (roleRights != null && DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("El usuario " + this._userCtx.getUserName() + " NO puede solicitar la publicaci\u00f3n del documento " + currentDocumentOid + " del contenido " + currentContentOid);
                }
                if (!DEBUG) continue;
                R01FLog.to((String)LOG_TYPE_ID).severe("El contenido de identificador '" + currentContentOid + "' no existe.");
            }
            if (!documentOidsToPublish.isEmpty()) {
                ((R01MContentModelManagerBzd)this.getBzd()).doPublishDocuments(this._userCtx, documentOidsToPublish, publicationType, publicationDate, new ArrayList<R01MPublishActionObject>());
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MDocument publishDocument(String documentOid, int publicationType, Date publicationDate) throws R01MSecurityException, R01MPublisherException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Solicitud de publicacion/despublicaci\u00f3n del documento " + documentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            String contentOid = "";
            try {
                contentOid = this.getDocumentParentContent(documentOid);
            }
            catch (R01MSecurityException ex) {
                throw new R01MSecurityException("");
            }
            R01MRoleRights roleRights = this.getRoleRightsInContent(contentOid);
            if (roleRights == null || !roleRights.canAprove()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede solicitar la publicaci\u00f3n de los documentos del contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            R01MDocument modifiedDocument = ((R01MContentModelManagerBzd)this.getBzd()).doPublishDocument(this._userCtx, documentOid, publicationType, publicationDate);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return modifiedDocument;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MDocumentRevisionState aproveDocument(String contentOid, String documentOid) throws R01MSecurityException, R01MPublisherException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Aprobaci\u00f3n del documento " + documentOid + " del contenido " + contentOid;
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) == null || !roleRights.canAprove()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede aprobar del documento " + documentOid + " en el contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            R01MDocumentRevisionState newState = ((R01MContentModelManagerBzd)this.getBzd()).doAproveDocument(this._userCtx, contentOid, documentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return newState;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MDocumentRevisionState rejectDocument(String contentOid, String documentOid, String notes) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Rechazo del documento " + documentOid + " del contenido " + contentOid;
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) == null || !roleRights.canAprove()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede rechazar del documento " + documentOid + " en el contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            R01MDocumentRevisionState newState = ((R01MContentModelManagerBzd)this.getBzd()).doRejectDocument(this._userCtx, contentOid, documentOid, notes);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return newState;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MDocumentRevisionState editDocument(String contentOid, String documentOid, String notes) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Redactar de nuevo el documento " + documentOid + " del contenido " + contentOid;
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) == null || !roleRights.canModify()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede redactar de nuevo el documento " + documentOid + " en el contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            R01MDocumentRevisionState newState = ((R01MContentModelManagerBzd)this.getBzd()).doEditDocument(this._userCtx, contentOid, documentOid, notes);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return newState;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MDocument translateDocument(String contentOid, String documentOid, String languageOid, boolean copyAttachment) throws R01MSecurityException, R01MDuplicateDocumentException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Solicitud de traducci\u00f3n del documento " + documentOid + "del contenido " + contentOid + " al lenguage de oid " + languageOid + ".Copiar adjuntos: " + copyAttachment;
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) == null || !roleRights.canTranslate()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede solicitar la traducci\u00f3n del documento " + documentOid + " en el contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            R01MDocument newDocumentTranslated = ((R01MContentModelManagerBzd)this.getBzd()).doTranslateDocument(this._userCtx, contentOid, documentOid, languageOid, copyAttachment);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return newDocumentTranslated;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MDocument copyDocument(String contentOid, String documentOid, String newInternalName, boolean copyAttachment) throws R01MSecurityException, R01MDuplicateDocumentException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Solicitud de copia del documento " + documentOid + "del contenido " + contentOid + " al nombre interno  " + newInternalName + ".Copiar adjuntos: " + copyAttachment;
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) == null || !roleRights.canTranslate()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede solicitar la copia del documento " + documentOid + " en el contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            R01MDocument newDocumentCopied = ((R01MContentModelManagerBzd)this.getBzd()).doCopyDocument(this._userCtx, contentOid, documentOid, newInternalName, copyAttachment);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return newDocumentCopied;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void copyDocumentInto(R01MContent content, String sourceDocumentOid, String targetDocumentOid, boolean copyAttachment) throws R01MSecurityException, R01MDuplicateDocumentException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Solicitud de copia del documento " + sourceDocumentOid + "del contenido " + content.getOid() + " al nombre documento  " + targetDocumentOid + ".Copiar adjuntos: " + copyAttachment;
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(content.getOid())) == null || !roleRights.canTranslate()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede solicitar la copia del documento origen " + sourceDocumentOid + " al documento destino " + targetDocumentOid + " en el contenido " + content.getOid());
                }
                throw new R01MContentModelException("El contenido de identificador '" + content.getOid() + "' no existe.");
            }
            List<R01MDocument> result = ((R01MContentModelManagerBzd)this.getBzd()).doCopyDocumentInto(this._userCtx, content.getOid(), sourceDocumentOid, targetDocumentOid, copyAttachment);
            content.getDocuments().put(targetDocumentOid, result.get(1));
            content.setLastUpdateTS(Long.parseLong("" + result.get(0)));
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MDocument setDocumentInitialPage(String contentOid, String documentOid, String dataFileOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Establecer la pagina de inicio para el dataFile " + dataFileOid + " del documento " + documentOid;
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) == null || !roleRights.canModify()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede establecer la pagina de inicio del documento " + documentOid + " en el contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            R01MDocument document = ((R01MContentModelManagerBzd)this.getBzd()).doSetDocumentInitialPage(this._userCtx, contentOid, documentOid, dataFileOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end): " + opDesc + LOG_SEP_END);
            }
            return document;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MLinkedResourcesGroup setDocumentLinkedResources(String contentOid, String documentOid, String docPublishRepoOid, R01MLinkedResourcesGroup resourcesGroup, boolean generateHTMLAsync) throws R01MSecurityException, R01MContentModelObjectsValidatorException, R01MContentModelException {
        return this.setDocumentLinkedResources(contentOid, documentOid, docPublishRepoOid, resourcesGroup, null, generateHTMLAsync);
    }

    public R01MLinkedResourcesGroup setDocumentLinkedResources(String contentOid, String documentOid, String docPublishRepoOid, R01MLinkedResourcesGroup resourcesGroup, Map inversePresentationTagIds, boolean generateHTMLAsync) throws R01MSecurityException, R01MContentModelObjectsValidatorException, R01MContentModelException {
        R01MLinkedResourcesGroup newResourcesGroup = null;
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Asociando los recursos de vinculaci\u00f3n al documento '" + documentOid + "' del contenido '" + contentOid + "'";
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) == null || !roleRights.canModify()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO tiene acceso al contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            newResourcesGroup = ((R01MContentModelManagerBzd)this.getBzd()).doSetDocumentLinkedResources(this._userCtx, contentOid, documentOid, docPublishRepoOid, resourcesGroup, inversePresentationTagIds, generateHTMLAsync);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end): " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return newResourcesGroup;
    }

    public R01MLinkedResourcesGroup linkDocumentToMultipleRelatedDocuments(String contentOid, String documentOid, String pubRepositoryOid, String linkedResourcesGroupTitleLabel, List relationsDef, Map inversePresentationTagIds, boolean generateHTMLAsync) throws R01MSecurityException, R01MContentModelObjectsValidatorException, R01MContentModelException {
        R01MLinkedResourcesGroup newResourcesGroup = null;
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Asociando los recursos de vinculaci\u00f3n al documento '" + documentOid + "' del contenido '" + contentOid + "'";
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) != null && roleRights.canModify()) {
                if (relationsDef != null && !relationsDef.isEmpty()) {
                    HashMap<String, R01MLinkedResource> linkedResources = new HashMap<String, R01MLinkedResource>(relationsDef.size());
                    for (R01MLinkedDocumentToDocumentResume currRelationDef : relationsDef) {
                        R01MLinkedResource currLinkedResource = new R01MLinkedResource();
                        currLinkedResource.linkToContent(currRelationDef.getDocumentRelatedContentOid(), currRelationDef.getDocumentRelatedDocumentOid());
                        currLinkedResource.setRelationId(currRelationDef.getRelationId());
                        currLinkedResource.setPresentationTags(currRelationDef.getRelationTags());
                        linkedResources.put(currLinkedResource.getOid(), currLinkedResource);
                    }
                    if (!linkedResources.isEmpty()) {
                        R01MLinkedResourcesGroup linkGroup = new R01MLinkedResourcesGroup();
                        linkGroup.setTitleGroupLabel(linkedResourcesGroupTitleLabel);
                        linkGroup.setResources(linkedResources);
                        newResourcesGroup = ((R01MContentModelManagerBzd)this.getBzd()).doSetDocumentLinkedResources(this._userCtx, contentOid, documentOid, pubRepositoryOid, linkGroup, inversePresentationTagIds, generateHTMLAsync);
                    }
                }
            } else {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO tiene acceso al contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end): " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return newResourcesGroup;
    }

    public void renderAndPublishDocumentLinkedResources(String contentOid, String documentOid, List repositories) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Regenerando y republicando los recursos de vinculaci\u00f3n al documento '" + documentOid + "' del contenido '" + contentOid + "'";
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) == null || !roleRights.canModify()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO tiene acceso al contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            ((R01MContentModelManagerBzd)this.getBzd()).doRenderAndPublishDocumentLinkedResources(this._userCtx, contentOid, documentOid, repositories);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end): " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MLinkedRelationsGroup getDocumentAvailableLinkedRelations(String contentSrcOid, String documentSrcOid, String documentDstOid, String containerId) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Obtener las relaciones posibles para la vinculaci\u00f3n entre los documentos '" + documentSrcOid + "'y '" + documentDstOid + "'";
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentSrcOid)) == null || !roleRights.canSee()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO tiene acceso al contenido " + contentSrcOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentSrcOid + "' no existe.");
            }
            R01MLinkedRelationsGroup availableRelations = ((R01MContentModelManagerBzd)this.getBzd()).doGetDocumentAvailableLinkedRelations(this._userCtx, documentSrcOid, documentDstOid, containerId);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end): " + opDesc + LOG_SEP_END);
            }
            return availableRelations;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MLinkedResourcesGroup getDocumentLinkedResources(String documentOid) throws R01MSecurityException, R01MContentModelException {
        R01MLinkedResourcesGroup resources;
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Obtener los recursos de vinculaci\u00f3n asociados al documento '" + documentOid + "'.";
        try {
            String contentOid;
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid = this.getDocumentParentContent(documentOid))) == null || !roleRights.canSee()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO tiene acceso al contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            resources = ((R01MContentModelManagerBzd)this.getBzd()).doGetDocumentLinkedResources(this._userCtx, documentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end): " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return resources;
    }

    public void setDocumentGalleryResources(String contentOid, String documentOid, String docPublishRepoOid, R01MGalleryResourcesGroup galleryResourcesGroup) throws R01MSecurityException, R01MContentModelObjectsValidatorException, R01MContentModelException {
        R01MGallery gallery2 = null;
        if (galleryResourcesGroup != null && !galleryResourcesGroup.getGalleries().isEmpty()) {
            for (R01MGallery gallery2 : galleryResourcesGroup.getGalleries().values()) {
                this.setDocumentGalleryResources(contentOid, documentOid, docPublishRepoOid, gallery2);
            }
        }
    }

    public void setDocumentGalleryResources(String contentOid, String documentOid, String docPublishRepoOid, R01MGallery galleryResources) throws R01MSecurityException, R01MContentModelObjectsValidatorException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Asociando los recursos de la galer\u00eda '" + galleryResources.getId() + "' al documento '" + documentOid + "' del contenido '" + contentOid + "'";
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) == null || !roleRights.canModify()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO tiene acceso al contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            ((R01MContentModelManagerBzd)this.getBzd()).doSetDocumentGalleryResources(this._userCtx, contentOid, documentOid, docPublishRepoOid, galleryResources);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end): " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MGalleryResourcesGroup getDocumentGalleryResources(String documentOid) throws R01MSecurityException, R01MContentModelException {
        R01MGalleryResourcesGroup resources;
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Obtener los recursos galer\u00eda asociados al documento '" + documentOid + "'.";
        try {
            String contentOid;
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid = this.getDocumentParentContent(documentOid))) == null || !roleRights.canSee()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO tiene acceso al contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            resources = ((R01MContentModelManagerBzd)this.getBzd()).doGetDocumentGalleryResources(this._userCtx, documentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end): " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return resources;
    }

    public Map getContainersConfig(R01MContentLocation loc, R01MContentTypologyInfo typo) throws R01MContentModelException, R01MContentModelObjectsValidatorException {
        if (loc == null && typo == null) {
            throw new R01MContentModelObjectsValidatorException("El objeto de almacenamiento y de tipologia son NULOS!!!");
        }
        String opDesc = "Obtener los contenedores para el almacenamiento: " + (loc != null ? loc.composeMemoCode() : "[null]") + " y la tipolog\u00eda " + (typo != null ? typo.composeMemoCode() : "[null]");
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
        }
        ArrayList<String> storageAndTypoContainers = new ArrayList<String>();
        if (loc != null) {
            R01MResourcesContainerConfig containerStorageCfg;
            loc.validateObject();
            try {
                containerStorageCfg = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(loc.getWorkAreaOid()).getAllowedResourcesContainers();
            }
            catch (R01MConfigLoadException cfgExc) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error en la carga de los contenedores por almacenamiento: " + loc.composeMemoCode() + ".Error:" + cfgExc.getMessage());
                throw new R01MContentModelException("Error en la carga de los contenedores para el almacenamiento: " + loc.composeMemoCode() + ".", (Exception)((Object)cfgExc));
            }
            if (containerStorageCfg != null && containerStorageCfg.getAllowedContainers() != null && !containerStorageCfg.getAllowedContainers().isEmpty()) {
                Iterator<String> itContainers = containerStorageCfg.getAllowedContainers().iterator();
                while (itContainers.hasNext()) {
                    storageAndTypoContainers.add(itContainers.next());
                }
            }
        }
        if (typo != null) {
            typo.validateObject();
            R01MResourcesContainerConfig containerTypoCfg = null;
            try {
                containerTypoCfg = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(typo.getTypeOid()).getAllowedResourcesContainers();
            }
            catch (R01MConfigLoadException cfgExc) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error en la carga de los contenedores por tipologia: " + typo.composeMemoCode() + ".Error:" + cfgExc.getMessage());
                throw new R01MContentModelException("Error en la carga de los contenedores para el almacenamiento: " + loc.composeMemoCode() + ".", (Exception)((Object)cfgExc));
            }
            if (containerTypoCfg != null && containerTypoCfg.getAllowedContainers() != null && !containerTypoCfg.getAllowedContainers().isEmpty()) {
                for (String containerId : containerTypoCfg.getAllowedContainers()) {
                    if (storageAndTypoContainers.contains(containerId)) continue;
                    storageAndTypoContainers.add(containerId);
                }
            }
        }
        R01MResourcesContainerManagementConfig containersCfg = null;
        try {
            containersCfg = R01MClientFactory.getResourcesContainerConfigAPI().getResourcesContainerConfig();
        }
        catch (Exception cfgExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en la carga de la configuraci\u00f3n de contenedores.Error:" + cfgExc.getMessage());
            throw new R01MContentModelException("Error en la carga de la configuraci\u00f3n de contenedores.", cfgExc);
        }
        HashMap storageAndTypoContainersDef = new HashMap();
        if (!storageAndTypoContainers.isEmpty() && containersCfg != null && containersCfg.getContainers() != null && !containersCfg.getContainers().isEmpty()) {
            for (String containerId : storageAndTypoContainers) {
                if (!containersCfg.getContainers().containsKey(containerId)) continue;
                storageAndTypoContainersDef.put(containerId, containersCfg.getContainers().get(containerId));
            }
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end): " + opDesc + LOG_SEP_END);
        }
        return storageAndTypoContainersDef;
    }

    public List getContainersConfigSortedByName(R01MContentLocation loc, R01MContentTypologyInfo typo, final String lang) throws R01MContentModelException, R01MContentModelObjectsValidatorException {
        ArrayList defaultContainers = new ArrayList(this.getContainersConfig(loc, typo).values());
        if (!defaultContainers.isEmpty()) {
            Collections.sort(defaultContainers, new Comparator(){

                public int compare(Object container1, Object container2) {
                    if (container1 != null && container2 != null) {
                        return ((R01MResourcesContainer)container1).getName(lang).compareTo(((R01MResourcesContainer)container2).getName(lang));
                    }
                    if (container1 != null) {
                        return 1;
                    }
                    if (container2 != null) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        return defaultContainers;
    }

    public R01MContent loadContentDataFileLazy(R01MContent inContent, String documentOid, String dataFileOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Carga ligera el fichero de datos " + dataFileOid + " del documento " + documentOid + " en el contenido " + inContent.getOid();
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            R01MContent content = null;
            if (R01MAuthManager.getRoleRights(inContent.getStoreLocation(), this._userCtx).canSee()) {
                if (inContent.getDocuments() == null || inContent.getDocuments().get(documentOid) == null) {
                    throw new R01MContentModelException("El contenido " + inContent.getOid() + " NO tiene un documento con oid " + documentOid + ". NO se puede cargar el archivo de datos " + dataFileOid);
                }
                R01MDocument document = inContent.getDocuments().get(documentOid);
                if (document instanceof R01MBaseResumeModelObject) {
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("... el documento " + documentOid + " AUN NO ESTABA CARGADO COMPLETAMENTE... cargarlo antes de cargar el documento!");
                    }
                    this.loadContentDocumentLazy(inContent, documentOid);
                }
            } else {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede leer el fichero de datos " + dataFileOid + " del documento " + documentOid + " en el contenido " + inContent.getOid());
            }
            content = ((R01MContentModelManagerBzd)this.getBzd()).doLoadContentDataFileLazy(this._userCtx, inContent, documentOid, dataFileOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return content;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public Map<String, R01MBasePublicationTarget> loadRunningPublications() throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Carga de las publicaciones y despublicaciones en estado RUNNING";
        Map runningPublications = null;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            runningPublications = ((R01MContentModelManagerBzd)this.getBzd()).doLoadRunningPublications(this._userCtx);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return runningPublications;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public Date loadContentIndexStartDate(String contentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Carga la fecha de inicio de indexacion del contenido pasado";
        Date indexStartDate = null;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            indexStartDate = ((R01MContentModelManagerBzd)this.getBzd()).doLoadContentIndexStartDate(this._userCtx, contentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return indexStartDate;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public String loadContentIndexersState(String contentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Carga el XML con el estado actual de los indexadores para el contenido pasado";
        String contentIndexersState = null;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            contentIndexersState = ((R01MContentModelManagerBzd)this.getBzd()).doLoadContentIndexersState(this._userCtx, contentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return contentIndexersState;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void setContentIndexStartDate(String contentOid, Date indexStartDate) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Establece la fecha de inicio de indexacion del contenido pasado";
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            ((R01MContentModelManagerBzd)this.getBzd()).doSetContentIndexStartDate(this._userCtx, contentOid, indexStartDate);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void setContentIndexersState(String contentOid, String indexerState) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Establece el XML con el estado actual de las indexaciones para los indexadores para el contenido pasado";
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            ((R01MContentModelManagerBzd)this.getBzd()).doSetContentIndexersState(this._userCtx, contentOid, indexerState);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public Date loadDocumentIndexStartDate(String documentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Carga la fecha de inicio de indexacion del documento pasado";
        Date indexStartDate = null;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            indexStartDate = ((R01MContentModelManagerBzd)this.getBzd()).doLoadDocumentIndexStartDate(this._userCtx, documentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return indexStartDate;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public String loadDocumentIndexersState(String documentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Carga el XML con el estado actual de los indexadores para el documento pasado";
        String documentIndexersState = null;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            documentIndexersState = ((R01MContentModelManagerBzd)this.getBzd()).doLoadDocumentIndexersState(this._userCtx, documentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return documentIndexersState;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void setDocumentIndexStartDate(String documentOid, Date indexStartDate) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Establece la fecha de inicio de indexacion del documento pasado";
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            ((R01MContentModelManagerBzd)this.getBzd()).doSetDocumentIndexStartDate(this._userCtx, documentOid, indexStartDate);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void setDocumentIndexersState(String documentOid, String indexerState) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Establece el XML de estado de las indexaciones para los indexadores del documento pasado";
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            ((R01MContentModelManagerBzd)this.getBzd()).doSetDocumentIndexersState(this._userCtx, documentOid, indexerState);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public boolean checkAliasExistence(String alias) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Comprobar existencia del alias " + alias;
        boolean existsAlias = false;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            existsAlias = ((R01MContentModelManagerBzd)this.getBzd()).doCheckAliasExistence(alias);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return existsAlias;
    }

    public void setContentPublishIndexFiles(String contentOid, boolean hasToPublishIndexFiles) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Establece el flag de publicaci\u00f3n de ficheros de indexaci\u00f3n del contenido pasado";
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            ((R01MContentModelManagerBzd)this.getBzd()).doSetContentPublishIndexFiles(this._userCtx, contentOid, hasToPublishIndexFiles);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void setDocumentPublishIndexFiles(String documentOid, boolean hasToPublishIndexFiles) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Establece el flag de publicaci\u00f3n de ficheros de indexaci\u00f3n del documento pasado";
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            ((R01MContentModelManagerBzd)this.getBzd()).doSetDocumentPublishIndexFiles(this._userCtx, documentOid, hasToPublishIndexFiles);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public String getDataFileParentDocument(String dataFileOid) throws R01MContentModelException {
        String opDesc = "Obtener el documento padre del dataFile " + dataFileOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            String docOid = ((R01MContentModelManagerBzd)this.getBzd()).doGetDataFileParentDocument(dataFileOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return docOid;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public String[] getDataFileParentDocumentAndContentOids(String dataFileOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Obtener el documento y contenido padres del dataFile " + dataFileOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
        }
        String contOid = null;
        String docOid = this.getDataFileParentDocument(dataFileOid);
        if (docOid != null) {
            contOid = this.getDocumentParentContent(docOid);
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        return new String[]{contOid, docOid, dataFileOid};
    }

    public int getStateOfGeneratedDatafile(String dataFileOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Obtener el estado del dataFile " + dataFileOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            int state = ((R01MContentModelManagerBzd)this.getBzd()).doGetStateOfGeneratedDatafile(this._userCtx, dataFileOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return state;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void generateDataFileUsingAllPresentationTemplates(String contentOid, String documentOid, String dataFileOid) throws R01MSecurityException, R01MContentModelException {
        this.generateDataFileContent(contentOid, documentOid, dataFileOid, false, true, "", false, true);
    }

    public void generateDataFileUsingAllPresentationTemplates(String contentOid, String documentOid, String dataFileOid, boolean syncWorkflow) throws R01MSecurityException, R01MContentModelException {
        this.generateDataFileContent(contentOid, documentOid, dataFileOid, false, true, "", syncWorkflow, true);
    }

    public void generateDataFileUsingPresentationTemplate(String contentOid, String documentOid, String dataFileOid, String presentationTemplateOid) throws R01MSecurityException, R01MContentModelException {
        this.generateDataFileContent(contentOid, documentOid, dataFileOid, false, false, presentationTemplateOid, false, true);
    }

    public void generateDataFileUsingPresentationTemplate(String contentOid, String documentOid, String dataFileOid, String presentationTemplateOid, boolean syncWorkflow) throws R01MSecurityException, R01MContentModelException {
        this.generateDataFileContent(contentOid, documentOid, dataFileOid, false, false, presentationTemplateOid, syncWorkflow, true);
    }

    public void generateDataFileContent(String contentOid, String documentOid, String dataFileOid, boolean generateAsync, boolean useAllPresentationTemplates, String presentationTemplateOid, boolean syncWorkflow, boolean uploadToDocumentFolder) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Generar el dataFile " + contentOid + ":" + documentOid + ":" + dataFileOid + " de forma " + (generateAsync ? "as\u00edncrona " : "sincrona ") + "utilizando " + (useAllPresentationTemplates ? " todas las plantillas de presentacion " : "la plantilla de presentacion " + presentationTemplateOid) + ", syncWorkflow es " + syncWorkflow;
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) == null || !roleRights.canModify()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO tiene acceso al contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            ((R01MContentModelManagerBzd)this.getBzd()).doGenerateDataFileContent(this._userCtx, contentOid, documentOid, dataFileOid, generateAsync, useAllPresentationTemplates, presentationTemplateOid, syncWorkflow, uploadToDocumentFolder);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public Map loadWorkAreaContents(R01MContentLocation loc) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Cargando los contenidos de la workArea " + loc.getWorkAreaOid();
        try {
            Map outMap = new HashMap();
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if (!R01MAuthManager.getRoleRights(loc, this._userCtx).canSee()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede acceder a la workarea " + loc.getWorkAreaOid());
            }
            outMap = ((R01MContentModelManagerBzd)this.getBzd()).doLoadWorkAreaContents(this._userCtx, loc);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return outMap;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public String[] loadWorkAreaContentsOids(R01MContentLocation loc) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Cargando los contenidos de la workArea " + loc.getWorkAreaOid();
        try {
            String[] outArray = null;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if (!R01MAuthManager.getRoleRights(loc, this._userCtx).canSee()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede acceder a la workarea " + loc.getWorkAreaOid());
            }
            outArray = ((R01MContentModelManagerBzd)this.getBzd()).doLoadWorkAreaContentsOids(this._userCtx, loc);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return outArray;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MContentManagerStorageIterator getStorageIterator(String serverOid, String dataStoreOid, String areaOid, String workAreaOid) throws R01MConfigLoadException {
        return new R01MContentManagerStorageIterator(serverOid, dataStoreOid, areaOid, workAreaOid);
    }

    public R01MIndexableContent prepareContentToBeIndexed(String contentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        if (!this.checkContentExistence(contentOid)) {
            R01FLog.to((String)LOG_TYPE_ID).warning("R01MContentModelAPI.prepareContentToBeIndexed: El contenido de identificador " + contentOid + " no existe.");
            return null;
        }
        String opDesc = "Preparando el contenido " + contentOid + " para ser indexado";
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            R01MRoleRights roleRights = this.getRoleRightsInContent(contentOid);
            R01MIndexableContent outIdxCont = null;
            if (roleRights == null || !roleRights.canModify()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO tiene acceso al contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            outIdxCont = ((R01MContentModelManagerBzd)this.getBzd()).doPrepareContentToBeIndexed(this._userCtx, contentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return outIdxCont;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadIndexableObject(R01MContent content, R01MIndexableContent idxCont) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): Subiendo el objeto indexable: " + content.getOid());
            }
            if ((roleRights = this.getRoleRightsInContent(content.getOid())) == null || !roleRights.canModify()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO tiene acceso al contenido " + content.getOid());
                }
                throw new R01MContentModelException("El contenido de identificador '" + content.getOid() + "' no existe.");
            }
            ((R01MContentModelManagerBzd)this.getBzd()).doUploadIndexableObject(this._userCtx, content, idxCont);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : Objeto indexable subido " + content.getOid() + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public List<R01MURLAlias> loadDocumentAliasesInState(String documentOid, int state) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Carga el XML con el estado actual de los indexadores para el documento pasado";
        List aliases = null;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            aliases = ((R01MContentModelManagerBzd)this.getBzd()).doLoadDocumentAliasesInState(this._userCtx, documentOid, state);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return aliases;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void updateDocumentAliasesState(String documentOid, int initialState, int finalState) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): Actualizando el estado de los aliases del documento " + documentOid + ". " + "Los alias con estado " + initialState + " se quedar\u00e1n con " + "estado " + finalState);
            }
            ((R01MContentModelManagerBzd)this.getBzd()).doUpdateDocumentAliasesState(this._userCtx, documentOid, initialState, finalState);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : Aliases del documento " + documentOid + " actualizados.  " + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public Map getOperationsGroupByContents(R01MChangesLabelsPacket changesPacket) throws R01MContentModelException, R01MSecurityException {
        if (!this._validateAdminContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Obtener los contenidos para el paquete de operaciones " + changesPacket.getPacketOid();
        try {
            Map outGroups = null;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            outGroups = ((R01MContentModelManagerBzd)this.getBzd()).doGetOperationsGroupByContents(this._userCtx, changesPacket);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return outGroups;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MBusinessErrors getBusinessErrors(String documentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Cargando los errores de negocio ";
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            R01MBusinessErrors bussinesErrors = ((R01MContentModelManagerBzd)this.getBzd()).doLoadBusinessErrors(this._userCtx, documentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return bussinesErrors;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public List getBusinessErrors(List documentOids) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Cargando los errores de negocio de varios documentos";
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            List bussinesErrorsList = ((R01MContentModelManagerBzd)this.getBzd()).doLoadBusinessErrorsList(this._userCtx, documentOids);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return bussinesErrorsList;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void setBusinessErrors(String documentOid, R01MBusinessErrors documentErrors) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Guardando los errores de negocio ";
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            ((R01MContentModelManagerBzd)this.getBzd()).doSetBusinessErrors(this._userCtx, documentOid, documentErrors);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public String composeContentName(String typologyOid, String metadataOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Generando el nombre del contenido";
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            String contenName = ((R01MContentModelManagerBzd)this.getBzd()).doComposeContentName(this._userCtx, typologyOid, metadataOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return contenName;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public int getUiState(String target, String oidDocument) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Obteniendo el nuevo estado uistate";
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            int uiState = ((R01MContentModelManagerBzd)this.getBzd()).doGetUiState(this._userCtx, target, oidDocument);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return uiState;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    private boolean _validateContext(R01MUserContext userCtx) {
        return userCtx != null;
    }

    private boolean _validateAdminContext(R01MUserContext userCtx) {
        if (userCtx == null) {
            return false;
        }
        return userCtx.getUserProfile().equals("masterSystem");
    }

    public R01MContentPublishResume loadContentPublishResume(String contentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Carga para le publicador  del contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            R01MContentPublishResume content = null;
            R01MRoleRights roleRights = this.getRoleRightsInContent(contentOid);
            if (roleRights == null || !roleRights.canSee()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede leer el contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            content = ((R01MContentModelManagerBzd)this.getBzd()).doLoadContentPublishResume(this._userCtx, contentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return content;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MDocumentPublishResume loadDocumentPublishResume(String documentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Carga del documento " + documentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            R01MDocumentPublishResume document = null;
            R01MRoleRights roleRights = this.getRoleRightsInContent(((R01MContentModelManagerBzd)this.getBzd()).doGetDocumentParentContent(documentOid));
            if (roleRights == null || !roleRights.canSee()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede leer el contenido del documento " + documentOid);
                }
                throw new R01MContentModelException("El documento de identificador '" + documentOid + "' no existe.");
            }
            document = ((R01MContentModelManagerBzd)this.getBzd()).doLoadDocumentPublishResume(this._userCtx, documentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            return document;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MLinkedResource getLinkedTranslated(R01MLinkedResource srcLinked, String dstLang, String translateDocumentOid) throws R01MContentModelException {
        try {
            return ((R01MContentModelManagerBzd)this.getBzd()).doGetLinkedTranslated(srcLinked, dstLang, translateDocumentOid);
        }
        catch (Exception bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", bzdCfgEx);
        }
    }

    public R01MContent changeContentCatalog(R01MUserContext userCtx, String contentOid, List newLabels) throws R01MContentModelException, R01MSecurityException {
        R01MContent content = null;
        try {
            if (!StringUtils.isEmptyString((String)contentOid)) {
                content = ((R01MContentModelManagerBzd)this.getBzd("contentModel")).doChangeContentCatalog(userCtx, contentOid, newLabels);
            }
        }
        catch (R01MConfigLoadException cfgExc) {
            throw new R01MContentModelException("CONFIG CLIENT API: No se podido modificar la catalogaci\u00f3n del contenido " + contentOid + " por el error" + cfgExc.getMessage());
        }
        return content;
    }

    public void saveContentGeoLabels(String contentOid, R01MGeoPicks geoCatalog) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Guardar la catalogaci\u00f3n geogr\u00e1fica del contenido " + contentOid;
        try {
            R01MRoleRights roleRights;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            if ((roleRights = this.getRoleRightsInContent(contentOid)) == null || !roleRights.canSee()) {
                if (roleRights != null) {
                    throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede leer el contenido " + contentOid);
                }
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' no existe.");
            }
            ((R01MContentModelManagerBzd)this.getBzd()).doSaveContentGeoLabels(this._userCtx, contentOid, geoCatalog);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public List getActiveNotices(String lang) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        StringBuffer opDesc = new StringBuffer(61);
        opDesc.append("Obtener los avisos vigentes ");
        try {
            List<R01MNotice> notices = null;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            notices = ((R01MContentModelManagerBzd)this.getBzd()).doGetActiveNotices(this._userCtx, lang);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end): " + opDesc + LOG_SEP_END);
            }
            return notices;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public Map getNoticesReadByUserLazy() throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        StringBuffer opDesc = new StringBuffer(61);
        opDesc.append("Obtener los avisos leidos del usuario = ");
        opDesc.append(this._userCtx.getUserName());
        try {
            Map noticesReaded = null;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            noticesReaded = ((R01MContentModelManagerBzd)this.getBzd()).doGetNoticesReadByUserLazy(this._userCtx);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end): " + opDesc + LOG_SEP_END);
            }
            return noticesReaded;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public List getNoticesNotReadByUser(String lang) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        StringBuffer opDesc = new StringBuffer(61);
        opDesc.append("Obtener los avisos NO leidos del usuario = ");
        opDesc.append(this._userCtx.getUserName());
        try {
            List<R01MNotice> noticesReaded = null;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            noticesReaded = ((R01MContentModelManagerBzd)this.getBzd()).doGetNoticesNotReadByUser(this._userCtx, lang);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end): " + opDesc + LOG_SEP_END);
            }
            return noticesReaded;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void setNoticesReadByUser(List readedList) throws R01MContentModelException, R01MSecurityException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        StringBuffer opDesc = new StringBuffer(61);
        opDesc.append("Marcar como leido los avisos del usuario = ");
        opDesc.append(this._userCtx.getUserName());
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            ((R01MContentModelManagerBzd)this.getBzd()).doSetNoticeReadByUser(this._userCtx, readedList);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end): " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }
}

