/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.datastore.R01MDataStoreItemAttachmentFilter;
import com.ejie.r01m.datastore.R01MDataStoreItemFilter;
import com.ejie.r01m.exceptions.R01MBufferSizeChunkOverflowException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.datastore.R01MDataStoreItem;
import com.ejie.r01m.services.R01MBaseAPI;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.bzd.R01MContentDataManagerBzd;
import com.ejie.r01m.utils.R01MConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class R01MContentDataAPI
extends R01MBaseAPI {
    private static final String LOG_SEP_INI = "\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n";
    private static final String LOG_SEP_END = "\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\n";
    private R01MUserContext _userCtx = new R01MUserContext();
    private String _contentOid = null;
    private static final String LOG_TYPE_ID = "r01m.dataAPI";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.dataAPI").intValue() != Level.OFF.intValue();

    private R01MContentDataAPI() {
        super("contentModelData");
    }

    public R01MContentDataAPI(R01MUserContext newUserCtx, String newContentOid) {
        this();
        this._userCtx = newUserCtx;
        this._contentOid = newContentOid;
    }

    public R01MContentDataAPI(R01MUserContext newUserCtx, R01MContent newContent) {
        this();
        this._userCtx = newUserCtx;
        if (newContent != null) {
            this._contentOid = newContent.getOid();
        } else {
            R01FLog.to((String)LOG_TYPE_ID).warning("ERROR al instanciar el API de Datos para contenidos... el contenido suministrado es nulo!!!");
        }
    }

    public boolean checkDataFile(String documentOid, String dataFileOid) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "checkDataFile > contentOid=" + this._contentOid + " documentOid=" + documentOid + " dataFileOid=" + dataFileOid;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            boolean exists = ((R01MContentDataManagerBzd)this.getBzd()).doCheckDataFile(this._userCtx, this._contentOid, documentOid, dataFileOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
            return exists;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public boolean checkAttachmentFile(String documentOid, String fileDocumentRelativePath) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "checkAttachmentFile > contentOid=" + this._contentOid + " documentOid=" + documentOid + " attachment=" + fileDocumentRelativePath;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            boolean exists = ((R01MContentDataManagerBzd)this.getBzd()).doCheckAttachmentFile(this._userCtx, this._contentOid, documentOid, fileDocumentRelativePath);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
            return exists;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public InputStream downloadDataFile(String documentOid, String dataFileOid) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "downloadDataFile > contentOid=" + this._contentOid + " documentOid=" + documentOid + " dataFileOid=" + dataFileOid;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            InputStream outIS = null;
            String wayUpload = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"wayUploadFile", (String)"atOnce");
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API: Descargando el fichero segun se indica en el properties de r01m en el parametro 'wayUploadFile': " + wayUpload);
            }
            if ("chunked".equals(wayUpload)) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                long offset = 0L;
                try {
                    byte[] buffer;
                    do {
                        if ((buffer = ((R01MContentDataManagerBzd)this.getBzd()).doDownloadDataFileChunk(this._userCtx, this._contentOid, documentOid, dataFileOid, offset, R01MConstants.BUFFER_SIZE_CHUNK_MIN)) == null || buffer.length <= 0) continue;
                        offset += Long.valueOf("" + R01MConstants.BUFFER_SIZE_CHUNK_MIN).longValue();
                        os.write(buffer);
                    } while (buffer != null && buffer.length > 0);
                }
                catch (IOException e) {
                    throw new R01MContentModelException("Error de lectura al descargar el fichero", (Exception)e);
                }
                finally {
                    if (os != null) {
                        try {
                            os.flush();
                            os.close();
                        }
                        catch (IOException e) {
                            throw new R01MContentModelException("Error de lectura al descargar el fichero", (Exception)e);
                        }
                    }
                }
                outIS = new ByteArrayInputStream(os.toByteArray());
            } else {
                outIS = ((R01MContentDataManagerBzd)this.getBzd()).doDownloadDataFile(this._userCtx, this._contentOid, documentOid, dataFileOid);
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
            return outIS;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public byte[] downloadDataFileChunk(String documentOid, String dataFileOid, long offset, int length) throws R01MSecurityException, R01MContentModelException, R01MBufferSizeChunkOverflowException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        if (length > R01MConstants.BUFFER_SIZE_CHUNK_MAX) {
            throw new R01MBufferSizeChunkOverflowException("Se ha rebasado el l\u00edmite de buffer para envio de trozos de un fichero");
        }
        try {
            String opDesc = "downloadDataFileChunk > contentOid=" + this._contentOid + " documentOid=" + documentOid + " dataFileOid=" + dataFileOid;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            byte[] outArray = ((R01MContentDataManagerBzd)this.getBzd()).doDownloadDataFileChunk(this._userCtx, this._contentOid, documentOid, dataFileOid, offset, length);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
            return outArray;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public InputStream downloadDocumentFile(String documentOid, String fileDocumentRelativePath) throws R01MSecurityException, R01MContentModelException {
        return this.downloadAttachmentFile(documentOid, fileDocumentRelativePath);
    }

    public InputStream downloadAttachmentFile(String documentOid, String fileDocumentRelativePath) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "downloadDocumentFile > contentOid=" + this._contentOid + " documentOid=" + documentOid + " fileDocumentRelativePath=" + fileDocumentRelativePath;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            InputStream outIS = null;
            String wayUpload = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"wayUploadFile", (String)"atOnce");
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API: Descargando el fichero segun se indica en el properties de r01m en el parametro 'wayUploadFile': " + wayUpload);
            }
            if ("chunked".equals(wayUpload)) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                long offset = 0L;
                try {
                    byte[] buffer;
                    do {
                        if ((buffer = ((R01MContentDataManagerBzd)this.getBzd()).doDownloadAttachmentFileChunk(this._userCtx, this._contentOid, documentOid, fileDocumentRelativePath, offset, R01MConstants.BUFFER_SIZE_CHUNK_MIN)) == null || buffer.length <= 0) continue;
                        offset += Long.valueOf("" + R01MConstants.BUFFER_SIZE_CHUNK_MIN).longValue();
                        os.write(buffer);
                    } while (buffer != null && buffer.length > 0);
                }
                catch (IOException e) {
                    throw new R01MContentModelException("Error de lectura al descargar el fichero", (Exception)e);
                }
                finally {
                    if (os != null) {
                        try {
                            os.flush();
                            os.close();
                        }
                        catch (IOException e) {
                            throw new R01MContentModelException("Error de lectura al descargar el fichero", (Exception)e);
                        }
                    }
                }
                outIS = new ByteArrayInputStream(os.toByteArray());
            } else {
                outIS = ((R01MContentDataManagerBzd)this.getBzd()).doDownloadAttachmentFile(this._userCtx, this._contentOid, documentOid, fileDocumentRelativePath);
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
            return outIS;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public byte[] downloadDocumentFileChunk(String documentOid, String fileDocumentRelativePath, long offset, int length) throws R01MSecurityException, R01MContentModelException, R01MBufferSizeChunkOverflowException {
        return this.downloadAttachmentFileChunk(documentOid, fileDocumentRelativePath, offset, length);
    }

    public byte[] downloadAttachmentFileChunk(String documentOid, String fileDocumentRelativePath, long offset, int length) throws R01MSecurityException, R01MContentModelException, R01MBufferSizeChunkOverflowException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        if (length > R01MConstants.BUFFER_SIZE_CHUNK_MAX) {
            throw new R01MBufferSizeChunkOverflowException("Se ha rebasado el l\u00edmite de buffer para envio de trozos de un fichero");
        }
        try {
            String opDesc = "downloadDocumentFileChunk > contentOid=" + this._contentOid + " documentOid=" + documentOid + " fileDocumentRelativePath=" + fileDocumentRelativePath;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            byte[] outArray = ((R01MContentDataManagerBzd)this.getBzd()).doDownloadAttachmentFileChunk(this._userCtx, this._contentOid, documentOid, fileDocumentRelativePath, offset, length);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
            return outArray;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MDataStoreItem[] getDocumentFolderContents(String documentOid, String folderDocumentRelativePath, boolean recursive) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "getDocumentFolderContents > contentOid=" + this._contentOid + " documentOid=" + documentOid + " folderDocumentRelativePath=" + folderDocumentRelativePath;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            R01MDataStoreItem[] outList = ((R01MContentDataManagerBzd)this.getBzd()).doGetDocumentFolderContents(this._userCtx, this._contentOid, documentOid, folderDocumentRelativePath, recursive);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
            return outList;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MDataStoreItem[] getContentFolderContents(String contentOid, boolean recursive, R01MDataStoreItemFilter filter, R01MDataStoreItemFilter readOnlyFilter) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        if (!StringUtils.isEmptyString((String)contentOid)) {
            this._contentOid = contentOid;
        }
        try {
            String opDesc = "getContentFolderContents > contentOid=" + this._contentOid;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            R01MDataStoreItem[] outList = ((R01MContentDataManagerBzd)this.getBzd()).doGetContentFolderContents(this._userCtx, this._contentOid, recursive, filter, readOnlyFilter);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
            return outList;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public Properties getDataFileAttributes(String documentOid, String dataFileOid) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "getDataFileExtendedAttributes > contentOid=" + this._contentOid + " documentOid=" + documentOid + " dataFileOid=" + dataFileOid;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            Properties outProps = ((R01MContentDataManagerBzd)this.getBzd()).doGetDataFileAttributes(this._userCtx, this._contentOid, documentOid, dataFileOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
            return outProps;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadDataFile(String documentOid, String dataFileOid, InputStream xmlData) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String wayUpload;
            String opDesc = "uploadDataFile > contentOid=" + this._contentOid + " documentOid=" + documentOid + " dataFileOid=" + dataFileOid;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            if ("chunked".equals(wayUpload = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"wayUploadFile", (String)"atOnce"))) {
                try {
                    long offset = 0L;
                    int totalLength = xmlData.available();
                    int block = R01MConstants.BUFFER_SIZE_CHUNK_MAX;
                    if (totalLength < block) {
                        block = totalLength;
                    }
                    do {
                        byte[] data = new byte[block];
                        xmlData.read(data);
                        ((R01MContentDataManagerBzd)this.getBzd()).doUploadDataFileChunk(this._userCtx, this._contentOid, documentOid, dataFileOid, data, offset);
                        if ((offset += (long)block) + (long)block <= (long)totalLength) continue;
                        block = totalLength - (int)offset;
                    } while (offset < (long)totalLength);
                }
                catch (IOException ioExc) {
                    throw new R01MContentModelException("Error al subir el archivo " + dataFileOid, (Exception)ioExc);
                }
                finally {
                    if (xmlData != null) {
                        try {
                            xmlData.close();
                        }
                        catch (IOException ex) {}
                    }
                }
            }
            ((R01MContentDataManagerBzd)this.getBzd()).doUploadDataFile(this._userCtx, this._contentOid, documentOid, dataFileOid, xmlData);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadDataFileToDocumentFolder(String documentOid, String dataFileOid, InputStream xmlData) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String wayUpload;
            String opDesc = "uploadDataFile > contentOid=" + this._contentOid + " documentOid=" + documentOid + " dataFileOid=" + dataFileOid;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            if ("chunked".equals(wayUpload = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"wayUploadFile", (String)"atOnce"))) {
                try {
                    long offset = 0L;
                    int totalLength = xmlData.available();
                    int block = R01MConstants.BUFFER_SIZE_CHUNK_MAX;
                    if (totalLength < block) {
                        block = totalLength;
                    }
                    do {
                        byte[] data = new byte[block];
                        xmlData.read(data);
                        ((R01MContentDataManagerBzd)this.getBzd()).doUploadDataFileChunkToDocumentFolder(this._userCtx, this._contentOid, documentOid, dataFileOid, data, offset);
                        if ((offset += (long)block) + (long)block <= (long)totalLength) continue;
                        block = totalLength - (int)offset;
                    } while (offset < (long)totalLength);
                }
                catch (IOException ioExc) {
                    throw new R01MContentModelException("Error al subir el archivo " + dataFileOid, (Exception)ioExc);
                }
                finally {
                    if (xmlData != null) {
                        try {
                            xmlData.close();
                        }
                        catch (IOException ex) {}
                    }
                }
            }
            ((R01MContentDataManagerBzd)this.getBzd()).doUploadDataFileToDocumentFolder(this._userCtx, this._contentOid, documentOid, dataFileOid, xmlData);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadDataFileChunk(String documentOid, String dataFileOid, byte[] xmlDataChunk, long offset) throws R01MSecurityException, R01MContentModelException, R01MBufferSizeChunkOverflowException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        if (xmlDataChunk.length > R01MConstants.BUFFER_SIZE_CHUNK_MAX) {
            throw new R01MBufferSizeChunkOverflowException("Se ha rebasado el l\u00edmite de buffer para envio de trozos de un fichero");
        }
        try {
            String opDesc = "uploadDataFileChunk > contentOid=" + this._contentOid + " documentOid=" + documentOid + " dataFileOid=" + dataFileOid;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MContentDataManagerBzd)this.getBzd()).doUploadDataFileChunk(this._userCtx, this._contentOid, documentOid, dataFileOid, xmlDataChunk, offset);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadDataFileChunkToDocumentFolder(String documentOid, String dataFileOid, byte[] xmlDataChunk, long offset) throws R01MSecurityException, R01MContentModelException, R01MBufferSizeChunkOverflowException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        if (xmlDataChunk.length > R01MConstants.BUFFER_SIZE_CHUNK_MAX) {
            throw new R01MBufferSizeChunkOverflowException("Se ha rebasado el l\u00edmite de buffer para envio de trozos de un fichero");
        }
        try {
            String opDesc = "uploadDataFileChunk > contentOid=" + this._contentOid + " documentOid=" + documentOid + " dataFileOid=" + dataFileOid;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MContentDataManagerBzd)this.getBzd()).doUploadDataFileChunkToDocumentFolder(this._userCtx, this._contentOid, documentOid, dataFileOid, xmlDataChunk, offset);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadGeneratedFile(String documentOid, String dataFileOid, String presentationTemplateOid, String presentationTemplateInstanceId, String generatedFileId, InputStream file) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String wayUpload;
            String opDesc = "uploadGeneratedFile > contentOid=" + this._contentOid + " documentOid=" + documentOid + " datafileOid=" + dataFileOid + " generatedFileId=" + generatedFileId + " (tpl=" + presentationTemplateOid + ")";
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init) " + opDesc);
            }
            if ("chunked".equals(wayUpload = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"wayUploadFile", (String)"atOnce"))) {
                try {
                    long offset = 0L;
                    int totalLength = file.available();
                    int block = R01MConstants.BUFFER_SIZE_CHUNK_MAX;
                    if (totalLength < block) {
                        block = totalLength;
                    }
                    do {
                        byte[] data = new byte[block];
                        file.read(data);
                        ((R01MContentDataManagerBzd)this.getBzd()).doUploadGeneratedFileChunk(this._userCtx, this._contentOid, documentOid, dataFileOid, presentationTemplateOid, presentationTemplateInstanceId, generatedFileId, data, offset);
                        if ((offset += (long)block) + (long)block <= (long)totalLength) continue;
                        block = totalLength - (int)offset;
                    } while (offset < (long)totalLength);
                }
                catch (IOException ioExc) {
                    throw new R01MContentModelException("Error al subir el archivo " + dataFileOid, (Exception)ioExc);
                }
                finally {
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (IOException ex) {}
                    }
                }
            }
            ((R01MContentDataManagerBzd)this.getBzd()).doUploadGeneratedFile(this._userCtx, this._contentOid, documentOid, dataFileOid, presentationTemplateOid, presentationTemplateInstanceId, generatedFileId, file);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadGeneratedFileChunk(String documentOid, String dataFileOid, String presentationTemplateOid, String presentationTemplateInstanceId, String generatedFileId, byte[] fileChunk, long offset) throws R01MSecurityException, R01MContentModelException, R01MBufferSizeChunkOverflowException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        if (fileChunk.length > R01MConstants.BUFFER_SIZE_CHUNK_MAX) {
            throw new R01MBufferSizeChunkOverflowException("Se ha rebasado el l\u00edmite de buffer para envio de trozos de un fichero");
        }
        try {
            String opDesc = "uploadGeneratedFileChunk > contentOid=" + this._contentOid + " documentOid=" + documentOid + " datafileOid=" + dataFileOid + " generatedFileId=" + generatedFileId + " (tpl=" + presentationTemplateOid + ")";
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init) " + opDesc);
            }
            ((R01MContentDataManagerBzd)this.getBzd()).doUploadGeneratedFileChunk(this._userCtx, this._contentOid, documentOid, dataFileOid, presentationTemplateOid, presentationTemplateInstanceId, generatedFileId, fileChunk, offset);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadGeneratedFileChunk(String documentOid, String dataFileOid, String presentationTemplateOid, String presentationTemplateInstanceId, byte[] fileChunk, long offset) throws R01MSecurityException, R01MContentModelException, R01MBufferSizeChunkOverflowException {
        this.uploadGeneratedFileChunk(documentOid, dataFileOid, presentationTemplateOid, presentationTemplateInstanceId, null, fileChunk, offset);
    }

    public void uploadAttachmentFile(String documentOid, String attachmentDocumentRelativePath, InputStream attach) throws R01MSecurityException, R01MContentModelException {
        this.uploadAttachmentFile(documentOid, attachmentDocumentRelativePath, attach, false);
    }

    public void uploadAttachmentFile(String documentOid, String attachmentDocumentRelativePath, InputStream attach, boolean useChunked) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        if (StringUtils.isEmptyString((String)attachmentDocumentRelativePath) || attachmentDocumentRelativePath.trim().equals("/")) {
            return;
        }
        try {
            String opDesc = "uploadAttachmentFile > contentOid=" + this._contentOid + " documentOid=" + documentOid + " attachmentDocumentRelativePath=" + attachmentDocumentRelativePath;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init) " + opDesc);
            }
            String wayUpload = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"wayUploadFile", (String)"atOnce");
            if (useChunked || "chunked".equals(wayUpload)) {
                try {
                    long offset = 0L;
                    int totalLength = attach.available();
                    int block = R01MConstants.BUFFER_SIZE_CHUNK_MAX;
                    if (totalLength < block) {
                        block = totalLength;
                    }
                    do {
                        byte[] data = new byte[block];
                        attach.read(data);
                        ((R01MContentDataManagerBzd)this.getBzd()).doUploadAttachmentFileChunk(this._userCtx, this._contentOid, documentOid, attachmentDocumentRelativePath, data, offset);
                        if ((offset += (long)block) + (long)block <= (long)totalLength) continue;
                        block = totalLength - (int)offset;
                    } while (offset < (long)totalLength);
                }
                catch (IOException ioExc) {
                    throw new R01MContentModelException("Error al subir el archivo ", (Exception)ioExc);
                }
                finally {
                    if (attach != null) {
                        try {
                            attach.close();
                        }
                        catch (IOException ex) {}
                    }
                }
            }
            ((R01MContentDataManagerBzd)this.getBzd()).doUploadAttachmentFile(this._userCtx, this._contentOid, documentOid, attachmentDocumentRelativePath, attach);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadAttachmentFileChunk(String documentOid, String attachmentDocumentRelativePath, byte[] attachChunk, long offset) throws R01MSecurityException, R01MContentModelException, R01MBufferSizeChunkOverflowException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        if (attachChunk.length > R01MConstants.BUFFER_SIZE_CHUNK_MAX) {
            throw new R01MBufferSizeChunkOverflowException("Se ha rebasado el l\u00edmite de buffer para envio de trozos de un fichero");
        }
        try {
            String opDesc = "uploadAttachmentFileChunk > contentOid=" + this._contentOid + " documentOid=" + documentOid + " attachmentDocumentRelativePath=" + attachmentDocumentRelativePath;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init) " + opDesc);
            }
            ((R01MContentDataManagerBzd)this.getBzd()).doUploadAttachmentFileChunk(this._userCtx, this._contentOid, documentOid, attachmentDocumentRelativePath, attachChunk, offset);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadFileInContent(String fileContentRelativePath, InputStream attach) throws R01MSecurityException, R01MContentModelException {
        this.uploadFileInContent(fileContentRelativePath, attach, false);
    }

    public void uploadFileInContent(String fileContentRelativePath, InputStream attach, boolean useChunked) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "uploadFileInContent > contentOid=" + this._contentOid + " fileContentRelativePath=" + fileContentRelativePath;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init) " + opDesc);
            }
            String wayUpload = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"wayUploadFile", (String)"atOnce");
            if (useChunked || "chunked".equals(wayUpload)) {
                try {
                    long offset = 0L;
                    int totalLength = attach.available();
                    int block = R01MConstants.BUFFER_SIZE_CHUNK_MAX;
                    if (totalLength < block) {
                        block = totalLength;
                    }
                    do {
                        byte[] data = new byte[block];
                        attach.read(data);
                        ((R01MContentDataManagerBzd)this.getBzd()).doUploadFileInContentChunk(this._userCtx, this._contentOid, fileContentRelativePath, data, offset);
                        if ((offset += (long)block) + (long)block <= (long)totalLength) continue;
                        block = totalLength - (int)offset;
                    } while (offset < (long)totalLength);
                }
                catch (IOException ioExc) {
                    throw new R01MContentModelException("Error al subir el archivo ", (Exception)ioExc);
                }
                finally {
                    if (attach != null) {
                        try {
                            attach.close();
                        }
                        catch (IOException ex) {}
                    }
                }
            }
            ((R01MContentDataManagerBzd)this.getBzd()).doUploadFileInContent(this._userCtx, this._contentOid, fileContentRelativePath, attach);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadFileInContentChunk(String fileContentRelativePath, byte[] attachChunk, long offset) throws R01MSecurityException, R01MContentModelException, R01MBufferSizeChunkOverflowException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        if (attachChunk.length > R01MConstants.BUFFER_SIZE_CHUNK_MAX) {
            throw new R01MBufferSizeChunkOverflowException("Se ha rebasado el l\u00edmite de buffer para envio de trozos de un fichero");
        }
        try {
            String opDesc = "uploadFileInContentChunk > contentOid=" + this._contentOid + " fileContentRelativePath=" + fileContentRelativePath;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init) " + opDesc);
            }
            ((R01MContentDataManagerBzd)this.getBzd()).doUploadFileInContentChunk(this._userCtx, this._contentOid, fileContentRelativePath, attachChunk, offset);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadAndExtractZipFileIntoContent(File contentZipFile) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        if (StringUtils.isEmptyString((String)this._contentOid)) {
            throw new R01MContentModelException("El identificador del contenido gestionado no es v\u00e1lido. Invocar al constructor estableciendo el identificador el contenido a gestionar.");
        }
        if (contentZipFile == null) {
            throw new R01MContentModelException("El fichero no es v\u00e1lido.");
        }
        String opDesc = "Subiendo el fichero  " + contentZipFile.getName() + " al servidor...";
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            String targetPath = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"contentManager/extractFilesDir", (String)"/datos/r01nt/file/extract/");
            R01MClientFactory.getContentAdminAPI(this._userCtx).uploadFileToServer(contentZipFile.getName(), targetPath, contentZipFile);
            ((R01MContentDataManagerBzd)this.getBzd()).doExtractZipFileIntoContent(this._userCtx, this._contentOid, contentZipFile.getName());
            if (DEBUG) {
                R01FLog.to((String)"r01m.contentAPI").info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadPublishFile(String publishFileWARelPath, ByteArrayInputStream byteArrayInputStreamFileList) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        if (StringUtils.isEmptyString((String)publishFileWARelPath) || publishFileWARelPath.trim().equals("/")) {
            return;
        }
        try {
            String opDesc = "uploadPublishFile > contentOid=" + this._contentOid + " publishFileWARelPath=" + publishFileWARelPath;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init) " + opDesc);
            }
            ((R01MContentDataManagerBzd)this.getBzd()).doUploadPublishFile(this._userCtx, this._contentOid, publishFileWARelPath, byteArrayInputStreamFileList);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public InputStream downloadPublishFile(String publishFileWARelPath) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        if (StringUtils.isEmptyString((String)publishFileWARelPath) || publishFileWARelPath.trim().equals("/")) {
            return null;
        }
        try {
            String opDesc = "downloadPublishFile > contentOid=" + this._contentOid + " publishFileWARelPath=" + publishFileWARelPath;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init) " + opDesc);
            }
            InputStream is = ((R01MContentDataManagerBzd)this.getBzd()).doDownloadPublishFile(this._userCtx, this._contentOid, publishFileWARelPath);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
            return is;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void copyAttachmentsFilesFromContent(String srcContentOid, String srcContentRelativePath, String dstContentRelativePath) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "copyAttachmentsFilesFromContent > Copiando el contenido de la carpeta " + srcContentRelativePath + " del contenido " + srcContentOid + " en el directorio " + dstContentRelativePath + " del contenido " + this._contentOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init) " + opDesc);
        }
        this.copyFilesFromContent(srcContentOid, srcContentRelativePath, dstContentRelativePath, new R01MDataStoreItemAttachmentFilter());
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
        }
    }

    public void copyFilesFromContent(String srcContentOid, String srcContentRelativePath, String dstContentRelativePath, R01MDataStoreItemFilter filter) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "copyFilesFromContent > Copiando el contenido de la carpeta " + srcContentRelativePath + " del contenido " + srcContentOid + " en el directorio " + dstContentRelativePath + " del contenido " + this._contentOid;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init) " + opDesc);
            }
            ((R01MContentDataManagerBzd)this.getBzd()).doCopyFilesFromContentToContent(this._userCtx, srcContentOid, srcContentRelativePath, this._contentOid, dstContentRelativePath, filter);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void copyAttachmentFileFromDocumentToAnother(String srcDocumentOid, String targetDocumentOid, String attachmentDocumentRelativePath) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "copyAttachmentFileFromDocumentToAnother > contentOid=" + this._contentOid + " srcDocumentOid=" + srcDocumentOid + " targetDocumentOid=" + targetDocumentOid + " attachmentDocumentRelativePath=" + attachmentDocumentRelativePath;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init) " + opDesc);
            }
            ((R01MContentDataManagerBzd)this.getBzd()).doCopyAttachmentFileFromDocumentToAnother(this._userCtx, this._contentOid, srcDocumentOid, targetDocumentOid, attachmentDocumentRelativePath);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void setDataFileAttributes(String documentOid, String dataFileOid, Properties extAttrs) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "setDataFileExtendedAttributes > contentOid=" + this._contentOid + " documentOid=" + documentOid + " dataFileOid=" + dataFileOid;
            if (extAttrs != null) {
                StringBuffer extAttrsDebugStr = new StringBuffer();
                Map.Entry<Object, Object> me2 = null;
                for (Map.Entry<Object, Object> me2 : extAttrs.entrySet()) {
                    extAttrsDebugStr.append("\t-" + me2.getKey() + "=" + me2.getValue() + "\r\n");
                }
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init) " + opDesc);
                    R01FLog.to((String)LOG_TYPE_ID).info(extAttrsDebugStr.toString());
                }
                ((R01MContentDataManagerBzd)this.getBzd()).doSetDataFileAttributes(this._userCtx, this._contentOid, documentOid, dataFileOid, extAttrs);
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
                }
            } else if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("NO SE HAN PASADO ATRIBUTOS EXTENDIDOS!!");
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void deleteDataFile(String documentOid, String dataFileOid) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "deleteDataFile > contentOid=" + this._contentOid + " documentOid=" + documentOid + " dataFileOid=" + dataFileOid;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MContentDataManagerBzd)this.getBzd()).doDeleteDataFile(this._userCtx, this._contentOid, documentOid, dataFileOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void deleteGeneratedFile(String documentOid, String dataFileOid, String presentationTemplateOid) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "deleteGeneratedFile > contentOid=" + this._contentOid + " dataFileOid=" + dataFileOid + " tpl=" + presentationTemplateOid;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MContentDataManagerBzd)this.getBzd()).doDeleteGeneratedFile(this._userCtx, this._contentOid, documentOid, dataFileOid, presentationTemplateOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void deleteAttachmentFile(String documentOid, String attachmentDocumentRelativePath) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "deleteAttachmentFile > contentOid=" + this._contentOid + " documentOid=" + documentOid + " attachmentDocumentRelativePath=" + attachmentDocumentRelativePath;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MContentDataManagerBzd)this.getBzd()).doDeleteAttachmentFile(this._userCtx, this._contentOid, documentOid, attachmentDocumentRelativePath);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void submmitDocument(String documentOid) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "submmitDocument > contentOid=" + this._contentOid + " documentOid=" + documentOid;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MContentDataManagerBzd)this.getBzd()).doSubmmitDocument(this._userCtx, this._contentOid, documentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void submmitContent(String contentOid) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "submmitDocument > contentOid=" + this._contentOid + " documentOid=" + contentOid;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MContentDataManagerBzd)this.getBzd()).doSubmmitContent(this._userCtx, this._contentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void submmitDocumentFolder(String documentOid, String folderDocumentRelativePath) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "submmitFolder > contentOid=" + this._contentOid + " documentOid=" + documentOid + " folderDocumentRelativePath=" + folderDocumentRelativePath;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MContentDataManagerBzd)this.getBzd()).doSubmmitDocumentFolder(this._userCtx, this._contentOid, documentOid, folderDocumentRelativePath);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void submmitDocumentFile(String documentOid, String fileDocumentRelativePath) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "submmitFolder > contentOid=" + this._contentOid + " documentOid=" + documentOid + " fileDocumentRelativePath=" + fileDocumentRelativePath;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MContentDataManagerBzd)this.getBzd()).doSubmmitDocumentFile(this._userCtx, this._contentOid, documentOid, fileDocumentRelativePath);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void submmitAttachmentFile(String documentOid, String fileDocumentRelativePath) throws R01MSecurityException, R01MContentModelException {
        this.submmitDocumentFile(documentOid, fileDocumentRelativePath);
    }

    public void submmitFileInContent(String fileContentRelativePath) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            String opDesc = "submmitFileInContent > contentOid=" + this._contentOid + " fileContentRelativePath=" + fileContentRelativePath;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT DATA API (init): " + opDesc);
            }
            ((R01MContentDataManagerBzd)this.getBzd()).doSubmmitFileInContent(this._userCtx, this._contentOid, fileContentRelativePath);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT DATA API (end) : " + opDesc);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del datos. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }
}

