/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.file.ResourcesLoader;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MPublisherException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MBaseLocationObject;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.contentmodel.R01MSearchedDocuments;
import com.ejie.r01m.objects.misc.R01MOperationInModelObjectResult;
import com.ejie.r01m.objects.opendata.R01MBaseOpendataPackageInterface;
import com.ejie.r01m.objects.opendata.R01MOpendataPackage;
import com.ejie.r01m.objects.opendata.R01MOpendataPackageExtended;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.services.R01MBaseAPI;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MContentModelAPI;
import com.ejie.r01m.services.bzd.R01MContentAdminBzd;
import com.ejie.r01m.utils.R01MConstants;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class R01MContentAdminAPI
extends R01MBaseAPI {
    private R01MUserContext _userCtx = null;
    private static final String LOG_TYPE_ID = "r01m.contentAPI";
    private static final String LOG_SEP_INI = "\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n";
    private static final String LOG_SEP_END = "\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\n";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.contentAPI").intValue() != Level.OFF.intValue();
    private static final String IMPORT_FILES_DIR = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"contentManager/importFilesDir", (String)"/datos/r01nt/file/import/");

    R01MContentAdminAPI() {
        super("contentAdmin");
    }

    R01MContentAdminAPI(R01MUserContext userCtx) {
        this();
        this._userCtx = userCtx;
    }

    public String loadContentDescriptor(String contentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Cargando el XML descriptor del contenido " + contentOid + "\r\nANTENCION!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\r\nUtilizar la funcion loadContentDescriptor UNICAMENTE PARA ADMINISTRACION";
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            R01MContentLocation loc = R01MClientFactory.getContentModelAPI(this._userCtx).loadContentLocation(contentOid);
            if (loc != null && R01MAuthManager.getRoleRights(loc, this._userCtx).canModify()) {
                String xml = ((R01MContentAdminBzd)this.getBzd()).doLoadContentDescriptor(this._userCtx, contentOid);
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
                return xml;
            }
            throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede cargar el descriptor del contenido " + contentOid);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void saveContentDescriptor(String contentOid, String contentXML, boolean updateDataStoreDescriptor) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Guardando el XML descriptor del contenido " + contentOid + "\r\nANTENCION!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\r\nUtilizar la funcion saveContentDescriptor UNICAMENTE PARA ADMINISTRACION";
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            R01MContentLocation loc = R01MClientFactory.getContentModelAPI(this._userCtx).loadContentLocation(contentOid);
            if (loc == null || !R01MAuthManager.getRoleRights(loc, this._userCtx).canModify()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede cargar el descriptor del contenido " + contentOid);
            }
            ((R01MContentAdminBzd)this.getBzd()).doSaveContentDescriptor(this._userCtx, contentOid, contentXML, updateDataStoreDescriptor);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public List[] publicateLocationContentsDocuments(R01MContentLocation loc, String publishRepositoryOid, int publicationType) throws R01MSecurityException, R01MPublisherException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Publicando la localizacion " + (loc != null ? loc.composeMemoCode() : "null") + "\r\nATENCION!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\r\nUtilizar la funcion publicateLocationContentsDocuments UNICAMENTE PARA ADMINISTRACION";
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            if (loc == null || !R01MAuthManager.getRoleRights(loc, this._userCtx).canAprove()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede publicar la localizacion " + (loc != null ? loc.composeMemoCode() : "null"));
            }
            ((R01MContentAdminBzd)this.getBzd()).doPublicateLocationContentsDocuments(this._userCtx, loc, publishRepositoryOid, publicationType);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return null;
    }

    public List[] publicateContentDocuments(String contentOid, String publishRepositoryOid, int publicationType) throws R01MSecurityException, R01MPublisherException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Publicando el contenido " + contentOid + "\r\nANTENCION!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\r\nUtilizar la funcion saveContentDescriptor UNICAMENTE PARA ADMINISTRACION";
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            R01MContent cont = R01MClientFactory.getContentModelAPI(this._userCtx).loadContent(contentOid);
            if (cont == null) {
                throw new R01MContentModelException("NO se ha podido cargar el contenido " + contentOid);
            }
            if (cont.getStoreLocation() == null || !R01MAuthManager.getRoleRights(cont.getStoreLocation(), this._userCtx).canAprove()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede publicar el contenido " + contentOid);
            }
            ((R01MContentAdminBzd)this.getBzd()).doPublicateContentDocuments(this._userCtx, contentOid, publishRepositoryOid, publicationType);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return null;
    }

    public List[] publicateContentDocuments(String[] contentOids, String publishRepositoryOid, int publicationType) throws R01MSecurityException, R01MPublisherException, R01MContentModelException {
        ArrayList[] outResults = null;
        if (contentOids != null) {
            outResults = new ArrayList[]{new ArrayList(), new ArrayList()};
            for (int i = 0; i < contentOids.length; ++i) {
                if (contentOids[i] == null) continue;
                List[] currContentOpResults = this.publicateContentDocuments(contentOids[i], publishRepositoryOid, publicationType);
                if (currContentOpResults[0] != null) {
                    outResults[0].addAll(currContentOpResults[0]);
                }
                if (currContentOpResults[1] == null) continue;
                outResults[1].addAll(currContentOpResults[1]);
            }
        }
        return outResults;
    }

    public List[] publicateDocuments(String documentOid, String publishRepositoryOid, int publicationType) throws R01MSecurityException, R01MPublisherException, R01MContentModelException {
        R01MContentModelAPI contentAPI = R01MClientFactory.getContentModelAPI(this._userCtx);
        return this.publicateDocuments(contentAPI.getDocumentParentContent(documentOid), documentOid, publishRepositoryOid, publicationType);
    }

    public List[] publicateDocuments(String contentOid, String documentOid, String publishRepositoryOid, int publicationType) throws R01MSecurityException, R01MPublisherException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Publicando el documento " + documentOid + "\r\n" + "ANTENCION!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\r\n" + "Utilizar la funcion publicateDocuments UNICAMENTE PARA ADMINISTRACION";
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            R01MContentModelAPI contentAPI = R01MClientFactory.getContentModelAPI(this._userCtx);
            if (!contentAPI.checkDocumentExistence(documentOid)) {
                throw new R01MContentModelException("El documento " + documentOid + " no existe.");
            }
            R01MContentLocation contLoc = contentAPI.loadContentLocation(contentOid);
            if (contLoc == null || !R01MAuthManager.getRoleRights(contLoc, this._userCtx).canAprove()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede publicar el documento " + documentOid);
            }
            ((R01MContentAdminBzd)this.getBzd()).doPublicateDocument(this._userCtx, contentOid, documentOid, publishRepositoryOid, publicationType);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return null;
    }

    public List[] generateLocationContentsDataFiles(R01MContentLocation loc) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Publicando la localizacion " + (loc != null ? loc.composeMemoCode() : "null") + "\r\nANTENCION!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\r\nUtilizar la funcion saveContentDescriptor UNICAMENTE PARA ADMINISTRACION";
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            if (loc == null || !R01MAuthManager.getRoleRights(loc, this._userCtx).canAprove()) {
                throw new R01MSecurityException("El usuario " + this._userCtx.getUserName() + " NO puede publicar la localizacion " + (loc != null ? loc.composeMemoCode() : "null"));
            }
            ((R01MContentAdminBzd)this.getBzd()).doGenerateLocationContentsDataFiles(this._userCtx, loc);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return null;
    }

    public List[] generateDatafileHTMLsBydocumentOid(String documentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Generando los HTMLs de datafiles a partir de una lista de documentos.";
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            ((R01MContentAdminBzd)this.getBzd()).doGenerateDatafileHTMLsBydocumentOid(this._userCtx, documentOid);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return null;
    }

    public List testContent(String contentOid, boolean repair) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Comprobando el contenido " + contentOid + "\r\nANTENCION!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\r\nUtilizar la funcion saveContentDescriptor UNICAMENTE PARA ADMINISTRACION";
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            List outList = ((R01MContentAdminBzd)this.getBzd()).doTestContent(this._userCtx, contentOid, repair);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            return outList;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public List testContents(String[] contentOids, boolean repair) throws R01MSecurityException, R01MContentModelException {
        ArrayList outResults = null;
        if (contentOids != null) {
            outResults = new ArrayList();
            for (int i = 0; i < contentOids.length; ++i) {
                List currContentOpResults;
                if (contentOids[i] == null || (currContentOpResults = this.testContent(contentOids[i], repair)) == null) continue;
                outResults.addAll(currContentOpResults);
            }
        }
        return outResults;
    }

    public List testLocation(R01MContentLocation loc, boolean repair) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Comprobando la localizacion " + loc.composeMemoCode() + "\r\nANTENCION!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\r\nUtilizar la funcion saveContentDescriptor UNICAMENTE PARA ADMINISTRACION";
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            List outList = ((R01MContentAdminBzd)this.getBzd()).doTestLocation(this._userCtx, loc, repair);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            return outList;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MOperationInModelObjectResult importContent(R01MContentLocation loc, String contentType, String contentName, boolean importDataFilesToSystemArea) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Importando el contenido " + contentName + " desde la workArea " + loc.composeMemoCode();
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            R01MOperationInModelObjectResult outRes = ((R01MContentAdminBzd)this.getBzd()).doImportContent(this._userCtx, loc, contentType, contentName, importDataFilesToSystemArea);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            return outRes;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public List[] importContents(R01MContentLocation loc, List contentTypesAndNames, boolean importDataFilesToSystemArea) throws R01MSecurityException, R01MContentModelException {
        ArrayList[] outResults = null;
        if (contentTypesAndNames != null) {
            outResults = new ArrayList[]{new ArrayList(), new ArrayList()};
            String[] currContentNameAndType2 = null;
            for (String[] currContentNameAndType2 : contentTypesAndNames) {
                if (currContentNameAndType2 == null || currContentNameAndType2[0] == null || currContentNameAndType2[1] == null) continue;
                R01MOperationInModelObjectResult currContentOpResults = this.importContent(loc, currContentNameAndType2[1], currContentNameAndType2[0], importDataFilesToSystemArea);
                if (currContentOpResults.isOperationOK()) {
                    outResults[0].add(currContentOpResults);
                    continue;
                }
                outResults[1].add(currContentOpResults);
            }
        }
        return outResults;
    }

    public List[] importLocationContents(R01MContentLocation loc, boolean importDataFilesToSystemArea) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Importando los contenidos de la localizacion " + loc.composeMemoCode() + "\r\nANTENCION!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\r\nUtilizar la funcion saveContentDescriptor UNICAMENTE PARA ADMINISTRACION";
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            List[] outList = ((R01MContentAdminBzd)this.getBzd()).doImportLocationContents(this._userCtx, loc, importDataFilesToSystemArea);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            return outList;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public List[] copyDataFilesFromSystemAreaToDocumentFolder(R01MContentLocation loc) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Copiando los dataFiles de los contenidos de la localizacion " + loc.composeMemoCode() + " desde el area de sistema a la estructura de carpetas del documento.\r\nANTENCION!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\r\nUtilizar la funcion saveContentDescriptor UNICAMENTE PARA ADMINISTRACION";
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            List[] outList = ((R01MContentAdminBzd)this.getBzd()).doCopyDataFilesFromSystemAreaToDocumentFolder(this._userCtx, loc);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            return outList;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void importContentsFromFile(File file, String prefix) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        if (prefix == null) {
            prefix = "";
        }
        if (file == null) {
            throw new R01MContentModelException("El fichero es nulo");
        }
        try {
            String opDesc = "Importando los CONTENIDOS almacenados en el fichero de importaci\u00f3n " + file.getName();
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            String targetPath = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"contentManager/importFilesDir", (String)"/datos/r01nt/file/import/");
            this.uploadFileToServer(file.getName(), targetPath, file);
            ((R01MContentAdminBzd)this.getBzd()).doImportContentsFromZipFile(this._userCtx, file.getName(), prefix);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void importContentsFromFile(InputStream file, String fileName, String prefix) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        if (prefix == null) {
            prefix = "";
        }
        if (file == null) {
            throw new R01MContentModelException("El fichero es nulo");
        }
        try {
            String opDesc = "Importando los CONTENIDOS almacenados en el fichero de importaci\u00f3n ";
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            String targetPath = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"contentManager/importFilesDir", (String)"/datos/r01nt/file/import/");
            this.uploadFileToServer(fileName, targetPath, file);
            ((R01MContentAdminBzd)this.getBzd()).doImportContentsFromZipFile(this._userCtx, fileName, prefix);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void importAttachmentsFromFile(String fileToImportName, String contentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Importando adjuntos del contenido " + contentOid;
        if (StringUtils.isEmptyString((String)fileToImportName)) {
            throw new R01MContentModelException("El nombre del fichero no es v\u00e1lido.");
        }
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            ((R01MContentAdminBzd)this.getBzd()).doImportAttachments(this._userCtx, fileToImportName, contentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void importAttachmentsFromFile(File file, String contentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Importando adjuntos del contenido " + contentOid;
        if (file == null) {
            throw new R01MContentModelException("El fichero es nulo");
        }
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            }
            this.uploadFileToServer(file.getName(), IMPORT_FILES_DIR, file);
            ((R01MContentAdminBzd)this.getBzd()).doImportAttachments(this._userCtx, file.getName(), contentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void exportContentToFile(String contentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Generando el empaquetado del contenido " + contentOid;
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            ((R01MContentAdminBzd)this.getBzd()).doExportContentToFile(this._userCtx, contentOid);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void exportQueryToFile(R01MQueryObject query, String fileName, R01MBaseLocationObject targetLocation, String waRelativePath, boolean exportAttachments) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Generacion del empaquetado de contenidos para la busqueda: " + query.composeDebugInfo() + " en el directorio " + waRelativePath + " de la WA " + targetLocation.composeMemoCode() + (exportAttachments ? " con adjuntos." : " sin adjuntos.");
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            ((R01MContentAdminBzd)this.getBzd()).doExportQueryToFile(this._userCtx, query, fileName, targetLocation, waRelativePath, exportAttachments);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void uploadFileToServer(String fileName, String dstDirAbsolutePath, File file) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Subir el archivo  " + fileName + " al directorio " + dstDirAbsolutePath + " del servidor.";
        R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
        InputStream stream = null;
        try {
            stream = ResourcesLoader.getResourceFileAsStream((String)file.getAbsolutePath());
        }
        catch (FileNotFoundException ex) {
            throw new R01MContentModelException("Fichero no encontrado: " + ex.getMessage());
        }
        this.uploadFileToServer(fileName, dstDirAbsolutePath, stream);
        R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
    }

    public void uploadFileToServer(String fileName, String dstDirAbsolutePath, InputStream file) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Subir el archivo  " + fileName + " al directorio " + dstDirAbsolutePath + " del servidor.";
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            try {
                byte[] buffer = null;
                String numKb = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"upload/transferNumKb", (String)"10");
                int sizeOfbytesToRead = Integer.parseInt(numKb) * 1024;
                buffer = new byte[sizeOfbytesToRead];
                int byteRead = 0;
                int totalBytesRead = 0;
                while (file.available() > 0) {
                    if (sizeOfbytesToRead < file.available()) {
                        byteRead = file.read(buffer, 0, sizeOfbytesToRead);
                    } else {
                        int read = file.available();
                        buffer = new byte[read];
                        byteRead = file.read(buffer, 0, read);
                    }
                    ((R01MContentAdminBzd)this.getBzd()).doUploadFileToServer(this._userCtx, fileName, dstDirAbsolutePath, buffer, totalBytesRead);
                    totalBytesRead += byteRead;
                }
            }
            catch (IOException io) {
                throw new R01MContentModelException("Error al subir el fichero: " + io.getMessage());
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (IOException ex) {
                        throw new R01MContentModelException("Error al cerrar el stream: " + ex.getMessage());
                    }
                }
            }
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public void generateContentXMLDescriptorFromDBRecords(String contentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Migrando el contenido " + contentOid;
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            ((R01MContentAdminBzd)this.getBzd()).doGenerateContentXMLDescriptorFromDBRecords(this._userCtx, contentOid);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public List[] generateLocationContentsXMLDescriptorFromDBRecords(R01MContentLocation loc) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Migrando los contenidos de la localizacion " + loc.composeMemoCode() + "\r\nANTENCION!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\r\nUtilizar la funcion saveContentDescriptor UNICAMENTE PARA ADMINISTRACION";
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            List[] outList = ((R01MContentAdminBzd)this.getBzd()).doGenerateLocationContentsXMLDescriptorFromDBRecords(this._userCtx, loc);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            return outList;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public final void saveOpendataPackage(R01MOpendataPackage opendataPackage) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Guardando empaquetado " + opendataPackage.getOid() + " con nombre " + opendataPackage.getNamePackage();
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            ((R01MContentAdminBzd)this.getBzd()).doSaveOpendataPackage(this._userCtx, opendataPackage);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public final boolean deleteOpendataPackage(String opendataPackageOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Borrando el empaquetado " + opendataPackageOid;
        boolean result = false;
        if (StringUtils.isEmptyString((String)opendataPackageOid)) {
            R01FLog.to((String)LOG_TYPE_ID).warning("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (end): Identificador de empaquetado vacio.");
        } else {
            try {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
                result = ((R01MContentAdminBzd)this.getBzd()).doDeleteOpendataPackage(this._userCtx, opendataPackageOid);
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            }
            catch (BzdConfigException bzdCfgEx) {
                throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
            }
        }
        return result;
    }

    public final List loadOpendataPackages() throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = " Cargando los empaquetados opendata ";
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            List outList = ((R01MContentAdminBzd)this.getBzd()).doLoadOpendataPackages(this._userCtx);
            R01MOpendataPackage elemento2 = null;
            if (outList == null) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + " --> Listado: No hay registros" + LOG_SEP_END);
            } else {
                for (R01MOpendataPackage elemento2 : outList) {
                    R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + " --> Listado: " + elemento2.getOid() + LOG_SEP_END);
                }
            }
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            return outList;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public final List<R01MOpendataPackageExtended> loadOpendataPackagesExtended() throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = " Cargando los empaquetados opendata ";
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            List<R01MOpendataPackageExtended> outList = ((R01MContentAdminBzd)this.getBzd()).doLoadOpendataPackagesExtended(this._userCtx);
            R01MOpendataPackageExtended elemento2 = null;
            if (outList == null) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + " --> Listado: No hay registros" + LOG_SEP_END);
            } else {
                for (R01MOpendataPackageExtended elemento2 : outList) {
                    R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + " --> Listado: " + elemento2.getOid() + LOG_SEP_END);
                }
            }
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            return outList;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public final List loadOpendataPackagesByContent(String contentOid) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = " Cargando los empaquetados opendata para el contenido " + contentOid;
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            List outList = ((R01MContentAdminBzd)this.getBzd()).doLoadOpendataPackagesByContent(this._userCtx, contentOid);
            R01MOpendataPackage elemento2 = null;
            if (outList == null) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + " --> Listado: No hay registros" + LOG_SEP_END);
            } else {
                for (R01MOpendataPackage elemento2 : outList) {
                    R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + " --> Listado: " + elemento2.getOid() + LOG_SEP_END);
                }
            }
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            return outList;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public R01MBaseOpendataPackageInterface loadOpendataPackage(String oidPackage) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Cargando los empaquetados opendata " + oidPackage;
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            R01MBaseOpendataPackageInterface packageInterface = ((R01MContentAdminBzd)this.getBzd()).doLoadOpendataPackage(this._userCtx, oidPackage);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            return packageInterface;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public final List loadOpendataPackagesActivedAndProcessed() throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = " Cargando los empaquetados opendata activos y ya procesados correctamente";
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            List outList = ((R01MContentAdminBzd)this.getBzd()).doLoadOpendataPackagesActivedAndProcessed(this._userCtx);
            R01MOpendataPackage elemento2 = null;
            if (outList == null) {
                R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + " --> Listado: No hay registros" + LOG_SEP_END);
            } else {
                for (R01MOpendataPackage elemento2 : outList) {
                    R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + " --> Listado: " + elemento2.getOid() + LOG_SEP_END);
                }
            }
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            return outList;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public List executedOpendataPackages() throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Ejecutando los empaquetados opendata ";
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            List activePackages = ((R01MContentAdminBzd)this.getBzd()).doExecutedOpendataPackages(this._userCtx);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            return activePackages;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public List loadActiveOpendataPackages(String lang) throws R01MSecurityException, R01MContentModelException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        String opDesc = "Ejecutando los empaquetados opendata ";
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            List activePackages = ((R01MContentAdminBzd)this.getBzd()).doLoadActiveOpendataPackages(this._userCtx, lang);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            return activePackages;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public String getComboOptions(String lang, String comboId, String useHTMLFieldAsKey) throws R01MContentModelException {
        try {
            String opDesc = "Cargando el combo con id:" + comboId;
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            String options = ((R01MContentAdminBzd)this.getBzd()).doLoadComboOptions(lang, comboId, useHTMLFieldAsKey);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            return options;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public String getComboOptions(String lang, String comboId, String useHTMLFieldAsKey, String orderCriterium) throws R01MContentModelException {
        try {
            String opDesc = "Cargando el combo con id:" + comboId;
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            String options = ((R01MContentAdminBzd)this.getBzd()).doLoadComboOptions(lang, comboId, useHTMLFieldAsKey, orderCriterium);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            return options;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public Map getComboOptionsMap(String lang, String comboId, String useHTMLFieldAsKey) throws R01MContentModelException {
        try {
            String opDesc = "Cargando el combo con id:" + comboId;
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            Map options = ((R01MContentAdminBzd)this.getBzd()).doLoadComboOptionsMap(lang, comboId, useHTMLFieldAsKey);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            return options;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public Map getComboOptionsMap(String lang, String comboId, String useHTMLFieldAsKey, String orderCriterium) throws R01MContentModelException {
        try {
            String opDesc = "Cargando el combo con id:" + comboId;
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            Map options = ((R01MContentAdminBzd)this.getBzd()).doLoadComboOptionsMap(lang, comboId, useHTMLFieldAsKey, orderCriterium);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            return options;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public String getComboOptionDescription(String lang, String comboId, String comboOptionId, String useHTMLFieldAsKey) throws R01MContentModelException {
        try {
            String opDesc = "Cargando la opcion con clave " + comboOptionId + " combo con id:" + comboId;
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            String option = ((R01MContentAdminBzd)this.getBzd()).doLoadComboOptionDescription(lang, comboId, comboOptionId, useHTMLFieldAsKey);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
            return option;
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
    }

    public List searchDocuments(R01MSearchedDocuments srchDocsCriteria) throws R01MContentModelException {
        String opDesc = "B\u00fasqueda de los documentos.";
        List docResults = null;
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            R01FLog.to((String)LOG_TYPE_ID).info(" por los siguientes criterios " + srchDocsCriteria.debugInfo(""));
            docResults = ((R01MContentAdminBzd)this.getBzd()).doSearchDocuments(srchDocsCriteria);
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return docResults;
    }

    public List getAllowedTargetsToPublishDocuments() throws R01MContentModelException {
        List allowedTargets;
        String opDesc = "Repositorios de publicaci\u00f3n disponibles para publicar contenidos.";
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            allowedTargets = ((R01MContentAdminBzd)this.getBzd()).doGetAllowedTargetsToPublishDocuments();
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return allowedTargets;
    }

    public List getAllowedTargetsAndNamesToPublishDocuments() throws R01MContentModelException {
        List allowedTargets;
        String opDesc = "Repositorios de publicaci\u00f3n disponibles para publicar contenidos.";
        try {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
            allowedTargets = ((R01MContentAdminBzd)this.getBzd()).doGetAllowedTargetsAndNamesToPublishDocuments();
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc + LOG_SEP_END);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MContentModelException("Error en la configuracion del businessDelegate del modelo de contenido. Revisa la configuracion", (Exception)((Object)bzdCfgEx));
        }
        return allowedTargets;
    }

    private boolean _validateContext(R01MUserContext userCtx) {
        return userCtx != null;
    }
}

