/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelsPacket;
import com.ejie.r01m.config.objects.cataloguing.R01MPacketInfo;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MCatalogElementNotFoundException;
import com.ejie.r01m.exceptions.R01MCatalogElementNotRemovableException;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MCatalogModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MDuplicateCatalogElementException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.cataloguing.structures.R01MBag;
import com.ejie.r01m.objects.cataloguing.structures.R01MBagGroup;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabel;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabelSearchFilter;
import com.ejie.r01m.objects.cataloguing.structures.R01MRelation;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructure;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructureDefinition;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructureItem;
import com.ejie.r01m.services.R01MBaseAPI;
import com.ejie.r01m.services.R01MCatalogCachesAPI;
import com.ejie.r01m.services.bzd.R01MCatalogManagerBzd;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.catalog.R01MCatalogModelObjectsValidator;
import com.ejie.r01m.utils.catalog.R01MCatalogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class R01MCatalogManagerAPI
extends R01MBaseAPI {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.catalogAPI").intValue() != Level.OFF.intValue();
    private static final String LOG_SEP_INI = "\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n";
    private static final String LOG_SEP_END = "\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\n";
    public static final String WITHOUT_TERM = "**Sin t&eacute;rmino**";
    public static final String WITHOUT_BAGGROUP = "**Sin Agrupaci&oacute;n**";
    public static final String WITHOUT_DESCRIPTION = "** Sin descripci&oacute;n **";
    public static final String CTE_LABEL_GUID = "root";
    public static final String CTE_STRUCTURE_GUID = "0";
    public static final String CTE_BAG_GUID = "-1";
    private transient R01MUserContext _userCtx = null;
    private static R01MCatalogCachesAPI _cachesAPI = new R01MCatalogCachesAPI();
    private static Map<String, Integer> labelsBlacklist = new HashMap<String, Integer>();
    private static Map<String, Integer> structuresBlacklist = new HashMap<String, Integer>();
    private static final int MAX_FAULT_REQUESTS_TO_LOCK = 3;
    private static final String ENV_ZONE = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"environment/zone", (String)"extranet");
    private static boolean isInternetZone;

    public R01MCatalogManagerAPI() {
        super("catalogManager");
        isInternetZone = false;
        if (ENV_ZONE.equalsIgnoreCase("internet")) {
            isInternetZone = true;
        }
    }

    public R01MCatalogManagerAPI(R01MUserContext theUserCtx) {
        super("catalogManager");
        this._userCtx = theUserCtx;
        isInternetZone = false;
        if (ENV_ZONE.equalsIgnoreCase("internet")) {
            isInternetZone = true;
        }
    }

    public boolean checkBagExistence(String bagOid, boolean useGuid) throws R01MCatalogException {
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doCheckBagExistence(bagOid, useGuid);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public R01MBag loadBag(String bagOid) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        return this.loadBag(bagOid, true);
    }

    public R01MBag loadBag(String bagOid, boolean forceServer) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        R01MBag bag = null;
        if (!StringUtils.isEmptyString((String)bagOid)) {
            try {
                if (!forceServer) {
                    bag = _cachesAPI.getBagFromCache(bagOid);
                }
                if (bag == null) {
                    bag = ((R01MCatalogManagerBzd)this.getBzd()).doLoadBag(bagOid);
                }
            }
            catch (BzdConfigException bzdConfigEx) {
                throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
            }
        }
        return bag;
    }

    public R01MBag loadBag(int bagId) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadBag(bagId);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public R01MBag loadBagByXlnetsUid(String xlnetsBagUid) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        R01MBag bag = null;
        if (!StringUtils.isEmptyString((String)xlnetsBagUid)) {
            try {
                bag = ((R01MCatalogManagerBzd)this.getBzd()).doLoadBagByXlnetsUid(xlnetsBagUid);
            }
            catch (BzdConfigException bzdConfigEx) {
                throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
            }
        }
        return bag;
    }

    public String getBagOidFromXlNetsUid(String xlnetsBagUid) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doGetBagOidFromXlNetsUid(xlnetsBagUid);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public List<R01MBag> loadBags() throws R01MCatalogException {
        return this.loadBags(null, true);
    }

    public List<R01MBag> loadBags(String languageCode) throws R01MCatalogException {
        return this.loadBags(languageCode, true);
    }

    public List<R01MBag> loadBags(String languageCode, boolean forceServer) throws R01MCatalogException {
        String opDesc = "Cargando todas las bolsas de catalogaci\u00f3n. forceServer = " + forceServer;
        if (DEBUG) {
            R01FLog.to((String)"r01m.portalAPI").info("\r\n\r\n\r\n\r\n\r\n\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\nCLIENT API (init): " + opDesc);
        }
        List bagsList = null;
        try {
            if (!forceServer) {
                bagsList = _cachesAPI.getAllBags(languageCode);
            }
            if (bagsList == null) {
                bagsList = ((R01MCatalogManagerBzd)this.getBzd()).doLoadBags(languageCode);
            }
            R01FLog.to((String)"r01m.portalAPI").info("\r\n:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::\r\n\r\n\r\n\r\n\r\n\r\nCLIENT API (end): " + opDesc);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
        return bagsList;
    }

    public List<String> getAllBagXLNetsUids() throws R01MCatalogException {
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doGetAllBagXLNetsUids();
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public int saveBag(R01MBag theBag) throws R01MSecurityException, R01MDuplicateCatalogElementException, R01MCatalogModelObjectsValidatorException, R01MCatalogException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        R01MCatalogModelObjectsValidator.validateBag(theBag);
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doSaveBag(this._userCtx, theBag);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public R01MBag loadBagWithLabel(String labelOid) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadBagWithLabel(labelOid);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public R01MBag loadBagWithStructure(String structureOid) throws R01MCatalogException, R01MCatalogElementNotFoundException {
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadBagWithStructure(structureOid);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public R01MLabel loadLabel(String labelOid) throws R01MCatalogException {
        return this.loadLabel(labelOid, true);
    }

    public R01MLabel loadLabel(String labelOid, boolean forceServer) throws R01MCatalogException {
        try {
            R01MLabel label = null;
            if (!forceServer) {
                label = _cachesAPI.getLabelFromCache(labelOid);
            }
            if (label != null) {
                return label;
            }
            if (isInternetZone && labelsBlacklist.containsKey(labelOid) && labelsBlacklist.get(labelOid) == 3) {
                return null;
            }
            label = ((R01MCatalogManagerBzd)this.getBzd()).doLoadLabel(labelOid);
            if (label == null && isInternetZone) {
                System.out.println("[ERROR] >>>>>>>>>>>>>> La etiqueta de oid " + labelOid + " no existe!!!!!!!!!");
                if (!labelsBlacklist.containsKey(labelOid)) {
                    labelsBlacklist.put(labelOid, 1);
                } else if (labelsBlacklist.get(labelOid) < 3) {
                    int val = labelsBlacklist.get(labelOid) + 1;
                    labelsBlacklist.put(labelOid, val);
                }
            }
            return label;
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public R01MLabel loadLabelByExtOID(String extOid) throws R01MCatalogException, R01MCatalogElementNotFoundException {
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadLabelByExtOID(extOid);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public List loadOrderedLabels(String languageCode) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        return this.loadOrderedLabels(null, languageCode);
    }

    public List loadOrderedLabels(String bagOid, String languageCode) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadOrderedLabels(bagOid, languageCode);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public List loadLabels(String bagOid) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        return this.loadLabels(bagOid, true);
    }

    public List loadLabels(String bagOid, boolean forceServer) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        try {
            List labels = null;
            if (!forceServer) {
                labels = _cachesAPI.getAllLabels();
            }
            if (labels != null) {
                return labels;
            }
            labels = ((R01MCatalogManagerBzd)this.getBzd()).doLoadLabels(bagOid);
            return labels;
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public R01MLabel loadLabel(int labelId) throws R01MCatalogException {
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadLabel(labelId);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public int saveLabel(String bagOid, R01MLabel label) throws R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogModelObjectsValidatorException, R01MCatalogException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        R01MCatalogModelObjectsValidator.validateLabel(label);
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doSaveLabel(this._userCtx, bagOid, label);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public void removeLabel(String bagOid, String labelOid) throws R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogElementNotRemovableException, R01MCatalogException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            ((R01MCatalogManagerBzd)this.getBzd()).doRemoveLabel(this._userCtx, bagOid, labelOid);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public void moveLabelToBag(String labelGuid, String bagGuid, String newBagGuid) throws R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            ((R01MCatalogManagerBzd)this.getBzd()).doMoveLabelToBag(this._userCtx, labelGuid, bagGuid, newBagGuid);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public void moveLabel(String bagOid, String structureGuid, String labelGuid, int relationId, int role, String structureGuidTarget, int targetStructureId, int targetLabelId, int targetRelationId, int targetRole) throws R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            ((R01MCatalogManagerBzd)this.getBzd()).doMoveLabel(this._userCtx, bagOid, structureGuid, labelGuid, relationId, role, structureGuidTarget, targetStructureId, targetLabelId, targetRelationId, targetRole);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public List loadSearchLabel(R01MLabelSearchFilter searchCriteriaObj) throws R01MCatalogException, R01MSecurityException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadSearchLabel(searchCriteriaObj);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public List loadLabelInStructureWithRole(String structureOid, String labelOid, int role) throws R01MCatalogException, R01MSecurityException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadLabelInStructureWithRole(structureOid, labelOid, role);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public R01MStructure loadStructure(String structureOid) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        return this.loadStructure(structureOid, true);
    }

    public R01MStructure loadStructure(String structureOid, boolean forceServer) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        try {
            R01MStructure structure = null;
            if (!forceServer) {
                structure = _cachesAPI.getStructureFromCache(structureOid);
            }
            if (structure != null) {
                return structure;
            }
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadStructure(structureOid);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public R01MStructure loadStructure(String structureOid, String languageTerm, int numRolesToReturn) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        return this.loadStructure(structureOid, languageTerm, 0, numRolesToReturn, true);
    }

    public R01MStructure loadStructure(String structureOid, String languageTerm, int relationParentId, int numRolesToReturn, boolean forceServer) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        try {
            R01MStructure structure = null;
            if (!forceServer) {
                structure = _cachesAPI.getStructureFromCache(structureOid);
            }
            if (structure != null) {
                return structure;
            }
            structure = ((R01MCatalogManagerBzd)this.getBzd()).doLoadStructure(structureOid, languageTerm, relationParentId, numRolesToReturn);
            return structure;
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public List loadStructuresWithLabel(String labelOid) throws R01MCatalogException {
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadStructuresWithLabel(labelOid);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public R01MStructureDefinition loadStructureDefinition(String structureOid) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        return this.loadStructureDefinition(structureOid, true);
    }

    public R01MStructureDefinition loadStructureDefinition(String structureOid, boolean forceServer) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        try {
            R01MStructure structure = null;
            if (!forceServer) {
                structure = _cachesAPI.getStructureFromCache(structureOid);
            }
            if (structure != null) {
                return structure.getSDefinition();
            }
            if (isInternetZone && structuresBlacklist.containsKey(structureOid) && structuresBlacklist.get(structureOid) == 3) {
                return null;
            }
            R01MStructureDefinition structureDef = ((R01MCatalogManagerBzd)this.getBzd()).doLoadStructureDefinition(structureOid);
            if (structureDef == null && isInternetZone && labelsBlacklist.get(structureOid) < 3) {
                int val = labelsBlacklist.get(structureOid) + 1;
                labelsBlacklist.put(structureOid, val);
            }
            return structureDef;
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public List loadStructureDefinitions(List bagsOids, char structureType, char structureStatus) throws R01MCatalogException {
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadStructureDefinitions(bagsOids, structureType, structureStatus);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public List loadStructuresInBag(String bagOid, char structureType, char structureStatus) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        return this.loadStructuresInBag(bagOid, structureType, structureStatus, R01MConstants.DEFAULT_LANG, true);
    }

    public List loadStructuresInBag(String bagOid, char structureType, char structureStatus, String languageCode) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        return this.loadStructuresInBag(bagOid, structureType, structureStatus, languageCode, true, -1);
    }

    public List loadStructuresInBag(String bagOid, char structureType, char structureStatus, String languageCode, boolean forceServer) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        return this.loadStructuresInBag(bagOid, structureType, structureStatus, languageCode, -1);
    }

    public List loadStructuresInBag(String bagOid, char structureType, char structureStatus, String languageCode, int maxRole) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        return this.loadStructuresInBag(bagOid, structureType, structureStatus, languageCode, true, maxRole);
    }

    public List loadStructuresInBag(String bagOid, char structureType, char structureStatus, String languageCode, boolean forceServer, int maxRole) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        try {
            List structures = null;
            if (!forceServer) {
                structures = _cachesAPI.getStructuresInBagFromCache(bagOid, structureType);
            }
            if (structures != null) {
                return structures;
            }
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadStructuresInBag(bagOid, structureType, structureStatus, languageCode, maxRole);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public List getLabelsInItsStructures(String[] labelOids) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        List branch;
        try {
            branch = ((R01MCatalogManagerBzd)this.getBzd()).doGetLabelsInItsStructures(labelOids);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
        return branch;
    }

    public List loadBranches(List branchCriteria) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        List branches;
        try {
            branches = ((R01MCatalogManagerBzd)this.getBzd()).doLoadBranches(branchCriteria);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
        return branches;
    }

    public List getStructuresConfig(String propXPath) throws R01MCatalogException {
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doGetStructuresConfig(propXPath);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public List loadChildren(List nodes) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadChildren(nodes, false);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public List loadChildRelations(String structureOid, int relationId, String languageTerm) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        List children = null;
        try {
            children = ((R01MCatalogManagerBzd)this.getBzd()).doLoadChildRelations(structureOid, relationId, languageTerm);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
        return children;
    }

    public List loadChildrenOrdered(List nodes) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadChildren(nodes, true);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public List loadSimilarLabels(String labelOid) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadSimilarLabels(labelOid);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public List loadSimilarRelations(String labelOid) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadSimilarRelations(labelOid);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public List loadSimilarBidirectionalRelations(String labelOid) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadSimilarBidirectionalRelations(labelOid);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public int addRelation(String bagOid, R01MRelation relation, int role) throws R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogModelObjectsValidatorException, R01MCatalogException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        R01MCatalogModelObjectsValidator.validateRelation(relation);
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doAddRelation(this._userCtx, bagOid, relation, role);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public int addBidirectionalRelation(String bagOid, R01MRelation relation, int role) throws R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogModelObjectsValidatorException, R01MCatalogException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        R01MCatalogModelObjectsValidator.validateRelation(relation);
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doAddBidirectionalRelation(this._userCtx, bagOid, relation, role);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public void removeRelation(String bagOid, int role, int relationId) throws R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            ((R01MCatalogManagerBzd)this.getBzd()).doRemoveRelation(this._userCtx, bagOid, role, relationId);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public void updateOrderRelations(String bagOid, List relations) throws R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogException {
        try {
            ((R01MCatalogManagerBzd)this.getBzd()).doUpdateOrderRelations(this._userCtx, bagOid, relations);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public List validateLabelsInOtherStructure(String structureGuid) throws R01MCatalogException {
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doValidateLabelsInOtherStructure(structureGuid);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public int saveStructure(String bagOid, R01MStructure structure) throws R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogModelObjectsValidatorException, R01MCatalogException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        R01MCatalogModelObjectsValidator.validateStructure(structure);
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doSaveStructure(this._userCtx, structure, bagOid);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public void removeStructure(String bagOid, String structureOid) throws R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            ((R01MCatalogManagerBzd)this.getBzd()).doRemoveStructure(this._userCtx, bagOid, structureOid);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public void moveStructure(String structureGuid, String bagGuid, String newBagGuid) throws R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            ((R01MCatalogManagerBzd)this.getBzd()).doMoveStructure(this._userCtx, structureGuid, bagGuid, newBagGuid);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public List loadPackets() throws R01MSecurityException, R01MCatalogException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadPacketsInfo(this._userCtx);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public Map loadPacketAdminInfo() throws R01MSecurityException, R01MCatalogException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadPacketAdminInfo(this._userCtx);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public R01MPacketInfo loadPacket(String packetOid) throws R01MSecurityException, R01MCatalogException, R01MCatalogElementNotFoundException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadPacketInfo(this._userCtx, packetOid);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public void launchPacket(String packetOid, int numOperations, List listeners, int typeProccessor, boolean forceProcessor) throws R01MSecurityException, R01MCatalogException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            ((R01MCatalogManagerBzd)this.getBzd()).doLaunchPacket(this._userCtx, packetOid, numOperations, listeners, typeProccessor, forceProcessor);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public List previewReport(String packetOid, int numOperations, String system) throws R01MSecurityException, R01MCatalogException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doPreviewReport(this._userCtx, packetOid, numOperations, system);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public void archivePacket(String packetOid) throws R01MSecurityException, R01MCatalogException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            ((R01MCatalogManagerBzd)this.getBzd()).doMovePacketToHistory(this._userCtx, packetOid);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public void executeRecatalogationProcess(R01MChangesLabelsPacket packet) throws R01MSecurityException, R01MCatalogException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            ((R01MCatalogManagerBzd)this.getBzd()).doExecuteRecatalogationProcess(this._userCtx, packet);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public R01MStructureItem getStructureItem(String structureOid, String labelChildGuid, int role) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        return this.getStructureItem(structureOid, labelChildGuid, role, true);
    }

    public R01MStructureItem getStructureItem(String structureOid, String labelChildGuid, int role, boolean forceServer) throws R01MCatalogElementNotFoundException, R01MCatalogException {
        R01MStructureItem structureItem = null;
        if (!forceServer) {
            structureItem = _cachesAPI.getStructureItemFromCache(structureOid, labelChildGuid, role);
        }
        if (structureItem != null) {
            return structureItem;
        }
        R01MStructure structure = this.loadStructure(structureOid, "es", role);
        structureItem = this.findStructureItem(structure.getStructureItems(), labelChildGuid, role);
        if (structureItem == null) {
            throw new R01MCatalogElementNotFoundException("La etiqueta " + labelChildGuid + " no existe en la estructura " + structureOid + " al nivel " + role);
        }
        return structureItem;
    }

    private R01MStructureItem findStructureItem(Map structureItems, String labelOidToFind, int role) {
        R01MStructureItem structureItem = null;
        for (Map.Entry me : structureItems.entrySet()) {
            R01MStructureItem structureItemTemp = (R01MStructureItem)me.getValue();
            if (structureItemTemp.getRootLabelOid().equals(labelOidToFind) && (structureItemTemp.getRole() == role || role == -1)) {
                return structureItemTemp;
            }
            if (structureItemTemp.getChildren() == null || structureItemTemp.getChildren().size() <= 0 || structureItemTemp.getRole() >= role && role != -1 || (structureItem = this.findStructureItem(structureItemTemp.getChildren(), labelOidToFind, role)) == null) continue;
            return structureItem;
        }
        return null;
    }

    public R01MBagGroup loadBagGroup(int bagGroupId, String userLang) throws R01MSecurityException, R01MCatalogException, R01MCatalogElementNotFoundException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadBagGroup(bagGroupId, userLang);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public List<R01MBagGroup> loadBagGroups(String userLang) throws R01MSecurityException, R01MCatalogException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadBagGroups(userLang);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public int saveBagGroup(R01MBagGroup theBagGroup) throws R01MSecurityException, R01MDuplicateCatalogElementException, R01MCatalogModelObjectsValidatorException, R01MCatalogException {
        if (theBagGroup == null || !this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El objeto de grupo de bolsas es NULO o el contexto de usuario NO es valido!");
        }
        R01MCatalogModelObjectsValidator.validateBagGroup(theBagGroup);
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doSaveBagGroup(theBagGroup);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public void removeBagGroup(int bagGroupId) throws R01MSecurityException, R01MCatalogException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El identificador de grupo de bolsas es NULO o el contexto de usuario NO es valido!");
        }
        try {
            ((R01MCatalogManagerBzd)this.getBzd()).doRemoveBagGroup(bagGroupId);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public List loadBagGroupsByBag(int bagId) throws R01MCatalogException {
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadBagGroupsByBag(bagId);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public void removeBag(String bagGuid, int bagId) throws R01MSecurityException, R01MCatalogElementNotFoundException, R01MCatalogElementNotRemovableException, R01MCatalogException {
        if (!this._validateContext(this._userCtx)) {
            throw new R01MSecurityException("El contexto de usuario NO es valido!");
        }
        try {
            ((R01MCatalogManagerBzd)this.getBzd()).doRemoveBag(this._userCtx, bagGuid, bagId);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public List loadStructuresInGroup(String tagGroup) throws R01MCatalogException {
        try {
            return ((R01MCatalogManagerBzd)this.getBzd()).doLoadStructuresInGroup(tagGroup);
        }
        catch (BzdConfigException bzdConfigEx) {
            throw new R01MCatalogException("Error en la configuracion del BZD de la catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
        }
    }

    public StringBuffer getLabelFormatted(String structureOid, String labelOid, String lang) {
        return R01MCatalogUtils.getLabelFormatted(structureOid, labelOid, lang);
    }

    private boolean _validateContext(R01MUserContext userCtx) {
        return true;
    }
}

