/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.objects.cataloguing.structures.R01MBag;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabel;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructure;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructureItem;
import com.ejie.r01m.services.R01MBaseAPI;
import com.ejie.r01m.services.bzd.R01MCatalogCacheBzd;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class R01MCatalogCachesAPI
extends R01MBaseAPI {
    private Map _bagsCache = new HashMap();
    private Map _labelsCache = new HashMap();
    private Map _structuresCache = new HashMap();
    private long _loadTS = DateUtils.getDateFromMillis((long)0L).getTime();
    private boolean _reload = false;

    public R01MCatalogCachesAPI() {
        super("catalogCaches");
    }

    public List getAllBags(final String languageCode) throws R01MCatalogException {
        this.reloadCaches();
        ArrayList allBags = null;
        if (this._bagsCache != null && !this._bagsCache.isEmpty()) {
            allBags = new ArrayList();
            Iterator itBags = this._bagsCache.values().iterator();
            while (itBags.hasNext()) {
                allBags.add(itBags.next());
            }
            Collections.sort(allBags, new Comparator(){

                public int compare(Object obj1, Object obj2) {
                    R01MBag bag1 = (R01MBag)obj1;
                    R01MBag bag2 = (R01MBag)obj2;
                    return bag1.getName(languageCode).toLowerCase().compareTo(bag2.getName(languageCode).toLowerCase());
                }
            });
        }
        return allBags;
    }

    public R01MBag getBagFromCache(String bagOid) throws R01MCatalogException {
        this.reloadCaches();
        return this._bagsCache != null && this._bagsCache.containsKey(bagOid) ? (R01MBag)this._bagsCache.get(bagOid) : null;
    }

    public List getAllLabels() throws R01MCatalogException {
        this.reloadCaches();
        ArrayList allLabels = null;
        if (this._labelsCache != null && !this._labelsCache.isEmpty()) {
            allLabels = new ArrayList();
            Iterator itLabels = this._labelsCache.entrySet().iterator();
            while (itLabels.hasNext()) {
                allLabels.add(itLabels.next());
            }
        }
        return allLabels;
    }

    public R01MLabel getLabelFromCache(String labelOid) throws R01MCatalogException {
        this.reloadCaches();
        return this._labelsCache != null && this._labelsCache.containsKey(labelOid) ? (R01MLabel)this._labelsCache.get(labelOid) : null;
    }

    public List getStructuresInBagFromCache(String bagOid, char structureType) throws R01MCatalogException {
        R01MBag bag;
        this.reloadCaches();
        if (this._bagsCache != null && this._bagsCache.containsKey(bagOid) && (bag = (R01MBag)this._bagsCache.get(bagOid)) != null) {
            ArrayList<R01MStructure> structures = new ArrayList<R01MStructure>();
            for (int i = 0; i < bag.getBelongStructures().size(); ++i) {
                R01MStructure structure = (R01MStructure)this._structuresCache.get(bag.getBelongStructures().get(i));
                if (structure != null) {
                    if (structure.getSDefinition().getStructureType() != structureType) continue;
                    structures.add(structure);
                    continue;
                }
                return null;
            }
            return structures;
        }
        return null;
    }

    public R01MStructure getStructureFromCache(String structureOid) throws R01MCatalogException {
        this.reloadCaches();
        return this._structuresCache != null && this._structuresCache.containsKey(structureOid) ? (R01MStructure)this._structuresCache.get(structureOid) : null;
    }

    public R01MStructureItem getStructureItemFromCache(String structureOid, String labelChildGuid, int role) throws R01MCatalogException {
        R01MStructureItem item;
        R01MStructure structure;
        this.reloadCaches();
        if (this._structuresCache != null && this._structuresCache.containsKey(structureOid) && (structure = (R01MStructure)this._structuresCache.get(structureOid)) != null && structure.getStructureItems() != null && (item = (R01MStructureItem)structure.getStructureItems().get(labelChildGuid)) != null && (role == -1 || item.getRole() == role)) {
            return (R01MStructureItem)structure.getStructureItems().get(labelChildGuid);
        }
        return null;
    }

    private synchronized boolean changedTS() {
        long serverTS;
        try {
            serverTS = ((R01MCatalogCacheBzd)this.getBzd()).doGetLoadTimeStamp();
        }
        catch (BzdConfigException bzdConfigEx) {
            return false;
        }
        if (this._loadTS != serverTS) {
            this._loadTS = serverTS;
            return true;
        }
        return false;
    }

    private void reloadCaches() throws R01MCatalogException {
        if (!this._reload && this.changedTS()) {
            this._reload = true;
            try {
                Map structures;
                Map labels;
                Map bags;
                this._bagsCache = bags = ((R01MCatalogCacheBzd)this.getBzd()).doGetBags();
                this._labelsCache = labels = ((R01MCatalogCacheBzd)this.getBzd()).doGetLabels();
                this._structuresCache = structures = ((R01MCatalogCacheBzd)this.getBzd()).doGetStructures();
            }
            catch (BzdConfigException bzdConfigEx) {
                throw new R01MCatalogException("Error en la configuracion del BZD de la carga de caches de catalogaci\u00f3n!!!:" + bzdConfigEx.getMessage(), (Exception)((Object)bzdConfigEx));
            }
            finally {
                this._reload = false;
            }
        }
    }
}

