/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.services;

import com.ejie.r01f.businessdelegate.BaseAPI;
import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MConfigAPIInterface;
import com.ejie.r01m.utils.R01MConstants;
import java.util.Hashtable;
import java.util.Map;

abstract class R01MBaseConfigAPI
extends BaseAPI
implements R01MConfigAPIInterface {
    protected static final long TIMESTAMP_CHECKED_PERIOD = Long.parseLong(XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"checkTSperiod", (String)"600000"));
    private static long _lastCheckTS = 0L;
    private static long _loadTS = DateUtils.getDateFromMillis((long)0L).getTime();
    private static Map<String, Map<Object, Object>> _configs;
    private String _oid;

    R01MBaseConfigAPI() {
    }

    R01MBaseConfigAPI(String newOid) {
        this();
        this._oid = newOid;
    }

    Object getBzd(String bzdOid) throws R01MConfigLoadException {
        try {
            return super.getBzd(R01MConstants.API_APPCODE, bzdOid);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MConfigLoadException("Revisa el fichero de propiedades de R01M: Error en la configuracion del businessDelegate del API de configuracion.", (Exception)((Object)bzdCfgEx));
        }
    }

    Object getNewBzd(String bzdOid) throws R01MConfigLoadException {
        try {
            return super.getBzd(R01MConstants.API_APPCODE, bzdOid);
        }
        catch (BzdConfigException bzdCfgEx) {
            throw new R01MConfigLoadException("Revisa el fichero de propiedades de R01M: Error en la configuracion del businessDelegate del API de configuracion.", (Exception)((Object)bzdCfgEx));
        }
    }

    Object getObjectConfig(Object objectOid) {
        this._checkCache();
        if (_configs == null) {
            return null;
        }
        Map<Object, Object> configs = _configs.get(this._oid);
        if (configs == null) {
            return null;
        }
        return configs.get(objectOid);
    }

    Map<String, Map<Object, Object>> getAllObjectConfig() {
        this._checkCache();
        return _configs;
    }

    Map<Object, Object> getConfigs() {
        this._checkCache();
        if (_configs == null) {
            return null;
        }
        return _configs.get(this._oid);
    }

    synchronized void cacheObjectConfig(Object objectOid, Object objCfg) {
        Map<Object, Object> configs;
        if (_configs == null) {
            _configs = new Hashtable<String, Map<Object, Object>>();
        }
        if ((configs = _configs.get(this._oid)) == null) {
            configs = new Hashtable<Object, Object>();
            _configs.put(this._oid, configs);
        }
        configs.put(objectOid, objCfg);
    }

    void resetCacheObjectConfig() {
        if (_configs != null) {
            _configs.remove(this._oid);
        }
    }

    private void _checkCache() {
        if (_lastCheckTS == 0L || _lastCheckTS + TIMESTAMP_CHECKED_PERIOD < System.currentTimeMillis()) {
            long loadTS = R01MClientFactory.getConfigLoadersTimingAPI().getLoadTimeStamp();
            _lastCheckTS = System.currentTimeMillis();
            if (loadTS > 0L && loadTS > _loadTS) {
                R01FLog.to((String)"r01m.loadConfigOnStartup").info("\r\n\r\n");
                R01FLog.to((String)"r01m.loadConfigOnStartup").info("//////////////////////////////////////////////////////////////////////////////////////////////////////\r\n");
                R01FLog.to((String)"r01m.loadConfigOnStartup").info("Se han actualizado los objetos de configuraci\u00f3n en el servidor y la cache del cliente ya NO es valida\r\n");
                R01FLog.to((String)"r01m.loadConfigOnStartup").info("//////////////////////////////////////////////////////////////////////////////////////////////////////\r\n");
                _configs = null;
                _loadTS = loadTS;
            }
        }
    }
}

