/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.tags;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.servlet.RequestUtils;
import com.ejie.r01f.servlet.URLDecoder;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.exceptions.R01MSearchWebException;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData;
import com.ejie.r01m.objects.searchengine.session.R01MSearchSession;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchResultsFormatterPreferences;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences;
import com.ejie.r01m.searchengine.servlet.R01MSearchEngineWebConstants;
import com.ejie.r01m.searchengine.servlet.R01MSearchEngineWebRequestProcessor;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

public class R01MSearchEngineSessionTag
extends TagSupport {
    private static final long serialVersionUID = 3L;
    private static boolean DEBUG = R01FLog.getLogLevel((String)"r01m.searchEngineWeb").intValue() != Level.OFF.intValue();
    private static final transient String DEFAULT_ERROR_REDIRPAGE = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"searchEngine/webSessionErrorRedirPage");
    private static final int HEADER_EXPIRES = XMLProperties.getInt((String)R01MConstants.API_APPCODE, (String)"searchEngine/headers/expires", (int)300);
    private String _contentType;
    private String _serviceBaseURL;
    private R01MQueryObject _qry;
    private boolean _returnAttachments = true;
    private String _guideOid;
    private boolean _cacheSearchSession = true;
    private boolean _isFullTextSearch = false;
    private R01MSearchSessionFormatterPreferences _sessionFormatterPrefs;
    private int _resultItemsPerPage = -1;
    private String _webSessionErrorRedirectPage = DEFAULT_ERROR_REDIRPAGE;
    private R01MSearchEngineWebRequestProcessor _webProcessor = new R01MSearchEngineWebRequestProcessor();

    public void release() {
        super.release();
        this._qry = null;
        this._sessionFormatterPrefs = null;
    }

    public int doStartTag() throws JspException {
        StringBuffer outText;
        block39: {
            String baseURL = "";
            String searchResultsPortal = this.pageContext.getRequest().getParameter("R01HPortal");
            String searchResultsPage = this.pageContext.getRequest().getParameter("R01HPage");
            String searchResultsLang = this.pageContext.getRequest().getParameter("R01HLang");
            String r01SearchEngine = this.pageContext.getRequest().getParameter("r01SearchEngine");
            if (!(StringUtils.isEmptyString((String)searchResultsPortal) || StringUtils.isEmptyString((String)searchResultsPage) || StringUtils.isEmptyString((String)searchResultsLang))) {
                baseURL = "/" + searchResultsPortal + "-" + searchResultsPage + "/" + searchResultsLang + "/";
            }
            if (StringUtils.isEmptyString((String)baseURL)) {
                baseURL = ((HttpServletRequest)this.pageContext.getRequest()).getRequestURI();
            } else if (!StringUtils.isEmptyString((String)this._serviceBaseURL)) {
                baseURL = baseURL + this._serviceBaseURL;
            }
            this._computeQueryStringReceivedPresentationParams();
            this._computeFullTextQuery();
            this._computeNumberOfResultsPerPage();
            this._qry.setReturnAttachments(this._returnAttachments);
            if (StringUtils.isEmptyString((String)r01SearchEngine)) {
                if (!StringUtils.isEmptyString((String)this._qry.getFullText())) {
                    this._qry.setFullTextSearch(true);
                } else {
                    this._qry.setFullTextSearch(false);
                }
            } else if (r01SearchEngine.indexOf("full") >= 0) {
                this._qry.setFullTextSearch(true);
            } else if (r01SearchEngine.indexOf("meta") >= 0) {
                this._qry.setFullTextSearch(false);
            }
            outText = new StringBuffer("");
            int minTextSize = R01MSearchEngineWebConstants.MIN_TEXT_SEARCH_SIZE;
            try {
                if (this._qry.getFullText() == null || this._qry.getFullText() != null && this._qry.getFullText().length() >= minTextSize) {
                    outText.append(this._webProcessor.processSearchRequest(baseURL, (HttpServletRequest)this.pageContext.getRequest(), this._qry, this._guideOid, this._resultItemsPerPage, this._cacheSearchSession, this._sessionFormatterPrefs));
                    break block39;
                }
                String lang = R01MConstants.DEFAULT_LANG;
                HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
                if (req.getParameter("r01kLang") != null && req.getParameter("r01kLang").length() > 0) {
                    lang = req.getParameter("r01kLang");
                } else if (req.getParameter("R01HLang") != null && req.getParameter("R01HLang").length() > 0) {
                    lang = req.getParameter("R01HLang");
                }
                StringBuffer msg = new StringBuffer(500);
                String header = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "errorQuery.header");
                String message = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "errorQuery.type1");
                Properties props = new Properties();
                try {
                    NumberFormat nf = NumberFormat.getInstance();
                    props.setProperty("minTextSize", nf.format(minTextSize));
                }
                catch (NumberFormatException nfEx) {
                    nfEx.printStackTrace(System.out);
                    props.setProperty("numResultados", Integer.toString(minTextSize));
                }
                try {
                    Pattern p = Pattern.compile("(\\$\\[[^]$]+\\]\\$)");
                    Matcher m = p.matcher(message);
                    boolean directiveValid = m.find();
                    String foundDirective = null;
                    String propValue = null;
                    while (directiveValid) {
                        foundDirective = message.substring(m.start(), m.end());
                        propValue = props.getProperty(foundDirective.substring(2, foundDirective.length() - 2));
                        m.appendReplacement(msg, propValue != null ? propValue : "");
                        directiveValid = m.find();
                    }
                    m.appendTail(msg);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.out);
                }
                outText.append("<div class=\"r01noResults\"><p class=\"r01noResultsLine1\">").append(header != null ? header : "[NO Results]").append("</p><p class=\"r01noResultsLine2\">").append(msg != null ? msg.toString() : "[NO Results: query is too short]").append("</p></div>");
            }
            catch (R01MSearchWebException srchWebEx) {
                try {
                    RequestUtils.redirect((ServletConfig)this.pageContext.getServletConfig(), (HttpServletRequest)((HttpServletRequest)this.pageContext.getRequest()), (HttpServletResponse)((HttpServletResponse)this.pageContext.getResponse()), (String)this._webSessionErrorRedirectPage);
                    return 5;
                }
                catch (ServletException srvltEx) {
                    throw new JspException((Throwable)srvltEx);
                }
            }
        }
        JspWriter writer = null;
        try {
            if (HEADER_EXPIRES > 0) {
                long now = System.currentTimeMillis();
                ((HttpServletResponse)this.pageContext.getResponse()).setDateHeader("Expires", now + (long)(HEADER_EXPIRES * 1000));
                ((HttpServletResponse)this.pageContext.getResponse()).setHeader("Cache-control", "max-age=" + HEADER_EXPIRES);
            }
            if (this._contentType == null) {
                this._contentType = "text/html";
            }
            this._contentType = this._sessionFormatterPrefs.encodingType == 1 ? this._contentType + ";utf-8" : this._contentType + ";iso-8859-1";
            this.pageContext.getResponse().setContentType(this._contentType);
            writer = this.pageContext.getOut();
            if (this._contentType.toLowerCase().startsWith("text/xml")) {
                writer.clear();
            }
            if (this._sessionFormatterPrefs.encodingType == 1) {
                String resultsUTF8 = new String(org.apache.commons.codec.binary.StringUtils.getBytesUtf8((String)outText.toString()));
                writer.write(resultsUTF8);
            } else {
                writer.write(outText.toString());
            }
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace(System.out);
            throw new JspException("Error al escribir en la salida del custom tag: " + ioEx.toString());
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.out);
                }
            }
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        return 6;
    }

    public String getContentType() {
        return this._contentType;
    }

    public void setContentType(String theContentType) {
        this._contentType = theContentType;
    }

    public String getServiceBaseURL() {
        return this._serviceBaseURL;
    }

    public void setServiceBaseURL(String baseURL) {
        this._serviceBaseURL = baseURL;
    }

    public R01MQueryObject getQuery() {
        return this._qry;
    }

    public void setQuery(R01MQueryObject theQry) {
        if (theQry != null) {
            R01MSearchEngineUtils.sanitizeQuery(theQry);
            this._qry = theQry;
            this._qry.setModified(true);
            if (this._qry != null && StringUtils.isEmptyString((String)this._qry.getQueryOid())) {
                try {
                    R01FLog.to((String)"r01m.searchEngine").warning("La query NO tiene GUID. Se genera UNO!!!!\r\nEs recomendable que la query tenga ya uno. Para generarlo: R01MUtils.generateNewGUID(R01MConstants.SEARCHENGINE_APPCODE)");
                    this._qry.setQueryOid(R01MUtils.generateNewOid(R01MConstants.API_APPCODE));
                }
                catch (GUIDDispenserException guidEx) {
                    guidEx.printStackTrace(System.out);
                }
            }
            this._modifySessionQuery(this._qry);
        }
    }

    public String getQueryEncoded() {
        return R01MSearchEngineUtils.encodeQueryObjectInURL(this._qry);
    }

    public void setQueryEncoded(String qryEncoded) {
        R01MSearchEngineUtils.sanitizeParam(qryEncoded);
        this._qry = R01MSearchEngineUtils.decodeURLInQueryObject(qryEncoded);
    }

    public String getQueryXML() {
        String outXML = "<query/>";
        if (this._qry != null) {
            try {
                outXML = XOManager.getXML((String)R01MConstants.QUERY_RESULTS_MAPFILE, (Object)this._qry);
            }
            catch (XOMarshallerException xoEx) {
                xoEx.printStackTrace(System.out);
            }
        }
        return outXML;
    }

    public void setQueryXML(String theQueryXML) {
        if (theQueryXML != null && theQueryXML.length() > 0) {
            try {
                this._qry = (R01MQueryObject)XOManager.getObject((String)R01MConstants.QUERY_RESULTS_MAPFILE, (String)theQueryXML);
                this._qry.setModified(true);
                this._modifySessionQuery(this._qry);
            }
            catch (XOMarshallerException xoEx) {
                xoEx.printStackTrace(System.out);
            }
        }
    }

    public boolean isFullTextSearch() {
        return this._isFullTextSearch;
    }

    public void setFullTextSearch(boolean isFullTextSearch) {
        this._isFullTextSearch = isFullTextSearch;
    }

    public boolean isReturnAttachments() {
        return this._returnAttachments;
    }

    public void setReturnAttachments(boolean theReturnAttachments) {
        this._returnAttachments = theReturnAttachments;
    }

    public String getGuideOid() {
        return this._guideOid;
    }

    public void setGuideOid(String guideOid) {
        this._guideOid = guideOid;
    }

    public boolean isCacheSearchSession() {
        return this._cacheSearchSession;
    }

    public void setCacheSearchSession(boolean theCacheSearchSession) {
        this._cacheSearchSession = theCacheSearchSession;
    }

    public String getWebSessionErrorRedirectPage() {
        if (this._webSessionErrorRedirectPage != null) {
            return this._webSessionErrorRedirectPage;
        }
        return DEFAULT_ERROR_REDIRPAGE;
    }

    public void setWebSessionErrorRedirectPage(String theErrorPage) {
        this._webSessionErrorRedirectPage = theErrorPage != null ? theErrorPage : DEFAULT_ERROR_REDIRPAGE;
    }

    public R01MSearchSessionFormatterPreferences getSessionFormatterPrefs() {
        return this._sessionFormatterPrefs;
    }

    public void setSessionFormatterPrefs(R01MSearchSessionFormatterPreferences theSessionFormatterPrefs) {
        this._sessionFormatterPrefs = theSessionFormatterPrefs;
    }

    public String getSessionFormatterClassName() {
        if (this._sessionFormatterPrefs == null) {
            return null;
        }
        return this._sessionFormatterPrefs.formatterImpls.sessionFormatterClassName;
    }

    public void setSessionFormatterClassName(String theSessionFormatterClassName) {
        if (this._sessionFormatterPrefs == null) {
            this._sessionFormatterPrefs = new R01MSearchSessionFormatterPreferences();
        }
        this._sessionFormatterPrefs.formatterImpls.sessionFormatterClassName = theSessionFormatterClassName;
    }

    public int getNumberOfResultItemsPerPage() {
        return this._resultItemsPerPage;
    }

    public void setNumberOfResultItemsPerPage(int theNumber) {
        if (theNumber > 0 && theNumber < R01MSearchEngineWebConstants.MAX_RESULTITEMS_PER_PAGE) {
            this._resultItemsPerPage = theNumber;
        } else if (theNumber > R01MSearchEngineWebConstants.MAX_RESULTITEMS_PER_PAGE) {
            this._resultItemsPerPage = R01MSearchEngineWebConstants.MAX_RESULTITEMS_PER_PAGE;
        } else {
            R01FLog.to((String)"r01m.searchEngine").warning(theNumber + " NO es un numero de resultados de b\u00fasqueda por pagina v\u00e1lido. El valor ha de estar entre 1 y " + R01MSearchEngineWebConstants.MAX_RESULTITEMS_PER_PAGE + ".\r\nSe establece el valor por defecto: " + R01MSearchEngineWebConstants.DEFAULT_RESULTITEMS_PER_PAGE);
            this._resultItemsPerPage = R01MSearchEngineWebConstants.DEFAULT_RESULTITEMS_PER_PAGE;
        }
    }

    private void _modifySessionQuery(R01MQueryObject qry) {
        R01MSearchSession srchSession;
        HttpSession httpSession = ((HttpServletRequest)this.pageContext.getRequest()).getSession(false);
        if (httpSession != null && (srchSession = (R01MSearchSession)httpSession.getAttribute("r01kSrchSession")) != null) {
            srchSession.setQuery(qry);
        }
    }

    private void _computeFullTextQuery() {
        String[] labelIds;
        String fullText = this.pageContext.getRequest().getParameter("queryText");
        if (fullText != null && !StringUtils.isEmptyString((String)fullText)) {
            if (this._qry == null) {
                this._qry = new R01MQueryObject();
            }
            this._qry.setFullText(fullText);
        }
        if ((labelIds = this.pageContext.getRequest().getParameterValues("catalogLabel")) != null) {
            if (this._qry == null) {
                this._qry = new R01MQueryObject();
            }
            for (int i = 0; i < labelIds.length; ++i) {
                this._qry.addANDStructureCatalog(labelIds[i]);
            }
        }
        HttpSession httpSession = ((HttpServletRequest)this.pageContext.getRequest()).getSession(false);
        R01MSearchSession srchSession = null;
        if (this._qry == null && httpSession != null) {
            String prevFullText;
            srchSession = (R01MSearchSession)httpSession.getAttribute("r01kSrchSession");
            if (srchSession != null) {
                this._qry = srchSession.getQuery();
            }
            if (this._qry != null && !this._qry.isFullTextSearch() && this._isFullTextSearch && (this._qry.getFullText() == null || StringUtils.isEmptyString((String)this._qry.getFullText()))) {
                this._qry = new R01MQueryObject();
            }
            fullText = this.pageContext.getRequest().getParameter("fullText");
            String string = prevFullText = this._qry != null && this._qry.getFullText() != null ? this._qry.getFullText() : null;
            if (fullText != null && prevFullText != null && !prevFullText.equals(fullText) || fullText != null && prevFullText == null) {
                if (this._qry == null) {
                    this._qry = new R01MQueryObject();
                }
                this._qry.removeMetaData("fullText");
                if (fullText.length() > 0) {
                    this._qry.addMetaData(new R01MSearchedMetaData("fullText", "LIKE", fullText));
                }
                this._qry.setModified(true);
            }
        }
        if (this._qry == null) {
            this._qry = new R01MQueryObject();
        }
        this._qry.setFullTextSearch(this._isFullTextSearch);
        if (this._qry.getFullText() != null) {
            R01FLog.to((String)"r01m.searchEngine").info("\r\n\r\n>>>[FullTextSearch]:" + this._qry.getFullText() + "\r\n\r\n");
        }
    }

    private void _computeNumberOfResultsPerPage() {
        if (this._resultItemsPerPage <= 0) {
            String numResultsPerPageValue = this.pageContext.getRequest().getParameter("r01kNumResultsPerPage");
            String numResultsPerPageV1Value = this.pageContext.getRequest().getParameter("numberOfElements");
            if (!StringUtils.isEmptyString((String)numResultsPerPageV1Value)) {
                numResultsPerPageValue = numResultsPerPageV1Value;
            }
            if (!StringUtils.isEmptyString((String)numResultsPerPageValue)) {
                try {
                    this._resultItemsPerPage = Integer.parseInt(numResultsPerPageValue);
                }
                catch (Exception ex) {
                    this._resultItemsPerPage = R01MSearchEngineWebConstants.DEFAULT_RESULTITEMS_PER_PAGE;
                }
            }
        }
        if (this._resultItemsPerPage <= 0) {
            this._resultItemsPerPage = R01MSearchEngineWebConstants.DEFAULT_RESULTITEMS_PER_PAGE;
        }
        if (this._resultItemsPerPage > R01MSearchEngineWebConstants.MAX_RESULTITEMS_PER_PAGE) {
            this._resultItemsPerPage = R01MSearchEngineWebConstants.MAX_RESULTITEMS_PER_PAGE;
        }
        this._qry.setPresentationProperty("r01PageSize", Integer.toString(this._resultItemsPerPage));
    }

    private void _computeQueryStringReceivedPresentationParams() {
        String vaName;
        String rssFeedValue;
        String contentsPageValue;
        String guideOidValue;
        String portalPageLang;
        String portalPageCode;
        String portalCode;
        String showRisp;
        String showSearchBoxValue;
        String showresultsHeaderValue;
        String thumbNailFormating = this.pageContext.getRequest().getParameter("r01kPresentationThumbnail");
        if (!StringUtils.isEmptyString((String)thumbNailFormating)) {
            if (this._sessionFormatterPrefs == null) {
                this._sessionFormatterPrefs = new R01MSearchSessionFormatterPreferences();
            }
            this._sessionFormatterPrefs.formatterImpls.searchResultItemFormatterClassName = this._sessionFormatterPrefs.formatterImpls.searchResultItemThumbnailFormatterClassName;
            this._sessionFormatterPrefs.addFormatterProperty("thumbNailType", thumbNailFormating);
            if (this._sessionFormatterPrefs.resultsFormatterPreferences == null) {
                this._sessionFormatterPrefs.resultsFormatterPreferences = new R01MSearchResultsFormatterPreferences();
            }
            if (this._sessionFormatterPrefs.resultsFormatterPreferences.formatterAtributtes == null) {
                this._sessionFormatterPrefs.resultsFormatterPreferences.formatterAtributtes = new HashMap();
            }
            this._sessionFormatterPrefs.resultsFormatterPreferences.formatterAtributtes.put("thumbNailType", thumbNailFormating);
        }
        if (!StringUtils.isEmptyString((String)(showresultsHeaderValue = this.pageContext.getRequest().getParameter("r01kSearchResultsHeader")))) {
            if (this._sessionFormatterPrefs == null) {
                this._sessionFormatterPrefs = new R01MSearchSessionFormatterPreferences();
            }
            this._sessionFormatterPrefs.showResultsHeader = "1".equals(showresultsHeaderValue);
        }
        if (!StringUtils.isEmptyString((String)(showSearchBoxValue = this.pageContext.getRequest().getParameter("r01kSearchBox"))) && "1".equals(showSearchBoxValue)) {
            if (this._sessionFormatterPrefs == null) {
                this._sessionFormatterPrefs = new R01MSearchSessionFormatterPreferences();
            }
            this._sessionFormatterPrefs.showSearchBox = true;
        }
        if (!StringUtils.isEmptyString((String)(showRisp = this.pageContext.getRequest().getParameter("r01kIncludeRisp"))) && "1".equals(showRisp)) {
            if (this._sessionFormatterPrefs == null) {
                this._sessionFormatterPrefs = new R01MSearchSessionFormatterPreferences();
            }
            this._sessionFormatterPrefs.showRisp = true;
        }
        if (!StringUtils.isEmptyString((String)(portalCode = this.pageContext.getRequest().getParameter("R01HPortal")))) {
            if (this._sessionFormatterPrefs == null) {
                this._sessionFormatterPrefs = new R01MSearchSessionFormatterPreferences();
            }
            this._sessionFormatterPrefs.addFormatterProperty("R01HPortal", portalCode);
        }
        if (!StringUtils.isEmptyString((String)(portalPageCode = this.pageContext.getRequest().getParameter("R01HPage")))) {
            if (this._sessionFormatterPrefs == null) {
                this._sessionFormatterPrefs = new R01MSearchSessionFormatterPreferences();
            }
            this._sessionFormatterPrefs.addFormatterProperty("R01HPage", portalPageCode);
        }
        if (!StringUtils.isEmptyString((String)(portalPageLang = this.pageContext.getRequest().getParameter("R01HLang")))) {
            if (this._sessionFormatterPrefs == null) {
                this._sessionFormatterPrefs = new R01MSearchSessionFormatterPreferences();
            }
            this._sessionFormatterPrefs.addFormatterProperty("R01HLang", portalPageLang);
        }
        if (!StringUtils.isEmptyString((String)(guideOidValue = this.pageContext.getRequest().getParameter("r01kGuide"))) && !"notConfigured".equals(guideOidValue)) {
            if (this._sessionFormatterPrefs == null) {
                this._sessionFormatterPrefs = new R01MSearchSessionFormatterPreferences();
            }
            this._sessionFormatterPrefs.showGuide = true;
            this._guideOid = guideOidValue;
            this._sessionFormatterPrefs.guideFormatterPreferences.showGuideElementsSubTotals = true;
            this._sessionFormatterPrefs.guideFormatterPreferences.showGuidesTabs = false;
            this._sessionFormatterPrefs.guideFormatterPreferences.guideType = 2;
            this._sessionFormatterPrefs.guideFormatterPreferences.guideColumnsNum = 3;
        }
        if ((contentsPageValue = this.pageContext.getRequest().getParameter("r01kPageContents")) != null && !StringUtils.isEmptyString((String)contentsPageValue)) {
            if (this._sessionFormatterPrefs == null) {
                this._sessionFormatterPrefs = new R01MSearchSessionFormatterPreferences();
            }
            this._sessionFormatterPrefs.resultsFormatterPreferences.itemUrlPrefix = contentsPageValue;
        }
        if (!StringUtils.isEmptyString((String)(rssFeedValue = this.pageContext.getRequest().getParameter("r01kRss"))) && "1".equals(rssFeedValue)) {
            if (this._sessionFormatterPrefs == null) {
                this._sessionFormatterPrefs = new R01MSearchSessionFormatterPreferences();
            }
            this._sessionFormatterPrefs.showRSSFeedLink = true;
            String rssFeedTitle = this.pageContext.getRequest().getParameter("r01kRssTitle");
            if (!StringUtils.isEmptyString((String)rssFeedTitle)) {
                this._sessionFormatterPrefs.addFormatterProperty("rssTitle", URLDecoder.decode((String)rssFeedTitle, (String)"UTF-8"));
            } else {
                this._sessionFormatterPrefs.addFormatterProperty("rssTitle", "");
            }
        }
        if (!StringUtils.isEmptyString((String)(vaName = this.pageContext.getRequest().getParameter("r01kVAName")))) {
            if (this._sessionFormatterPrefs == null) {
                this._sessionFormatterPrefs = new R01MSearchSessionFormatterPreferences();
            }
            this._sessionFormatterPrefs.addFormatterProperty("vaName", vaName);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.searchEngineWeb").info("Par\u00e1metros de formateo: \r\n\" + " + (!StringUtils.isEmptyString((String)thumbNailFormating) ? "\t-ThumbNailFormatting: " + thumbNailFormating : "") + "\r\n" + (!StringUtils.isEmptyString((String)showSearchBoxValue) ? "\t-showSearchBox: " + showSearchBoxValue : "") + "\r\n" + (!StringUtils.isEmptyString((String)showRisp) ? "\t-showRisp: " + showRisp : "") + "\r\n" + (!StringUtils.isEmptyString((String)guideOidValue) ? "\t-guideOid: " + guideOidValue : "") + "\r\n" + (!StringUtils.isEmptyString((String)contentsPageValue) ? "\t-contentsPage: " + contentsPageValue : "") + "\r\n" + (!StringUtils.isEmptyString((String)rssFeedValue) ? "\t-rssFeed: " + rssFeedValue : ""));
        }
    }
}

