/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.servlet;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.exceptions.R01MSearchGuideManagerException;
import com.ejie.r01m.exceptions.R01MSearchInitializeException;
import com.ejie.r01m.exceptions.R01MSearchWebException;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuide;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.session.R01MSearchSession;
import com.ejie.r01m.searchengine.servlet.R01MBaseSearchEngineWebSessionManager;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class R01MSearchEngineWebSessionManager
extends R01MBaseSearchEngineWebSessionManager
implements Serializable {
    private static final long serialVersionUID = 2856792255194177846L;
    private static boolean USE_HTTPSESSION = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"searchEngine/session/enable") == null ? true : XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"searchEngine/session/enable").equalsIgnoreCase("true");
    private transient HttpServletRequest _request = null;
    private transient String _clientIP = "noIP";

    public R01MSearchEngineWebSessionManager() {
    }

    public R01MSearchEngineWebSessionManager(HttpServletRequest req) {
        this._request = req;
        this._clientIP = this._obtainClientIP();
    }

    @Override
    public void resetWebSearchSession() {
        HttpSession webSession = this._request.getSession(false);
        if (webSession != null) {
            webSession.removeAttribute("r01kSrchSession");
        } else {
            R01FLog.to((String)"r01m.searchEngineWeb").warning("La sesi\u00f3n web de la b\u00fasqueda es nula!!!");
        }
    }

    @Override
    protected R01MSearchSession getSearchSessionFromWebSession(Boolean isFullTextSearch) throws R01MSearchWebException, R01MSearchInitializeException {
        R01MSearchSession outSearchSession = null;
        HttpSession webSession = this._request.getSession(false);
        if (USE_HTTPSESSION && this.isCacheSearchSession() && webSession != null) {
            outSearchSession = (R01MSearchSession)webSession.getAttribute("r01kSrchSession");
            if (outSearchSession == null) {
                R01FLog.to((String)"r01m.searchEngineWeb").warning("La sesi\u00f3n web NO contiene la sesi\u00f3n de b\u00fasqueda... se inicializa una nueva");
            } else {
                R01FLog.to((String)"r01m.searchEngineWeb").info("Se est\u00e1 utilizando sesi\u00f3n web para mantener la sesi\u00f3n de b\u00fasqueda....");
            }
        }
        if (outSearchSession == null && this._request.getParameter("r01kQry") != null) {
            String lang = this._request.getParameter("r01kLang");
            String qryURLEncoded = this._request.getParameter("r01kQry");
            String guideOid = this._request.getParameter("r01kGuide");
            String currGuideElement = this._request.getParameter("r01kCurrGuideEl");
            R01FLog.to((String)"r01m.searchEngineWeb").info("--->webSessionManager (" + this._clientIP + "): lang=" + lang + ", guideOid=" + guideOid + ", currGuideElement=" + currGuideElement + ", qryURLEncoded=" + qryURLEncoded);
            R01FLog.to((String)"r01m.searchEngineWeb").info("Bien la sesi\u00f3n web ha caducado o bien no se utiliza sesi\u00f3n web... recomponer la sesi\u00f3n de b\u00fasqueda a partir de la query encodeada en la url: " + qryURLEncoded);
            R01MQueryObject qry = R01MSearchEngineUtils.decodeURLInQueryObject(qryURLEncoded);
            if (isFullTextSearch != null) {
                qry.setFullTextSearch(isFullTextSearch);
            }
            if (currGuideElement == null) {
                R01FLog.to((String)"r01m.searchEngineWeb").info("NO hay guia de navegaci\u00f3n....");
                R01FLog.to((String)"r01m.searchEngineWeb").info("--->webSessionManager (" + this._clientIP + "): NO hay guia de navegacion...");
                outSearchSession = this.executeQuery(lang == null ? R01MConstants.DEFAULT_LANG : lang, qry, guideOid);
            } else if (guideOid != null) {
                R01MSearchGuide guide = null;
                try {
                    R01FLog.to((String)"r01m.searchEngineWeb").info("Ir por la guia de navegacion " + guideOid + " al elemento " + currGuideElement + "....");
                    R01FLog.to((String)"r01m.searchEngineWeb").info("--->webSessionManager (" + this._clientIP + "): Ir por la guia de navegacion " + guideOid + " al elemento " + currGuideElement + "....");
                    guide = R01MClientFactory.getSearchEnginePersistenceAPI().getGuide(guideOid, qry);
                    if (guide != null) {
                        outSearchSession = new R01MSearchSession();
                        outSearchSession.setSessionLang(lang);
                        outSearchSession.setQuery(qry);
                        outSearchSession.setLazyInit(false);
                        outSearchSession.setSearchGuide(guide);
                        outSearchSession.followGuide(currGuideElement);
                        if (this.isCacheSearchSession()) {
                            this.setSearchSessionInWebSession(outSearchSession);
                        }
                    }
                }
                catch (R01MSearchGuideManagerException gmEx) {
                    gmEx.printStackTrace(System.out);
                    R01FLog.to((String)"r01m.searchEngineWeb").severe("Se ignora la guia de navegaci\u00f3n " + guideOid + " ya que no se puede cargar la guia: " + gmEx.getMessage());
                }
            }
        } else if (outSearchSession != null) {
            R01FLog.to((String)"r01m.searchEngineWeb").info("--->webSessionManager (" + this._clientIP + "): Ya existe una sesi\u00f3n de b\u00fasqueda para la query " + (outSearchSession.getQuery() != null ? outSearchSession.getQuery().getQueryOid() : "no query!!!"));
        } else {
            R01FLog.to((String)"r01m.searchEngineWeb").info("--->webSessionManager (" + this._clientIP + "): NO existe sesi\u00f3n de b\u00fasqueda");
        }
        return outSearchSession;
    }

    @Override
    protected void setSearchSessionInWebSession(R01MSearchSession srchSession) throws R01MSearchWebException {
        HttpSession webSession;
        HttpSession httpSession = webSession = USE_HTTPSESSION && this.isCacheSearchSession() ? this._request.getSession(true) : null;
        if (webSession != null) {
            if (srchSession == null) {
                throw new R01MSearchWebException("La sesi\u00f3n de b\u00fasqueda que se intenta almacenar en la sessi\u00f3n web es NULA!!!");
            }
        } else {
            throw new R01MSearchWebException("[SEARCHENGINEWEBSESSIONMANAGER_ERROR]: NO se puede crera la sesi\u00f3n web");
        }
        webSession.setAttribute("r01kSrchSession", (Object)srchSession);
    }

    private String _obtainClientIP() {
        String ip = "noIP";
        if (this._request != null && (ip = this._request.getHeader("WL-Proxy-Client-IP")) == null) {
            ip = this._request.getRemoteAddr();
        }
        return ip;
    }
}

