/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.servlet;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.servlet.URLDecoder;
import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01f.util.Pager;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.config.objects.searchengine.R01MSearchEngineConfig;
import com.ejie.r01m.config.objects.searchengine.R01MSearchSource;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MSearchIllegalPaginationException;
import com.ejie.r01m.exceptions.R01MSearchInitializeException;
import com.ejie.r01m.exceptions.R01MSearchPerformerException;
import com.ejie.r01m.exceptions.R01MSearchStorageException;
import com.ejie.r01m.exceptions.R01MSearchWebException;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.session.R01MSearchSession;
import com.ejie.r01m.searchengine.formatters.R01MSearchSessionFormatterInstanceManager;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchSessionFormatter;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences;
import com.ejie.r01m.searchengine.formatters.xml.defaults.R01MDefSearchSessionXMLFormatter;
import com.ejie.r01m.searchengine.servlet.R01MBaseSearchEngineWebSessionManager;
import com.ejie.r01m.searchengine.servlet.R01MSearchEngineWebConstants;
import com.ejie.r01m.searchengine.servlet.R01MSearchEngineWebSessionManager;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class R01MSearchEngineWebRequestProcessor
implements Serializable {
    private static final long serialVersionUID = 8565914376203038212L;
    private static final boolean DEBUG_FINEST = R01FLog.getLogLevel((String)"r01m.searchEngineWeb").intValue() > Level.FINEST.intValue();
    private static final int ACTION_UNKNOWN = -1;
    private static final int ACTION_CONTROL = 1;
    private static final int ACTION_PAGING = 2;
    private static final int ACTION_GUIDE_NAV = 3;
    private static final int ACTION_SEARCH = 4;

    public StringBuffer processSearchRequest(String serviceBaseURL, HttpServletRequest req, R01MQueryObject query, String guideOid, int numResultsPerPage, boolean cacheSearchSession, R01MSearchSessionFormatterPreferences formatPrefs) throws R01MSearchWebException {
        StringBuffer outStr;
        R01MSearchSession srchSession;
        StringBuffer debugStr;
        String ip;
        String lang;
        block68: {
            boolean isCacheSearchSession;
            R01MSearchSessionFormatterPreferences prefs = formatPrefs;
            if (formatPrefs == null) {
                prefs = new R01MSearchSessionFormatterPreferences();
            }
            boolean bl = isCacheSearchSession = !cacheSearchSession ? false : prefs.useSession;
            if (cacheSearchSession != prefs.useSession) {
                R01FLog.to((String)"r01m.searchEngineWeb").warning("OJO!!! El valor indicado en el tag de b\u00fasqueda sobre el cacheo de la sesi\u00f3n DIFIERE de el valor indicado en las preferencias (prefs.useSession), el valor que se va a utilizar es: " + isCacheSearchSession);
            }
            R01MSearchEngineWebSessionManager webSessionManager = new R01MSearchEngineWebSessionManager(req);
            webSessionManager.setCacheSearchSession(isCacheSearchSession);
            webSessionManager.setLazyInit(false);
            webSessionManager.setLazyGuide(!prefs.guideFormatterPreferences.showGuideElementsSubTotals);
            lang = this._obtainLang(req);
            boolean debug = this._isInDebugMode(req);
            if (debug) {
                R01FLog.to((String)"r01m.searchEngineWeb").warning("MODO DEBUG: Se buscan tanto elementos publicados como no publicados!");
                query.setPublishedItemsOnly(false);
            }
            query.setReturnAttachments(this._showAttachments(req));
            int action = -1;
            ip = req.getHeader("WL-Proxy-Client-IP");
            if (ip == null) {
                ip = req.getRemoteAddr();
            }
            debugStr = new StringBuffer(575);
            debugStr.append("\r\n\r\n\r\n\r\n").append(ip).append("............[INIT] REQUEST DE B\u00daSQUEDA................\r\n").append(ip).append(" >>Parsear los par\u00e1metros de la request: ");
            if (req == null || req.getParameterMap() == null) {
                debugStr.append("NO se pueden obtener los par\u00e1metros de b\u00fasqueda: la request es nula o bien no tiene parametros!\r\n");
            } else {
                debugStr.append("\r\n").append(ip).append(" >>Comando a ejecutar (").append(lang).append("): ");
                try {
                    if (req.getParameter("r01kCtrl") != null && req.getParameter("r01kCtrl").length() > 0) {
                        action = 1;
                        debugStr.append("Control de la sesi\u00f3n: ");
                        String ctrlParamVal = req.getParameter("r01kCtrl");
                        if (ctrlParamVal.equals("resetSession")) {
                            debugStr.append("resetear la sesi\u00f3n de usuario");
                            ((R01MBaseSearchEngineWebSessionManager)webSessionManager).resetWebSearchSession();
                            return new StringBuffer("<r01searchCtrl>Session Reseted</r01searchCtrl>");
                        }
                        if (ctrlParamVal.equals("usageInfo")) {
                            debugStr.append("mostrar informaci\u00f3n de utilizaci\u00f3n de par\u00e1metros");
                            StringBuffer outInfo = new StringBuffer(39);
                            outInfo.append("<pre>\r\n<r01searchCtrl>\r\n").append(R01MSearchEngineWebConstants.SEARCHPARAMS_USAGEMSG).append("</r01searchCtrl>\r\n</pre>\r\n");
                            return outInfo;
                        }
                        debugStr.append("[Comando de control no reconocido]");
                    } else if (req.getParameter("r01kPgCmd") != null && req.getParameter("r01kPgCmd").length() > 0) {
                        action = 2;
                        debugStr.append("Paginaci\u00f3n: ");
                        String srchSrcOid = req.getParameter("r01kSrchSrcId");
                        if (srchSrcOid != null) {
                            debugStr.append("source=");
                            debugStr.append(srchSrcOid);
                            debugStr.append("-> ");
                            String pagingParamVal = req.getParameter("r01kPgCmd");
                            String targetPageNum = req.getParameter("r01kTgtPg");
                            if (NumberUtils.isInteger((String)targetPageNum)) {
                                debugStr.append("goto page (").append(targetPageNum).append(')');
                                webSessionManager.gotoPage(srchSrcOid, Integer.parseInt(targetPageNum), new Boolean(query.isFullTextSearch));
                            } else if (pagingParamVal.equals("first")) {
                                debugStr.append("first page (").append(targetPageNum).append(')');
                                webSessionManager.gotoFirstPage(srchSrcOid);
                            } else if (pagingParamVal.equals("prev")) {
                                debugStr.append("prev page (").append(targetPageNum).append(')');
                                webSessionManager.gotoPrevPage(srchSrcOid);
                            } else if (pagingParamVal.equals("next")) {
                                debugStr.append("next page (").append(targetPageNum).append(')');
                                webSessionManager.gotoNextPage(srchSrcOid);
                            } else if (pagingParamVal.equals("last")) {
                                debugStr.append("last page (").append(targetPageNum).append(')');
                                webSessionManager.gotoLastPage(srchSrcOid);
                            } else if (pagingParamVal.equals("nextBlock")) {
                                debugStr.append("last page (").append(targetPageNum).append(')');
                                webSessionManager.gotoNextBlockFirstPage(srchSrcOid);
                            } else if (pagingParamVal.equals("prevBlock")) {
                                debugStr.append("last page (").append(targetPageNum).append(')');
                                webSessionManager.gotoPrevBlockLastPage(srchSrcOid);
                            } else {
                                debugStr.append("[COMANDO DE PAGINACION NO RECONOCIDO]");
                            }
                        } else {
                            debugStr.append("Error al paginar. No ha llegado el parametro ").append("r01kSrchSrcId");
                        }
                    } else if (req.getParameter("r01kGuideCmd") != null && req.getParameter("r01kGuideCmd").length() > 0) {
                        action = 3;
                        String guideElementPath = req.getParameter("r01kTgtGuideEl");
                        String guideCmd = req.getParameter("r01kGuideCmd");
                        if (guideCmd != null && guideCmd.equals("reset")) {
                            debugStr.append("Reseteo de la guia");
                            webSessionManager.resetGuide();
                        } else if (guideElementPath != null && StringUtils.isEmptyString((String)guideElementPath)) {
                            debugStr.append("Navegaci\u00f3n (").append(guideCmd).append(") por la guia hasta el elemento: ").append(guideElementPath);
                            webSessionManager.gotoGuideNode(guideElementPath);
                        } else if (guideCmd.equals("rewind")) {
                            debugStr.append("Navegaci\u00f3n (rewind) por la guia hasta el elemento: ").append(guideElementPath);
                            webSessionManager.rewindGuide(guideElementPath);
                        } else if (guideCmd.equals("follow")) {
                            debugStr.append("Navegaci\u00f3n (follow) por la guia hasta el elemento: ").append(guideElementPath);
                            webSessionManager.followGuide(guideElementPath);
                        }
                    } else if (req.getParameter("r01kStoredQry") != null && req.getParameter("r01kStoredQry").length() > 0 || req.getParameter("searchGUID") != null && req.getParameter("searchGUID").length() > 0) {
                        action = 4;
                        String storedQryOid = R01MSearchEngineUtils.sanitizeParam(req.getParameter("r01kStoredQry"));
                        if (storedQryOid == null) {
                            storedQryOid = R01MSearchEngineUtils.sanitizeParam(req.getParameter("searchGUID"));
                        }
                        debugStr.append("Acceso a una query almacenada: queryOid=").append(storedQryOid);
                        R01MSearchSession srchSession2 = ((R01MBaseSearchEngineWebSessionManager)webSessionManager).getSearchSessionFromWebSession(null);
                        if (srchSession2 != null && srchSession2.getQuery() != null) {
                            ((R01MBaseSearchEngineWebSessionManager)webSessionManager).resetWebSearchSession();
                        }
                        webSessionManager.executeStoredQuery(lang, storedQryOid, guideOid);
                    } else if (req.getParameter("r01kQry") != null && req.getParameter("r01kQry").length() > 0) {
                        action = 4;
                        String qryInURL = URLDecoder.decode((String)req.getParameter("r01kQry"), (String)req.getCharacterEncoding());
                        debugStr.append("Ejecuci\u00f3n de una Query recibida en la url: ").append(qryInURL);
                        R01MQueryObject qry = R01MSearchEngineUtils.decodeURLInQueryObject(qryInURL);
                        if (qry == null || qry.getPresentationProperty("r01PageSize") == null || NumberUtils.isInteger((String)qry.getPresentationProperty("r01PageSize")) && NumberUtils.toInt((String)qry.getPresentationProperty("r01PageSize")) <= 0 && numResultsPerPage > 0) {
                            qry.setPresentationProperty("r01PageSize", Integer.toString(numResultsPerPage));
                        }
                        qry.setFullTextSearch(query.isFullTextSearch());
                        webSessionManager.executeQuery(lang, qry, guideOid);
                    } else if (req.getParameter("r01kQryXML") != null && req.getParameter("r01kQryXML").length() > 0) {
                        action = 4;
                        String qryXML = URLDecoder.decode((String)req.getParameter("r01kQryXML"), (String)req.getCharacterEncoding());
                        debugStr.append("Ejecuci\u00f3n de una Query recibida en XML: ").append(qryXML);
                        webSessionManager.executeQuery(lang, qryXML, guideOid);
                    } else if (query != null) {
                        action = 4;
                        debugStr.append("Ejecuci\u00f3n de una query que llega como objeto completo");
                        srchSession = ((R01MBaseSearchEngineWebSessionManager)webSessionManager).getSearchSessionFromWebSession(null);
                        if (srchSession != null && srchSession.getQuery() != null || query.isModified()) {
                            ((R01MBaseSearchEngineWebSessionManager)webSessionManager).resetWebSearchSession();
                        }
                        webSessionManager.executeQuery(lang, query, guideOid);
                    }
                }
                catch (R01MSearchStorageException srchQryStoEx) {
                    srchQryStoEx.printStackTrace(System.out);
                    debugStr.append("Error al cargar la query almacenada desde base de datos: ");
                    debugStr.append(srchQryStoEx.getDetailedMessage());
                }
                catch (R01MSearchInitializeException srchInitEx) {
                    srchInitEx.printStackTrace(System.out);
                    debugStr.append("Error al inicializar la b\u00fasqueda: ");
                    debugStr.append(srchInitEx.getDetailedMessage());
                }
                catch (R01MSearchPerformerException srchPrfmrEx) {
                    srchPrfmrEx.printStackTrace(System.out);
                    debugStr.append("Error al ejecutar la b\u00fasqueda: ");
                    debugStr.append(srchPrfmrEx.getDetailedMessage());
                }
                catch (R01MSearchIllegalPaginationException srchIllPgEx) {
                    srchIllPgEx.printStackTrace(System.out);
                    debugStr.append("Error al paginar los resultados: ");
                    debugStr.append(srchIllPgEx.getDetailedMessage());
                }
            }
            srchSession = webSessionManager.getSearchSession();
            if (srchSession == null) {
                throw new R01MSearchWebException("[SEARCHENGINEWEBREQUESTPROCESSOR_ERROR]: Ha sido imposible obtener una sesi\u00f3n de b\u00fasqueda.... \u00bf ha caducado la sesion web ?");
            }
            outStr = null;
            debugStr.append("\r\nse utilizan preferencias de presentaci\u00f3n personalizadas...");
            prefs.resultsFormatterPreferences.showAttachments = formatPrefs.resultsFormatterPreferences.showAttachments;
            if (req.getParameter("r01kIncludeRisp") != null && req.getParameter("r01kIncludeRisp").equals("1")) {
                prefs.resultsFormatterPreferences.showRisp = true;
            }
            R01MSearchSessionFormatterInstanceManager fmtInstanceMgr = new R01MSearchSessionFormatterInstanceManager();
            R01MSearchSessionFormatter formatter = fmtInstanceMgr.getSessionFormatter(prefs);
            try {
                outStr = formatter.formatSearchSession(lang, prefs, srchSession);
                if (!StringUtils.isEmptyStringBuffer((StringBuffer)outStr)) break block68;
                StringBuffer[] formatterOutput = this._formatSectionBySection(action, lang, srchSession, formatter, prefs);
                debugStr.append(formatterOutput[1]);
                outStr = formatterOutput[0];
                if (!debug) break block68;
                R01MDefSearchSessionXMLFormatter xmlFormatter = new R01MDefSearchSessionXMLFormatter();
                outStr.append(xmlFormatter.formatSearchSession(lang, prefs, srchSession));
                String[] sourcesOids = srchSession.getSearchSourcesOids();
                if (sourcesOids != null && sourcesOids.length > 0) {
                    Pager pager = null;
                    for (int s = 0; s < sourcesOids.length; ++s) {
                        pager = srchSession.getPager(sourcesOids[s]);
                        outStr.append("\r\n<pre>\r\n").append("Origen: ").append(sourcesOids[s]).append(" --->>> ");
                        if (pager != null) {
                            outStr.append(srchSession.getSearchEngineQuerySentence(sourcesOids[s], pager.getCurrentPageElementNumber(), pager.getCurrentPageFirstElement(), pager.getCurrentPageLastElement()));
                        } else {
                            outStr.append(srchSession.getSearchEngineQuerySentence(sourcesOids[s], -1, null, null));
                        }
                        outStr.append("\r\n</pre>\r\n");
                    }
                    break block68;
                }
                R01MSearchEngineConfig searchEngineConfig = null;
                try {
                    searchEngineConfig = R01MClientFactory.getSearchEngineConfigAPI().getSearchEngineConfig();
                }
                catch (R01MConfigLoadException cfgLoadEx) {
                    cfgLoadEx.printStackTrace(System.out);
                }
                if (searchEngineConfig != null && searchEngineConfig.getSearchSources() != null && !searchEngineConfig.getSearchSources().isEmpty()) {
                    String searchEngCtx = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"searchEngine/defaultSearchEngineContext", (String)"intranet");
                    R01MSearchSource currSearchSrc2 = null;
                    for (R01MSearchSource currSearchSrc2 : searchEngineConfig.getSearchSources().values()) {
                        if (StringUtils.isEmptyString((String)searchEngCtx) || !searchEngCtx.equals(currSearchSrc2.getContext())) continue;
                        outStr.append("\r\n<pre>\r\n").append("Origen: ").append(currSearchSrc2.getOid()).append(" --->>> ");
                        outStr.append(srchSession.getSearchEngineQuerySentence(currSearchSrc2.getOid(), -1, null, null));
                        outStr.append("\r\n</pre>\r\n");
                    }
                }
            }
            catch (R01MSearchPerformerException spEx) {
                throw new R01MSearchWebException((Exception)((Object)spEx));
            }
            catch (IllegalStateException illStateEx) {
                throw new R01MSearchWebException(illStateEx);
            }
        }
        String serviceURL = serviceBaseURL;
        if (DEBUG_FINEST) {
            R01FLog.to((String)"r01m.searchEngineWeb").info(ip + "----> Base URL para los resultados de busqueda: " + serviceURL);
        }
        debugStr.append("\r\ndecorar los resultados de b\u00fasqueda...");
        outStr = R01MSearchEngineUtils.decorateSearchResult(lang, serviceURL, this._moreParameters(req), R01MSearchEngineUtils.encodeQueryObjectInURL(srchSession.getQuery()), guideOid, srchSession.getSearchGuide() != null && srchSession.getSearchGuide().getCurrentGuideNode() != null ? srchSession.getSearchGuide().getCurrentGuideNode().getPathInGuide() : null, outStr);
        debugStr.append("\r\n............[END] REQUEST DE B\u00daSQUEDA................\r\n\r\n\r\n\r\n");
        if (DEBUG_FINEST) {
            R01FLog.to((String)"r01m.searchEngineWeb").info(debugStr.toString());
        }
        return outStr;
    }

    private String _obtainLang(HttpServletRequest req) {
        String outLang = R01MConstants.DEFAULT_LANG;
        if (!StringUtils.isEmptyString((String)req.getParameter("r01kLang"))) {
            outLang = req.getParameter("r01kLang");
        } else if (!StringUtils.isEmptyString((String)req.getParameter("R01HLang"))) {
            outLang = req.getParameter("R01HLang");
        }
        outLang = R01MSearchEngineUtils.sanitizeParam(outLang);
        if (!R01MConstants.DOCUMENT_ALLOWED_LANGS.contains(outLang)) {
            outLang = R01MConstants.DEFAULT_LANG;
        }
        return StringUtils.isEmptyString((String)outLang) ? R01MConstants.DEFAULT_LANG : outLang;
    }

    private boolean _isInDebugMode(HttpServletRequest req) {
        String debug = req.getParameter("r01kDebug");
        return !StringUtils.isEmptyString((String)debug) && debug.equalsIgnoreCase("true");
    }

    private boolean _showAttachments(HttpServletRequest req) {
        String showAttachments = req.getParameter("r01kShowAttachments");
        return StringUtils.isEmptyString((String)showAttachments) || !showAttachments.equalsIgnoreCase("false");
    }

    private String _moreParameters(HttpServletRequest req) {
        String moreParameters = "";
        if (req.getParameterMap() != null) {
            Map paramMap = req.getParameterMap();
            for (Map.Entry param : paramMap.entrySet()) {
                String paramName = param.getKey().toString();
                if ("r01kSearchResultsHeader|r01kVAName|r01kRss|r01kRssTitle|r01kSearchBox|r01kSuggestedSearchBox|r01kIncludeRisp|r01kBanner|r01kSemanticSearch|r01kMaxNumHighLights|r01kHighLightsNoScriptText|r01kHighLightsNoScriptTitle|r01kPresentationXSL|r01kPresentationThumbnail|r01kPageContents|r01kNumResultsPerPage|numberOfElements|r01kLang|r01kSrchSrcId".indexOf(paramName) >= 0 || "r01kQry|r01kQryXML|r01kStoredQry|searchGUID|r01kCommonSearchQry|fullText|languageAplication".indexOf(paramName) >= 0 || "r01kTgtPg|r01kPgCmd|first|prevBlock|prev|next|nextBlock|last|r01kGuide|r01kCurrGuideEl|r01kTgtGuideEl|r01kGuideCmd|follow|rewind|reset".indexOf(paramName) >= 0 || "r01kCtrl|usageInfo|resetSession|showSession".indexOf(paramName) >= 0 || "R01HPage|R01HLang|r01EJIEEnv|R01HPortal".indexOf(paramName) >= 0) continue;
                moreParameters = moreParameters + paramName + "=" + req.getParameter(paramName) + "&";
            }
        }
        return moreParameters;
    }

    private boolean _isQueryModified(int action) {
        return action == 3 || action == 4;
    }

    private StringBuffer[] _formatSectionBySection(int action, String lang, R01MSearchSession srchSession, R01MSearchSessionFormatter formatter, R01MSearchSessionFormatterPreferences prefs) throws R01MSearchPerformerException {
        StringBuffer[] outStrs = new StringBuffer[]{null, new StringBuffer(575)};
        StringBuffer qryFormatted = srchSession.getCachedFormattedCode("query");
        StringBuffer searchBoxFormatted = srchSession.getCachedFormattedCode("searchBox");
        StringBuffer headerFormatted = srchSession.getCachedFormattedCode("header");
        StringBuffer guideFormatted = srchSession.getCachedFormattedCode("guide");
        if (this._isQueryModified(action) || qryFormatted == null) {
            outStrs[1].append("\r\nNo se hab\u00eda formateado la query... generarla");
            qryFormatted = formatter.formatQuery(lang, prefs, srchSession.getEffectiveQuery(), srchSession.getCachedFormatedCodeMap());
            srchSession.addCachedFormattedCode("query", qryFormatted);
        } else {
            outStrs[1].append("\r\nYa se hab\u00eda formateado la query... NO generarla");
        }
        if (prefs.showSearchBox && (this._isQueryModified(action) || searchBoxFormatted == null)) {
            outStrs[1].append("\r\nNo se hab\u00eda formateado la caja de b\u00fasqueda... generarla");
            searchBoxFormatted = formatter.formatSearchBox(lang, prefs, srchSession.getEffectiveQuery(), srchSession.getCachedFormatedCodeMap());
            srchSession.addCachedFormattedCode("searchBox", searchBoxFormatted);
        } else {
            outStrs[1].append("\r\nYa se hab\u00eda formateado la caja de b\u00fasqueda... NO generarla");
        }
        if (headerFormatted == null) {
            outStrs[1].append("\r\nNo se hab\u00eda formateado la cabecera... generarla");
            headerFormatted = formatter.formatHeader(lang, prefs, srchSession.getEffectiveQuery(), srchSession.getSearchResults(), srchSession.getCachedFormatedCodeMap());
            srchSession.addCachedFormattedCode("header", headerFormatted);
        } else {
            outStrs[1].append("\r\nYa se hab\u00eda formateado la cabecera... NO generarla");
        }
        if (srchSession.getSearchGuide() != null) {
            if (action == 3 || guideFormatted == null) {
                outStrs[1].append("\r\nSe est\u00e1 navegando por la guia o bien NO se hab\u00eda formateado la guia de navegaci\u00f3n... generarla");
                guideFormatted = formatter.formatSearchGuide(lang, prefs, srchSession.getSearchGuide(), srchSession.getCachedFormatedCodeMap());
                srchSession.addCachedFormattedCode("guide", guideFormatted);
            }
        } else {
            outStrs[1].append("\r\nBien NO se utiliza guia de navegaci\u00f3n, bien esta est\u00e1 ya generada y pre-cacheada");
        }
        StringBuffer srchResultHtml = formatter.formatSearchResults(lang, prefs, srchSession.getSearchResults(), srchSession.getCachedFormatedCodeMap(), srchSession.getEffectiveQuery());
        if (DEBUG_FINEST) {
            R01FLog.to((String)"r01m.searchEngineWeb").info("Formatear los resultados de b\u00fasqueda...");
        }
        outStrs[0] = formatter.format(lang, prefs, srchResultHtml, srchSession.getCachedFormatedCodeMap());
        return outStrs;
    }
}

