/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.servlet;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01m.exceptions.R01MSearchGuideManagerException;
import com.ejie.r01m.exceptions.R01MSearchIllegalPaginationException;
import com.ejie.r01m.exceptions.R01MSearchInitializeException;
import com.ejie.r01m.exceptions.R01MSearchPerformerException;
import com.ejie.r01m.exceptions.R01MSearchStorageException;
import com.ejie.r01m.exceptions.R01MSearchWebException;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuide;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.results.R01MSearchSourceResults;
import com.ejie.r01m.objects.searchengine.session.R01MSearchSession;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MSearchEngineSessionAPI;
import com.ejie.r01m.utils.R01MConstants;

public abstract class R01MBaseSearchEngineWebSessionManager {
    protected R01MSearchSession _searchSession;
    protected boolean _cacheSearchSession = true;
    protected boolean _lazyInit = false;
    protected boolean _lazyGuide = false;

    public boolean isCacheSearchSession() {
        return this._cacheSearchSession;
    }

    public void setCacheSearchSession(boolean theCacheSearchSession) {
        this._cacheSearchSession = theCacheSearchSession;
    }

    public boolean isLazyInit() {
        return this._lazyInit;
    }

    public void setLazyInit(boolean theLazyInit) {
        this._lazyInit = theLazyInit;
    }

    public boolean isLazyGuide() {
        return this._lazyGuide;
    }

    public void setLazyGuide(boolean theLazyGuide) {
        this._lazyGuide = theLazyGuide;
    }

    public abstract void resetWebSearchSession();

    protected abstract R01MSearchSession getSearchSessionFromWebSession(Boolean var1) throws R01MSearchWebException, R01MSearchInitializeException;

    protected abstract void setSearchSessionInWebSession(R01MSearchSession var1) throws R01MSearchWebException;

    public R01MSearchSession getSearchSession() {
        return this._searchSession;
    }

    public R01MSearchSession executeStoredQuery(String lang, String queryOid) throws R01MSearchWebException, R01MSearchStorageException, R01MSearchInitializeException {
        R01MQueryObject qry = R01MClientFactory.getSearchEnginePersistenceAPI().loadQuery(queryOid);
        return this.executeQuery(lang, qry);
    }

    public R01MSearchSession executeStoredQuery(String lang, String queryOid, String guideOid) throws R01MSearchWebException, R01MSearchStorageException, R01MSearchInitializeException {
        R01MQueryObject qry = R01MClientFactory.getSearchEnginePersistenceAPI().loadQuery(queryOid);
        return this.executeQuery(lang, qry, guideOid);
    }

    public R01MSearchSession executeQuery(String lang, String queryXML) throws R01MSearchWebException, R01MSearchInitializeException {
        R01MQueryObject qry;
        try {
            qry = (R01MQueryObject)XOManager.getObject((String)R01MConstants.QUERY_RESULTS_MAPFILE, (String)queryXML);
        }
        catch (XOMarshallerException xoEx) {
            throw new R01MSearchInitializeException("Error en el XML de la query: " + xoEx.getMessage(), (Exception)((Object)xoEx));
        }
        return this.executeQuery(lang, qry);
    }

    public R01MSearchSession executeQuery(String lang, String queryXML, String guideOid) throws R01MSearchWebException, R01MSearchInitializeException {
        R01MQueryObject qry;
        try {
            qry = (R01MQueryObject)XOManager.getObject((String)R01MConstants.QUERY_RESULTS_MAPFILE, (String)queryXML);
        }
        catch (XOMarshallerException xoEx) {
            throw new R01MSearchInitializeException("Error en el XML de la query: " + xoEx.getMessage(), (Exception)((Object)xoEx));
        }
        return this.executeQuery(lang, qry, guideOid);
    }

    public R01MSearchSession executeQuery(String lang, R01MQueryObject query) throws R01MSearchWebException, R01MSearchInitializeException {
        return this._initSearchSession(lang, query, null);
    }

    public R01MSearchSession executeQuery(String lang, R01MQueryObject query, String guideOid) throws R01MSearchWebException, R01MSearchInitializeException {
        return this._initSearchSession(lang, query, guideOid);
    }

    public R01MSearchSourceResults gotoFirstPage(String sourceOid) throws R01MSearchWebException, R01MSearchInitializeException, R01MSearchPerformerException, R01MSearchIllegalPaginationException {
        this._searchSession = this.getSearchSessionFromWebSession(null);
        return this._searchSession.goToFirstPage(sourceOid);
    }

    public R01MSearchSourceResults gotoPrevBlockLastPage(String sourceOid) throws R01MSearchWebException, R01MSearchInitializeException, R01MSearchPerformerException, R01MSearchIllegalPaginationException {
        this._searchSession = this.getSearchSessionFromWebSession(null);
        return this._searchSession.goToPrevBlockLastPage(sourceOid);
    }

    public R01MSearchSourceResults gotoPrevPage(String sourceOid) throws R01MSearchWebException, R01MSearchInitializeException, R01MSearchPerformerException, R01MSearchIllegalPaginationException {
        this._searchSession = this.getSearchSessionFromWebSession(null);
        return this._searchSession.goToPrevPage(sourceOid);
    }

    public R01MSearchSourceResults gotoPage(String sourceOid, int pageNum, Boolean isFullTextSearch) throws R01MSearchWebException, R01MSearchInitializeException, R01MSearchPerformerException, R01MSearchIllegalPaginationException {
        this._searchSession = this.getSearchSessionFromWebSession(isFullTextSearch);
        return this._searchSession.goToPage(sourceOid, pageNum);
    }

    public R01MSearchSourceResults gotoNextPage(String sourceOid) throws R01MSearchWebException, R01MSearchInitializeException, R01MSearchPerformerException, R01MSearchIllegalPaginationException {
        this._searchSession = this.getSearchSessionFromWebSession(null);
        return this._searchSession.goToNextPage(sourceOid);
    }

    public R01MSearchSourceResults gotoNextBlockFirstPage(String sourceOid) throws R01MSearchWebException, R01MSearchInitializeException, R01MSearchPerformerException, R01MSearchIllegalPaginationException {
        this._searchSession = this.getSearchSessionFromWebSession(null);
        return this._searchSession.goToNextBlockFirstPage(sourceOid);
    }

    public R01MSearchSourceResults gotoLastPage(String sourceOid) throws R01MSearchWebException, R01MSearchInitializeException, R01MSearchPerformerException, R01MSearchIllegalPaginationException {
        this._searchSession = this.getSearchSessionFromWebSession(null);
        return this._searchSession.goToLastPage(sourceOid);
    }

    public void gotoGuideNode(String guideNodeKey) throws R01MSearchWebException, R01MSearchInitializeException {
        this._searchSession = this.getSearchSessionFromWebSession(null);
        this._searchSession.gotoGuideNode(guideNodeKey);
    }

    public void followGuide(String futureElementKey) throws R01MSearchWebException, R01MSearchInitializeException {
        this._searchSession = this.getSearchSessionFromWebSession(null);
        this._searchSession.followGuide(futureElementKey);
    }

    public void rewindGuide(String elementToRewindKey) throws R01MSearchWebException, R01MSearchInitializeException {
        this._searchSession = this.getSearchSessionFromWebSession(null);
        this._searchSession.rewindGuide(elementToRewindKey);
    }

    public void resetGuide() throws R01MSearchWebException, R01MSearchInitializeException {
        this._searchSession = this.getSearchSessionFromWebSession(null);
        this._searchSession.resetGuide();
    }

    private R01MSearchSession _initSearchSession(String lang, R01MQueryObject qry, String guideOid) throws R01MSearchWebException, R01MSearchInitializeException {
        R01MSearchGuide guide = null;
        try {
            if (!StringUtils.isEmptyString((String)guideOid)) {
                guide = R01MClientFactory.getSearchEnginePersistenceAPI().getGuide(guideOid, qry);
            }
        }
        catch (R01MSearchGuideManagerException gmEx) {
            gmEx.printStackTrace(System.out);
            R01FLog.to((String)"r01m.searchEngineWeb").severe("Se ignora la guia de navegaci\u00f3n " + guideOid + " ya que no se puede cargar la guia: " + gmEx.getMessage());
            guide = null;
        }
        R01MSearchEngineSessionAPI srchAPI = R01MClientFactory.getSearchEngineSessionAPI();
        this._searchSession = srchAPI.createSession(null, null, null, lang, qry, guide, this._lazyInit, this._lazyGuide, true);
        if (this.isCacheSearchSession()) {
            this.setSearchSessionInWebSession(this._searchSession);
        }
        return this._searchSession;
    }
}

