/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.guides;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.config.objects.searchengine.guide.R01MSearchGuideDef;
import com.ejie.r01m.config.objects.searchengine.guide.R01MSearchGuideDefBranch;
import com.ejie.r01m.config.objects.typology.R01MBaseTypologyObject;
import com.ejie.r01m.config.objects.typology.R01MContentCluster;
import com.ejie.r01m.config.objects.typology.R01MContentFamily;
import com.ejie.r01m.config.objects.typology.R01MContentType;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.exceptions.R01MCatalogElementNotFoundException;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MSearchGuideManagerException;
import com.ejie.r01m.exceptions.R01MSearchStorageException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabel;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructure;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructureItem;
import com.ejie.r01m.objects.cataloguing.structures.R01MTerm;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuide;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuideNode;
import com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedTypoObj;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedCluster;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedContentType;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedFamily;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedStructureCatalog;
import com.ejie.r01m.services.R01MClientFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class R01MSearchGuideManager {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.searchEngine").intValue() != Level.OFF.intValue();
    private static Map _guidesCache;

    public static R01MSearchGuide getGuide(String guideOid, R01MQueryObject qry) throws R01MSearchGuideManagerException {
        R01MSearchGuide guide = null;
        try {
            R01MSearchGuideDef guideDef = R01MClientFactory.getSearchEnginePersistenceAPI().loadGuideDef(guideOid);
            guide = R01MSearchGuideManager.getGuide(guideDef, qry);
        }
        catch (R01MSearchStorageException ssEx) {
            throw new R01MSearchGuideManagerException("Error al componer la guia a partir de su definici\u00f3n: " + ssEx.getMessage(), (Exception)((Object)ssEx));
        }
        return guide;
    }

    public static R01MSearchGuide getGuide(R01MSearchGuideDef guideDef, R01MQueryObject qry) throws R01MSearchGuideManagerException {
        R01MSearchGuide masterGuide;
        if (guideDef == null) {
            return null;
        }
        if (_guidesCache == null) {
            _guidesCache = new HashMap();
        }
        if ((masterGuide = (R01MSearchGuide)_guidesCache.get(guideDef.getOid())) == null) {
            masterGuide = R01MSearchGuideManager._composeGuide(guideDef);
            _guidesCache.put(guideDef.getOid(), masterGuide);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01m.searchEngine").info("Guia de navegaci\u00f3n\r\n" + masterGuide.composeDebugInfo());
        }
        R01MSearchGuide clonedGuide = masterGuide.cloneGuide();
        clonedGuide.setCurrentGuideNode(null);
        if (qry != null) {
            List structsToRemove;
            HashSet nodesToRetainPaths = new HashSet();
            Set clustersToRetain = R01MSearchGuideManager._findTypoNodesToRetain(guideDef, clonedGuide.getGuideNodesIndex(), qry.getContentClusters());
            Set familiesToRetain = R01MSearchGuideManager._findTypoNodesToRetain(guideDef, clonedGuide.getGuideNodesIndex(), qry.getContentFamilies());
            Set typosToRetain = R01MSearchGuideManager._findTypoNodesToRetain(guideDef, clonedGuide.getGuideNodesIndex(), qry.getContentTypes());
            if (clustersToRetain != null) {
                nodesToRetainPaths.addAll(clustersToRetain);
            }
            if (familiesToRetain != null) {
                nodesToRetainPaths.addAll(familiesToRetain);
            }
            if (typosToRetain != null) {
                nodesToRetainPaths.addAll(typosToRetain);
            }
            if (nodesToRetainPaths != null && nodesToRetainPaths.size() > 0) {
                ArrayList<String> nodesToRemove = new ArrayList<String>();
                R01MSearchGuideNode currNode = null;
                String currNodePathInGuide = null;
                Map.Entry me2 = null;
                for (Map.Entry me2 : clonedGuide.getGuideNodesIndex().entrySet()) {
                    currNode = (R01MSearchGuideNode)me2.getValue();
                    currNodePathInGuide = (String)me2.getKey();
                    if (!currNode.getNodeType().equals("typo") || nodesToRetainPaths.contains(currNode.getPathInBranch())) continue;
                    nodesToRemove.add(currNodePathInGuide);
                }
                Iterator it = nodesToRemove.iterator();
                while (it.hasNext()) {
                    clonedGuide.removeNode((String)((Object)it.next()));
                }
            }
            if ((structsToRemove = R01MSearchGuideManager._findStructureNodesToRemove(clonedGuide.getGuideNodesIndex(), qry.getCatalogLabelsAnd())) != null) {
                for (String structToRemove : structsToRemove) {
                    if (DEBUG) {
                        R01FLog.to((String)"r01m.searchEngine").info(structToRemove);
                    }
                    clonedGuide.removeNode(structToRemove);
                }
            }
        }
        return clonedGuide;
    }

    public static void reloadGuide(R01MSearchGuideDef guideDef) throws R01MSearchGuideManagerException {
        R01MSearchGuide masterGuide = R01MSearchGuideManager._composeGuide(guideDef);
        if (_guidesCache == null) {
            _guidesCache = new HashMap();
        }
        _guidesCache.put(guideDef.getOid(), masterGuide);
    }

    public static void resetGuide() {
        _guidesCache = null;
    }

    private static Set _findTypoNodesToRetain(R01MSearchGuideDef guideDef, Map nodeIndex, List typoSearchedObjs) {
        if (typoSearchedObjs == null) {
            return null;
        }
        HashSet<String> nodesToRetainPaths = new HashSet<String>();
        R01MBaseSearchedTypoObj currSearchedTypoObj2 = null;
        for (R01MBaseSearchedTypoObj currSearchedTypoObj2 : typoSearchedObjs) {
            R01MSearchGuideNode currNode2 = null;
            String[] currNodePathSplitted = null;
            for (R01MSearchGuideNode currNode2 : nodeIndex.values()) {
                if (!currNode2.getNodeType().equals("typo")) continue;
                R01MSearchGuideDefBranch branchDef = guideDef.getBranchDef(currNode2.getBranchDefPath());
                currNodePathSplitted = (branchDef.getStartingPath() + "/" + currNode2.getPathInBranch()).split("/");
                if (currSearchedTypoObj2 instanceof R01MSearchedCluster && currNodePathSplitted.length == 1 && currNodePathSplitted[0].equals(currSearchedTypoObj2.getOid())) {
                    nodesToRetainPaths.add(currNode2.getPathInBranch());
                    continue;
                }
                if (currSearchedTypoObj2 instanceof R01MSearchedFamily && currNodePathSplitted.length == 2 && currNodePathSplitted[1].equals(currSearchedTypoObj2.getOid())) {
                    nodesToRetainPaths.add(currNode2.getPathInBranch());
                    continue;
                }
                if (!(currSearchedTypoObj2 instanceof R01MSearchedContentType) || currNodePathSplitted.length != 3 || !currNodePathSplitted[2].equals(currSearchedTypoObj2.getOid())) continue;
                nodesToRetainPaths.add(currNode2.getPathInBranch());
            }
        }
        return nodesToRetainPaths;
    }

    private static List _findStructureNodesToRemove(Map guideNodeIndex, List structureCats) {
        if (structureCats == null) {
            return null;
        }
        ArrayList<String> nodesToRemovePaths = new ArrayList<String>();
        R01MSearchedStructureCatalog currCat2 = null;
        for (R01MSearchedStructureCatalog currCat2 : structureCats) {
            R01MSearchGuideNode currNode2 = null;
            for (R01MSearchGuideNode currNode2 : guideNodeIndex.values()) {
                if (!currNode2.getNodeType().equals("structure") || currNode2.getPathInBranch().indexOf(currCat2.getLabelOid()) < 0) continue;
                R01MSearchGuideNode parentNode = currNode2.getParentNode();
                if (parentNode != null) {
                    R01MSearchGuideNode currChildNode2 = null;
                    for (R01MSearchGuideNode currChildNode2 : parentNode.getFutureNodes()) {
                        if (currChildNode2.getPathInBranch().indexOf(currCat2.getLabelOid()) >= 0) continue;
                        nodesToRemovePaths.add(currChildNode2.getPathInGuide());
                    }
                    continue;
                }
                R01MSearchGuideNode currFirstLevelNode2 = null;
                for (R01MSearchGuideNode currFirstLevelNode2 : guideNodeIndex.values()) {
                    if (!currFirstLevelNode2.getNodeType().equals("structure") || currFirstLevelNode2.getPathInGuide().indexOf(currCat2.getLabelOid()) >= 0) continue;
                    nodesToRemovePaths.add(currFirstLevelNode2.getPathInGuide());
                }
            }
        }
        return nodesToRemovePaths;
    }

    private static R01MSearchGuide _composeGuide(R01MSearchGuideDef guideDef) throws R01MSearchGuideManagerException {
        R01MSearchGuide outGuide = new R01MSearchGuide(guideDef.getOid(), guideDef.getName(), guideDef.getDescription());
        R01MSearchGuideDefBranch startingBranch = guideDef.getStartingBranch();
        R01MSearchGuideNode[] firstLevelNodes = R01MSearchGuideManager._composeBranch(outGuide.getGuideNodesIndex(), startingBranch);
        outGuide.setFirstLevelNodes(firstLevelNodes);
        return outGuide;
    }

    private static R01MSearchGuideNode[] _composeBranch(Map guideIndex, R01MSearchGuideDefBranch branchDef) throws R01MSearchGuideManagerException {
        R01MSearchGuideNode[] nextLevelBranchNodes;
        if (branchDef == null) {
            return null;
        }
        R01MSearchGuideNode[] branchNodes = null;
        String branchType = branchDef.getBranchType();
        if (branchType.equals("typo")) {
            branchNodes = R01MSearchGuideManager._composeTypoBranch(branchDef);
        } else if (branchType.equals("structure")) {
            branchNodes = R01MSearchGuideManager._composeStructureBranch(branchDef);
        } else if (branchType.equals("geoStructure")) {
            throw new R01MSearchGuideManagerException("NO implementado de momento!");
        }
        HashMap branchNodesIndex = new HashMap();
        R01MSearchGuideManager._composeBranchNodesIndex(branchNodesIndex, branchNodes);
        guideIndex.putAll(branchNodesIndex);
        if (branchNodes != null && branchDef.getNextLevelBranch() != null && (nextLevelBranchNodes = R01MSearchGuideManager._composeBranch(guideIndex, branchDef.getNextLevelBranch())) != null) {
            for (R01MSearchGuideNode currNode : branchNodesIndex.values()) {
                if (currNode.getFutureNodes() != null && currNode.getFutureNodes().size() != 0) continue;
                for (int i = 0; i < nextLevelBranchNodes.length; ++i) {
                    currNode.addFutureGuideNode(nextLevelBranchNodes[i]);
                }
            }
        }
        return branchNodes;
    }

    private static void _composeBranchNodesIndex(Map index, R01MSearchGuideNode[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            index.put(nodes[i].getPathInGuide(), nodes[i]);
            if (nodes[i].getFutureNodes() == null) continue;
            R01MSearchGuideManager._composeBranchNodesIndex(index, nodes[i].getFutureNodesArray());
        }
    }

    private static R01MSearchGuideNode[] _composeStructureBranch(R01MSearchGuideDefBranch branchDef) throws R01MSearchGuideManagerException {
        R01MSearchGuideNode[] outNodes;
        String startingPath = branchDef.getStartingPath();
        if (startingPath == null || startingPath.length() == 0) {
            throw new R01MSearchGuideManagerException("NO se puede crear el branch tipo estructura de catalogaci\u00f3n ya que al menos se debe indicar el EJE en la propiedad startingPath de la definici\u00f3n del branch!");
        }
        String[] startingPathEls = startingPath.split("/");
        String structureOid = startingPathEls[0];
        R01MStructure structure = null;
        try {
            structure = R01MClientFactory.getCatalogAPI(R01MAuthManager.createMasterSystemUserContext()).loadStructure(structureOid, false);
        }
        catch (R01MCatalogElementNotFoundException catNFEx) {
            throw new R01MSearchGuideManagerException("La estructura " + structureOid + " no existe: " + catNFEx.getMessage(), (Exception)((Object)catNFEx));
        }
        catch (R01MCatalogException catEx) {
            throw new R01MSearchGuideManagerException("Error al cargar la estructura " + structureOid + ": " + catEx.getMessage(), (Exception)((Object)catEx));
        }
        catch (R01MSecurityException secEx) {
            throw new R01MSearchGuideManagerException("Error al cargar la estructura " + structureOid + ". Error al crear el contexto del usuario administrador: " + secEx.getMessage(), (Exception)((Object)secEx));
        }
        if (structure == null) {
            throw new R01MSearchGuideManagerException("NO se ha cargado la estructura " + structureOid);
        }
        String currLabelOid = null;
        Map<String, R01MStructureItem> children = structure.getStructureItems();
        R01MStructureItem currItem = null;
        for (int i = 1; children != null && i < startingPathEls.length; ++i) {
            currLabelOid = startingPathEls[i];
            currItem = (R01MStructureItem)children.get(currLabelOid);
            if (currItem == null) {
                throw new R01MSearchGuideManagerException("La etiqueta " + currLabelOid + " NO existe en el eje " + structureOid + ": Revisa la ruta especificada en la propiedad startingPath de la definici\u00f3n del branch!!!");
            }
            children = currItem.getChildren();
        }
        if (children == null && currItem != null) {
            children = new HashMap<String, R01MStructureItem>(1);
            children.put(currItem.getRootLabelOid(), currItem);
        }
        try {
            outNodes = R01MSearchGuideManager._composeStructureBranchNodes(branchDef.getMaxLevels(), 1, branchDef.getPathInGuide(), null, children);
        }
        catch (R01MCatalogElementNotFoundException catNFEx) {
            throw new R01MSearchGuideManagerException("Alguna etiqueta no existe: " + catNFEx.getMessage(), (Exception)((Object)catNFEx));
        }
        catch (R01MCatalogException catEx) {
            throw new R01MSearchGuideManagerException("Error al cargar las etiquetas : " + catEx.getMessage(), (Exception)((Object)catEx));
        }
        return outNodes;
    }

    private static R01MSearchGuideNode[] _composeStructureBranchNodes(int maxLevels, int currLevel, String branchDefPath, String parentNodePath, Map children) throws R01MCatalogException, R01MCatalogElementNotFoundException {
        if (children == null) {
            return null;
        }
        R01MSearchGuideNode[] outNodes = new R01MSearchGuideNode[children.size()];
        int i = 0;
        for (R01MStructureItem currItem : children.values()) {
            R01MLabel label;
            HashMap<String, String> itemDescriptions = null;
            try {
                label = R01MClientFactory.getCatalogAPI(R01MAuthManager.createMasterSystemUserContext()).loadLabel(currItem.getRootLabelOid(), false);
            }
            catch (R01MSecurityException secEx) {
                throw new R01MCatalogException("Error al cargar la etiqueta " + currItem.getRootLabelOid() + ". Error al crear el contexto del usuario administrador: " + secEx.getMessage(), (Exception)((Object)secEx));
            }
            if (label.getStandardizedTerms() != null) {
                itemDescriptions = new HashMap<String, String>(label.getStandardizedTerms().size());
                for (R01MTerm term : label.getStandardizedTerms().values()) {
                    itemDescriptions.put(term.getLanguage(), term.getValue());
                }
            }
            String currNodePathInBranch = (parentNodePath == null ? "" : parentNodePath + "/") + currItem.getRootLabelOid();
            R01MSearchGuideNode itemNode = new R01MSearchGuideNode("structure", branchDefPath, currNodePathInBranch, itemDescriptions);
            R01MSearchGuideNode[] childNodes = null;
            if (currLevel < maxLevels) {
                childNodes = R01MSearchGuideManager._composeStructureBranchNodes(maxLevels, currLevel + 1, branchDefPath, currNodePathInBranch, currItem.getChildren());
            }
            if (childNodes != null) {
                itemNode.setFutureNodesFromArray(childNodes);
            }
            outNodes[i] = itemNode;
            ++i;
        }
        return outNodes;
    }

    private static R01MSearchGuideNode[] _composeTypoBranch(R01MSearchGuideDefBranch branchDef) throws R01MSearchGuideManagerException {
        String startingPath = branchDef.getStartingPath();
        R01MSearchGuideNode[] outNodes = null;
        if (startingPath != null && startingPath.length() > 0) {
            String[] startingPathEls = startingPath.split("/");
            if (startingPathEls.length > 3) {
                throw new R01MSearchGuideManagerException("Error en la definici\u00f3n del branch de la guia: en una guia tipol\u00f3gica solo hay tres niveles: cluster/familia/tipo.\r\nRevisa la propiedad startingPath de la definici\u00f3n del branch");
            }
            R01MBaseTypologyObject typoObj = R01MSearchGuideManager._obtainFirstBranchTypologyObjectConfig(branchDef.getStartingPath());
            HashMap<String, R01MBaseTypologyObject> children = typoObj.getChildren();
            if (typoObj instanceof R01MContentType) {
                children = new HashMap<String, R01MBaseTypologyObject>();
                children.put(typoObj.getOid(), typoObj);
            }
            outNodes = R01MSearchGuideManager._composeTypoBranchNodes(branchDef.getMaxLevels(), 1, branchDef.getPathInGuide(), null, children);
        } else {
            Map clusters = R01MSearchGuideManager._obtainClustersConfig();
            outNodes = R01MSearchGuideManager._composeTypoBranchNodes(branchDef.getMaxLevels(), 1, branchDef.getPathInGuide(), null, clusters);
        }
        return outNodes;
    }

    private static R01MSearchGuideNode[] _composeTypoBranchNodes(int maxLevels, int currLevel, String branchDefPath, String parentNodePath, Map children) {
        if (children == null) {
            return null;
        }
        R01MSearchGuideNode[] outNodes = new R01MSearchGuideNode[children.size()];
        int i = 0;
        for (R01MBaseTypologyObject currTypoObj : children.values()) {
            Map itemDescriptions = currTypoObj.getPublicName();
            String currNodePathInBranch = (parentNodePath == null ? "" : parentNodePath + "/") + currTypoObj.getOid();
            R01MSearchGuideNode itemNode = new R01MSearchGuideNode("typo", branchDefPath, currNodePathInBranch, itemDescriptions);
            R01MSearchGuideNode[] childNodes = null;
            if (currLevel < maxLevels) {
                childNodes = R01MSearchGuideManager._composeTypoBranchNodes(maxLevels, currLevel + 1, branchDefPath, currNodePathInBranch, currTypoObj.getChildren());
            }
            if (childNodes != null) {
                itemNode.setFutureNodesFromArray(childNodes);
            }
            outNodes[i] = itemNode;
            ++i;
        }
        return outNodes;
    }

    private static R01MBaseTypologyObject _obtainFirstBranchTypologyObjectConfig(String typoPath) throws R01MSearchGuideManagerException {
        Map clusters = R01MSearchGuideManager._obtainClustersConfig();
        String[] typoPathEls = typoPath.split("/");
        if (typoPathEls.length > 3) {
            throw new R01MSearchGuideManagerException("Error en la definici\u00f3n del branch de la guia: en una guia tipol\u00f3gica solo hay tres niveles: cluster/familia/tipo.\r\nRevisa la propiedad startingPath de la definici\u00f3n del branch");
        }
        R01MContentCluster cluster = null;
        R01MContentFamily family = null;
        R01MContentType type = null;
        if (typoPathEls.length >= 1) {
            cluster = (R01MContentCluster)clusters.get(typoPathEls[0]);
        }
        if (typoPathEls.length >= 2 && cluster != null) {
            family = cluster.getFamily(typoPathEls[1]);
        }
        if (typoPathEls.length == 3 && family != null) {
            type = family.getType(typoPathEls[2]);
        }
        R01MBaseTypologyObject outTypoObj = null;
        if (typoPathEls.length == 1) {
            outTypoObj = cluster;
        } else if (typoPathEls.length == 2) {
            outTypoObj = family;
        } else if (typoPathEls.length == 3) {
            outTypoObj = type;
        }
        if (outTypoObj == null) {
            throw new R01MSearchGuideManagerException("NO se ha podido cargar la configuraci\u00f3n de alguno de los objetos de tipolog\u00eda de la ruta " + typoPath);
        }
        return outTypoObj;
    }

    private static Map _obtainClustersConfig() throws R01MSearchGuideManagerException {
        Map<String, R01MContentCluster> clusters = null;
        try {
            clusters = R01MClientFactory.getTypologyConfigAPI().getAllClusterConfig();
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            throw new R01MSearchGuideManagerException("Error al obtener la configuraci\u00f3n de los clusters: " + cfgLoadEx.getMessage(), (Exception)((Object)cfgLoadEx));
        }
        if (clusters == null) {
            throw new R01MSearchGuideManagerException("NO se ha podido obtener la configuraci\u00f3n de los clusters!!");
        }
        return clusters;
    }
}

