/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.rss.defaults;

import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuide;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchSessionResults;
import com.ejie.r01m.objects.searchengine.results.R01MSearchSourceResults;
import com.ejie.r01m.objects.searchengine.session.R01MSearchSession;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchQueryFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchResultItemsFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchSessionFormatter;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class R01MDefSearchSessionRSSFormatter
implements R01MSearchSessionFormatter,
Serializable {
    private static final long serialVersionUID = -5286844506799110678L;

    @Override
    public StringBuffer formatSearchSession(String lang, R01MSearchSessionFormatterPreferences prefs, R01MSearchSession session) {
        return null;
    }

    @Override
    public StringBuffer formatSectionBySection(String lang, R01MSearchSessionFormatterPreferences prefs, StringBuffer searchResultsFormatted, Map preGeneratedCode) {
        return R01MDefSearchSessionRSSFormatter._format(lang, searchResultsFormatted, preGeneratedCode, prefs.resultsFormatterPreferences.rssSpec, prefs.encodingType);
    }

    @Override
    public StringBuffer format(String lang, R01MSearchSessionFormatterPreferences prefs, StringBuffer searchResultsFormatted, Map preGeneratedCode) {
        return this.formatSectionBySection(lang, prefs, searchResultsFormatted, preGeneratedCode);
    }

    @Override
    public StringBuffer formatSearchBox(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject qry, Map preGeneratedCode) {
        return null;
    }

    @Override
    public StringBuffer formatHeader(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject query, R01MSearchSessionResults sessionResults, Map preGeneratedCode) {
        return R01MDefSearchSessionRSSFormatter._composeChannelDescription(lang, prefs, preGeneratedCode);
    }

    @Override
    public StringBuffer formatQuery(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject qry, Map preGeneratedCode) {
        return this.formatQuery(lang, prefs, qry, preGeneratedCode, false);
    }

    @Override
    public StringBuffer formatQuery(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject qry, Map preGeneratedCode, boolean showAllMetadataDescription) {
        StringBuffer query = R01MDefSearchSessionRSSFormatter._formatQuery(lang, prefs, qry, preGeneratedCode, showAllMetadataDescription);
        return query;
    }

    @Override
    public StringBuffer formatRssFeedLink(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject qry, Map preGeneratedCode) {
        return null;
    }

    @Override
    public StringBuffer formatRispLink(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject qry, Map preGeneratedCode) {
        return null;
    }

    @Override
    public StringBuffer formatSearchResults(String lang, R01MSearchSessionFormatterPreferences prefs, R01MSearchSessionResults sessionResults, Map preGeneratedCode, R01MQueryObject qry) {
        StringBuffer results = R01MDefSearchSessionRSSFormatter._formatResults(lang, prefs, sessionResults.getSearchResultsBySource(), preGeneratedCode);
        return results;
    }

    @Override
    public StringBuffer formatSearchResultsItems(String lang, R01MSearchSessionFormatterPreferences prefs, R01MSearchResultItem[] items, Map preGeneratedCode) {
        return R01MDefSearchSessionRSSFormatter._formatResultItems(lang, prefs, items, preGeneratedCode);
    }

    @Override
    public StringBuffer formatSearchGuide(String lang, R01MSearchSessionFormatterPreferences prefs, R01MSearchGuide guide, Map preGeneratedCode) {
        return null;
    }

    private static StringBuffer _format(String lang, StringBuffer searchResultsFormatted, Map preGeneratedCode, int rssSpecification, int rssEncodingType) {
        StringBuffer sb = new StringBuffer(400);
        if (rssEncodingType == 1) {
            sb.append("<?xml version=\"1.0\" encoding='UTF-8'?>\r\n");
        } else {
            sb.append("<?xml version=\"1.0\" encoding='ISO-8859-1'?>\r\n");
        }
        if (rssSpecification == 1) {
            sb.append("<!DOCTYPE rss SYSTEM \"http://my.netscape.com/publish/formats/rss-0.91.dtd\">\r\n<rss version=\"0.91\">\r\n");
        } else {
            sb.append("<rss xmlns:content='http://purl.org/rss/1.0/modules/content/' xmlns:taxo='http://purl.org/rss/1.0/modules/taxonomy/' xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#' xmlns:dc='http://purl.org/dc/elements/1.1/' xmlns:atom='http://www.w3.org/2005/Atom' version='2.0'>\r\n");
        }
        if (preGeneratedCode != null) {
            StringBuffer headerFormatted = (StringBuffer)preGeneratedCode.get("header");
            sb.append("<channel>\r\n");
            if (headerFormatted != null) {
                sb.append(headerFormatted);
            }
            if (searchResultsFormatted != null) {
                sb.append(searchResultsFormatted);
            }
            sb.append("</channel>\r\n");
        }
        sb.append("</rss>");
        StringUtils.windows1252ToIso8859((StringBuffer)sb);
        return sb;
    }

    private static StringBuffer _formatQuery(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject qry, Map preGeneratedCode, boolean showAllMetadataDescription) {
        R01MSearchSessionFormatterPreferences appliedPrefs = prefs == null ? new R01MSearchSessionFormatterPreferences() : prefs;
        StringBuffer sb = new StringBuffer(87);
        if (appliedPrefs.formatterImpls.searchQueryFormatterClassName != null) {
            try {
                R01MSearchQueryFormatter qryFormatter = (R01MSearchQueryFormatter)ReflectionUtils.getObjectInstance((String)appliedPrefs.formatterImpls.searchQueryFormatterClassName);
                sb.append(qryFormatter.doFormatQuery(lang, appliedPrefs.queryFormatterPreferences, qry, showAllMetadataDescription));
            }
            catch (ReflectionException refEx) {
                refEx.printStackTrace(System.out);
                sb.append("Error al formatear la cabecera de b\u00fasqueda. No se ha podido instanciar el formateador: ");
                sb.append(refEx.getMessage());
            }
        }
        return sb;
    }

    private static StringBuffer _formatResults(String lang, R01MSearchSessionFormatterPreferences prefs, Map searchResultsBySource, Map preGeneratedCode) {
        R01MSearchSessionFormatterPreferences appliedPrefs = prefs == null ? new R01MSearchSessionFormatterPreferences() : prefs;
        StringBuffer sb = new StringBuffer("");
        if (searchResultsBySource != null) {
            R01MSearchSourceResults currSrcResults2 = null;
            for (R01MSearchSourceResults currSrcResults2 : searchResultsBySource.values()) {
                if (currSrcResults2.getResults() == null || currSrcResults2.getResults().length == 0) {
                    sb.append(R01MDefSearchSessionRSSFormatter._composeNoResultsMessage(lang, preGeneratedCode));
                    continue;
                }
                sb.append(R01MDefSearchSessionRSSFormatter._formatResultItems(lang, appliedPrefs, currSrcResults2.getResults(), preGeneratedCode));
            }
        } else {
            sb.append(R01MDefSearchSessionRSSFormatter._composeNoResultsMessage(lang, preGeneratedCode));
        }
        return sb;
    }

    private static StringBuffer _formatResultItems(String lang, R01MSearchSessionFormatterPreferences prefs, R01MSearchResultItem[] items, Map preGeneratedCode) {
        R01MSearchSessionFormatterPreferences appliedPrefs = prefs == null ? new R01MSearchSessionFormatterPreferences() : prefs;
        StringBuffer sb = new StringBuffer(78);
        if (appliedPrefs.formatterImpls.searchResultItemFormatterClassName != null) {
            try {
                R01MSearchResultItemsFormatter resultsFormatter = (R01MSearchResultItemsFormatter)ReflectionUtils.getObjectInstance((String)appliedPrefs.formatterImpls.searchResultItemFormatterClassName);
                sb.append(resultsFormatter.doFormatResultItems(lang, appliedPrefs.resultsFormatterPreferences, items));
            }
            catch (ReflectionException refEx) {
                refEx.printStackTrace(System.out);
                sb.append("Error al formatear los resultados. No se ha podido instanciar el formateador: ");
                sb.append(refEx.getDetailedMessage());
            }
        }
        return sb;
    }

    private static StringBuffer _composeChannelDescription(String lang, R01MSearchSessionFormatterPreferences prefs, Map preGeneratedCode) {
        String rssChannelImageURL;
        StringBuffer queryFormatted = preGeneratedCode != null ? (StringBuffer)preGeneratedCode.get("query") : new StringBuffer("");
        StringBuffer outSb = new StringBuffer(500);
        outSb.append("\t<title>");
        String title = prefs != null && !StringUtils.isEmptyString((String)prefs.getFormatterProperty("rssTitle")) ? prefs.getFormatterProperty("rssTitle") : (!StringUtils.isEmptyStringBuffer((StringBuffer)queryFormatted) ? queryFormatted.toString() : "RSS Feed");
        outSb.append(title);
        String fmt = DateUtils.getLanguageDateFormat((String)"rss", (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS);
        outSb.append("</title>\r\n\t<link>");
        outSb.append(prefs.requestUri);
        outSb.append("</link>\r\n\t<description>");
        outSb.append(R01MConstants.CUSTOMER_NAME);
        outSb.append("</description>\r\n\t<language>");
        outSb.append(lang.equalsIgnoreCase("es") ? "es-es" : lang);
        outSb.append("</language>\r\n\t<copyright>");
        outSb.append(XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"customerInfo/copyright"));
        outSb.append("</copyright>\r\n");
        if (prefs.resultsFormatterPreferences.rssSpec == 2) {
            outSb.append("\t<generator>PLATEA-EJGV-EJIE</generator>\r\n");
        }
        if (prefs.resultsFormatterPreferences.rssSpec == 2) {
            outSb.append("\t<docs>http://www.rssboard.org/rss-2-0</docs>\r\n");
        } else if (prefs.resultsFormatterPreferences.rssSpec == 1) {
            outSb.append("\t<docs>http://www.rssboard.org/rss-0-9-1</docs>\r\n");
        }
        outSb.append("\t<pubDate>");
        outSb.append(DateUtils.getDateFormated((Date)new Date(), (String)fmt, (Locale)Locale.ENGLISH));
        outSb.append("</pubDate>\r\n\t<lastBuildDate>");
        outSb.append(DateUtils.getDateFormated((Date)new Date(), (String)fmt, (Locale)Locale.ENGLISH));
        outSb.append("</lastBuildDate>\r\n");
        String rssChannelImagePath = prefs != null ? prefs.getFormatterProperty("rssChannelImagePath") : null;
        String string = rssChannelImageURL = prefs != null ? prefs.getFormatterProperty("rssChannelImageURL") : null;
        if (rssChannelImagePath == null && rssChannelImageURL == null) {
            rssChannelImageURL = R01MConstants.URL_INTERNET + XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"searchEngine/rss/rssChannelImagePath", (String)"/AVComun/images/r01-euskadieus_logo_250.gif");
        } else if (rssChannelImageURL == null && rssChannelImagePath != null) {
            rssChannelImageURL = R01MConstants.URL_INTERNET + rssChannelImagePath;
        }
        if (rssChannelImageURL != null) {
            outSb.append("\t<image>\r\n\t\t<title>");
            outSb.append(title);
            outSb.append("</title>\r\n\t\t<url>");
            outSb.append(rssChannelImageURL);
            outSb.append("</url>\r\n\t\t<link>");
            outSb.append(prefs.requestUri);
            outSb.append("</link>\r\n\t</image>\r\n");
        }
        return outSb;
    }

    private static StringBuffer _composeNoResultsMessage(String lang, Map preGeneratedCode) {
        return new StringBuffer("");
    }
}

