/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.rss.defaults;

import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.R01FProperties;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemPublicationInfo;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemStructureCatalog;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterDirectiveUtils;
import com.ejie.r01m.searchengine.formatters.R01MSearchResultItemFormatterUtils;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchResultItemsFormatter;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchResultsFormatterPreferences;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class R01MDefSearchResultItemsRSSFormatter
implements R01MSearchResultItemsFormatter,
Serializable {
    private static final long serialVersionUID = 4137006538927512147L;
    private Properties _typoDepFormatterClassNames = null;
    private static Properties _authorByLang = XMLProperties.getProperties((String)R01MConstants.API_APPCODE, (String)"searchEngine/rss/authorByLang");
    private static String RSS_KEY_FILE = XMLProperties.getString((String)R01MConstants.API_APPCODE, (String)"rssFormatter/templateKey", (String)"contentRSS");
    private static String CONTENT_BASE_PATH = XMLProperties.getString((String)R01MConstants.API_APPCODE, (String)"aliasManagement/documentFriendlyUrl/basePathInApache", (String)"/aplic/r32/html");

    @Override
    public void setTypoDependantFormatterClassNames(Properties classNames) {
        this._typoDepFormatterClassNames = classNames;
        if (this._typoDepFormatterClassNames == null) {
            this._typoDepFormatterClassNames = R01FProperties.getProperties((String)R01MConstants.API_APPCODE, (String)"searchEngine/searchResultItemFormatterByTypo/rss");
        }
    }

    @Override
    public StringBuffer doFormatResultItems(String lang, R01MSearchResultsFormatterPreferences prefs, R01MSearchResultItem[] results) {
        if (results == null || results.length == 0) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        StringBuffer sb = new StringBuffer(200);
        for (int i = 0; i < results.length; ++i) {
            try {
                sb.append(this._formatResultItem(lang, prefs, results[i]));
                continue;
            }
            catch (Exception ex) {
                sb.append("<!--[Error :");
                sb.append(ex.getMessage());
                sb.append("]-->");
            }
        }
        return sb;
    }

    private StringBuffer _formatResultItem(String lang, R01MSearchResultsFormatterPreferences prefs, R01MSearchResultItem item) {
        String author;
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        StringBuffer sb = new StringBuffer(300);
        StringBuffer itemURL = R01MSearchResultItemFormatterUtils.composeItemURL(item, prefs);
        String string = _authorByLang != null ? (_authorByLang.get(lang) != null ? _authorByLang.getProperty(lang) : _authorByLang.getProperty("default")) : (author = null);
        if (author == null) {
            author = "Euskadi.eus";
        }
        String itemName = item.getDocumentName() != null ? item.getDocumentName() : R01MConstants.CUSTOMER_DOMAIN;
        String itemDescription = item.getDocumentDescription();
        sb.append("\t<item>\r\n");
        sb.append("\t\t<title><![CDATA[");
        sb.append(R01MSearchEngineUtils.fixTextForRSS(itemName));
        sb.append("]]></title>\r\n");
        String domain = prefs.itemUrlBase;
        sb.append("\t\t<link>");
        sb.append(domain);
        sb.append(itemURL);
        sb.append("</link>\r\n");
        sb.append("\t\t<description><![CDATA[");
        if (item.documentMainDataFileGeneratedFilesDocumentRelativePaths.containsKey(RSS_KEY_FILE)) {
            sb.append("\r\n<!--#exec cmd=\"if [ `stat -c %s ");
            sb.append(CONTENT_BASE_PATH);
            sb.append(this._composeItemCustomRSSURL(item));
            sb.append("` -gt 0 ]; then cat ");
            sb.append(CONTENT_BASE_PATH);
            sb.append(this._composeItemCustomRSSURL(item));
            sb.append("; else echo ");
            if (itemDescription != null) {
                sb.append(R01MSearchEngineUtils.fixTextForRSS(itemDescription).replaceAll("\"", "&#34;"));
            }
            sb.append("; fi;\"-->");
        } else if (itemDescription != null) {
            sb.append(R01MSearchEngineUtils.fixTextForRSS(itemDescription));
        } else {
            sb.append(R01MSearchEngineUtils.fixTextForRSS(itemName));
        }
        sb.append("\r\n]]></description>\r\n");
        if (prefs.rssSpec == 2) {
            if (author != null) {
                sb.append("\t\t<dc:creator><![CDATA[");
                sb.append(author);
                sb.append("]]></dc:creator>\r\n");
            }
            sb.append("\t\t<guid isPermaLink='true'>");
            sb.append(domain);
            sb.append(itemURL);
            sb.append("</guid>\r\n\t\t<pubDate>");
            sb.append(this._composePubDate(lang, item));
            sb.append("</pubDate>\r\n");
            sb.append(this._composeItemCategories(lang, item));
        }
        sb.append("\t</item>\r\n");
        return sb;
    }

    private StringBuffer _composeItemCategories(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer("");
        if (item.getContentTypology() != null) {
            outSb.append("\t\t<category domain='");
            outSb.append(R01MConstants.CUSTOMER_DOMAIN);
            outSb.append("'><![CDATA[");
            outSb.append(R01MSearchFormatterDirectiveUtils.composeTypoDirective(item.getContentTypology().getClusterOid(), item.getContentTypology().getFamilyOid(), item.getContentTypology().getTypeOid()));
            outSb.append("]]></category>\r\n");
        }
        if (item.getStructureCatalogs() != null) {
            R01MSearchResultItemStructureCatalog currCat2 = null;
            HashMap<String, R01MSearchResultItemStructureCatalog> uniqueCats = new HashMap<String, R01MSearchResultItemStructureCatalog>();
            for (R01MSearchResultItemStructureCatalog currCat2 : item.getStructureCatalogs()) {
                uniqueCats.put(currCat2.getOid(), currCat2);
            }
            for (R01MSearchResultItemStructureCatalog currCat2 : uniqueCats.values()) {
                String searchResultItemStructureCatalog = R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(currCat2.getStructureOid(), currCat2.getOid(), currCat2.getRole());
                if (StringUtils.isEmptyString((String)searchResultItemStructureCatalog)) continue;
                outSb.append("\t\t<category domain='");
                outSb.append(R01MConstants.CUSTOMER_DOMAIN);
                outSb.append("'><![CDATA[");
                outSb.append(searchResultItemStructureCatalog);
                outSb.append("]]></category>\r\n");
            }
        }
        return outSb;
    }

    private String _composePubDate(String lang, R01MSearchResultItem item) {
        Date pubDate = new Date();
        if (item.getDocumentPublicationInfo() != null && item.getDocumentPublicationInfo().size() > 0) {
            R01MSearchResultItemPublicationInfo srPubInfo = item.getDocumentPublicationInfo().get(0);
            pubDate = srPubInfo.getDate();
        }
        String fmt = DateUtils.getLanguageDateFormat((String)"rss", (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS);
        return DateUtils.getDateFormated((Date)pubDate, (String)fmt, (Locale)Locale.ENGLISH);
    }

    public Map doFormatSimpleResultItems(String lang, R01MSearchResultsFormatterPreferences prefs, R01MSearchResultItem[] results) {
        return null;
    }

    private String _composeItemCustomRSSURL(R01MSearchResultItem item) {
        String documentWorkAreaRelativePath = item.getDocumentWorkAreaRelativePath() != null ? item.getDocumentWorkAreaRelativePath() : "";
        String docMainDataFileDefGenFileDocRelPath = null;
        if (item.getDocumentMainDataFileGeneratedFilesDocumentRelativePaths() != null) {
            docMainDataFileDefGenFileDocRelPath = (String)item.getDocumentMainDataFileGeneratedFilesDocumentRelativePaths().get(RSS_KEY_FILE);
        }
        if (StringUtils.isEmptyString(docMainDataFileDefGenFileDocRelPath)) {
            docMainDataFileDefGenFileDocRelPath = item.getDocumentMainDataFileDefaultGeneratedFileDocumentRelativePath() != null ? item.getDocumentMainDataFileDefaultGeneratedFileDocumentRelativePath() : "";
        }
        StringBuffer customRSSURL = new StringBuffer();
        if (documentWorkAreaRelativePath != null && !StringUtils.isEmptyString((String)docMainDataFileDefGenFileDocRelPath)) {
            customRSSURL.append('/');
            customRSSURL.append(documentWorkAreaRelativePath);
            customRSSURL.append('/');
            customRSSURL.append(docMainDataFileDefGenFileDocRelPath);
            return customRSSURL.toString();
        }
        return "#";
    }
}

