/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.rss.defaults;

import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchQueryCatalogLabelsFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchQueryFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchQueryMetaDataFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchQueryStorageFormatter;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchQueryTypoFormatter;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchQueryFormatterPreferences;
import com.ejie.r01m.searchengine.formatters.rss.defaults.R01MDefSearchQueryCatalogLabelsRSSFormatter;
import com.ejie.r01m.searchengine.formatters.rss.defaults.R01MDefSearchQueryMetaDataRSSFormatter;
import com.ejie.r01m.searchengine.formatters.rss.defaults.R01MDefSearchQueryTypoRSSFormatter;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import java.io.Serializable;
import java.util.List;

public class R01MDefSearchQueryRSSFormatter
implements R01MSearchQueryFormatter,
Serializable {
    private static final long serialVersionUID = 701404439804313589L;
    private R01MSearchQueryFormatterPreferences _prefs = null;
    private R01MSearchQueryStorageFormatter _storageFormatter = null;
    private R01MSearchQueryTypoFormatter _typoFormatter = new R01MDefSearchQueryTypoRSSFormatter();
    private R01MSearchQueryMetaDataFormatter _metaDataFormatter = null;
    private R01MSearchQueryCatalogLabelsFormatter _catalogLabelsFormatter = new R01MDefSearchQueryCatalogLabelsRSSFormatter();

    public R01MDefSearchQueryRSSFormatter() {
        this._metaDataFormatter = new R01MDefSearchQueryMetaDataRSSFormatter();
    }

    @Override
    public StringBuffer doFormatQuery(String lang, R01MSearchQueryFormatterPreferences prefs, R01MQueryObject qry) {
        return this.doFormatQuery(lang, prefs, qry, false);
    }

    @Override
    public StringBuffer doFormatQuery(String lang, R01MSearchQueryFormatterPreferences prefs, R01MQueryObject qry, boolean showAllMetadataDescription) {
        StringBuffer sb;
        if (this._prefs == null) {
            this._prefs = new R01MSearchQueryFormatterPreferences();
        }
        if (qry != null) {
            sb = new StringBuffer(200);
            StringBuffer typoConditions = this.doFormatTypo(lang, prefs, qry.getContentClusters(), qry.getContentFamilies(), qry.getContentTypes());
            StringBuffer metaDataConditions = this.doFormatMetaData(lang, prefs, qry.getContentClusters(), qry.getContentFamilies(), qry.getContentTypes(), qry.getMetaData(), qry.getOrderBy(), showAllMetadataDescription);
            StringBuffer catConditions = this.doFormatStructureLabels(lang, prefs, qry.getCatalogLabelsAnd(), qry.getCatalogLabelsOr());
            if (metaDataConditions != null) {
                sb.append(R01MSearchEngineUtils.fixTextForRSS(metaDataConditions));
            }
            if (typoConditions != null && typoConditions.length() > 0) {
                if (sb.length() > 0) {
                    sb.append(' ');
                    sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.type"));
                    sb.append(' ');
                }
                sb.append(R01MSearchEngineUtils.fixTextForRSS(typoConditions));
            }
            if (catConditions != null && catConditions.length() > 0) {
                if (sb.length() > 0) {
                    sb.append(' ');
                    sb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.cats"));
                    sb.append(' ');
                }
                sb.append(R01MSearchEngineUtils.fixTextForRSS(catConditions));
            }
        } else {
            sb = new StringBuffer("");
        }
        return sb;
    }

    @Override
    public StringBuffer doFormatTypo(String lang, R01MSearchQueryFormatterPreferences prefs, List clusters, List families, List typos) {
        return this._typoFormatter.doFormatTypo(lang, clusters, families, typos);
    }

    @Override
    public StringBuffer doFormatMetaData(String lang, R01MSearchQueryFormatterPreferences prefs, List clusters, List families, List typos, List searchedMetaData, List orderByMetaData) {
        return this.doFormatMetaData(lang, prefs, clusters, families, typos, searchedMetaData, orderByMetaData, false);
    }

    @Override
    public StringBuffer doFormatMetaData(String lang, R01MSearchQueryFormatterPreferences prefs, List clusters, List families, List typos, List searchedMetaData, List orderByMetaData, boolean showAllMetadataDescription) {
        return this._metaDataFormatter.doFormatMetaData(lang, clusters, families, typos, searchedMetaData, orderByMetaData, showAllMetadataDescription);
    }

    @Override
    public StringBuffer doFormatOrderByMetaData(String lang, R01MSearchQueryFormatterPreferences prefs, List clusters, List families, List typos, List orderByMetaData) {
        return this._metaDataFormatter.doFormatOrderByMetaData(lang, clusters, families, typos, orderByMetaData);
    }

    @Override
    public StringBuffer doFormatStorage(String lang, R01MSearchQueryFormatterPreferences prefs, List servers, List dataRepositories, List areas, List workAreas) {
        return this._storageFormatter.doFormatStorage(lang, servers, dataRepositories, areas, workAreas);
    }

    @Override
    public StringBuffer doFormatStructureLabels(String lang, R01MSearchQueryFormatterPreferences prefs, List labelsAnd, List labelsOr) {
        return this._catalogLabelsFormatter.doFormatStructureLabels(lang, labelsAnd, labelsOr);
    }

    @Override
    public StringBuffer doFormatGeoLabels(String lang, R01MSearchQueryFormatterPreferences prefs, List labelsAnd, List labelsOr) {
        return this._catalogLabelsFormatter.doFormatGeoLabels(lang, labelsAnd, labelsOr);
    }
}

