/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.rdf.defaults;

import com.ejie.r01f.file.ResourcesLoader;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.objects.searchengine.guide.R01MSearchGuide;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchSessionResults;
import com.ejie.r01m.objects.searchengine.results.R01MSearchSourceResults;
import com.ejie.r01m.objects.searchengine.session.R01MSearchSession;
import com.ejie.r01m.searchengine.formatters.R01MSearchResultItemFormatterUtils;
import com.ejie.r01m.searchengine.formatters.interfaces.R01MSearchSessionFormatter;
import com.ejie.r01m.searchengine.formatters.preferences.R01MSearchSessionFormatterPreferences;
import com.ejie.r01m.searchengine.servlet.R01MSearchEngineWebConstants;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class R01MDefSearchSessionRDFFormatter
implements R01MSearchSessionFormatter,
Serializable {
    private static final long serialVersionUID = -5286844506799110678L;
    private static Map _rdfTemplatesCache = new HashMap();

    @Override
    public StringBuffer formatSearchSession(String lang, R01MSearchSessionFormatterPreferences prefs, R01MSearchSession session) {
        return null;
    }

    @Override
    public StringBuffer formatSectionBySection(String lang, R01MSearchSessionFormatterPreferences prefs, StringBuffer searchResultsFormatted, Map preGeneratedCode) {
        StringBuffer code = R01MDefSearchSessionRDFFormatter._format(searchResultsFormatted, preGeneratedCode);
        return code;
    }

    @Override
    public StringBuffer format(String lang, R01MSearchSessionFormatterPreferences prefs, StringBuffer searchResultsFormatted, Map preGeneratedCode) {
        return this.formatSectionBySection(lang, prefs, searchResultsFormatted, preGeneratedCode);
    }

    @Override
    public StringBuffer formatSearchBox(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject qry, Map preGeneratedCode) {
        StringBuffer searchBox = R01MDefSearchSessionRDFFormatter._formatSearchBox(lang, qry, preGeneratedCode, prefs);
        return searchBox;
    }

    @Override
    public StringBuffer formatHeader(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject query, R01MSearchSessionResults sessionResults, Map preGeneratedCode) {
        StringBuffer header = R01MDefSearchSessionRDFFormatter._formatHeader(lang, prefs, query, sessionResults, preGeneratedCode);
        return header;
    }

    @Override
    public StringBuffer formatQuery(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject qry, Map preGeneratedCode) {
        return this.formatQuery(lang, prefs, qry, preGeneratedCode, false);
    }

    @Override
    public StringBuffer formatQuery(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject qry, Map preGeneratedCode, boolean showAllMetadataDescription) {
        return null;
    }

    @Override
    public StringBuffer formatRssFeedLink(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject qry, Map preGeneratedCode) {
        return null;
    }

    @Override
    public StringBuffer formatRispLink(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject qry, Map preGeneratedCode) {
        return null;
    }

    @Override
    public StringBuffer formatSearchResults(String lang, R01MSearchSessionFormatterPreferences prefs, R01MSearchSessionResults sessionResults, Map preGeneratedCode, R01MQueryObject qry) {
        StringBuffer results = R01MDefSearchSessionRDFFormatter._formatResults(lang, prefs, sessionResults.getSearchResultsBySource(), preGeneratedCode, qry);
        StringUtils.windows1252ToIso8859((StringBuffer)results);
        return results;
    }

    @Override
    public StringBuffer formatSearchResultsItems(String lang, R01MSearchSessionFormatterPreferences prefs, R01MSearchResultItem[] items, Map preGeneratedCode) {
        return null;
    }

    @Override
    public StringBuffer formatSearchGuide(String lang, R01MSearchSessionFormatterPreferences prefs, R01MSearchGuide guide, Map preGeneratedCode) {
        return null;
    }

    private static StringBuffer _format(StringBuffer searchResultsFormatted, Map preGeneratedCode) {
        StringBuffer sb = new StringBuffer(500);
        if (searchResultsFormatted != null) {
            sb.append(searchResultsFormatted);
        }
        return sb;
    }

    private static StringBuffer _formatSearchBox(String lang, R01MQueryObject qry, Map preGeneratedCode, R01MSearchSessionFormatterPreferences prefs) {
        return null;
    }

    private static StringBuffer _formatHeader(String lang, R01MSearchSessionFormatterPreferences prefs, R01MQueryObject query, R01MSearchSessionResults sessionResults, Map preGeneratedCode) {
        return null;
    }

    private static StringBuffer _formatResults(String lang, R01MSearchSessionFormatterPreferences prefs, Map searchResultsBySource, Map preGeneratedCode, R01MQueryObject qry) {
        R01MSearchSessionFormatterPreferences appliedPrefs = prefs == null ? new R01MSearchSessionFormatterPreferences() : prefs;
        String domain = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"opendata/templates/url/domain");
        StringBuffer rdfTemplate = null;
        if (_rdfTemplatesCache.containsKey(lang)) {
            rdfTemplate = new StringBuffer(((StringBuffer)_rdfTemplatesCache.get(lang)).toString());
        } else {
            try {
                InputStream newTemplateIS = ResourcesLoader.getResourceFileAsStream((String)XMLProperties.get((String)R01MConstants.API_APPCODE, (String)("opendata/templates/rdf/" + lang), (String)("/html/datos/rdfTemplates/r01RdfTemplate_" + lang + ".rdf")));
                StringBuffer newTemplate = StringUtils.loadBufferFromStream((InputStream)newTemplateIS);
                _rdfTemplatesCache.put(lang, newTemplate);
                rdfTemplate = new StringBuffer(((StringBuffer)_rdfTemplatesCache.get(lang)).toString());
            }
            catch (Exception ex) {
                rdfTemplate = new StringBuffer();
                rdfTemplate.append("Error al cargar la plantilla del formato del resultados RDF: ");
                rdfTemplate.append(ex.getMessage());
                return rdfTemplate;
            }
        }
        if (rdfTemplate != null) {
            StringBuffer results = null;
            int numResults = 0;
            if (searchResultsBySource != null) {
                R01MSearchSourceResults currSrcResults2 = null;
                results = new StringBuffer(5000);
                for (R01MSearchSourceResults currSrcResults2 : searchResultsBySource.values()) {
                    if (currSrcResults2.getResults() == null || currSrcResults2.getResults().length == 0) continue;
                    numResults += R01MDefSearchSessionRDFFormatter._formatResultItems(lang, appliedPrefs, currSrcResults2.getResults(), preGeneratedCode, domain, results);
                }
            }
            qry.getPresentationProperties().put("r01PageSize", String.valueOf(R01MSearchEngineWebConstants.MAX_RESULTITEMS_PER_PAGE));
            qry.getPresentationProperties().remove("r01NavBarBlockSize");
            StringBuffer urlToEncode = new StringBuffer(50);
            String ampersand = "&amp;";
            urlToEncode.append(XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"opendata/templates/url/search"));
            urlToEncode.append("r01kLang");
            urlToEncode.append('=');
            urlToEncode.append(lang);
            urlToEncode.append(ampersand);
            urlToEncode.append(R01MSearchEngineUtils.encodeQueryObjectInURL(qry));
            StringUtils.replaceAll((StringBuffer)rdfTemplate, (String)"$[url_domain]$", (String)domain);
            StringUtils.replaceAll((StringBuffer)rdfTemplate, (String)"$[url_search]$", (String)urlToEncode.toString());
            StringUtils.replaceAll((StringBuffer)rdfTemplate, (String)"$[num_results]$", (String)String.valueOf(numResults));
            StringUtils.replaceAll((StringBuffer)rdfTemplate, (String)"$[create_date]$", (String)DateUtils.getDateFormated((Date)new Date(), (String)"yyyy-MM-dd"));
            if (results != null) {
                StringUtils.replaceAll((StringBuffer)rdfTemplate, (String)"$[member_items]$", (String)results.toString());
            } else {
                StringUtils.replaceAll((StringBuffer)rdfTemplate, (String)"$[member_items]$", (String)"");
            }
        }
        return rdfTemplate;
    }

    private static int _formatResultItems(String lang, R01MSearchSessionFormatterPreferences prefs, R01MSearchResultItem[] items, Map preGeneratedCode, String domain, StringBuffer results) {
        if (domain == null) {
            domain = "";
        }
        int numResults = 0;
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || items[i].getContentTypology() == null || items[i].getContentTypology().getFamilyOid() == null || !items[i].getContentTypology().getFamilyOid().equals("opendata")) continue;
            results.append("<ds:member rdf:resource=\"");
            results.append(domain);
            results.append(R01MSearchResultItemFormatterUtils.composeItemRdfURL(items[i], prefs.resultsFormatterPreferences));
            results.append("\"/>\n\t\t");
            ++numResults;
        }
        return numResults;
    }
}

