/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.searchResult.typo;

import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterDirectiveUtils;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import java.util.Date;
import java.util.Properties;

public class R01MDefSearchResultItemTypoRegistrosAdministrativosFormatter
extends R01MDefSearchResultItemTypoDefaultFormatter {
    private static final String BEGINLIST = "<li><span class='r01srItemLiteral'>";
    private static final String ENDLABEL = ":&nbsp;</span><em>";
    private static final String ENDLIST = "</em></li>\r\n";
    private static final String SEARCH_REF = "searchEngineResources";
    private static final String LABEL_REF = "registros_administrativos";
    private static final int MAX_CHAR = 250;

    @Override
    public final String obtainTypoId(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer();
        outSb.append(super.obtainTypoId(lang, item));
        outSb.append('_');
        outSb.append(item.getContentTypology().getTypeOid());
        return outSb.toString();
    }

    @Override
    public final StringBuffer composeDocumentDescription(String lang, R01MSearchResultItem item) {
        return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    @Override
    public final StringBuffer composeTypoInfo(String lang, R01MSearchResultItem item) {
        StringBuffer typoInfo;
        if (item == null) {
            typoInfo = R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        } else if (item.getContentTypology() == null) {
            typoInfo = new StringBuffer("<em>&nbsp;</em>\r\n");
        } else {
            String typoId = this.obtainTypoId(lang, item);
            typoInfo = new StringBuffer(24);
            typoInfo.append("<em><span");
            if (!StringUtils.isEmptyString((String)typoId)) {
                typoInfo.append(" class='r01srItem");
                typoInfo.append(typoId);
                typoInfo.append('\'');
            }
            typoInfo.append('>');
            typoInfo.append(R01MSearchFormatterDirectiveUtils.composeTypoDirective(item.getContentTypology().getClusterOid(), item.getContentTypology().getFamilyOid(), item.getContentTypology().getTypeOid()));
            typoInfo.append("</span></em>");
        }
        return typoInfo;
    }

    @Override
    public final StringBuffer composeTypoDetails(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(426);
        String recNumRec = item.getDocumentMetaData("recNumRec");
        String recConstDate = item.getDocumentMetaData("recConstitutionDate");
        String recAddress = item.getDocumentMetaData("recAddress");
        String recTerritoryName = item.getDocumentMetaData("recTerritoryName");
        String recTownName = item.getDocumentMetaData("recTownName");
        String recGoal = item.getDocumentMetaData("recGoal");
        if (!StringUtils.isEmptyString((String)recConstDate)) {
            Date endDat = DateUtils.getDateFromLanguageFormatedString((String)recConstDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
            recConstDate = DateUtils.getDateLanguageFormated((Date)endDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS);
        }
        outSb.append("\t\t\t<div class='r01srTypoDetails'>\r\n <ul>");
        if (!StringUtils.isEmptyString((String)recNumRec)) {
            outSb.append(BEGINLIST);
            outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, SEARCH_REF, lang, "registros_administrativos.numero_de_registro"));
            outSb.append(ENDLABEL);
            outSb.append(recNumRec);
            outSb.append(ENDLIST);
        }
        if (!(StringUtils.isEmptyString((String)recAddress) && StringUtils.isEmptyString((String)recTerritoryName) && StringUtils.isEmptyString((String)recTownName))) {
            outSb.append(BEGINLIST);
            outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, SEARCH_REF, lang, "registros_administrativos.domicilio"));
            outSb.append(ENDLABEL);
            if (!StringUtils.isEmptyString((String)recAddress)) {
                outSb.append(recAddress);
            }
            outSb.append("&nbsp;(");
            if (!StringUtils.isEmptyString((String)recTownName)) {
                outSb.append(recTownName);
            }
            if (!StringUtils.isEmptyString((String)recTerritoryName)) {
                outSb.append("&cedil;&nbsp;");
                outSb.append(recTerritoryName);
            }
            outSb.append(")");
            outSb.append(ENDLIST);
        }
        if (!StringUtils.isEmptyString((String)recConstDate)) {
            outSb.append(BEGINLIST);
            outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, SEARCH_REF, lang, "registros_administrativos.fecha_contitucion"));
            outSb.append(ENDLABEL);
            outSb.append(recConstDate);
            outSb.append(ENDLIST);
        }
        String recSection = null;
        if (item.getContentTypology().getTypeOid().equals("asociacion")) {
            recSection = R01MUtils.getLiteral(R01MConstants.API_APPCODE, SEARCH_REF, lang, "registros_administrativos.A" + item.getDocumentMetaData("asoSection"));
            if (!StringUtils.isEmptyString((String)recSection)) {
                outSb.append(BEGINLIST);
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, SEARCH_REF, lang, "registros_administrativos.tipo"));
            }
        } else {
            recSection = R01MUtils.getLiteral(R01MConstants.API_APPCODE, SEARCH_REF, lang, "registros_administrativos." + item.getDocumentMetaData("fouSection"));
            if (!StringUtils.isEmptyString((String)recSection)) {
                outSb.append(BEGINLIST);
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, SEARCH_REF, lang, "registros_administrativos.actividad"));
            }
        }
        if (!StringUtils.isEmptyString((String)recSection)) {
            outSb.append(ENDLABEL);
            outSb.append(recSection);
            outSb.append(ENDLIST);
        }
        if (!StringUtils.isEmptyString((String)recGoal)) {
            if (recGoal.length() > 250) {
                recGoal = recGoal.substring(0, 245) + "...";
            }
            outSb.append(BEGINLIST);
            outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, SEARCH_REF, lang, "registros_administrativos.fines"));
            outSb.append(ENDLABEL);
            outSb.append(recGoal);
            outSb.append(ENDLIST);
        }
        outSb.append("</ul>\t\t\t</div>\r\n");
        if (recNumRec == null && recAddress == null && recConstDate == null && recGoal == null && recTerritoryName == null && recTownName == null) {
            outSb = R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        return outSb;
    }

    @Override
    public final StringBuffer composeCatalogDetails(String lang, R01MSearchResultItem item) {
        return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }
}

