/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.searchResult.typo;

import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemStructureCatalog;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterDirectiveUtils;
import com.ejie.r01m.searchengine.formatters.R01MSearchResultItemFormatterUtils;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import java.util.Date;
import java.util.Properties;

public class R01MDefSearchResultItemTypoInformacionPublicaFormatter
extends R01MDefSearchResultItemTypoDefaultFormatter {
    private static final String DEFAULT_VALUE_EMPTY_STRING = "---";
    private static final String PROMOTOR_CAT_ID = "r01e00000fe4e6676dda470b8deed65c9bfe02f4c";
    private static final String TEMA_CAT_ID = "r01e00000fe4e6676dda470b898e584a4a1047312";
    private static final String LEVEL = "/";
    private static final String SPACE = "&nbsp;";
    private static final String COLON = ":";
    private static final String OPEN_TAG = "<div class=\"r01srItemTypoMetItemPublicInformation\">";
    private static final String CLOSE_TAG = "</div>";
    private static final String OPEN_STRONG = "<strong>";
    private static final String CLOSE_STRONG = "</strong> ";

    public StringBuffer composeDocumentIconText(String lang, R01MSearchResultItem item) {
        StringBuffer title = new StringBuffer(500);
        String pattern = DateUtils.getLanguageDateFormat((String)"es", (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS);
        Date currentDate = new Date();
        currentDate = DateUtils.rollDateToMinimum((Date)currentDate);
        String state = "";
        state = DateUtils.getDateAsMillis((Date)currentDate) >= DateUtils.getDateAsMillis((Date)DateUtils.getDateFromFormatedString((String)item.getDocumentMetaData("pubInfBeginDate"), (String)pattern)) && DateUtils.getDateAsMillis((Date)currentDate) <= DateUtils.getDateAsMillis((Date)DateUtils.getDateFromFormatedString((String)item.getDocumentMetaData("pubInfEndDate"), (String)pattern)) ? "vigente" : (!StringUtils.isEmptyString((String)item.getDocumentMetaData("pubInfEndDate")) && DateUtils.getDateAsMillis((Date)currentDate) > DateUtils.getDateAsMillis((Date)DateUtils.getDateFromFormatedString((String)item.getDocumentMetaData("pubInfEndDate"), (String)pattern)) ? "caducado" : "sinEmpezar");
        String notice = "";
        if (!StringUtils.isEmptyString((String)item.getDocumentMetaData("pubAnNotice"))) {
            notice = "r01srItemPublicInformationNotice";
        }
        String style = "r01srItemPublicInformation_" + state;
        title.append("<div class=\"r01Subtitle ");
        title.append(notice);
        title.append("\">");
        title.append("<span class=\"r01srItemPublicInformation_comun ");
        title.append(style);
        title.append("\">");
        title.append(R01MSearchFormatterDirectiveUtils.composeTypoDirective(item.getContentTypology().getClusterOid(), item.getContentTypology().getFamilyOid(), item.getContentTypology().getTypeOid()));
        title.append(":&nbsp;");
        title.append("</span>");
        title.append(OPEN_STRONG);
        title.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "informacionPublica." + state));
        title.append(CLOSE_STRONG);
        title.append(CLOSE_TAG);
        return title;
    }

    @Override
    public StringBuffer composeDocument(String lang, R01MSearchResultItem item, int numItems, boolean allItemsAreAttachmentFiles, StringBuffer docTitle, StringBuffer docDescription, StringBuffer typoInfo, StringBuffer typoDetails, StringBuffer catalogDetails, StringBuffer metaDataDetails) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        return this._composeDocument(lang, docTitle, item);
    }

    private StringBuffer _composeDocument(String lang, StringBuffer docTitle, R01MSearchResultItem item) {
        StringBuffer sb = new StringBuffer(700);
        sb.append("\t\t\t\t<div class=\"r01srItemDocLink r01srItemDocLinkTransfer r01clearfix\">\r\n\t\t\t\t\t<div class=\"r01srItemAutonomousRule\">\r\n\t\t\t\t\t\t<em class=\"r01srItemDocName\">\r\n");
        sb.append(docTitle);
        sb.append("\t\t\t\t\t\t</em>\r\n</div>");
        sb.append("\t\t\t\t</div>\r\n\t\t\t\t<div class=\"r01srItemDetails r01srItemDetailsTransfer\">\r\n\t\t\t\t\t");
        sb.append(this._composeMetadataInfo(lang, item));
        sb.append("</div>\r\n");
        return sb;
    }

    private StringBuffer _composeMetadataInfo(String lang, R01MSearchResultItem item) {
        StringBuffer sb = new StringBuffer(700);
        sb.append(this.composeDocumentIconText(lang, item));
        sb.append("<div class=\"r01srItemTypoMet\">");
        R01MSearchResultItemStructureCatalog promotorCat = R01MSearchResultItemFormatterUtils.obtainStructureCatalog(item, PROMOTOR_CAT_ID, "1");
        R01MSearchResultItemStructureCatalog promotorCatRol2 = R01MSearchResultItemFormatterUtils.obtainStructureCatalog(item, PROMOTOR_CAT_ID, "2");
        if (promotorCat != null) {
            String promotor = R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(promotorCat.getStructureOid(), promotorCat.getOid(), promotorCat.getRole()) + SPACE;
            String promotorRol2 = "";
            if (promotorCatRol2 != null) {
                promotorRol2 = "/&nbsp;" + R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(promotorCatRol2.getStructureOid(), promotorCatRol2.getOid(), promotorCatRol2.getRole());
            }
            if (!StringUtils.isEmptyString((String)promotor)) {
                if (StringUtils.isEmptyString((String)promotorRol2)) {
                    promotorRol2 = "/&nbsp;---";
                }
                sb.append(OPEN_TAG);
                sb.append(OPEN_STRONG + R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "informacionPublica.promotor") + COLON + SPACE + CLOSE_STRONG + promotor + promotorRol2);
                sb.append(CLOSE_TAG);
            }
        }
        R01MSearchResultItemStructureCatalog temaCat = R01MSearchResultItemFormatterUtils.obtainStructureCatalog(item, TEMA_CAT_ID, "1");
        R01MSearchResultItemStructureCatalog temaCatRol2 = R01MSearchResultItemFormatterUtils.obtainStructureCatalog(item, TEMA_CAT_ID, "2");
        if (temaCat != null) {
            String tema = R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(temaCat.getStructureOid(), temaCat.getOid(), temaCat.getRole()) + SPACE;
            String temaRol2 = "";
            if (temaCatRol2 != null) {
                temaRol2 = "/&nbsp;" + R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(temaCatRol2.getStructureOid(), temaCatRol2.getOid(), temaCatRol2.getRole());
            }
            if (!StringUtils.isEmptyString((String)tema)) {
                if (StringUtils.isEmptyString((String)temaRol2)) {
                    temaRol2 = "/&nbsp;---";
                }
                sb.append(OPEN_TAG);
                sb.append(OPEN_STRONG + R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "informacionPublica.tema") + COLON + SPACE + CLOSE_STRONG + tema + temaRol2);
                sb.append(CLOSE_TAG);
            }
        }
        if (item.getDocumentMetaData() != null || !StringUtils.isEmptyString((String)item.getDocumentMetaData("pubInfBeginDate")) || !StringUtils.isEmptyString((String)item.getDocumentMetaData("pubInfEndDate"))) {
            String beginDate = item.getDocumentMetaData("pubInfBeginDate");
            String endDate = item.getDocumentMetaData("pubInfEndDate");
            if (!StringUtils.isEmptyString((String)beginDate) && !StringUtils.isEmptyString((String)endDate)) {
                sb.append(OPEN_TAG);
                if ("eu".equalsIgnoreCase(lang)) {
                    Date endDat = DateUtils.getDateFromLanguageFormatedString((String)beginDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
                    beginDate = DateUtils.getDateLanguageFormated((Date)endDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS);
                    endDat = DateUtils.getDateFromLanguageFormatedString((String)endDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
                    endDate = DateUtils.getDateLanguageFormated((Date)endDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS);
                    sb.append(OPEN_STRONG + R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "informacionPublica.periodo") + COLON + CLOSE_STRONG + SPACE + beginDate + R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "informacionPublica.desde") + SPACE + endDate + R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "informacionPublica.hasta"));
                } else {
                    sb.append(OPEN_STRONG + R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "informacionPublica.periodo") + COLON + CLOSE_STRONG + R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "informacionPublica.desde") + SPACE + beginDate + SPACE + R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "informacionPublica.hasta") + SPACE + endDate);
                }
                sb.append(CLOSE_TAG);
            }
        }
        sb.append(CLOSE_TAG);
        return sb;
    }
}

