/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.searchResult.typo;

import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.config.objects.container.R01MResourcesContainerManagementConfig;
import com.ejie.r01m.config.objects.typology.R01MResourcesPresentationRenderConfig;
import com.ejie.r01m.config.objects.typology.R01MResourcesRenderConfig;
import com.ejie.r01m.config.objects.typology.R01MResourcesRenderGroup;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoRRHHFormatter;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MTypologyConfigAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;

public class R01MDefSearchResultItemTypoEmpleoPublicoOPEFormatter
extends R01MDefSearchResultItemTypoRRHHFormatter {
    private static final String DEFAULT_VALUE_EMPTY_STRING = "---";

    @Override
    public StringBuffer composeDocument(String lang, R01MSearchResultItem item, int numItems, boolean allItemsAreAttachmentFiles, StringBuffer docTitle, StringBuffer docDescription, StringBuffer typoInfo, StringBuffer typoDetails, StringBuffer catalogDetails, StringBuffer metaDataDetails) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        return this._composeEmpleoPublicoDocument(lang, docTitle, item);
    }

    @Override
    public StringBuffer composeMetaDataDetails(String lang, R01MSearchResultItem item) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this._composeDataFilesInfo(lang, item));
        return sb;
    }

    private StringBuffer _composeEmpleoPublicoDocument(String lang, StringBuffer docTitle, R01MSearchResultItem item) {
        StringBuffer sb = new StringBuffer(700);
        sb.append("\t\t\t\t");
        sb.append("<div class=\"r01srItemDocLink\">\r\n");
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)docTitle)) {
            sb.append("\t\t\t\t\t");
            sb.append("<em class=\"r01srItemDocName\">");
            sb.append(docTitle);
            sb.append("</em>\r\n");
        } else {
            sb.append("\t\t\t\t\t<em class=\"r01srItemDocName\">&nbsp;</em>\r\n");
        }
        sb.append("\t\t\t\t</div>\r\n");
        sb.append(this.composeRispDetails("\t\t\t\t", lang, item));
        sb.append(this._composeMetadataInfo(lang, item));
        sb.append(this._composeDateInfo(lang, item));
        return sb;
    }

    private StringBuffer _composeMetadataInfo(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(700);
        String strOfertante = item.getDocumentMetaData() != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("rrhhSponsor")) ? item.getDocumentMetaData("rrhhSponsor") : DEFAULT_VALUE_EMPTY_STRING;
        String strNumPlazas = item.getDocumentMetaData() != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("rrhhVacancies")) ? item.getDocumentMetaData("rrhhVacancies") : "0";
        outSb.append("\t\t\t\t");
        outSb.append("<div class=\"r01srItemDocDesc\">\r\n ");
        outSb.append("\t\t\t\t\t");
        outSb.append("<div class=\"r01srItemTypoEmpleoPublico\">\r\n");
        outSb.append("\t\t\t\t\t\t");
        outSb.append("<strong>");
        outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "publicJob.sponsor"));
        outSb.append(": </strong>");
        outSb.append(strOfertante + "\r\n");
        StringBuffer sbLocalizacion = this._composeMetaDataDetails(lang, item);
        if (sbLocalizacion.length() > 0) {
            outSb.append(" (");
            outSb.append(sbLocalizacion);
            outSb.append(")");
        }
        outSb.append("\t\t\t\t\t");
        outSb.append("</div>\r\n");
        outSb.append("\t\t\t\t\t");
        outSb.append("<div class=\"r01srItemTypoEmpleoPublico\">\r\n");
        outSb.append("\t\t\t\t\t\t");
        outSb.append("<strong>");
        outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "publicJob.vacancies"));
        outSb.append(": </strong>");
        outSb.append(strNumPlazas + "\r\n");
        outSb.append("\t\t\t\t\t");
        outSb.append("</div>\r\n");
        outSb.append("\t\t\t\t\t");
        outSb.append("<div class=\"r01srItemTypoEmpleoPublico\">\r\n");
        outSb.append("<span class=\"r01srItemTypoEmpleoPublicoOfertasRelacionadas\">\r\n");
        outSb.append("<!--#include virtual=\"" + this.getDocumentPath(lang, item) + "\" -->\r\n");
        outSb.append("</span>\r\n");
        outSb.append("\t\t\t\t\t");
        outSb.append("</div>\r\n");
        outSb.append("\t\t\t\t");
        outSb.append("</div>\r\n");
        return outSb;
    }

    private StringBuffer _composeMetaDataDetails(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(90);
        boolean sw = false;
        if (item.getDocumentMetaData("rrhhTown") != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("rrhhTown"))) {
            String town = item.getDocumentMetaData("rrhhTown");
            outSb.append(town);
            sw = true;
        }
        if (item.getDocumentMetaData("rrhhTerritory") != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("rrhhTerritory"))) {
            String territory = item.getDocumentMetaData("rrhhTerritory");
            if (sw) {
                outSb.append(" - ");
            } else {
                sw = true;
            }
            outSb.append(territory);
        } else if (item.getDocumentMetaData("rrhhRegion") != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("rrhhRegion"))) {
            String region = item.getDocumentMetaData("rrhhRegion");
            if (sw) {
                outSb.append(" - ");
            }
            outSb.append(region);
        }
        return outSb;
    }

    private StringBuffer _composeDateInfo(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(700);
        String startDate = item.getDocumentMetaData("rrhhStartDate");
        String endDate = item.getDocumentMetaData("rrhhEndDate");
        Date startDat = DateUtils.getDateFromLanguageFormatedString((String)startDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
        Date endDat = DateUtils.getDateFromLanguageFormatedString((String)endDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
        Date currentDate = new Date();
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        String formattedDate = df.format(currentDate);
        currentDate = DateUtils.getDateFromLanguageFormatedString((String)formattedDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
        String state = "";
        state = startDat == null || endDat == null ? "pendiente" : (DateUtils.getDateAsMillis((Date)currentDate) < DateUtils.getDateAsMillis((Date)startDat) ? "no_abierto" : (endDat != null && DateUtils.getDateAsMillis((Date)currentDate) > DateUtils.getDateAsMillis((Date)endDat) ? "cerrado" : "abierto"));
        outSb.append("\t\t\t\t");
        outSb.append("<div class=\"r01srItemDetails\">\r\n");
        outSb.append("\t\t\t\t");
        outSb.append("<div class=\"r01srItemDocDetail1 r01srItemTypo_empleo_publico_ope_");
        outSb.append(state);
        outSb.append("\">\r\n");
        outSb.append("\t\t\t\t");
        outSb.append("<div class=\"r01srItemTypo\">\r\n");
        outSb.append("\t\t\t\t\t");
        outSb.append("<em><br>");
        outSb.append("<span class=\"r01srItemTypo_empleo_publico_ope_" + state + "\">");
        outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "publicJob.dateRange_" + state));
        if (startDat != null) {
            outSb.append("&nbsp;(");
            outSb.append(DateUtils.getDateLanguageFormated((Date)startDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
        }
        if (endDat != null) {
            outSb.append("&nbsp;-&nbsp;");
            outSb.append(DateUtils.getDateLanguageFormated((Date)endDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
            outSb.append(")");
        }
        if (startDat != null && endDat == null) {
            outSb.append(")");
        }
        outSb.append("</span>\r\n");
        outSb.append("\t\t\t\t\t");
        outSb.append("</em>");
        outSb.append("\t\t\t\t");
        outSb.append("</div>");
        outSb.append("\t\t\t\t");
        outSb.append("</div>");
        outSb.append("\t\t\t\t");
        outSb.append("\t\t\t\t</div>\r\n");
        return outSb;
    }

    private StringBuffer _composeDataFilesInfo(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(700);
        boolean swPaintDivTag = false;
        outSb.append("<div class='r01srItemOPEEmpleoPublico'>\r\n");
        outSb.append("<ul>\r\n");
        if (item.getDocumentMetaData("rrhhRules") != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("rrhhRules"))) {
            swPaintDivTag = true;
            String bases = item.getDocumentMetaData("rrhhRules");
            outSb.append("<li class='r01srItemMDEmpleoPublico r01clearfix'>\r\n");
            outSb.append(bases);
            outSb.append("</li>\r\n");
        }
        if (item.getDocumentMetaData("rrhhLists") != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("rrhhLists"))) {
            swPaintDivTag = true;
            String list = StringEscapeUtils.unescapeHtml((String)item.getDocumentMetaData("rrhhLists"));
            String[] listhtml = list.split("#");
            for (int i = 0; i < listhtml.length; ++i) {
                if (StringUtils.isEmptyString((String)listhtml[i])) continue;
                outSb.append("<li class='r01srItemMDEmpleoPublico r01clearfix'>\r\n");
                outSb.append(listhtml[i]);
                outSb.append("</li>\r\n");
            }
        }
        outSb.append("</ul>\r\n");
        outSb.append("</div>\r\n");
        if (!swPaintDivTag) {
            outSb.setLength(0);
        }
        return outSb;
    }

    private String getDocumentPath(String lang, R01MSearchResultItem item) {
        R01MTypologyConfigAPI typoAPI = R01MClientFactory.getTypologyConfigAPI();
        try {
            R01MResourcesPresentationRenderConfig rendersTypoCfg = typoAPI.getTypeConfig(item.getContentTypology().getTypeOid()).getPresentationRenderConfig();
            R01MResourcesRenderGroup renderGroup = null;
            if (rendersTypoCfg != null && rendersTypoCfg.getRenderGroups() != null && !rendersTypoCfg.getRenderGroups().isEmpty() && rendersTypoCfg.getRenderGroups().containsKey("linked")) {
                renderGroup = (R01MResourcesRenderGroup)rendersTypoCfg.getRenderGroups().get("linked");
            }
            R01MResourcesRenderConfig renderConfig = null;
            if (renderGroup != null && renderGroup.getRenders() != null && !renderGroup.getRenders().isEmpty() && renderGroup.getRenders().containsKey("offerLinks")) {
                renderConfig = (R01MResourcesRenderConfig)renderGroup.getRenders().get("offerLinks");
            }
            String fileName = "";
            if (renderConfig != null && renderConfig.getProperties() != null && !renderConfig.getProperties().isEmpty() && renderConfig.getProperties().containsKey("fileName")) {
                fileName = (String)renderConfig.getProperties().get("fileName");
            }
            R01MResourcesContainerManagementConfig containersCfg = R01MClientFactory.getResourcesContainerConfigAPI().getResourcesContainerConfig();
            Properties vars = new Properties();
            vars.put("documentLanguage", item.getDocumentLanguage());
            vars.put("documentInternalName", item.getDocumentInternalName());
            vars.put("container", (String)containersCfg.getContainerIds().get(0));
            vars.put("renderId", renderConfig.getId());
            String documentWorkAreaRelativePath = item.getDocumentWorkAreaRelativePath() != null ? item.getDocumentWorkAreaRelativePath() : "";
            StringBuffer offerLinksURL = new StringBuffer();
            String contentAlias = R01MSearchEngineUtils.obtainContentRepositoryAlias(item.getDocumentPublicationInfo());
            if (documentWorkAreaRelativePath != null) {
                offerLinksURL.append('/');
                offerLinksURL.append(contentAlias);
                offerLinksURL.append('/');
                offerLinksURL.append(documentWorkAreaRelativePath);
                offerLinksURL.append('/');
                offerLinksURL.append(StringUtils.replaceVariableValues((String)fileName, (char)'$', (Map)vars));
                return offerLinksURL.toString();
            }
        }
        catch (R01MConfigLoadException ex) {
            ex.printStackTrace();
        }
        return "#";
    }
}

