/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.searchResult.typo;

import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoRRHHFormatter;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;

public class R01MDefSearchResultItemTypoEmpleoPublicoFormatter
extends R01MDefSearchResultItemTypoRRHHFormatter {
    private static final String DEFAULT_VALUE_EMPTY_STRING = "---";

    @Override
    public StringBuffer composeDocument(String lang, R01MSearchResultItem item, int numItems, boolean allItemsAreAttachmentFiles, StringBuffer docTitle, StringBuffer docDescription, StringBuffer typoInfo, StringBuffer typoDetails, StringBuffer catalogDetails, StringBuffer metaDataDetails) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        return this._composeEmpleoPublicoDocument(lang, docTitle, item);
    }

    @Override
    public StringBuffer composeMetaDataDetails(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(30);
        outSb.append("<div class='r01srItemOPEEmpleoPublico'>\r\n");
        outSb.append("<ul>\r\n");
        boolean swPaintDivTag = false;
        if (item.getDocumentMetaData("rrhhRules") != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("rrhhRules"))) {
            swPaintDivTag = true;
            String bases = item.getDocumentMetaData("rrhhRules");
            outSb.append("<li class='r01srItemMDEmpleoPublico r01clearfix'>\r\n");
            outSb.append(bases);
            outSb.append("</li>\r\n");
        }
        if (item.getDocumentMetaData("rrhhLists") != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("rrhhLists"))) {
            swPaintDivTag = true;
            String list = StringEscapeUtils.unescapeHtml((String)item.getDocumentMetaData("rrhhLists"));
            String[] listhtml = list.split("#");
            for (int i = 0; i < listhtml.length; ++i) {
                if (StringUtils.isEmptyString((String)listhtml[i])) continue;
                outSb.append("<li class='r01srItemMDEmpleoPublico r01clearfix'>\r\n");
                outSb.append(listhtml[i]);
                outSb.append("</li>\r\n");
            }
        }
        outSb.append("</ul>\r\n");
        if (!swPaintDivTag) {
            outSb.setLength(0);
        }
        return outSb;
    }

    private StringBuffer _composeEmpleoPublicoDocument(String lang, StringBuffer docTitle, R01MSearchResultItem item) {
        StringBuffer sb = new StringBuffer(700);
        sb.append("\t\t\t\t<div class=\"r01srItemDocLink\">\r\n");
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)docTitle)) {
            sb.append("\t\t\t\t\t<em class=\"r01srItemDocName\">");
            sb.append(docTitle);
            sb.append("</em>\r\n");
        } else {
            sb.append("\t\t\t\t\t<em class=\"r01srItemDocName\">&nbsp;</em>\r\n");
        }
        sb.append("\t\t\t\t</div>\r\n");
        sb.append(this.composeRispDetails("\t\t\t\t", lang, item));
        sb.append(this._composeMetadataInfo(lang, item));
        return sb;
    }

    public StringBuffer _composeMetadataInfo(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(700);
        String strOfertante = item.getDocumentMetaData() != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("rrhhSponsor")) ? item.getDocumentMetaData("rrhhSponsor") : DEFAULT_VALUE_EMPTY_STRING;
        String strNumPlazas = item.getDocumentMetaData() != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("rrhhVacancies")) ? item.getDocumentMetaData("rrhhVacancies") : "0";
        String strRegJuridico = item.getDocumentMetaData() != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("rrhhType")) ? item.getDocumentMetaData("rrhhType") : DEFAULT_VALUE_EMPTY_STRING;
        String startDate = item.getDocumentMetaData("rrhhStartDate");
        String endDate = item.getDocumentMetaData("rrhhEndDate");
        Date startDat = DateUtils.getDateFromLanguageFormatedString((String)startDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
        Date endDat = DateUtils.getDateFromLanguageFormatedString((String)endDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
        Date currentDate = new Date();
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        String formattedDate = df.format(currentDate);
        currentDate = DateUtils.getDateFromLanguageFormatedString((String)formattedDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
        String state = "";
        outSb.append("\t\t\t\t<div class=\"r01srItemDocDesc\">\r\n \t\t\t\t\t<div class=\"r01srItemTypoEmpleoPublico\">\r\n\t\t\t\t\t\t<strong>");
        outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "publicJob.sponsor"));
        outSb.append(": </strong>");
        outSb.append(strOfertante + "\r\n");
        StringBuffer sbLocalizacion = this._composeMetaDataDetails(lang, item);
        if (sbLocalizacion.length() > 0) {
            outSb.append(" (");
            outSb.append(sbLocalizacion);
            outSb.append(")");
        }
        outSb.append("\t\t\t\t\t</div>\r\n");
        outSb.append("\t\t\t\t\t<div class=\"r01srItemTypoEmpleoPublico\">\r\n");
        outSb.append("\t\t\t\t\t\t<strong>");
        outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "publicJob.vacancies"));
        outSb.append(": </strong>");
        outSb.append(strNumPlazas + "\r\n");
        outSb.append("\t\t\t\t\t</div>\r\n");
        outSb.append("\t\t\t\t\t<div class=\"r01srItemTypoEmpleoPublico\">\r\n");
        outSb.append("\t\t\t\t\t\t<strong>");
        outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "publicJob.regJuridic"));
        outSb.append(": </strong>");
        outSb.append(strRegJuridico + "\r\n");
        outSb.append("\t\t\t\t\t</div>\r\n\t\t\t\t</div>\r\n");
        state = startDat == null || startDat == null && endDat == null ? "pendiente" : (DateUtils.getDateAsMillis((Date)currentDate) < DateUtils.getDateAsMillis((Date)startDat) ? "no_abierto" : (endDat != null && DateUtils.getDateAsMillis((Date)currentDate) > DateUtils.getDateAsMillis((Date)endDat) ? "cerrado" : "abierto"));
        outSb.append("\t\t\t\t");
        outSb.append("<div class=\"r01srItemDetails\">\r\n");
        outSb.append("\t\t\t\t");
        outSb.append("<div class=\"r01srItemDocDetail1 r01srItemTypo_empleo_publico_");
        outSb.append(state);
        outSb.append("\">\r\n");
        outSb.append("\t\t\t\t");
        outSb.append("<div class=\"r01srItemTypo\">\r\n");
        outSb.append("\t\t\t\t\t");
        outSb.append("<em><br>");
        outSb.append("<span class=\"r01srItemTypo_empleo_publico_" + state + "\">");
        outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "publicJob.dateRange_" + state));
        if (startDat != null) {
            outSb.append("&nbsp;(");
            outSb.append(DateUtils.getDateLanguageFormated((Date)startDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
        }
        if (endDat != null) {
            outSb.append("&nbsp;-&nbsp;");
            outSb.append(DateUtils.getDateLanguageFormated((Date)endDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
            outSb.append(")");
        }
        if (startDat != null && endDat == null) {
            outSb.append(")");
        }
        outSb.append("</span>\r\n");
        outSb.append("\t\t\t\t\t");
        outSb.append("</em>");
        outSb.append("\t\t\t\t");
        outSb.append("</div>");
        outSb.append("\t\t\t\t");
        outSb.append("</div>");
        outSb.append("\t\t\t\t");
        outSb.append("\t\t\t\t</div>\r\n");
        return outSb;
    }

    private StringBuffer _composeMetaDataDetails(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(90);
        boolean sw = false;
        if (item.getDocumentMetaData("rrhhTown") != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("rrhhTown"))) {
            String town = item.getDocumentMetaData("rrhhTown");
            outSb.append(town);
            sw = true;
        }
        if (item.getDocumentMetaData("rrhhTerritory") != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("rrhhTerritory"))) {
            String territory = item.getDocumentMetaData("rrhhTerritory");
            if (sw) {
                outSb.append(" - ");
            } else {
                sw = true;
            }
            outSb.append(territory);
        } else if (item.getDocumentMetaData("rrhhRegion") != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("rrhhRegion"))) {
            String region = item.getDocumentMetaData("rrhhRegion");
            if (sw) {
                outSb.append(" - ");
            }
            outSb.append(region);
        }
        return outSb;
    }
}

