/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.searchResult.typo;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoLegislacionFormatter;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;

public class R01MDefSearchResultItemTypoConvenioFormatter
extends R01MDefSearchResultItemTypoLegislacionFormatter {
    @Override
    public String obtainTypoId(String lang, R01MSearchResultItem item) {
        StringBuffer sb = new StringBuffer(100);
        sb.append(super.obtainTypoId(lang, item));
        sb.append("_");
        sb.append(item.getContentTypology().getTypeOid());
        return sb.toString();
    }

    @Override
    public StringBuffer composeDocumentTitleText(String lang, R01MSearchResultItem item) {
        if (!StringUtils.isEmptyString((String)item.getDocumentMetaData("conventionTitle"))) {
            return new StringBuffer(item.getDocumentMetaData("conventionTitle"));
        }
        return new StringBuffer(item.getDocumentName());
    }

    @Override
    public StringBuffer composeDocumentDescription(String lang, R01MSearchResultItem item) {
        String text = item.getDocumentDescription();
        if (item.getDocumentMetaData("conventionObject") != null) {
            text = item.getDocumentMetaData("conventionObject");
        }
        return text != null ? new StringBuffer(text) : R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    @Override
    public StringBuffer composeDocument(String lang, R01MSearchResultItem item, int numItems, boolean allItemsAreAttachmentFiles, StringBuffer docTitle, StringBuffer docDescription, StringBuffer typoInfo, StringBuffer typoDetails, StringBuffer catalogDetails, StringBuffer metaDataDetails) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        StringBuffer sb = this._composeConvenioDocument(lang, docTitle, item, docDescription, typoInfo, typoDetails);
        return sb;
    }

    @Override
    public StringBuffer composeTypoDetails(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(50);
        String newDate = null;
        if (item.getContentTypology() != null && item.getContentTypology().getTypeOid() != null) {
            String conventionDate;
            String string = conventionDate = item.getDocumentMetaData() != null ? item.getDocumentMetaData("conventionDate") : null;
            if (conventionDate != null) {
                newDate = R01MSearchEngineUtils.formatDateTypeSearchResultMetaData(lang, conventionDate);
            }
        } else {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        if (newDate != null) {
            outSb.append("<span class='" + super.obtainTypoId(lang, item) + "'>");
            outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "legislacion.convenio.firmado"));
            outSb.append(": ");
            outSb.append(newDate);
            outSb.append("</span>");
        }
        if (StringUtils.isEmptyStringBuffer((StringBuffer)outSb)) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        outSb.insert(0, "<em class=\"r01srItemTypoDet\">");
        outSb.append("</em>");
        return outSb;
    }

    private StringBuffer _composeConvenioDocument(String lang, StringBuffer docTitle, R01MSearchResultItem item, StringBuffer docDescription, StringBuffer typoInfo, StringBuffer typoDetails) {
        StringBuffer sb = new StringBuffer(700);
        sb.append("\t\t\t\t<div class=\"r01srItemDocLink\">\r\n");
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)docTitle)) {
            sb.append("\t\t\t\t\t<em class=\"r01srItemDocName\">");
            sb.append(docTitle);
            sb.append("</em>\r\n");
        } else {
            sb.append("\t\t\t\t\t<em class=\"r01srItemDocName\">&nbsp;</em>\r\n");
        }
        sb.append("\t\t\t\t</div>\r\n");
        sb.append(this.composeRispDetails("\t\t\t\t", lang, item));
        sb.append("\t\t\t\t<div class=\"r01srItemDetails\">\r\n");
        if (!StringUtils.isEmptyStringBuffer((StringBuffer)docDescription)) {
            sb.append("\t\t\t\t\t<div class=\"r01srItemDocDesc\">");
            sb.append(docDescription);
            sb.append("</div>\r\n");
        }
        String typoCSSClassName = "r01srItem" + this.obtainTypoId(lang, item);
        sb.append("\t\t\t\t\t<div class=\"r01srItemDocDetail1 ");
        sb.append(typoCSSClassName);
        sb.append(" r01clearfix\">\r\n\t\t\t\t\t\t<div class=\"r01srItemTypo\">\r\n");
        sb.append(typoInfo);
        sb.append("\r\n\t\t\t\t\t\t</div>\r\n\t\t\t\t\t\t<div class=\"r01srItemTypoDet\">\r\n");
        sb.append(typoDetails);
        sb.append("\r\n\t\t\t\t\t\t</div>\r\n\t\t\t\t</div>\r\n");
        return sb;
    }
}

