/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.searchResult.typo;

import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemStructureCatalog;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterDirectiveUtils;
import com.ejie.r01m.searchengine.formatters.R01MSearchResultItemFormatterUtils;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoEventsFormatter;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoProceduresFormatter;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import java.util.Date;
import java.util.Properties;

public class R01MDefSearchResultItemTypoContratacionFormatter
extends R01MDefSearchResultItemTypoProceduresFormatter {
    @Override
    public String obtainTypoId(String lang, R01MSearchResultItem item) {
        String cls = super.obtainTypoId(lang, item);
        String prcStatus = item.getDocumentMetaData("prcStatus");
        if (!StringUtils.isEmptyString((String)prcStatus)) {
            if (prcStatus.equals("11")) {
                cls = "Typo_contratacion_anuncio_previo";
            } else if (prcStatus.equals("21")) {
                cls = "Typo_contratacion_plazo";
            } else if (prcStatus.equals("22")) {
                cls = "Typo_contratacion_cerrado";
            } else if (prcStatus.equals("23")) {
                cls = "Typo_contratacion_adjudicacion_provisional";
            } else if (prcStatus.equals("24")) {
                cls = "Typo_contratacion_adjudicado";
            } else if (prcStatus.equals("25")) {
                cls = "Typo_contratacion_historico";
            }
        }
        return cls;
    }

    @Override
    public StringBuffer composeTypoDetails(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(30);
        String prcStatus = item.getDocumentMetaData("prcStatus");
        if (!StringUtils.isEmptyString((String)prcStatus)) {
            Date endDat;
            String endDate = item.getDocumentMetaData("prcEndDate");
            if (endDate != null && (endDat = DateUtils.getDateFromLanguageFormatedString((String)endDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS)) != null) {
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.fechaFin"));
                outSb.append("&nbsp;");
                outSb.append(DateUtils.getDateLanguageFormated((Date)endDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
            }
            if (StringUtils.isEmptyStringBuffer((StringBuffer)outSb)) {
                return R01MDefSearchResultItemTypoEventsFormatter.EMPTY_TYPO;
            }
            outSb.insert(0, "<em class=\"r01srItemTypoDet\">");
            outSb.append("</em>");
        }
        return outSb;
    }

    @Override
    public StringBuffer composeCatalogDetails(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(100);
        R01MSearchResultItemStructureCatalog ambitoCat = R01MSearchResultItemFormatterUtils.obtainStructureCatalog(item, R01MConstants.FIXED_STRUCTURES.ambitoGeograficoStructOid, R01MConstants.FIXED_STRUCTURES.ambitoGeograficoRole);
        R01MSearchResultItemStructureCatalog poderAdjudicadorCat = R01MSearchResultItemFormatterUtils.obtainStructureCatalog(item, R01MConstants.FIXED_STRUCTURES.adjudicadorStructOid, R01MConstants.FIXED_STRUCTURES.adjudicadorRole);
        R01MSearchResultItemStructureCatalog organoContratacionCat = R01MSearchResultItemFormatterUtils.obtainStructureCatalog(item, R01MConstants.FIXED_STRUCTURES.organoContratacionStructOid, R01MConstants.FIXED_STRUCTURES.organoContratacionRole);
        R01MSearchResultItemStructureCatalog mesaContratacionCat = R01MSearchResultItemFormatterUtils.obtainStructureCatalog(item, R01MConstants.FIXED_STRUCTURES.mesasContratacionStructOid, R01MConstants.FIXED_STRUCTURES.mesasContratacionRole);
        R01MSearchResultItemStructureCatalog departamentoContratacionCat = R01MSearchResultItemFormatterUtils.obtainStructureCatalog(item, R01MConstants.FIXED_STRUCTURES.departamentosStructOid, R01MConstants.FIXED_STRUCTURES.departamentosStructRole);
        if (mesaContratacionCat != null || poderAdjudicadorCat != null || organoContratacionCat != null || departamentoContratacionCat != null) {
            outSb.append("\t\t\t\t\t\t<ul class='r01srItemContratacionCat'>\r\n");
            if (ambitoCat != null) {
                outSb.append("\t<li>\r\n<span class='r01srItemLiteral'>");
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.procAmbito"));
                outSb.append(":&nbsp;</span>");
                outSb.append(R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(ambitoCat.getStructureOid(), ambitoCat.getOid(), ambitoCat.getRole()));
                outSb.append("\t\t\t\t\t\t\t</li>\r\n");
            }
            if (poderAdjudicadorCat != null) {
                outSb.append("\t<li>\r\n<span class='r01srItemLiteral'>");
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.procPoderAdjudicador"));
                outSb.append(":&nbsp;</span>");
                outSb.append(R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(poderAdjudicadorCat.getStructureOid(), poderAdjudicadorCat.getOid(), poderAdjudicadorCat.getRole()));
                outSb.append("\t\t\t\t\t\t\t</li>\r\n");
            }
            if (departamentoContratacionCat != null) {
                outSb.append("\t<li>\r\n<span class='r01srItemLiteral'>");
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.procDepartamentoContratacion"));
                outSb.append(":&nbsp;</span>");
                outSb.append(R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(departamentoContratacionCat.getStructureOid(), departamentoContratacionCat.getOid(), departamentoContratacionCat.getRole()));
                outSb.append("\t\t\t\t\t\t\t</li>\r\n");
            }
            if (organoContratacionCat != null) {
                outSb.append("\t<li>\r\n<span class='r01srItemLiteral'>");
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.procOrganoContratacion"));
                outSb.append(":&nbsp;</span>");
                outSb.append(R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(organoContratacionCat.getStructureOid(), organoContratacionCat.getOid(), organoContratacionCat.getRole()));
                outSb.append("\t\t\t\t\t\t\t</li>\r\n");
            }
            if (mesaContratacionCat != null) {
                outSb.append("\t<li>\r\n<span class='r01srItemLiteral'>");
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.procMesaContratacion"));
                outSb.append(":&nbsp;</span>");
                outSb.append(R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(mesaContratacionCat.getStructureOid(), mesaContratacionCat.getOid(), mesaContratacionCat.getRole()));
                outSb.append("\t\t\t\t\t\t\t</li>\r\n");
            }
            outSb.append("\t\t\t\t\t\t</ul>\r\n");
        }
        if (StringUtils.isEmptyStringBuffer((StringBuffer)outSb)) {
            return R01MDefSearchResultItemTypoEventsFormatter.EMPTY_TYPO;
        }
        return outSb;
    }

    @Override
    public StringBuffer composeMetaDataDetails(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(500);
        String prcOnLine = item.getDocumentMetaData("prcTramitacionOnline");
        String prcOnLineUrl = item.getDocumentMetaData("prcUrlTramitacionOnline");
        String exp = item.getDocumentMetaData("prcExpCode");
        String modified = item.getDocumentMetaData("prcAdvMod");
        if (!StringUtils.isEmptyString((String)prcOnLineUrl) && prcOnLine != null && prcOnLine.equalsIgnoreCase("S") || !StringUtils.isEmptyString((String)exp) || !StringUtils.isEmptyString((String)modified) && !modified.equalsIgnoreCase("N")) {
            outSb.append("\t\t\t\t\t\t<ul>\r\n");
        }
        if (!StringUtils.isEmptyString((String)prcOnLineUrl) && prcOnLine != null && !prcOnLine.equalsIgnoreCase("N")) {
            outSb.append("\t\t\t\t\t\t\t<li class='r01srItemMDProcedureOnLine'><span><a href='");
            outSb.append(prcOnLineUrl);
            outSb.append("'>");
            outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.tramitacionOnLine"));
            outSb.append("</a></span></li>\r\n");
        }
        if (!StringUtils.isEmptyString((String)exp)) {
            outSb.append("\t\t\t\t\t\t\t<li class='r01srItemMDProcedureExpCode'><span class='r01srItemLiteral'>Exp:&nbsp;</span><span class='r01srItemShallowText'>");
            outSb.append(exp);
            outSb.append("</span></li>\r\n");
        }
        if (!StringUtils.isEmptyString((String)modified) && modified.equalsIgnoreCase("S")) {
            Date pubDat;
            outSb.append("\t\t\t\t\t\t\t<li class='r01srItemMDProcedureModified'><span class='r01srItemMDProcedureModifiedAlert'>");
            outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.modificado"));
            outSb.append(": </span>");
            String prcPubDate = item.getDocumentMetaData("prcAdvPubDate");
            if (!StringUtils.isEmptyString((String)prcPubDate) && (pubDat = DateUtils.getDateFromLanguageFormatedString((String)prcPubDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS)) != null) {
                outSb.append("<span class='r01srItemShallowText'>");
                outSb.append(DateUtils.getDateLanguageFormated((Date)pubDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
                outSb.append("</span>");
            }
            outSb.append("</li>\r\n");
        }
        if (!StringUtils.isEmptyString((String)prcOnLineUrl) && prcOnLine != null && !prcOnLine.equalsIgnoreCase("N") || !StringUtils.isEmptyString((String)exp) || !StringUtils.isEmptyString((String)modified) && !modified.equalsIgnoreCase("N")) {
            outSb.append("\t\t\t\t\t\t</ul>\r\n");
        }
        return outSb;
    }
}

