/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.searchResult.typo;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDirectoriosFormatter;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;

public class R01MDefSearchResultItemTypoBibliotecaFormatter
extends R01MDefSearchResultItemTypoDirectoriosFormatter {
    @Override
    public String obtainTypoId(String lang, R01MSearchResultItem item) {
        StringBuffer sb = new StringBuffer(100);
        sb.append(super.obtainTypoId(lang, item));
        sb.append('_');
        sb.append(item.getContentTypology().getTypeOid());
        return sb.toString();
    }

    @Override
    public StringBuffer composeTypoDetails(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(30);
        String address = item.getDocumentMetaData("libraryAddress");
        String town = item.getDocumentMetaData("libraryTown");
        String cp = item.getDocumentMetaData("libraryCP");
        String province = item.getDocumentMetaData("libraryProvince");
        if (StringUtils.isEmptyString((String)address) && StringUtils.isEmptyString((String)town) && StringUtils.isEmptyString((String)cp) && StringUtils.isEmptyString((String)province)) {
            return new StringBuffer("<em class=\"r01srItemTypoDet\">&nbsp;</em>");
        }
        String coma = "";
        outSb.append("<em class=\"r01srItemTypoDet\">");
        if (!StringUtils.isEmptyString((String)address)) {
            outSb.append(address);
            coma = ",&nbsp;";
        }
        if (!StringUtils.isEmptyString((String)cp)) {
            outSb.append(coma);
            coma = "&nbsp";
            outSb.append(cp);
        }
        if (!StringUtils.isEmptyString((String)town)) {
            outSb.append(coma);
            coma = "&nbsp";
            outSb.append(town);
        }
        if (!StringUtils.isEmptyString((String)province)) {
            outSb.append(coma);
            coma = "&nbsp";
            outSb.append("(").append(province).append(")");
        }
        outSb.append("</em>");
        return outSb;
    }

    @Override
    public StringBuffer composeCatalogDetails(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer();
        String phone = item.getDocumentMetaData("libraryPhone");
        String email = item.getDocumentMetaData("libraryEmail");
        String time = item.getDocumentMetaData("libraryTimeTable");
        String summertime = item.getDocumentMetaData("librarySummerTimeTable");
        if (!StringUtils.isEmptyString((String)phone) || !StringUtils.isEmptyString((String)email)) {
            outSb.append("<div>");
            if (!StringUtils.isEmptyString((String)phone)) {
                outSb.append("<strong class=\"r01srItemBiblioteca r01srItemBibliotecaTefefono\">");
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "biblioteca.telefono"));
                outSb.append(": &nbsp;");
                outSb.append("</strong>");
                outSb.append("<em>");
                outSb.append(phone);
                outSb.append("</em>");
            }
            if (!StringUtils.isEmptyString((String)email)) {
                outSb.append("&nbsp;&nbsp;<strong class=\"r01srItemBiblioteca r01srItemBibliotecaEmail\">");
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "biblioteca.email"));
                outSb.append(": &nbsp;");
                outSb.append("</strong>");
                outSb.append("<em>");
                outSb.append(email);
                outSb.append("</em>");
            }
            outSb.append("</div>");
        }
        if (!StringUtils.isEmptyString((String)time) || !StringUtils.isEmptyString((String)summertime)) {
            outSb.append("<div>");
            if (!StringUtils.isEmptyString((String)time)) {
                outSb.append("<strong class=\"r01srItemBiblioteca r01srItemBibliotecaHorario\">");
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "biblioteca.horario"));
                outSb.append(": &nbsp;");
                outSb.append("</strong>");
                outSb.append("<em>");
                outSb.append(time);
                outSb.append("</em>");
            }
            if (!StringUtils.isEmptyString((String)summertime)) {
                outSb.append("&nbsp;&nbsp;<strong>&nbsp;");
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "biblioteca.horarioVerano"));
                outSb.append(": &nbsp;");
                outSb.append("</strong>");
                outSb.append("<em>");
                outSb.append(summertime);
                outSb.append("</em>");
            }
            outSb.append("</div>");
        }
        return outSb;
    }
}

