/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.searchResult.typo;

import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.indexer.R01MRispDocument;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemStructureCatalog;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterDirectiveUtils;
import com.ejie.r01m.searchengine.formatters.R01MSearchResultItemFormatterUtils;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoEventsFormatter;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoProceduresFormatter;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class R01MDefSearchResultItemTypoAnuncioContratacionFormatter
extends R01MDefSearchResultItemTypoProceduresFormatter {
    @Override
    public String obtainTypoId(String lang, R01MSearchResultItem item) {
        String cls = "Typo_procedimientos_administrativos";
        String prcStatus = item.getDocumentMetaData("contratacion_estado_tramitacion");
        String prcStatusAdjudicacion = item.getDocumentMetaData("contratacion_adjudicacion");
        if (!StringUtils.isEmptyString((String)prcStatus)) {
            if ("AP".equals(prcStatus)) {
                cls = "Typo_contratacion_anuncio_previo";
            } else if ("AT".equals(prcStatus)) {
                cls = "Typo_contratacion_alerta_temprana";
            } else if ("AL".equals(prcStatus)) {
                cls = "Typo_contratacion_plazo";
            } else if ("AC".equals(prcStatus)) {
                cls = "Typo_contratacion_cerrado";
            } else if ("AD".equals(prcStatus)) {
                if (!StringUtils.isEmptyString((String)prcStatusAdjudicacion)) {
                    cls = "Typo_contratacion_adjudicacion_provisional";
                    cls = "2".equals(prcStatusAdjudicacion) ? "Typo_contratacion_adjudicado" : "Typo_contratacion_adjudicacion_provisional";
                } else {
                    cls = "Typo_contratacion_adjudicacion_provisional";
                }
            } else if ("DE".equals(prcStatus)) {
                cls = "Typo_contratacion_desistimiento";
            } else if ("HI".equals(prcStatus)) {
                cls = "Typo_contratacion_historico";
            } else if ("FO".equals(prcStatus)) {
                cls = "Typo_formalizacion_contrato";
            }
        }
        return cls;
    }

    @Override
    public StringBuffer composeTypoDetails(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(30);
        String fechaPublicacion = "";
        fechaPublicacion = item.getDocumentMetaData("contratacion_fecha_de_publicacion_documento");
        String prcStatus = item.getDocumentMetaData("contratacion_estado_tramitacion");
        String prcStatusAdjudicacion = item.getDocumentMetaData("contratacion_adjudicacion");
        if (StringUtils.isEmptyString((String)fechaPublicacion)) {
            return new StringBuffer("<em class=\"r01srItemTypoDet\"><span class=\"r01srItemTypo_informacion\">&nbsp;</span></em>");
        }
        String typoInfo = "<em class=\"r01srItemTypoDet\"><span class=\"r01srItemTypo_informacion\">";
        outSb.insert(0, typoInfo);
        if ("AP".equals(prcStatus)) {
            outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "anuncio_contratacion.AnuncioPrevio"));
        } else if ("AT".equals(prcStatus)) {
            outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "anuncio_contratacion.AlertaTemprana"));
        } else if ("AL".equals(prcStatus)) {
            outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "anuncio_contratacion.PlazoAbierto"));
        } else if ("AC".equals(prcStatus)) {
            outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "anuncio_contratacion.EnEstudio"));
        } else if ("AD".equals(prcStatus)) {
            if ("2".equals(prcStatusAdjudicacion)) {
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "anuncio_contratacion.AdjudicacionDefinitiva"));
            } else {
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "anuncio_contratacion.AdjudicacionProvisional"));
            }
        } else if ("DE".equals(prcStatus)) {
            outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "anuncio_contratacion.Desistimiento"));
        } else if ("HI".equals(prcStatus)) {
            outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "anuncio_contratacion.Historico"));
        } else if ("FO".equals(prcStatus)) {
            outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "anuncio_contratacion.FormalizacionContrato"));
        }
        outSb.append(" ");
        Date fechaPublicacionDate = null;
        if (!StringUtils.isEmptyString((String)item.getDocumentMetaData("contratacion_fecha_de_publicacion_documento"))) {
            fechaPublicacionDate = DateUtils.getDateFromLanguageFormatedString((String)item.getDocumentMetaData("contratacion_fecha_de_publicacion_documento"), null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
            outSb.append(DateUtils.getDateLanguageFormated((Date)fechaPublicacionDate, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
        }
        outSb.append("</span></em>");
        return outSb;
    }

    @Override
    public StringBuffer composeCatalogDetails(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(100);
        R01MSearchResultItemStructureCatalog ambitoCat = R01MSearchResultItemFormatterUtils.obtainStructureCatalog(item, R01MConstants.FIXED_STRUCTURES.ambitoGeograficoStructOid, R01MConstants.FIXED_STRUCTURES.ambitoGeograficoRole);
        R01MSearchResultItemStructureCatalog poderAdjudicadorCat = R01MSearchResultItemFormatterUtils.obtainStructureCatalog(item, R01MConstants.FIXED_STRUCTURES.adjudicadorStructOid, R01MConstants.FIXED_STRUCTURES.adjudicadorRole);
        R01MSearchResultItemStructureCatalog organoContratacionCat = R01MSearchResultItemFormatterUtils.obtainStructureCatalog(item, R01MConstants.FIXED_STRUCTURES.organoContratacionStructOid, R01MConstants.FIXED_STRUCTURES.organoContratacionRole);
        R01MSearchResultItemStructureCatalog mesaContratacionCat = R01MSearchResultItemFormatterUtils.obtainStructureCatalog(item, R01MConstants.FIXED_STRUCTURES.mesasContratacionStructOid, R01MConstants.FIXED_STRUCTURES.mesasContratacionRole);
        R01MSearchResultItemStructureCatalog departamentoContratacionCat = R01MSearchResultItemFormatterUtils.obtainStructureCatalog(item, R01MConstants.FIXED_STRUCTURES.departamentosStructOid, R01MConstants.FIXED_STRUCTURES.departamentosStructRole);
        R01MSearchResultItemStructureCatalog entidadImpulsoraCat = R01MSearchResultItemFormatterUtils.obtainStructureCatalog(item, R01MConstants.FIXED_STRUCTURES.impulsorStructOid, R01MConstants.FIXED_STRUCTURES.impulsorRole);
        if (mesaContratacionCat != null || poderAdjudicadorCat != null || organoContratacionCat != null || departamentoContratacionCat != null || entidadImpulsoraCat != null) {
            outSb.append("\t\t\t\t\t\t<ul class='r01srItemContratacionCat'>\r\n");
            if (ambitoCat != null) {
                outSb.append("\t<li>\r\n<span class='r01srItemLiteral'>");
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.procAmbito"));
                outSb.append(":&nbsp;</span>");
                outSb.append(R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(ambitoCat.getStructureOid(), ambitoCat.getOid(), ambitoCat.getRole()));
                outSb.append("\t\t\t\t\t\t\t</li>\r\n");
            }
            if (poderAdjudicadorCat != null) {
                outSb.append("\t<li>\r\n<span class='r01srItemLiteral'>");
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.procPoderAdjudicador"));
                outSb.append(":&nbsp;</span>");
                outSb.append(R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(poderAdjudicadorCat.getStructureOid(), poderAdjudicadorCat.getOid(), poderAdjudicadorCat.getRole()));
                outSb.append("\t\t\t\t\t\t\t</li>\r\n");
            }
            if (entidadImpulsoraCat != null) {
                outSb.append("\t<li>\r\n<span class='r01srItemLiteral'>");
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.procDepartamentoContratacion"));
                outSb.append(":&nbsp;</span>");
                outSb.append(R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(entidadImpulsoraCat.getStructureOid(), entidadImpulsoraCat.getOid(), entidadImpulsoraCat.getRole()));
                outSb.append("\t\t\t\t\t\t\t</li>\r\n");
            }
            if (departamentoContratacionCat != null) {
                outSb.append("\t<li>\r\n<span class='r01srItemLiteral'>");
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.procDepartamentoContratacion"));
                outSb.append(":&nbsp;</span>");
                outSb.append(R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(departamentoContratacionCat.getStructureOid(), departamentoContratacionCat.getOid(), departamentoContratacionCat.getRole()));
                outSb.append("\t\t\t\t\t\t\t</li>\r\n");
            }
            if (organoContratacionCat != null) {
                outSb.append("\t<li>\r\n<span class='r01srItemLiteral'>");
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.procOrganoContratacion"));
                outSb.append(":&nbsp;</span>");
                outSb.append(R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(organoContratacionCat.getStructureOid(), organoContratacionCat.getOid(), organoContratacionCat.getRole()));
                outSb.append("\t\t\t\t\t\t\t</li>\r\n");
            }
            if (mesaContratacionCat != null) {
                outSb.append("\t<li>\r\n<span class='r01srItemLiteral'>");
                outSb.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "item.procMesaContratacion"));
                outSb.append(":&nbsp;</span>");
                outSb.append(R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(mesaContratacionCat.getStructureOid(), mesaContratacionCat.getOid(), mesaContratacionCat.getRole()));
                outSb.append("\t\t\t\t\t\t\t</li>\r\n");
            }
            outSb.append("\t\t\t\t\t\t</ul>\r\n");
        }
        if (StringUtils.isEmptyStringBuffer((StringBuffer)outSb)) {
            return R01MDefSearchResultItemTypoEventsFormatter.EMPTY_TYPO;
        }
        return outSb;
    }

    @Override
    public StringBuffer composeMetaDataDetails(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(500);
        String exp = item.getDocumentMetaData("contratacion_expediente");
        if (!StringUtils.isEmptyString((String)exp)) {
            outSb.append("\t\t\t\t\t\t<ul>\r\n\t\t\t\t\t\t\t<li class='r01srItemMDProcedureExpCode'><span class='r01srItemLiteral'>Exp:&nbsp;</span><span class='r01srItemShallowText'>");
            outSb.append(exp);
            outSb.append("</span></li>\r\n\t\t\t\t\t\t</ul>\r\n");
        }
        String imagenContratacion = item.getDocumentMetaData("contratacion_poder_adjudicador_url");
        String titleContratacion = item.getDocumentMetaData("contratacion_poder_adjudicador_titulo");
        outSb.append("\t\t\t\t\t\t<ul>\r\n\t\t\t\t\t\t\t<li class='r01srItemMDProcedureExpCode'><img src=\"");
        outSb.append(imagenContratacion);
        outSb.append("\" alt=\"");
        outSb.append(titleContratacion);
        outSb.append("\" title=\"");
        outSb.append(titleContratacion);
        outSb.append("\"/></li>\r\n\t\t\t\t\t\t</ul>\r\n");
        return outSb;
    }

    @Override
    public StringBuffer composeRispDetails(String prefix, String lang, R01MSearchResultItem item) {
        if (!this._formatterPrefs.showRisp) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        StringBuffer sb = new StringBuffer();
        if (item.getContentRispDocumentsInfo() != null && !item.getContentRispDocumentsInfo().isEmpty()) {
            Map<String, String> rispInfo = item.getContentRispDocumentsInfo();
            StringBuffer listXml = new StringBuffer();
            if (rispInfo != null && !rispInfo.isEmpty()) {
                String contentAlias = R01MSearchEngineUtils.obtainContentRepositoryAlias(item.getDocumentPublicationInfo());
                for (String keyResult : rispInfo.keySet()) {
                    Map dataFilesGenerated;
                    R01MRispDocument rispDoc;
                    String[] values = rispInfo.get(keyResult).toString().split(",");
                    if (values.length <= 1 || StringUtils.isEmptyString((String)(rispDoc = new R01MRispDocument(keyResult, values[0], values[1])).getContentRelativePath()) || !rispDoc.getType().toUpperCase().equalsIgnoreCase("XML")) continue;
                    if (item.getDocumentDataFilesGeneratedFilesDocumentRelativePaths() != null && (dataFilesGenerated = item.getDocumentDataFilesGeneratedFilesDocumentRelativePaths()) != null && !dataFilesGenerated.isEmpty()) {
                        Iterator dataFilesGeneratedAux = dataFilesGenerated.keySet().iterator();
                        String key = (String)dataFilesGeneratedAux.next();
                        String dataFileOid = key.indexOf(".") == -1 ? key : key.substring(key.indexOf(".") + 1);
                        listXml.append(prefix);
                        listXml.append("<li>\t<a href=\"/");
                        listXml.append(contentAlias);
                        listXml.append('/');
                        listXml.append(item.getContentWorkAreaRelativePath());
                        listXml.append('/');
                        listXml.append(item.getDocumentLanguage());
                        listXml.append('_');
                        listXml.append(item.getDocumentInternalName());
                        listXml.append("/data/");
                        listXml.append(item.getDocumentLanguage());
                        listXml.append('_');
                        listXml.append(dataFileOid);
                        listXml.append("\" class=\"");
                        listXml.append(rispDoc.getType().toLowerCase());
                        listXml.append("\" title=\"");
                        listXml.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp." + rispDoc.getType().toLowerCase() + ".datos"));
                        listXml.append("\" ><strong><span class=\"file\">");
                        if (R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()) != null && !"".equals(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()))) {
                            listXml.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()));
                        } else {
                            listXml.append(rispDoc.getType().toUpperCase());
                        }
                        listXml.append("</span></strong>");
                        listXml.append("<strong><span class=\"adjuntos\">&nbsp;");
                        listXml.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto.datos"));
                        listXml.append("</span></strong></a></li>");
                    }
                    listXml.append(prefix);
                    listXml.append("<li>\t<a href=\"/");
                    listXml.append(contentAlias);
                    listXml.append('/');
                    listXml.append(item.getContentWorkAreaRelativePath());
                    listXml.append(rispDoc.getContentRelativePath());
                    listXml.append("\" class=\"");
                    listXml.append(rispDoc.getType().toLowerCase());
                    listXml.append("\" title=\"");
                    listXml.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp." + rispDoc.getType().toLowerCase() + ".metadatos"));
                    listXml.append("\" ><strong><span class=\"file\">");
                    if (R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()) != null && !"".equals(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()))) {
                        listXml.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto." + rispDoc.getType().toLowerCase()));
                    } else {
                        listXml.append(rispDoc.getType().toUpperCase());
                    }
                    listXml.append("</span></strong>");
                    listXml.append("<strong><span class=\"adjuntos\">&nbsp;");
                    listXml.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.texto.metadatos"));
                    listXml.append("</span></strong></a></li>");
                }
                if (!StringUtils.isEmptyStringBuffer((StringBuffer)listXml)) {
                    StringBuffer head = new StringBuffer(60);
                    head.append("<div class=\"r01RispResultLabel\">");
                    head.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.accederDatos"));
                    head.append("&nbsp;<a href=\"#TB_inline?height=450&amp;width=450&amp;inlineId=r01gSearchResultRispLeyend&amp;modal=false\" title=\"");
                    head.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.div.leyend"));
                    head.append("\" class=\"thickbox\"><img src=\"/AVComun/r01gSearchResultVA/images/ayuda.gif\"  alt=\"");
                    head.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "risp.img.alt"));
                    head.append("\" /></a>&nbsp;:</div>");
                    head.append("<div class=\"r01RispResultFiles\"><ul>");
                    listXml.insert(0, head);
                    listXml.append("</ul></div>");
                    sb.append(prefix);
                    sb.append("<div class=\"r01srItemRispLink r01clearfix\">");
                    sb.append(listXml);
                    sb.append(prefix);
                    sb.append("</div>");
                }
            }
        }
        sb.append(this._composeCODICE(prefix, lang, item));
        return sb;
    }

    private StringBuffer _composeCODICE(String prefix, String lang, R01MSearchResultItem item) {
        if (StringUtils.isEmptyString((String)item.getDocumentMetaData("contratacion_estado_tramitacion"))) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        StringBuffer list = new StringBuffer();
        String prcStatus = item.getDocumentMetaData("contratacion_estado_tramitacion");
        if ("AP".equals(prcStatus)) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        if ("AT".equals(prcStatus)) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        if ("AL".equals(prcStatus)) {
            list.append(this._obtainCodiceURLByTypoDoc(prefix, lang, item, 1));
            list.append(this._obtainCodiceURLByTypoDoc(prefix, lang, item, 2));
        } else if ("AC".equals(prcStatus)) {
            list.append(this._obtainCodiceURLByTypoDoc(prefix, lang, item, 1));
            list.append(this._obtainCodiceURLByTypoDoc(prefix, lang, item, 2));
        } else if ("AD".equals(prcStatus)) {
            list.append(this._obtainCodiceURLByTypoDoc(prefix, lang, item, 1));
            list.append(this._obtainCodiceURLByTypoDoc(prefix, lang, item, 2));
            list.append(this._obtainCodiceURLByTypoDoc(prefix, lang, item, 4));
        } else if ("DE".equals(prcStatus)) {
            list.append(this._obtainCodiceURLByTypoDoc(prefix, lang, item, 1));
            list.append(this._obtainCodiceURLByTypoDoc(prefix, lang, item, 2));
            list.append(this._obtainCodiceURLByTypoDoc(prefix, lang, item, 5));
        } else {
            if ("HI".equals(prcStatus)) {
                return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
            }
            if ("FO".equals(prcStatus)) {
                list.append(this._obtainCodiceURLByTypoDoc(prefix, lang, item, 1));
                list.append(this._obtainCodiceURLByTypoDoc(prefix, lang, item, 2));
                list.append(this._obtainCodiceURLByTypoDoc(prefix, lang, item, 4));
                list.append(this._obtainCodiceURLByTypoDoc(prefix, lang, item, 6));
            }
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer head = new StringBuffer(60);
        head.append("<div class=\"r01RispResultLabel\">");
        head.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "anuncio_contratacion.risp.accederCodice"));
        head.append("&nbsp;<a href=\"#TB_inline?height=450&amp;width=450&amp;inlineId=r01gAnuncioContratacionSearchResultRispLeyend&amp;modal=false\" title=\"");
        head.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "anuncio_contratacion.risp.queesCodice"));
        head.append("\" class=\"thickbox\"><img src=\"/AVComun/r01gSearchResultVA/images/ayuda.gif\"  alt=\"");
        head.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "anuncio_contratacion.risp.queesCodice"));
        head.append("\" /></a>&nbsp;:</div>");
        head.append("<div class=\"r01RispResultFiles\"><ul>");
        list.insert(0, head);
        list.append("</ul></div>");
        sb.append(prefix);
        sb.append("<div class=\"r01srItemRispLink r01clearfix\">");
        sb.append(list);
        sb.append(prefix);
        sb.append("</div>");
        return sb;
    }

    private StringBuffer _obtainCodiceURLByTypoDoc(String prefix, String lang, R01MSearchResultItem item, int typoDoc) {
        StringBuffer listXml = new StringBuffer();
        String codiceURL = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "anuncio_contratacion.risp.urlCodice");
        codiceURL = StringUtils.replaceString((String)codiceURL, (String)"$[expediente]$", (String)item.getDocumentMetaData("contratacion_expediente"));
        codiceURL = StringUtils.replaceString((String)codiceURL, (String)"$[tipoDoc]$", (String)String.valueOf(typoDoc));
        listXml.append(prefix);
        listXml.append("<li>\t<a href=\"");
        listXml.append(codiceURL);
        listXml.append("\" class=\"xml\"");
        listXml.append("title=\"");
        listXml.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "anuncio_contratacion.risp." + typoDoc));
        listXml.append("\" ><strong><span class=\"file\">XML</span></strong>");
        listXml.append("<strong><span class=\"adjuntos\">&nbsp;");
        listXml.append(R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "anuncio_contratacion.risp." + typoDoc));
        listXml.append("</span></strong></a></li>");
        return listXml;
    }
}

