/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.searchResult.customized;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterDirectiveUtils;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import java.util.ArrayList;

public class R01MDefSearchResultItemGazteInformazioaTypoLibroFormatter
extends R01MDefSearchResultItemTypoDefaultFormatter {
    private static final String BEGINLIST = "<li><span class='r01srItemLiteral'>";
    private static final String ENDLABEL = ":&nbsp;</span><em>";
    private static final String ENDLIST = "</em></li>\r\n";
    private static final String SEARCH_REF = "searchEngineResources";
    private static final String LABEL_REF = "gazteinformazioa";
    private static final String ID_ES_LAN = "es";
    private static final String ID_EU_LAN = "eu";
    private static final String ID_EN_LAN = "en";
    private static final String ID_DE_LAN = "de";
    private static final String ID_FR_LAN = "fr";
    private static final String SPLIT_REG = ";";
    private static final String SPLIT_COL = "#";
    private static ArrayList langCombo = null;
    private static ArrayList avaiCombo = null;

    @Override
    public String obtainTypoId(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(100);
        outSb.append("_gazteinformazioa");
        return outSb.toString();
    }

    @Override
    public StringBuffer composeDocumentDescription(String lang, R01MSearchResultItem item) {
        return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    @Override
    public StringBuffer composeCatalogDetails(String lang, R01MSearchResultItem item) {
        return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    @Override
    public final StringBuffer composeTypoInfo(String lang, R01MSearchResultItem item) {
        StringBuffer typoInfo;
        if (item == null) {
            typoInfo = R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        } else if (item.getContentTypology() == null) {
            typoInfo = new StringBuffer("<em>&nbsp;</em>\r\n");
        } else {
            String typoId = this.obtainTypoId(lang, item);
            typoInfo = new StringBuffer(24);
            typoInfo.append("<div><em><span");
            if (!StringUtils.isEmptyString((String)typoId)) {
                typoInfo.append(" class='r01srItem");
                typoInfo.append(typoId);
                typoInfo.append('\'');
            }
            typoInfo.append('>');
            typoInfo.append(R01MSearchFormatterDirectiveUtils.composeTypoDirective(item.getContentTypology().getClusterOid(), item.getContentTypology().getFamilyOid(), item.getContentTypology().getTypeOid()));
            typoInfo.append("</span></em>\t</div>\r\n");
            if (item.getDocumentAuthor() != null) {
                typoInfo.append("<div class=\"gazteinformazioa\"><em><span>");
                typoInfo.append(item.getDocumentAuthor());
                typoInfo.append("</span></em>\t</div>\r\n");
            }
        }
        return typoInfo;
    }

    @Override
    public StringBuffer composeTypoDetails(String lang, R01MSearchResultItem item) {
        StringBuffer outSb = new StringBuffer(200);
        this.checkCombos();
        String label = "";
        String docAuthor = null;
        String docLanguage = null;
        String docLocalization = null;
        String docAvailability = null;
        if (item.getDocumentMetaData() != null) {
            docAuthor = item.getDocumentMetaData("docAuthor");
            docLanguage = this.getLang(item.getDocumentMetaData("docLanguage"), lang);
            docLocalization = item.getDocumentMetaData("docLocalization");
            docAvailability = this.getAvailability(item.getDocumentMetaData("docAvailability"), lang);
        }
        outSb.append("\t\t\t<div class='r01srTypoDetails'>\r\n <ul>");
        if (docAuthor != null && !"".equals(label = R01MUtils.getLiteral(R01MConstants.API_APPCODE, SEARCH_REF, lang, "gazteinformazioa.autor"))) {
            outSb.append(BEGINLIST);
            outSb.append(label);
            outSb.append(ENDLABEL);
            outSb.append(docAuthor);
            outSb.append(ENDLIST);
        }
        if (docLanguage != null && !"".equals(label = R01MUtils.getLiteral(R01MConstants.API_APPCODE, SEARCH_REF, lang, "gazteinformazioa.idioma"))) {
            outSb.append(BEGINLIST);
            outSb.append(label);
            outSb.append(ENDLABEL);
            outSb.append(docLanguage);
            outSb.append(ENDLIST);
        }
        if (docLocalization != null && !"".equals(label = R01MUtils.getLiteral(R01MConstants.API_APPCODE, SEARCH_REF, lang, "gazteinformazioa.localizacion"))) {
            outSb.append(BEGINLIST);
            outSb.append(label);
            outSb.append(ENDLABEL);
            outSb.append(docLocalization);
            outSb.append(ENDLIST);
        }
        if (docAvailability != null && !"".equals(label = R01MUtils.getLiteral(R01MConstants.API_APPCODE, SEARCH_REF, lang, "gazteinformazioa.disponibilidad"))) {
            outSb.append(BEGINLIST);
            outSb.append(label);
            outSb.append(ENDLABEL);
            outSb.append(docAvailability);
            outSb.append(ENDLIST);
        }
        outSb.insert(0, "<em class=\"r01srItemTypoDet\">");
        outSb.append("</ul>\r\n</div>\r\n</em>");
        if (docAuthor == null && docLanguage == null && docLocalization == null && docAvailability == null) {
            outSb = R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        return outSb;
    }

    @Override
    public StringBuffer composeMetaDataDetails(String lang, R01MSearchResultItem item) {
        return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    private void checkCombos() {
        if (langCombo == null || avaiCombo == null) {
            this.setCombos();
        }
    }

    private String getLang(String docLanguage, String lang) {
        String output = null;
        if (docLanguage != null) {
            for (String[][] item : langCombo) {
                for (int j = 0; j < item.length && lang.equals(item[j][2]); ++j) {
                    if (!docLanguage.equals(item[j][0])) continue;
                    output = item[j][1];
                    break;
                }
                if (output == null) continue;
                break;
            }
        }
        return output;
    }

    private String getAvailability(String docAvailability, String lang) {
        String output = null;
        if (docAvailability != null) {
            for (String[][] item : avaiCombo) {
                for (int j = 0; j < item.length && lang.equals(item[j][2]); ++j) {
                    if (!docAvailability.equals(item[j][0])) continue;
                    output = item[j][1];
                    break;
                }
                if (output == null) continue;
                break;
            }
        }
        return output;
    }

    private void setCombos() {
        langCombo = new ArrayList();
        avaiCombo = new ArrayList();
        String[][] outLang = this.setLangArray(ID_ES_LAN);
        String[][] outAvai = this.setAvaiArray(ID_ES_LAN);
        if (outLang != null) {
            langCombo.add(outLang);
        }
        if (outAvai != null) {
            avaiCombo.add(outAvai);
        }
        outLang = this.setLangArray(ID_EU_LAN);
        outAvai = this.setAvaiArray(ID_EU_LAN);
        if (outLang != null) {
            langCombo.add(outLang);
        }
        if (outAvai != null) {
            avaiCombo.add(outAvai);
        }
        outLang = this.setLangArray(ID_DE_LAN);
        outAvai = this.setAvaiArray(ID_DE_LAN);
        if (outLang != null) {
            langCombo.add(outLang);
        }
        if (outAvai != null) {
            avaiCombo.add(outAvai);
        }
        outLang = this.setLangArray(ID_EN_LAN);
        outAvai = this.setAvaiArray(ID_EN_LAN);
        if (outLang != null) {
            langCombo.add(outLang);
        }
        if (outAvai != null) {
            avaiCombo.add(outAvai);
        }
        outLang = this.setLangArray(ID_FR_LAN);
        outAvai = this.setAvaiArray(ID_FR_LAN);
        if (outLang != null) {
            langCombo.add(outLang);
        }
        if (outAvai != null) {
            avaiCombo.add(outAvai);
        }
    }

    private String[][] setLangArray(String lang) {
        String[] nombre = R01MUtils.getLiteral(R01MConstants.API_APPCODE, SEARCH_REF, lang, "gazteinformazioa.lang_combo").split(SPLIT_REG);
        String[][] outLang = null;
        int nomLength = nombre.length;
        if (nombre != null && nomLength > 0) {
            String[] cols = nombre[0].split(SPLIT_COL);
            outLang = new String[nomLength][cols.length + 1];
            for (int i = 0; i < nomLength; ++i) {
                cols = nombre[i].split(SPLIT_COL);
                outLang[i][0] = cols[0];
                outLang[i][1] = cols[1];
                outLang[i][2] = lang;
            }
        }
        return outLang;
    }

    private String[][] setAvaiArray(String idDeLan) {
        String[] nombre = R01MUtils.getLiteral(R01MConstants.API_APPCODE, SEARCH_REF, idDeLan, "gazteinformazioa.avai_combo").split(SPLIT_REG);
        String[][] outAvai = null;
        int nomLength = nombre.length;
        if (nombre != null && nomLength > 0) {
            String[] cols = nombre[0].split(SPLIT_COL);
            outAvai = new String[nomLength][cols.length + 1];
            for (int i = 0; i < nomLength; ++i) {
                cols = nombre[i].split(SPLIT_COL);
                outAvai[i][0] = cols[0];
                outAvai[i][1] = cols[1];
                outAvai[i][2] = idDeLan;
            }
        }
        return outAvai;
    }
}

