/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.ehu;

import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoEventsFormatter;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;
import java.util.Date;
import java.util.Properties;

public class R01MDefSearchResultItemTypoEventsEHUFormatter
extends R01MDefSearchResultItemTypoEventsFormatter {
    @Override
    public StringBuffer composeDocumentTitleText(String lang, R01MSearchResultItem item) {
        String[] startAndEndDates = this._obtainStartAndEndDates(lang, item, "eventStartDate", "eventStartDate");
        if (startAndEndDates == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        StringBuffer outSb = new StringBuffer(200);
        if (startAndEndDates[0] != null && startAndEndDates[1] != null) {
            outSb.append("<span class='r01srItemTypoEvent'>");
            outSb.append(startAndEndDates[0]);
            outSb.append(":&nbsp;");
            outSb.append("</span>");
        } else if (startAndEndDates[0] != null) {
            outSb.append("<span class='r01srItemTypoEvent'>");
            outSb.append(startAndEndDates[0]);
            outSb.append(":&nbsp;");
            outSb.append("</span>");
        }
        outSb.append(item.getDocumentName());
        return outSb;
    }

    @Override
    public StringBuffer composeDocumentDescription(String lang, R01MSearchResultItem item) {
        String text = item.getDocumentDescription();
        if (text != null && item.getDocumentName() != null && text.equalsIgnoreCase(item.getDocumentName())) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        return text != null ? new StringBuffer(text) : R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }

    @Override
    public StringBuffer composeTypoDetails(String lang, R01MSearchResultItem item) {
        String country;
        StringBuffer outSb = new StringBuffer(200);
        String startDate = item.getDocumentMetaData() != null ? item.getDocumentMetaData("eventStartDate") : null;
        String endDate = item.getDocumentMetaData() != null ? item.getDocumentMetaData("eventEndDate") : null;
        String location = item.getDocumentMetaData() != null ? item.getDocumentMetaData("eventLocation") : null;
        String town = item.getDocumentMetaData() != null ? item.getDocumentMetaData("eventTown") : null;
        String string = country = item.getDocumentMetaData() != null ? item.getDocumentMetaData("eventCountry") : null;
        if (location != null) {
            outSb.append(location);
        }
        if (town != null) {
            outSb.append("&nbsp;-&nbsp;");
            outSb.append(town);
        }
        if (country != null) {
            outSb.append('(');
            outSb.append(country);
            outSb.append(")&nbsp;");
        }
        if (startDate != null && endDate != null) {
            Date startDat = DateUtils.getDateFromLanguageFormatedString((String)startDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
            Date endDat = DateUtils.getDateFromLanguageFormatedString((String)endDate, null, (Properties)R01MSearchEngineConstants.SEARCHRESULT_DATE_FORMATS);
            if (startDate != null && endDate != null) {
                outSb.append(DateUtils.getDateLanguageFormated((Date)startDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
                outSb.append("&nbsp;-&nbsp;");
                outSb.append(DateUtils.getDateLanguageFormated((Date)endDat, (String)lang, (Properties)R01MSearchEngineConstants.PRESENTATION_DATE_FORMATS));
            }
        }
        if (StringUtils.isEmptyStringBuffer((StringBuffer)outSb)) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TYPO;
        }
        outSb.insert(0, "<em class=\"r01srItemTypoDet\">");
        outSb.append("</em>");
        return outSb;
    }

    @Override
    public StringBuffer composeMetaDataDetails(String lang, R01MSearchResultItem item) {
        return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
    }
}

