/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.searchengine.formatters.html.defaults.typodependant;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItemStructureCatalog;
import com.ejie.r01m.searchengine.formatters.R01MSearchFormatterDirectiveUtils;
import com.ejie.r01m.searchengine.formatters.R01MSearchResultItemFormatterUtils;
import com.ejie.r01m.searchengine.formatters.html.defaults.typodependant.R01MDefSearchResultItemTypoDefaultFormatter;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;

public class R01MDefSearchResultItemTypoStatuteFormatter
extends R01MDefSearchResultItemTypoDefaultFormatter {
    private static final String DEFAULT_VALUE_EMPTY_STRING = "---";

    @Override
    public StringBuffer composeDocumentTitleText(String lang, R01MSearchResultItem item) {
        StringBuffer title = new StringBuffer(500);
        title.append("<span class=\"r01srItemlegesarea r01srItemlegesarea_Statute\"><span>");
        title.append(item.getDocumentName());
        title.append("</span></span>");
        return title;
    }

    @Override
    public StringBuffer composeDocument(String lang, R01MSearchResultItem item, int numItems, boolean allItemsAreAttachmentFiles, StringBuffer docTitle, StringBuffer docDescription, StringBuffer typoInfo, StringBuffer typoDetails, StringBuffer catalogDetails, StringBuffer metaDataDetails) {
        if (item == null) {
            return R01MDefSearchResultItemTypoDefaultFormatter.EMPTY_TEXT;
        }
        return this._composeDocument(lang, docTitle, item);
    }

    private StringBuffer _composeDocument(String lang, StringBuffer docTitle, R01MSearchResultItem item) {
        StringBuffer sb = new StringBuffer(700);
        sb.append("\t\t\t\t<div class=\"r01srItemDocLink r01srItemDocLinkTransfer r01clearfix\">\r\n\t\t\t\t\t<div class=\"r01srItemAutonomousRule\">\r\n\t\t\t\t\t\t<em class=\"r01srItemDocName\">\r\n");
        sb.append(docTitle);
        sb.append("\t\t\t\t\t\t</em>\r\n</div>");
        sb.append(this.composeRispDetails("\t\t\t\t", lang, item));
        sb.append("\t\t\t\t</div>\r\n\t\t\t\t<div class=\"r01srItemDetails r01srItemDetailsTransfer\">\r\n\t\t\t\t\t");
        sb.append(this._composeMetadataInfo(lang, item));
        sb.append("<div class=\"r01srItemDocDetail1 ");
        String typoCSSClassName = "r01srItem" + this.obtainTypoId(lang, item);
        sb.append(typoCSSClassName);
        sb.append(" r01clearfix\">\r\n\t\t\t\t\t\t<div class=\"r01srItemTypo\">\r\n");
        if (!StringUtils.isEmptyString((String)item.getDocumentMetaData("statuteState"))) {
            String text;
            String cls;
            if (item.getDocumentMetaData("statuteState").toString().equals("1")) {
                cls = "Efectuada";
                text = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "transferencia.state.completed");
            } else {
                cls = "Pendiente";
                text = R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "transferencia.state.pending");
            }
            sb.append("<span class=\"r01srItemState_");
            sb.append(cls);
            sb.append("\">");
            sb.append(text);
            sb.append("</span>");
        } else {
            sb.append("&nbsp;");
        }
        sb.append("\r\n\t\t\t\t\t\t</div></div></div>\r\n");
        return sb;
    }

    private StringBuffer _composeMetadataInfo(String lang, R01MSearchResultItem item) {
        StringBuffer sb = new StringBuffer(700);
        sb.append("<div class=\"r01srItemTypoNormative r01srItemTypoNormativeFirst r01clearfix\">");
        sb.append("<div class=\"r01srItemTypoMetItemStatute\">");
        String area = "";
        R01MSearchResultItemStructureCatalog[] areaCat = R01MSearchResultItemFormatterUtils.obtainOrgStructuresCatalog(item, "structures/areaActuacion", false);
        if (areaCat != null && areaCat.length > 0) {
            for (int i = 0; i < areaCat.length; ++i) {
                area = i == 0 ? R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(areaCat[i].getStructureOid(), areaCat[i].getOid(), areaCat[i].getRole()) : area + "; " + R01MSearchFormatterDirectiveUtils.composeStructureLabelDirective(areaCat[i].getStructureOid(), areaCat[i].getOid(), areaCat[i].getRole());
            }
        } else {
            area = DEFAULT_VALUE_EMPTY_STRING;
        }
        area = !StringUtils.isEmptyString((String)area) ? area : DEFAULT_VALUE_EMPTY_STRING;
        sb.append("<strong>" + R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "transferencias.area") + ": </strong> " + area);
        sb.append("</div>");
        sb.append("<div class=\"r01srItemTypoMetItemStatute\">");
        String year = item.getDocumentMetaData() != null && !StringUtils.isEmptyString((String)item.getDocumentMetaData("statuteYear")) ? item.getDocumentMetaData("statuteYear") : DEFAULT_VALUE_EMPTY_STRING;
        sb.append("<strong>" + R01MUtils.getLiteral(R01MConstants.API_APPCODE, "searchEngineResources", lang, "transferencias.year") + ": </strong> " + year + "");
        sb.append("</div>");
        sb.append("</div>");
        return sb;
    }
}

